/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.botp.writeback;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.operation.ErOperationServiceHelper;
import kd.fi.er.mservice.botp.writeback.DailyLoanBillWriteBackService;

public class ApplyPayBillWriteBackService
extends DailyLoanBillWriteBackService {
    private static Log logger = LogFactory.getLog(ApplyPayBillWriteBackService.class);

    @Override
    public void afterSaveWriteBackResult(DynamicObject[] sourceBills) {
        Object[] pKids = Arrays.stream(sourceBills).map(v -> v.getPkValue()).toArray(Object[]::new);
        logger.info("\u51fa\u7eb3\u96c6\u6210,\u4ed8\u6b3e\u7533\u8bf7\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5f00\u59cb,\u4ed8\u6b3e\u7533\u8bf7\u5355ids:" + Arrays.toString(pKids));
        OperateOption option = OperateOption.create();
        this.setVariables(option, sourceBills);
        OperationResult operationResult = ErOperationServiceHelper.localInvokeOperation((String)"wbsourcebill", (DynamicObject[])sourceBills, (OperateOption)option);
        HashSet recsrcbillid = new HashSet();
        if (operationResult.isSuccess()) {
            Arrays.stream(sourceBills).forEach(data -> {
                DynamicObjectCollection accountentry = data.getDynamicObjectCollection("accountentry");
                recsrcbillid.addAll(accountentry.stream().map(v -> v.get("recsrcbillid")).collect(Collectors.toSet()));
            });
            DynamicObjectCollection pubColl = QueryServiceHelper.query((String)"er_publicreimbursebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", recsrcbillid)});
            if (pubColl.size() > 0) {
                OperateOption operateOption;
                Object[] pubids = pubColl.stream().map(v -> v.get("id")).toArray(Object[]::new);
                operationResult = ErOperationServiceHelper.localInvokeOperation((String)"wbsourcebill", (String)"er_publicreimbursebill", (Object[])pubids, (OperateOption)(operateOption = OperateOption.create()));
                if (operationResult.isSuccess()) {
                    logger.info("\u51fa\u7eb3\u96c6\u6210,\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u8d39\u7528\u5408\u540c\u53f0\u8d26\u6210\u529f\uff01");
                } else {
                    ValidateResultCollection validateResult = operationResult.getValidateResult();
                    logger.info("\u51fa\u7eb3\u96c6\u6210,\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u8d39\u7528\u5408\u540c\u53f0\u8d26\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
                }
            }
        } else {
            this.addErrorCode(String.valueOf(pKids[0]), String.format(ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e%1$s\u53cd\u5199\u5931\u8d25\u3002", (String)"AbstractWriteBackServcie_2", (String)"fi-er-mservice", (Object[])new Object[0]), pKids[0]));
            ValidateResultCollection validateResult = operationResult.getValidateResult();
            logger.info("\u51fa\u7eb3\u96c6\u6210,\u4ed8\u6b3e\u7533\u8bf7\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
            String msg = ResManager.loadKDString((String)"\u51fa\u7eb3\u96c6\u6210\uff0c\u53cd\u5199\u4e0a\u6e38\u5355\u636e\u5931\u8d25\uff1a", (String)"PublicReimBillWriteBackService_0", (String)"fi-er-mservice", (Object[])new Object[0]);
            throw new KDBizException(msg + SerializationUtils.toJsonString((Object)operationResult));
        }
        logger.info("\u51fa\u7eb3\u96c6\u6210,\u4ed8\u6b3e\u7533\u8bf7\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u6210\u529f!");
        logger.info("\u51fa\u7eb3\u96c6\u6210,\u4ed8\u6b3e\u7533\u8bf7\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u7ed3\u675f!");
    }

    @Override
    public String getSelectFileds() {
        return "balanceamount,payamount,recsrcbillid,recsrcbilltype,accapproveamount,accapprovecurramount," + super.getSelectFileds();
    }

    @Override
    public boolean needOverrideAfterSaveWriteBackResult() {
        return true;
    }
}

