/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.botp.writeback;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.refund.RefundEntryInfo;
import kd.fi.cas.refund.SourceBillInfo;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.FieldNameHelper;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.enums.PayLogEnum;
import kd.fi.er.mservice.botp.writeback.AbstractWriteBackServcie;
import kd.fi.er.mservice.param.ErRefundEntryInfo;
import kd.fi.er.mservice.util.LogUtil;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class LoanAndReimBillWriteBackService
extends AbstractWriteBackServcie {
    private static final Log logger = LogFactory.getLog(LoanAndReimBillWriteBackService.class);
    protected static final String AGENT_PAY_BILL_AMOUNT = "e_amount";
    protected static final String AGENT_REFUND_BILL_AMOUNT = "e_refundamt";
    protected static final String PAY_REFUND_BILL_AMOUNT = "refundamt";
    protected static final String SOURCE_BILL_ID = "sourceentryid";
    private static final String SOURCEENTRYPK = "sourceentrypk";
    private static final String ORIAMOUNT = "amount";
    private static final String TARGETPK = "targetpk";
    protected static final String PAYEDAMOUNT = "payedamount";
    protected static final String NOT_PAYAMOUNT = "notpayamount";
    private static final String ER_APPLYPAYBILL = "er_applypaybill";

    private void setHeadProperties(DynamicObject ... resultArr) {
        if (resultArr.length > 0) {
            for (DynamicObject bill : resultArr) {
                Long companyId;
                Date payDate = (Date)this.getLastDate(bill);
                bill.set("head_paydate", (Object)payDate);
                if (bill.getDynamicObjectType().getProperty("repaymentdate") == null || (companyId = ErCommonUtils.getPk((Object)bill.get("company"))) == null || SystemParamterUtil.getRepaymentDateBase((long)companyId) != 1) continue;
                bill.set("repaymentdate", (Object)CoreBaseBillServiceHelper.computeRepaymentDate((DynamicObject)bill));
            }
        }
    }

    @Override
    protected boolean writeBack(DynamicObject sourceBill, Object tarBillEntryInfo, Object targetPkId) {
        Boolean isNeedSumHead;
        Boolean isRefund;
        Object srcEntryMapPkId;
        Boolean isSuccess;
        BigDecimal amount;
        Object tarBillEntry;
        BigDecimal refundAmount = BigDecimal.ZERO;
        if (tarBillEntryInfo instanceof DynamicObject) {
            tarBillEntry = (DynamicObject)tarBillEntryInfo;
            amount = tarBillEntry.getBigDecimal(AGENT_PAY_BILL_AMOUNT);
            isSuccess = Boolean.valueOf(String.valueOf(tarBillEntry.get("e_issuccess")));
            srcEntryMapPkId = tarBillEntry.get(SOURCE_BILL_ID);
            isRefund = tarBillEntry.getBoolean("e_isrefund");
            if (isRefund.booleanValue()) {
                refundAmount = tarBillEntry.getBigDecimal(AGENT_REFUND_BILL_AMOUNT);
                if (this.isAboutCancelRefund().booleanValue()) {
                    refundAmount = refundAmount.negate();
                }
            }
            isNeedSumHead = Boolean.TRUE;
        } else if (tarBillEntryInfo instanceof ErRefundEntryInfo) {
            ErRefundEntryInfo refundEntryInfo = (ErRefundEntryInfo)tarBillEntryInfo;
            RefundEntryInfo tarBillEntry2 = refundEntryInfo.getRefundEntryInfo();
            amount = tarBillEntry2.getAmount();
            isSuccess = tarBillEntry2.getSuccess();
            srcEntryMapPkId = ((SourceBillInfo)tarBillEntry2.getSourceInfos().get(0)).getSourceEntryPks().toArray()[0];
            isRefund = true;
            refundAmount = tarBillEntry2.getRefundAmt();
            isNeedSumHead = Boolean.FALSE;
            if ("cas_agentpaybill".equals(refundEntryInfo.getTargetBillType())) {
                isNeedSumHead = Boolean.TRUE;
                if (this.isAboutCancelRefund().booleanValue()) {
                    isRefund = tarBillEntry2.getRefund();
                }
            }
        } else {
            tarBillEntry = (Map)tarBillEntryInfo;
            srcEntryMapPkId = tarBillEntry.get(SOURCEENTRYPK);
            isSuccess = Boolean.valueOf(String.valueOf(tarBillEntry.get("issuccess")));
            amount = (BigDecimal)tarBillEntry.get(ORIAMOUNT);
            isNeedSumHead = Boolean.FALSE;
            isRefund = Boolean.TRUE;
            refundAmount = (BigDecimal)tarBillEntry.get(PAY_REFUND_BILL_AMOUNT);
        }
        boolean isWriteSucess = this.writeBackStatusAndAmount(sourceBill, srcEntryMapPkId, targetPkId, amount, isSuccess, tarBillEntryInfo, isNeedSumHead, isRefund, refundAmount);
        this.setHeadProperties(sourceBill);
        return isWriteSucess;
    }

    private boolean writeBackStatusAndAmount(DynamicObject sourceBill, Object srcEntryMapPkId, Object targetPkId, BigDecimal amount, Boolean isSuccess, Object tarBillEntryInfo, Boolean isNeedSumHead, Boolean isRefund, BigDecimal refundAmount) {
        DynamicObjectCollection accEntryCollection = sourceBill.getDynamicObjectCollection("accountentry");
        boolean[] isWriteSuccess = new boolean[]{true};
        accEntryCollection.stream().filter(v -> v.getPkValue().equals(srcEntryMapPkId)).forEach(accountInfo -> {
            boolean aboutRefund;
            boolean check = this.checkCanWriteBack(this.getBillType(tarBillEntryInfo), (Long)targetPkId, this.getEntryId(tarBillEntryInfo), this.getRecId(tarBillEntryInfo));
            if (!check) {
                logger.info("\u51fa\u7eb3\u96c6\u6210,\u5df2\u7ecf\u53cd\u5199\u8fc7\uff0c\u4e0d\u518d\u53cd\u5199\uff0c\u76ee\u6807\u5355\uff1a{}\uff0c \u5206\u5f55\uff1a{} ", targetPkId, (Object)SerializationUtils.toJsonString((Object)tarBillEntryInfo));
                return;
            }
            boolean isWrite = this.isWriteBack(sourceBill, targetPkId, this.getOperateName(), (DynamicObject)accountInfo, amount, isSuccess, isRefund, refundAmount);
            boolean bl = isWriteSuccess[0] = isWriteSuccess[0] && isWrite;
            if (!isWrite) {
                logger.info("\u51fa\u7eb3\u96c6\u6210,\u4e0d\u8fdb\u884c\u53cd\u5199\uff0c\u76ee\u6807\u5355\uff1a{}\uff0c \u5206\u5f55\uff1a{} ", targetPkId, (Object)SerializationUtils.toJsonString((Object)tarBillEntryInfo));
                return;
            }
            String operateName = this.getOperateName();
            BigDecimal rollBackAmount = amount;
            boolean bl2 = aboutRefund = operateName.equalsIgnoreCase("renote") || operateName.equalsIgnoreCase("refund") || operateName.equalsIgnoreCase("cancelRefund") || operateName.equalsIgnoreCase("cancelRenote");
            if (aboutRefund && isRefund.booleanValue() || operateName.equalsIgnoreCase("cancelPay") || operateName.equalsIgnoreCase("cancelPayValidate")) {
                rollBackAmount = rollBackAmount.negate();
                if (aboutRefund) {
                    rollBackAmount = refundAmount.negate();
                    this.writeBackBuildAmount((DynamicObject)accountInfo, refundAmount);
                }
            }
            String entryStatus = accountInfo.getString("billstatusfield");
            logger.info("operateName: {}, entryStatus: {}, isSuccess: {}, aboutRefund: {}, isRefund : {}", new Object[]{operateName, entryStatus, isSuccess, aboutRefund, isRefund});
            if (aboutRefund && isRefund.booleanValue() || (operateName.equalsIgnoreCase("cancelPay") || operateName.equalsIgnoreCase("cancelPayValidate")) && !isSuccess.booleanValue() && (entryStatus.equals(ErBillStatusEnum.G.name()) || entryStatus.equals(ErBillStatusEnum.F.name())) || (operateName.equalsIgnoreCase("payOrSync") || operateName.equalsIgnoreCase("payValidate")) && isSuccess.booleanValue()) {
                logger.info("\u51fa\u7eb3\u96c6\u6210,\u8fdb\u5165\u53cd\u5199\u8d4b\u503c\u903b\u8f91");
                this.setSrcPayEntry(sourceBill, this.getPayEntryInfo(tarBillEntryInfo), isNeedSumHead, isSuccess);
                LogUtil.writeLog(sourceBill.getPkValue(), targetPkId, this.getBillTypeEnum(tarBillEntryInfo), this.getOperateName(), PayLogEnum.ASSIGN_ENTRY_BEFORE, this.formatAccentryLog((DynamicObject)accountInfo));
                this.writeBackEntryAmount((DynamicObject)accountInfo, rollBackAmount, null);
                LogUtil.writeLog(sourceBill.getPkValue(), targetPkId, this.getBillTypeEnum(tarBillEntryInfo), this.getOperateName(), PayLogEnum.ASSIGN_ENTRY_AFTER, this.formatAccentryLog((DynamicObject)accountInfo));
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)operateName, (CharSequence[])new CharSequence[]{"payOrSync", "payValidate"})) {
                    String entryName = this.getSrcEntityName();
                    String encashAmtField = FieldNameHelper.getBillHeadInstance((String)entryName).encashAmtField;
                    BigDecimal payAmount = this.getTotalPayedAndNotPayAmount(accEntryCollection).get(PAYEDAMOUNT);
                    BigDecimal enCashAmount = sourceBill.getBigDecimal(encashAmtField);
                    DynamicObject currency = sourceBill.getDynamicObject("currency");
                    int precision = currency.getInt("amtprecision");
                    String currencySign = currency.getString("sign");
                    if (payAmount.subtract(enCashAmount).compareTo(new BigDecimal("0.1")) > 0) {
                        this.addErrorCode(String.valueOf(targetPkId), String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u52a0\u4e0a\u6b64\u6b21\u4ed8\u6b3e\uff0c\u5355\u636e\u7d2f\u8ba1\u5df2\u4ed8\u91d1\u989d\u4e3a\u201c%2$s\u201d\uff0c\u4ed8\u73b0\u91d1\u989d\u4e3a\u201c%3$s\u201d\uff0c\u76f8\u5dee\u8d85\u8fc70.1\u5143\uff0c\u4ed8\u6b3e\u5931\u8d25\u3002", (String)"LoanAndReimBillWriteBackService_11", (String)"fi-er-mservice", (Object[])new Object[0]), sourceBill.getString("billno"), StringUtils.joinWith(null, (Object[])new Object[]{currencySign, payAmount.setScale(precision)}), StringUtils.joinWith(null, (Object[])new Object[]{currencySign, enCashAmount.setScale(precision)})));
                        isWriteSuccess[0] = false;
                    }
                }
                logger.info("\u51fa\u7eb3\u53cd\u5199\u5355\u5934\u72b6\u6001\u5f00\u59cb>>>>>>>>>>" + isWriteSuccess[0]);
                if (isWriteSuccess[0]) {
                    LogUtil.writeLog(sourceBill.getPkValue(), targetPkId, this.getBillTypeEnum(tarBillEntryInfo), this.getOperateName(), PayLogEnum.ASSIGN_BILL_BEFORE, this.formaLog(sourceBill, this.billHeadLogFileds()));
                    this.writeBackBillAmount(sourceBill, amount, accEntryCollection);
                    LogUtil.writeLog(sourceBill.getPkValue(), targetPkId, this.getBillTypeEnum(tarBillEntryInfo), this.getOperateName(), PayLogEnum.ASSIGN_BILL_AFTER, this.formaLog(sourceBill, this.billHeadLogFileds()));
                }
                logger.info("\u51fa\u7eb3\u53cd\u5199\u5355\u5934\u72b6\u6001\u7ed3\u675f>>>>>>>>>>");
                if (isWriteSuccess[0] && Arrays.asList("payOrSync", "renote", "refund", "cancelPay", "cancelRefund", "cancelRenote").contains(this.getOperateName())) {
                    this.saveWriteBackRecord(this.getBillType(tarBillEntryInfo), (Long)targetPkId, this.getEntryId(tarBillEntryInfo), this.getRecId(tarBillEntryInfo));
                }
            }
        });
        return isWriteSuccess[0];
    }

    private boolean isWriteBack(DynamicObject srcBill, Object targetPk, String operateName, DynamicObject accountInfo, BigDecimal amount, Boolean isSuccess, Boolean isRefund, BigDecimal refundAmount) {
        boolean flag = true;
        String entryStatus = accountInfo.getString("billstatusfield");
        Object srcBillPk = srcBill.getPkValue();
        switch (operateName) {
            case "payOrSync": 
            case "payValidate": {
                if (entryStatus.equals(ErBillStatusEnum.G.name())) {
                    return false;
                }
                BigDecimal accpayedamount = BigDecimal.ZERO;
                accpayedamount = accountInfo.getDataEntityType().getProperties().containsKey((Object)"accapproveamount") ? accountInfo.getBigDecimal("accapproveamount") : accountInfo.getBigDecimal("orireceiveamount");
                if (!isSuccess.booleanValue() || accountInfo.getBigDecimal("oriaccpayedamount").add(amount).compareTo(accpayedamount) <= 0) break;
                flag = false;
                String tip = ResManager.loadKDString((String)"\u5bf9\u5e94ID\u4e3a%1$s\u7684\u4e0a\u6e38\u5355\u636e\u6536\u6b3e\u4fe1\u606f\u7684\u5df2\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6536\u6b3e\u4fe1\u606f\u7684\u6536\u6b3e\u91d1\u989d%2$s", (String)"LoanAndReimBillWriteBackService_4", (String)"fi-er-mservice", (Object[])new Object[0]);
                tip = String.format(tip, srcBillPk, accountInfo.getBigDecimal("orireceiveamount"));
                this.addErrorCode(String.valueOf(targetPk), tip);
                break;
            }
            case "renote": 
            case "renoteValidate": 
            case "refund": 
            case "refundValidate": {
                if (accountInfo.getBigDecimal("oriaccpayedamount").compareTo(refundAmount.abs()) < 0) {
                    String tip = ResManager.loadKDString((String)"\u672c\u6b21\u9000\u6b3e\u91d1\u989d\u8d85\u8fc7\u5f53\u524d\u5355\u636e\u5df2\u4ed8\u91d1\u989d\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"LoanAndReimBillWriteBackService_12", (String)"fi-er-mservice", (Object[])new Object[0]);
                    this.addErrorCode(String.valueOf(targetPk), tip);
                    return false;
                }
                if (!this.isLoanBillCancelPay(srcBill, targetPk)) break;
                return false;
            }
            case "cancelPay": 
            case "cancelPayValidate": {
                if (!entryStatus.equals(ErBillStatusEnum.G.name()) && !entryStatus.equals(ErBillStatusEnum.F.name()) || isSuccess.booleanValue()) break;
                if (accountInfo.getBigDecimal("oriaccnotpayamount").add(amount).compareTo(accountInfo.getBigDecimal("orireceiveamount")) > 0) {
                    flag = false;
                    String tip = ResManager.loadKDString((String)"\u5bf9\u5e94ID\u4e3a%1$s\u7684\u4e0a\u6e38\u5355\u636e\u6536\u6b3e\u4fe1\u606f\u7684\u672a\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6536\u6b3e\u91d1\u989d%2$s", (String)"LoanAndReimBillWriteBackService_5", (String)"fi-er-mservice", (Object[])new Object[0]);
                    tip = String.format(tip, srcBillPk, accountInfo.getBigDecimal("orireceiveamount"));
                    this.addErrorCode(String.valueOf(targetPk), tip);
                    break;
                }
                flag = flag && this.isCancePay(this.getSrcEntityName(), srcBill, targetPk);
                break;
            }
            case "cancelRefund": 
            case "cancelRefundValidate": 
            case "cancelRenote": 
            case "cancelRenoteValidate": {
                if ((entryStatus.equals(ErBillStatusEnum.E.name()) || entryStatus.equals(ErBillStatusEnum.F.name())) && accountInfo.getBigDecimal("oriaccnotpayamount").compareTo(refundAmount.abs()) >= 0 && accountInfo.getBigDecimal("orireceiveamount").subtract(accountInfo.getBigDecimal("buildedamount")).compareTo(refundAmount.abs()) >= 0) break;
                flag = false;
                this.addErrorCode(String.valueOf(targetPk), String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u201c%s\u201d\u5df2\u91cd\u65b0\u53d1\u8d77\u4ed8\u6b3e\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002", (String)"LoanAndReimBillWriteBackService_9", (String)"fi-er-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
            }
        }
        return flag;
    }

    private boolean isLoanBill(DynamicObject srcBill) {
        IDataEntityType dataEntityType = srcBill.getDataEntityType();
        String srcEntityId = dataEntityType.getName();
        return ErEntityTypeUtils.isPrePayBill((String)srcEntityId) || ErEntityTypeUtils.isDailyLoanBill((String)srcEntityId) || ErEntityTypeUtils.isTripReqBill((String)srcEntityId) && dataEntityType.getProperties().get((Object)"isloan") != null && srcBill.getBoolean("isloan");
    }

    private Object getLastDate(DynamicObject bill) {
        DynamicObjectCollection payEntreis = bill.getDynamicObjectCollection("caspayentry");
        Optional<DynamicObject> max = payEntreis.stream().max(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                long result = this.getDate(o1, "targetpaydate") - this.getDate(o2, "targetpaydate");
                if (result > 0L) {
                    return 1;
                }
                if (result == 0L) {
                    return 0;
                }
                return -1;
            }

            long getDate(DynamicObject o, String propertyName) {
                return o.getDate(propertyName) == null ? 0L : o.getDate(propertyName).getTime();
            }
        });
        if (max.isPresent()) {
            return max.get().getDate("targetpaydate");
        }
        return null;
    }

    protected void writeBackBuildAmount(DynamicObject sourceBillEntry, BigDecimal amount) {
        sourceBillEntry.set("buildedamount", (Object)sourceBillEntry.getBigDecimal("buildedamount").subtract(amount));
    }

    protected void writeBackBillAmount(DynamicObject sourceBill, BigDecimal amount, DynamicObjectCollection collection) {
        try {
            Set entrySet;
            if (collection.size() == 1) {
                sourceBill.set("billstatus", ((DynamicObject)collection.get(0)).get("billstatusfield"));
            }
            if (collection.size() > 1 && !(entrySet = collection.stream().filter(v -> BigDecimal.ZERO.compareTo(v.getBigDecimal("receiveamount")) < 0).map(v -> v.getString("billstatusfield")).collect(Collectors.toSet())).isEmpty()) {
                String status = (String)entrySet.iterator().next();
                logger.info(".>>>>>>writeBackBillAmount1>>>>>>>>>set bill status:" + status);
                if (entrySet.size() == 1 && StringUtils.isNotEmpty((CharSequence)status)) {
                    sourceBill.set("billstatus", (Object)status);
                } else {
                    sourceBill.set("billstatus", (Object)"F");
                    logger.info(">>>>>>writeBackBillAmount2>>>>>>>>set bill status:F");
                }
            }
        }
        catch (Exception e2) {
            logger.error("\u51fa\u7eb3\u96c6\u6210,", (Throwable)e2);
            throw e2;
        }
    }

    protected void writeBackEntryAmount(DynamicObject sourceBillEntry, BigDecimal amount, BigDecimal curAmount) {
        BigDecimal oriPayedAmount = sourceBillEntry.getBigDecimal("oriaccpayedamount").add(amount);
        sourceBillEntry.set("oriaccpayedamount", (Object)oriPayedAmount);
        BigDecimal accpayedamount = BigDecimal.ZERO;
        BigDecimal receiveamount = BigDecimal.ZERO;
        if (sourceBillEntry.getDataEntityType().getProperties().containsKey((Object)"accapproveamount")) {
            accpayedamount = sourceBillEntry.getBigDecimal("accapproveamount");
            receiveamount = sourceBillEntry.getBigDecimal("accapprovecurramount");
        } else {
            accpayedamount = sourceBillEntry.getBigDecimal("orireceiveamount");
            receiveamount = sourceBillEntry.getBigDecimal("receiveamount");
        }
        if (oriPayedAmount.compareTo(accpayedamount) == 0) {
            sourceBillEntry.set("accpayedamount", (Object)receiveamount);
        } else if (curAmount == null) {
            BigDecimal payedAmount = BigDecimal.ZERO;
            payedAmount = StringUtils.equals((CharSequence)"0", (CharSequence)sourceBillEntry.getString("accquotetype")) ? sourceBillEntry.getBigDecimal("oriaccpayedamount").multiply(sourceBillEntry.getBigDecimal("accexchangerate")).setScale(AmountUtils.getAmountFieldPrecision((DynamicObject)sourceBillEntry, (String)"accpayedamount"), RoundingMode.HALF_UP) : sourceBillEntry.getBigDecimal("oriaccpayedamount").divide(sourceBillEntry.getBigDecimal("accexchangerate"), AmountUtils.getAmountFieldPrecision((DynamicObject)sourceBillEntry, (String)"accpayedamount"), RoundingMode.HALF_UP);
            sourceBillEntry.set("accpayedamount", (Object)payedAmount);
        } else {
            sourceBillEntry.set("accpayedamount", (Object)sourceBillEntry.getBigDecimal("accpayedamount").add(curAmount));
        }
        sourceBillEntry.set("oriaccbalamount", (Object)sourceBillEntry.getBigDecimal("oriaccpayedamount"));
        sourceBillEntry.set("accbalamount", (Object)sourceBillEntry.getBigDecimal("accpayedamount"));
        sourceBillEntry.set("oriaccnotpayamount", (Object)accpayedamount.subtract(sourceBillEntry.getBigDecimal("oriaccpayedamount")));
        BigDecimal notPayAmount = BigDecimal.ZERO;
        if (StringUtils.equals((CharSequence)"0", (CharSequence)sourceBillEntry.getString("accquotetype"))) {
            notPayAmount = sourceBillEntry.getBigDecimal("oriaccnotpayamount").multiply(sourceBillEntry.getBigDecimal("accexchangerate"));
        } else {
            BigDecimal accexchangerate = sourceBillEntry.getBigDecimal("accexchangerate").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : sourceBillEntry.getBigDecimal("accexchangerate");
            notPayAmount = sourceBillEntry.getBigDecimal("oriaccnotpayamount").divide(accexchangerate, RoundingMode.HALF_UP);
        }
        sourceBillEntry.set("accnotpayamount", (Object)notPayAmount);
        logger.error(">.......writeBackEntryAmount.......oriaccpayedamount:." + sourceBillEntry.getBigDecimal("oriaccpayedamount") + "..accpayedamount:" + accpayedamount);
        if (sourceBillEntry.getBigDecimal("oriaccpayedamount").compareTo(accpayedamount) == 0) {
            sourceBillEntry.set("billstatusfield", (Object)"G");
            logger.info(">.......writeBackEntryAmount........set.billstatusfield :G");
        } else if (sourceBillEntry.getBigDecimal("buildedamount").compareTo(BigDecimal.ZERO) <= 0) {
            sourceBillEntry.set("billstatusfield", (Object)"E");
            logger.info(">.......writeBackEntryAmount........set.billstatusfield :E");
        } else {
            sourceBillEntry.set("billstatusfield", (Object)"F");
            logger.info(">.......writeBackEntryAmount........set.billstatusfield :F");
        }
    }

    protected boolean isCancePay(String srcEntityName, DynamicObject srcBill, Object targetPk) {
        if (this.isLoanBillCancelPay(srcBill, targetPk)) {
            return false;
        }
        DynamicObjectCollection payEntryCollection = srcBill.getDynamicObjectCollection("caspayentry");
        for (DynamicObject payEntry : payEntryCollection) {
            if (!targetPk.equals(payEntry.getLong("targetbillid"))) continue;
            return true;
        }
        this.addErrorCode(String.valueOf(targetPk), ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6570\u636e\uff0c\u5bf9\u5e94\u4e0a\u6e38\u5355\u636e\u8fd8\u672a\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u53d6\u6d88\u4ed8\u6b3e\u6216\u9000\u7968\u5904\u7406\u3002", (String)"LoanAndReimBillWriteBackService_0", (String)"fi-er-mservice", (Object[])new Object[0]));
        return false;
    }

    protected boolean isLoanBillCancelPay(DynamicObject srcBill, Object targetPk) {
        Map directTrackDownBills;
        boolean existValidRangeBill;
        IDataEntityType dataEntityType = srcBill.getDataEntityType();
        String billFormId = srcBill.getDataEntityType().getName();
        if (this.isLoanBill(srcBill) && ((existValidRangeBill = (directTrackDownBills = BotpDrawServiceUtil.getDirectTrackDownBills((String)billFormId, (Long[])new Long[]{ErCommonUtils.getPk((Object)srcBill)})).values().stream().flatMap(Collection::stream).anyMatch(downbill -> {
            String entityKey = downbill.getTableDefine().getEntityKey();
            QFilter qFilter = new QFilter("id", "=", (Object)downbill.getPk());
            qFilter.and(new QFilter("billstatus", "!=", (Object)ErBillStatusEnum.H.name()));
            return (ErEntityTypeUtils.isTripReimburseBill((String)entityKey) || ErEntityTypeUtils.isDailyReimburseBill((String)entityKey) || ErEntityTypeUtils.isPublicReimburseBill((String)entityKey) || ErEntityTypeUtils.isRepaymentBill((String)entityKey)) && QueryServiceHelper.queryOne((String)entityKey, (String)"id", (QFilter[])new QFilter[]{qFilter}) != null;
        })) || srcBill.getBigDecimal("usedamount").compareTo(BigDecimal.ZERO) != 0 && srcBill.getBigDecimal("returnedamount").compareTo(BigDecimal.ZERO) != 0)) {
            String billLocaleValue = dataEntityType.getDisplayName().getLocaleValue();
            String billno = srcBill.getString("billno");
            this.addErrorCode(String.valueOf(targetPk), String.format(ResManager.loadKDString((String)"\u4e0a\u6e38%1$s\u201c%2$s\u201d\u5df2\u6838\u9500\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"DailyLoanBillWriteBackService_1", (String)"fi-er-mservice", (Object[])new Object[0]), billLocaleValue, billno));
            return true;
        }
        return false;
    }

    protected Map<String, BigDecimal> getTotalPayedAndNotPayAmount(DynamicObjectCollection collection) {
        BigDecimal billPayedAmount = BigDecimal.ZERO;
        BigDecimal billNotPayedAmount = BigDecimal.ZERO;
        for (DynamicObject dyObject : collection) {
            billPayedAmount = billPayedAmount.add(dyObject.getBigDecimal("accpayedamount"));
            billNotPayedAmount = billNotPayedAmount.add(dyObject.getBigDecimal("accnotpayamount"));
        }
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        result.put(PAYEDAMOUNT, billPayedAmount);
        result.put(NOT_PAYAMOUNT, billNotPayedAmount);
        return result;
    }

    @Override
    public String getSelectFileds() {
        Character split = Character.valueOf(',');
        StringBuilder sBuffer = new StringBuilder();
        sBuffer.append("dpcurrency").append(split).append("dpcurrency").append(split).append("dpexchangerate").append(split).append("dpamt").append(split).append("dplocalamt").append(split).append("agreedrate").append(split).append("lossamt").append(split).append("fee").append(split).append("feecurrency").append(split).append("head_paydate").append(split).append("receiveamount").append(split).append("modifytime").append(split).append("id,applier,currency,billstatus,notpayamount,buildedamount,oriaccpayedamount,accexchangerate,accountcurrency,accquotetype,accpayedamount,oriaccbalamount,accbalamount,oriaccnotpayamount,accnotpayamount,orireceiveamount,billstatusfield,caspayentry.seq,targetbillno,targetbizdate,targetpaydate,targetpayorg,targetopenorg,targetpayacct,targetpayacctid,targetpaybank,targetcurrency,targetexchange,targetpayamt,targetlocalamount,targetentrustorg,targetsettletype,targetbillid,billno,approveamount");
        return sBuffer.toString();
    }

    private void setSrcPayEntry(DynamicObject srcObj, Map<String, Object> payEntryInfo, Boolean isNeedSumHead, Boolean isSuccess) {
        logger.info("\u51fa\u7eb3\u96c6\u6210,\u53cd\u5199\u4e0a\u6e38\u4ed8\u6b3e\u4fe1\u606f\u5206\u5f55:" + SerializationUtils.toJsonString(payEntryInfo));
        DynamicObjectCollection payEntryCollection = srcObj.getDynamicObjectCollection("caspayentry");
        String operateName = this.getOperateName();
        Boolean isForward = null;
        if (payEntryInfo != null && payEntryInfo.size() > 0) {
            if ((operateName.equalsIgnoreCase("payOrSync") || operateName.equalsIgnoreCase("payValidate")) && isSuccess.booleanValue()) {
                isForward = Boolean.TRUE;
            } else if (operateName.equalsIgnoreCase("refund") || operateName.equalsIgnoreCase("renote") || operateName.equalsIgnoreCase("cancelPay") || operateName.equalsIgnoreCase("cancelPayValidate")) {
                isForward = Boolean.FALSE;
            } else if (operateName.equalsIgnoreCase("cancelRefund") || operateName.equalsIgnoreCase("cancelRenote")) {
                isForward = Boolean.TRUE;
            }
        }
        if (isForward == null) {
            return;
        }
        this.sumPayCollection(payEntryCollection, payEntryInfo, isNeedSumHead, isForward);
        if (payEntryCollection == null || payEntryCollection.size() <= 0) {
            return;
        }
        int i = 0;
        while (i < payEntryCollection.size()) {
            DynamicObject payEntry = (DynamicObject)payEntryCollection.get(i);
            payEntry.set("seq", (Object)(++i));
        }
    }

    private void sumPayCollection(DynamicObjectCollection payEntryCollection, Map<String, Object> payEntryInfo, Boolean isNeedSumHead, Boolean isForward) {
        Object entryBillId = payEntryInfo.get("targetbillid");
        Optional<DynamicObject> findFirst = payEntryCollection.stream().filter(v -> v.get("targetbillid").equals(entryBillId)).findFirst();
        if (findFirst.isPresent()) {
            DynamicObject payentry = findFirst.get();
            if (isNeedSumHead.booleanValue()) {
                this.sumAmount(payentry, isForward, payEntryInfo, "targetpayamt", "targetlocalamount", "dpamt", "dplocalamt");
            } else {
                this.sumAmount(payentry, isForward, payEntryInfo, "targetpayamt", "targetlocalamount");
            }
        } else if (isForward.booleanValue()) {
            this.addPayEntryCollection(payEntryInfo, payEntryCollection);
        }
        Iterator iterator = payEntryCollection.iterator();
        while (iterator.hasNext()) {
            DynamicObject payEntry = (DynamicObject)iterator.next();
            Long targetBillId = payEntry.getLong("targetbillid");
            BigDecimal targetPayAmount = payEntry.getBigDecimal("targetpayamt");
            if (targetBillId.compareTo(Long.valueOf(String.valueOf(payEntryInfo.get("targetbillid")))) != 0 || targetPayAmount.compareTo(BigDecimal.ZERO) > 0) continue;
            iterator.remove();
        }
    }

    private void addPayEntryCollection(Map<String, Object> payEntryInfo, DynamicObjectCollection payEntryCollection) {
        DynamicObjectType entryType = payEntryCollection.getDynamicObjectType();
        DynamicObject entry = new DynamicObject(entryType);
        for (Map.Entry<String, Object> entryinfo : payEntryInfo.entrySet()) {
            if (entryinfo.getKey().equals(AGENT_REFUND_BILL_AMOUNT)) continue;
            if (Arrays.asList("targetbizdate", "targetpaydate").contains(entryinfo.getKey()) && entryinfo.getValue() instanceof String) {
                logger.info("\u5b57\u6bb5\uff1a {}\uff0c \u503c\uff1a{}, \u662f\u5426\u65e5\u671f\uff1a {}", new Object[]{entryinfo.getKey(), entryinfo.getValue(), entryinfo.getValue() instanceof String});
                try {
                    entry.set(entryinfo.getKey(), (Object)DateUtils.parseDate((String)entryinfo.getValue().toString(), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                continue;
            }
            entry.set(entryinfo.getKey(), entryinfo.getValue());
        }
        payEntryCollection.add((Object)entry);
    }

    private void sumAmount(DynamicObject payentry, Boolean isForward, Map<String, Object> payEntryInfo, String ... fields) {
        if (isForward.booleanValue()) {
            for (String field : fields) {
                payentry.set(field, (Object)payentry.getBigDecimal(field).add((BigDecimal)payEntryInfo.get(field)));
            }
        } else {
            boolean hasCaculated = false;
            for (String field : fields) {
                if ("targetpayamt".equals(field) || "targetlocalamount".equals(field)) {
                    BigDecimal targetPayAmount;
                    BigDecimal targetExchangeRate;
                    BigDecimal oriTargetPayAmount;
                    if (hasCaculated) continue;
                    Object refundAmountObject = payEntryInfo.get(AGENT_REFUND_BILL_AMOUNT);
                    BigDecimal refundAmount = null;
                    if (refundAmountObject != null && (refundAmount = (BigDecimal)refundAmountObject).compareTo(BigDecimal.ZERO) > 0) {
                        oriTargetPayAmount = (BigDecimal)payEntryInfo.get("targetpayamt");
                        targetExchangeRate = payentry.getBigDecimal("targetexchange");
                        targetPayAmount = oriTargetPayAmount.subtract(refundAmount);
                        payentry.set("targetpayamt", (Object)targetPayAmount);
                        payentry.set("targetlocalamount", (Object)targetPayAmount.multiply(targetExchangeRate));
                        hasCaculated = true;
                        continue;
                    }
                    if (refundAmountObject != null && (refundAmount = (BigDecimal)refundAmountObject).compareTo(BigDecimal.ZERO) < 0) {
                        oriTargetPayAmount = payentry.getBigDecimal("targetpayamt");
                        targetExchangeRate = payentry.getBigDecimal("targetexchange");
                        targetPayAmount = oriTargetPayAmount.subtract(refundAmount);
                        payentry.set("targetpayamt", (Object)targetPayAmount);
                        payentry.set("targetlocalamount", (Object)targetPayAmount.multiply(targetExchangeRate));
                        hasCaculated = true;
                        continue;
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)field, (CharSequence)"dpamt") || StringUtils.equalsIgnoreCase((CharSequence)field, (CharSequence)"dplocalamt")) continue;
                payentry.set(field, (Object)payentry.getBigDecimal(field).subtract((BigDecimal)payEntryInfo.get(field)));
            }
        }
        logger.info("targetpaydate\uff0c \u503c\uff1a{}, \u662f\u5426\u65e5\u671f\uff1a {}", payEntryInfo.get("targetpaydate"), (Object)(payEntryInfo.get("targetpaydate") instanceof String));
        if (payEntryInfo.get("targetpaydate") instanceof String) {
            try {
                payentry.set("targetpaydate", (Object)DateUtils.parseDate((String)((String)payEntryInfo.get("targetpaydate")), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        } else {
            payentry.set("targetpaydate", payEntryInfo.get("targetpaydate"));
        }
    }

    private Map<String, Object> getPayEntryInfo(Object paramInfo) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(32);
        if (paramInfo instanceof DynamicObject) {
            DynamicObject agentEntry = (DynamicObject)paramInfo;
            DynamicObject agentHead = (DynamicObject)agentEntry.getParent();
            resultMap.put("targetbillno", agentHead.get("billno"));
            resultMap.put("targetbizdate", agentHead.get("bizdate"));
            resultMap.put("targetpaydate", agentHead.get("paytime"));
            resultMap.put("targetpayorg", agentHead.get("org"));
            resultMap.put("targetopenorg", agentHead.get("openorg"));
            resultMap.put("targetpayacct", agentHead.get("payeracctbank.bankaccountnumber"));
            resultMap.put("targetpayacctid", agentHead.get("payeracctbank"));
            resultMap.put("targetpaybank", agentHead.get("payerbank"));
            resultMap.put("targetcurrency", agentHead.get("currency"));
            resultMap.put("targetexchange", agentHead.get("exchangerate"));
            resultMap.put("targetentrustorg", agentHead.get("delegorg"));
            resultMap.put("targetsettletype", agentHead.get("settletype"));
            resultMap.put("targetbillid", agentHead.getPkValue());
            resultMap.put("targetpayamt", agentEntry.get(AGENT_PAY_BILL_AMOUNT));
            resultMap.put("targetlocalamount", agentEntry.get("e_localamt"));
            if (agentEntry.getDynamicObjectType().getProperties().get((Object)AGENT_REFUND_BILL_AMOUNT) != null && agentEntry.getBoolean("e_isrefund")) {
                resultMap.put(AGENT_REFUND_BILL_AMOUNT, agentEntry.get(AGENT_REFUND_BILL_AMOUNT));
            }
            resultMap.put("dpcurrency", agentHead.get("dpcurrency"));
            BigDecimal dpexchangerate = agentHead.getBigDecimal("dpexchangerate");
            resultMap.put("dpexchangerate", dpexchangerate);
            BigDecimal agreedrate = agentHead.getBigDecimal("agreedrate");
            resultMap.put("agreedrate", agreedrate);
            boolean isdiffcur = agentHead.getBoolean("isdiffcur");
            if (isdiffcur) {
                resultMap.put("dpamt", agentEntry.get("e_dpamt"));
                resultMap.put("dplocalamt", agentEntry.get("e_dplocalamt"));
            } else {
                resultMap.put("dpamt", agentEntry.get(AGENT_PAY_BILL_AMOUNT));
                resultMap.put("dplocalamt", agentEntry.get("e_localamt"));
            }
            resultMap.put("lossamt", agentHead.get("lossamt"));
            resultMap.put("fee", agentHead.get("fee"));
            resultMap.put("feecurrency", agentHead.get("feecurrency"));
        } else if (paramInfo instanceof Map) {
            Map paramMap = (Map)paramInfo;
            resultMap.putIfAbsent("targetbillno", paramMap.get("targetbillno"));
            resultMap.putIfAbsent("targetbizdate", paramMap.get("bizdate"));
            resultMap.putIfAbsent("targetpaydate", paramMap.get("paydate"));
            resultMap.putIfAbsent("targetpayorg_id", paramMap.get("org"));
            resultMap.putIfAbsent("targetopenorg_id", paramMap.get("openorg"));
            resultMap.putIfAbsent("targetpayacct", paramMap.get("payeracctbankno"));
            resultMap.putIfAbsent("targetpayacctid_id", paramMap.get("payeracctbank"));
            resultMap.putIfAbsent("targetpaybank_id", paramMap.get("payerbank"));
            resultMap.putIfAbsent("targetcurrency_id", paramMap.get("currencypk"));
            resultMap.putIfAbsent("targetexchange", paramMap.get("exchangerate"));
            resultMap.putIfAbsent("targetentrustorg_id", paramMap.get("entrustorg"));
            resultMap.putIfAbsent("targetsettletype_id", paramMap.get("settletype"));
            if (paramMap.containsKey(PAY_REFUND_BILL_AMOUNT)) {
                resultMap.putIfAbsent(AGENT_REFUND_BILL_AMOUNT, paramMap.get(PAY_REFUND_BILL_AMOUNT));
            }
            resultMap.putIfAbsent("targetbillid", paramMap.get(TARGETPK));
            BigDecimal localPayAmount = (BigDecimal)paramMap.get("localamt");
            BigDecimal payAmount = (BigDecimal)paramMap.get(ORIAMOUNT);
            resultMap.put("targetpayamt", payAmount);
            resultMap.put("targetlocalamount", localPayAmount);
            resultMap.put("dpcurrency", paramMap.get("dpcurrency"));
            Object dpexchangerate = paramMap.get("dpexchangerate");
            resultMap.put("dpexchangerate", dpexchangerate);
            Object agreedrate = paramMap.get("agreedrate");
            resultMap.put("agreedrate", agreedrate);
            resultMap.put("dpamt", paramMap.get("dpamt"));
            resultMap.put("dplocalamt", paramMap.get("dplocalamt"));
            resultMap.put("lossamt", paramMap.get("lossamt"));
            resultMap.put("fee", paramMap.get("fee"));
            resultMap.put("feecurrency", paramMap.get("feecurrency"));
        } else if (paramInfo instanceof ErRefundEntryInfo) {
            ErRefundEntryInfo refundEntryInfo = (ErRefundEntryInfo)paramInfo;
            RefundEntryInfo param = refundEntryInfo.getRefundEntryInfo();
            resultMap.putIfAbsent("targetbillno", param.getTargetBillNo());
            resultMap.putIfAbsent("targetbizdate", param.getBizdate());
            resultMap.putIfAbsent("targetpaydate", param.getPaydate());
            resultMap.putIfAbsent("targetpayorg_id", param.getOrg());
            resultMap.putIfAbsent("targetopenorg_id", param.getOpenOrg());
            resultMap.putIfAbsent("targetpayacct", param.getPayerAcctBankNo());
            resultMap.putIfAbsent("targetpayacctid_id", param.getPayerAcctBank());
            resultMap.putIfAbsent("targetpaybank_id", param.getPayerBank());
            resultMap.putIfAbsent("targetcurrency_id", param.getCurrencyPk());
            resultMap.putIfAbsent("targetexchange", param.getExchangeRate());
            resultMap.putIfAbsent("targetentrustorg_id", param.getEntrustOrg());
            resultMap.putIfAbsent("targetsettletype_id", param.getSettleType());
            resultMap.putIfAbsent(AGENT_REFUND_BILL_AMOUNT, param.getRefundAmt());
            resultMap.putIfAbsent("targetbillid", refundEntryInfo.getTargetPk());
            BigDecimal localPayAmount = param.getLocalAmt();
            BigDecimal payAmount = param.getRefundAmt().negate();
            resultMap.put("targetpayamt", payAmount);
            resultMap.put("targetlocalamount", localPayAmount);
            resultMap.put("dpcurrency", param.getDpCurrency());
            BigDecimal dpexchangerate = param.getDpExchangeRate();
            resultMap.put("dpexchangerate", dpexchangerate);
            BigDecimal agreedrate = param.getAgreedRate();
            resultMap.put("agreedrate", agreedrate);
            resultMap.put("dpamt", param.getDpAmt());
            resultMap.put("dplocalamt", param.getDpLocalAmt());
            resultMap.put("lossamt", param.getLossAmt());
            resultMap.put("fee", param.getFee());
            resultMap.put("feecurrency", param.getFeeCurrency());
        }
        return resultMap;
    }

    private Boolean isAboutCancelRefund() {
        String operateName = this.getOperateName();
        return operateName.equalsIgnoreCase("cancelRefund") || operateName.equalsIgnoreCase("cancelRefundValidate") || operateName.equalsIgnoreCase("cancelRenote") || operateName.equalsIgnoreCase("cancelRenoteValidate");
    }

    private String formatAccentryLog(DynamicObject accentry) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("oriaccpayedamount");
        list.add("accpayedamount");
        list.add("oriaccnotpayamount");
        list.add("accnotpayamount");
        list.add("oriaccbalamount");
        list.add("accbalamount");
        list.add("billstatusfield");
        return this.formaLog(accentry, list);
    }

    private String formaLog(DynamicObject sourceBill, List<String> fields) {
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            sb.append(field).append(": ").append(sourceBill.get(field));
        }
        return sb.toString();
    }

    List<String> billHeadLogFileds() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("billstatus");
        return list;
    }

    void setVariables(OperateOption option, DynamicObject[] sourceBills) {
        for (DynamicObject d : sourceBills) {
            option.setVariableValue("caswber" + String.valueOf(d.getPkValue()), d.getString("billstatus"));
        }
    }
}

