/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import org.apache.commons.lang3.StringUtils;

public class UpdateInvoiceGoodsNameAndGoodsName
implements IUpgradeService {
    private static final int INDEX_COUNT = 5000;
    private Map<String, String> codeName = Maps.newHashMap();
    private Set<String> notInTableCodeName = Sets.newHashSet();

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u5df2\u5f00\u59cb\u3002", (String)"UpdateInvoiceGoodsNameAndGoodsName_0", (String)"fi-er-mservice", (Object[])new Object[0]));
        Long start = System.currentTimeMillis();
        int count = this.updateInfo("t_er_invoiceinfo", "t_er_invoiceitem");
        Long invoiceInfoEnd = System.currentTimeMillis();
        result.setLog(ResManager.loadKDString((String)("upgrade t_er_invoiceinfo, data\uff1a" + count + "\uff0ccost time\uff1a" + (invoiceInfoEnd - start)), (String)"UpdateInvoiceGoodsNameAndGoodsName_0", (String)"fi-er-mservice", (Object[])new Object[0]));
        count = this.updateInfo("t_er_pubreiminvoiceinfo", "t_er_pubreiminvoiceitem");
        Long pubInvoiceInfoEnd = System.currentTimeMillis();
        result.setLog(ResManager.loadKDString((String)("upgrade t_er_pubreiminvoiceinfo, data\uff1a" + count + "\uff0ccost time\uff1a" + (pubInvoiceInfoEnd - invoiceInfoEnd)), (String)"UpdateInvoiceGoodsNameAndGoodsName_0", (String)"fi-er-mservice", (Object[])new Object[0]));
        count = this.updateInfo("t_er_invoicepoolinfo", "t_er_invoicepoolitem");
        Long expensePollInvoiceInfoEnd = System.currentTimeMillis();
        result.setLog(ResManager.loadKDString((String)("upgrade t_er_invoicepoolinfo, data\uff1a" + count + "\uff0ccost time\uff1a" + (expensePollInvoiceInfoEnd - pubInvoiceInfoEnd)), (String)"UpdateInvoiceGoodsNameAndGoodsName_0", (String)"fi-er-mservice", (Object[])new Object[0]));
        count = this.updateInfo("t_er_invoiceinfocp", "t_er_invoiceitemcp");
        Long checkInvoiceInfoEnd = System.currentTimeMillis();
        result.setLog(ResManager.loadKDString((String)("upgrade t_er_invoiceinfocp, data\uff1a" + count + "\uff0ccost time\uff1a" + (checkInvoiceInfoEnd - expensePollInvoiceInfoEnd)), (String)"UpdateInvoiceGoodsNameAndGoodsName_0", (String)"fi-er-mservice", (Object[])new Object[0]));
        result.setLog(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"UpdateInvoiceGoodsNameAndGoodsName_1", (String)"fi-er-mservice", (Object[])new Object[0]));
        return result;
    }

    private int updateInfo(String infoTable, String itemTable) {
        List<Object[]> args;
        String invoiceInfoSelectClumn = "finvoiceheadentryid,fgoodsname,fgoodscode";
        int index = 1;
        int count = 0;
        while ((args = this.updateInvoiceInfo(invoiceInfoSelectClumn, infoTable, itemTable, index)) != null) {
            count += args.size();
            ++index;
        }
        return count;
    }

    private String getIndex(String selectClumn, String table, int index) {
        int startIndex = (index - 1) * 5000;
        int endIndex = index * 5000;
        int count = endIndex - startIndex;
        String format = "SELECT top %s, %s  %s FROM %s t1 where finvoiceheadentryid != 0";
        return String.format(format, count, startIndex, selectClumn, table);
    }

    private List<Object[]> updateInvoiceInfo(String invoiceInfoSelectClumn, String infoTable, String tableName, int index) {
        String updateSql = "update " + infoTable + " set finvoicegoodsname = ?, finvoicealltaxcode = ? where fentryid = ?";
        String invoiceInfosql = this.getIndex(invoiceInfoSelectClumn, tableName, index);
        ResultHandle resultHandle = new ResultHandle();
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)invoiceInfosql, (ResultSetHandler)resultHandle);
        LinkedList<Object[]> args = new LinkedList<Object[]>();
        Map<Long, List<ItemInfo>> invoiceItemInfo = resultHandle.getInvoiceItemInfo();
        if (invoiceItemInfo.isEmpty()) {
            return null;
        }
        Set<String> mergeCodeSet = invoiceItemInfo.values().stream().flatMap(v -> v.stream().map(a -> a.goodscode).filter(a -> this.codeName.get(a) == null && !this.notInTableCodeName.contains(a))).collect(Collectors.toSet());
        if (!mergeCodeSet.isEmpty()) {
            this.setCodeName(mergeCodeSet);
        }
        for (Map.Entry<Long, List<ItemInfo>> entry : invoiceItemInfo.entrySet()) {
            Long invoiceEntryId = entry.getKey();
            List<ItemInfo> itemInfoList = entry.getValue();
            String goodsName = itemInfoList.stream().map(v -> v.goodsName).filter(v -> StringUtils.isNotBlank((CharSequence)v)).collect(Collectors.joining("\uff0c"));
            goodsName = StringUtils.isBlank((CharSequence)goodsName) ? " " : (goodsName.length() < 255 ? goodsName : goodsName.substring(0, 255));
            String goodsCode = itemInfoList.stream().map(v -> v.goodscode).filter(v -> StringUtils.isNotBlank((CharSequence)v) && this.codeName.get(v) != null).map(v -> this.codeName.get(v)).collect(Collectors.joining("\uff0c"));
            String string = StringUtils.isBlank((CharSequence)goodsCode) ? " " : (goodsCode = goodsCode.length() < 255 ? goodsCode : goodsCode.substring(0, 255));
            if (!StringUtils.isNotBlank((CharSequence)goodsName) && !StringUtils.isNotBlank((CharSequence)goodsCode)) continue;
            args.add(new Object[]{goodsName, goodsCode, invoiceEntryId});
        }
        if (args == null || args.isEmpty()) {
            return args;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)updateSql, args);
        return args;
    }

    private void setCodeName(Set<String> mergeCodeSet) {
        String selectCodeSql = "select a.fmergecode,b.fname from t_er_taxclasscode a LEFT join t_er_taxclasscode_l b on a.fid = b.fid where b.flocaleid = 'zh_CN' and a.fmergecode in (%s)";
        String param = "'" + StringUtils.join(mergeCodeSet, (String)"','") + "'";
        selectCodeSql = String.format(selectCodeSql, param);
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)selectCodeSql, (ResultSetHandler)new ResultSetHandler(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    UpdateInvoiceGoodsNameAndGoodsName.this.codeName.put(resultSet.getString("fmergecode"), resultSet.getString("fname"));
                }
                return null;
            }
        });
        this.notInTableCodeName.addAll(mergeCodeSet);
        this.notInTableCodeName.removeAll(this.codeName.keySet());
    }

    public static class ItemInfo {
        String goodsName;
        String goodscode;

        public ItemInfo(String goodsName, String goodscode) {
            this.goodsName = goodsName;
            this.goodscode = goodscode;
        }
    }

    public static class ResultHandle
    implements ResultSetHandler {
        private Map<Long, List<ItemInfo>> invoiceItemInfo;

        public Object handle(ResultSet resultSet) throws Exception {
            this.invoiceItemInfo = Maps.newHashMap();
            while (resultSet.next()) {
                Long invoiceEntryId = resultSet.getLong("finvoiceheadentryid");
                String goodsName = resultSet.getString("fgoodsname");
                String goodscode = resultSet.getString("fgoodscode");
                ItemInfo info = new ItemInfo(goodsName, goodscode);
                ArrayList itemInfo = this.invoiceItemInfo.get(invoiceEntryId);
                if (itemInfo == null) {
                    itemInfo = Lists.newArrayList();
                    this.invoiceItemInfo.put(invoiceEntryId, itemInfo);
                }
                itemInfo.add(info);
            }
            return null;
        }

        public Map<Long, List<ItemInfo>> getInvoiceItemInfo() {
            return this.invoiceItemInfo;
        }
    }
}

