/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.er.common.PayerTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class UpgradeCheckingPayAddPayerAccountName
implements IUpgradeService {
    private static final int BATCH_UPDATE_SIZE = 1000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String accountName;
        UpgradeResult result = new UpgradeResult();
        result.setLog("start upgrade UpgradeCheckingPayAddPayerAccountName");
        String querySql = "SELECT FID, FPAYERTYPE, FPAYERID FROM T_ER_CHECKINGPAY WHERE FPAYERACCOUNTNAME = ' '";
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(1000);
        HashMap<Long, String> orgAccountNameMap = new HashMap<Long, String>();
        HashMap<Long, String> customerAccountNameMap = new HashMap<Long, String>();
        HashMap<Long, String> supplierAccountNameMap = new HashMap<Long, String>();
        final HashMap idToOrgPayerIdMap = new HashMap();
        final HashMap idToCustomerPayerIdMap = new HashMap();
        final HashMap idToSupplierPayerIdMap = new HashMap();
        final HashSet orgIds = new HashSet();
        final HashSet customerIds = new HashSet();
        final HashSet supplierIds = new HashSet();
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)querySql, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String payerType = resultSet.getString("fpayertype");
                    Long payerId = resultSet.getLong("fpayerid");
                    Long checkingPayId = resultSet.getLong("fid");
                    if (StringUtils.isBlank((CharSequence)payerType) || payerId == 0L) continue;
                    if (payerType.equals(PayerTypeEnum.CASORG.getType())) {
                        orgIds.add(payerId);
                        idToOrgPayerIdMap.put(checkingPayId, payerId);
                        continue;
                    }
                    if (payerType.equals(PayerTypeEnum.CUSTOMER.getType())) {
                        customerIds.add(payerId);
                        idToCustomerPayerIdMap.put(checkingPayId, payerId);
                        continue;
                    }
                    if (!payerType.equals(PayerTypeEnum.SUPPLIER.getType())) continue;
                    supplierIds.add(payerId);
                    idToSupplierPayerIdMap.put(checkingPayId, payerId);
                }
                return null;
            }
        });
        String language = ResManager.getLanguage();
        ArrayList<Long> ids = new ArrayList<Long>(1);
        for (Long l : orgIds) {
            ids.add(l);
            if (ids.size() < 1000) continue;
            this.batchGetOrgPayerAccountName(ids, orgAccountNameMap, language);
            ids.clear();
        }
        if (!ids.isEmpty()) {
            this.batchGetOrgPayerAccountName(ids, orgAccountNameMap, language);
        }
        ids.clear();
        for (Map.Entry entry : idToOrgPayerIdMap.entrySet()) {
            accountName = (String)orgAccountNameMap.get(idToOrgPayerIdMap.get(entry.getKey()));
            if (StringUtils.isBlank((CharSequence)accountName)) continue;
            updateList.add(new Object[]{accountName, entry.getKey()});
        }
        for (Long l : customerIds) {
            ids.add(l);
            if (ids.size() < 1000) continue;
            this.batchGetCustomerAccountName(ids, customerAccountNameMap, language);
            ids.clear();
        }
        if (!ids.isEmpty()) {
            this.batchGetCustomerAccountName(ids, customerAccountNameMap, language);
        }
        ids.clear();
        for (Map.Entry entry : idToCustomerPayerIdMap.entrySet()) {
            accountName = (String)customerAccountNameMap.get(idToCustomerPayerIdMap.get(entry.getKey()));
            if (StringUtils.isBlank((CharSequence)accountName)) continue;
            updateList.add(new Object[]{accountName, entry.getKey()});
        }
        for (Long l : supplierIds) {
            ids.add(l);
            if (ids.size() < 1000) continue;
            this.batchGetSupplierAccountName(ids, supplierAccountNameMap, language);
            ids.clear();
        }
        if (!ids.isEmpty()) {
            this.batchGetSupplierAccountName(ids, supplierAccountNameMap, language);
        }
        ids.clear();
        for (Map.Entry entry : idToSupplierPayerIdMap.entrySet()) {
            accountName = (String)supplierAccountNameMap.get(idToSupplierPayerIdMap.get(entry.getKey()));
            if (StringUtils.isBlank((CharSequence)accountName)) continue;
            updateList.add(new Object[]{accountName, entry.getKey()});
        }
        this.batchUpdate(updateList);
        result.setLog("end upgrade UpgradeCheckingPayAddPayerAccountName");
        return result;
    }

    private void batchUpdate(List<Object[]> updateList) {
        String updateSql = "UPDATE T_ER_CHECKINGPAY SET FPAYERACCOUNTNAME = ? WHERE FID = ?";
        ArrayList<Object[]> updateListExecute = new ArrayList<Object[]>(1);
        for (Object[] objects : updateList) {
            updateListExecute.add(objects);
            if (updateListExecute.size() < 1000) continue;
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)updateSql, updateListExecute);
            updateListExecute.clear();
        }
        if (!updateListExecute.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)updateSql, updateListExecute);
        }
    }

    private void batchGetOrgPayerAccountName(List<Long> payerIds, final Map<Long, String> payerMap, final String language) {
        String querySql = "select b.facctname as accountname,b.flocaleid,a.fisdefaultrec as isdefault_bank,a.fcompanyid as companyid from t_bd_accountbanks a left join t_bd_accountbanks_l b on a.fid=b.fid where a.fcompanyid in (" + this.getJoinParam(payerIds) + ") and a.fisdefaultrec = '1'";
        DB.query((DBRoute)DBRoute.of((String)"basedata"), (String)querySql, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    if (!language.equals(resultSet.getString("flocaleid"))) continue;
                    payerMap.put(resultSet.getLong("companyid"), resultSet.getString("accountname"));
                }
                return null;
            }
        });
    }

    private void batchGetCustomerAccountName(List<Long> payerIds, final Map<Long, String> payerMap, final String language) {
        String querySql = "select b.faccountname as accountname,b.flocaleid as localeid,a.fisdefault as isdefault_bank,a.fid as id from T_BD_CustomerBank a left join T_BD_CustomerBank_l b on a.fentryid=b.fentryid where a.fid in (" + this.getJoinParam(payerIds) + ")";
        DB.query((DBRoute)DBRoute.of((String)"basedata"), (String)querySql, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    if (!resultSet.getBoolean("isdefault_bank") || !language.equals(resultSet.getString("localeid"))) continue;
                    payerMap.put(resultSet.getLong("id"), resultSet.getString("accountname"));
                }
                return null;
            }
        });
    }

    private void batchGetSupplierAccountName(List<Long> payerIds, final Map<Long, String> payerMap, final String language) {
        String querySql = "select b.faccountname as accountname,b.flocaleid as localeid,a.fisdefault as isdefault_bank,a.fid as id from T_BD_SupplierBank a left join T_BD_SupplierBank_l b on a.fentryid=b.fentryid where a.fid in (" + this.getJoinParam(payerIds) + ")";
        DB.query((DBRoute)DBRoute.of((String)"basedata"), (String)querySql, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    if (!resultSet.getBoolean("isdefault_bank") || !language.equals(resultSet.getString("localeid"))) continue;
                    payerMap.put(resultSet.getLong("id"), resultSet.getString("accountname"));
                }
                return null;
            }
        });
    }

    private String getJoinParam(List<Long> payerIds) {
        return payerIds.stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

