/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang3.StringUtils;

public class UpgradeCostCompany2LoanCheckEntry
implements IUpgradeService {
    private static int max = 999;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        this.upgradeData(result, "t_er_pubreimwrioffdet", "er_publicreimbursebill", "fsourceentryid", "fid as id ,FSRCBILLTYPE as srcbilltype,FSOURCEENTRYID as sourceentryid,FSOURCEBILLID as sourcebillid", "FCOSTCOMPANYID = 0");
        this.upgradeData(result, "t_er_writeoffdetail", "er_dailyreimbursebill", "fsourceentryid", "fid as id ,FSRCBILLTYPE as srcbilltype,FSOURCEENTRYID as sourceentryid,FSOURCEBILLID as sourcebillid", "FCOSTCOMPANYID = 0");
        this.upgradeData(result, "t_er_reimbclearloanentry", "er_tripreimbursebill", "freqaccountentryid", "fid as id,FSRCBILLTYPE as srcbilltype,FREQACCOUNTENTRYID as sourceentryid,FLOANBILLID as sourcebillid", "FCOSTCOMPANYID = 0");
        result.setLog("success");
        return result;
    }

    private void upgradeData(UpgradeResult result, String tableName, String entityName, String srcEntryName, String selectFields, String filterStr) {
        List<LoanCheckEntry> subList;
        result.setLog(String.format("begin \uff1a %s ", tableName));
        ArrayList loancheckEntrys = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList unknowTypeloancheckEntrys = Lists.newArrayListWithExpectedSize((int)16);
        String sql = String.format("select %s from %s where %s ", selectFields, tableName, filterStr);
        try (DataSet queryDataSet = DB.queryDataSet((String)"fi.upgrade.reimburse.loancheck", (DBRoute)DBRoute.of((String)"er"), (String)sql);){
            while (queryDataSet.hasNext()) {
                Row next = queryDataSet.next();
                String srcbilltype = next.getString("srcbilltype");
                Long sourceentryid = next.getLong("sourceentryid");
                if (sourceentryid == null || sourceentryid == 0L) continue;
                if (StringUtils.isBlank((CharSequence)srcbilltype)) {
                    LoanCheckEntry loanCheckEntry = new LoanCheckEntry(next.getLong("sourcebillid"), sourceentryid);
                    loanCheckEntry.setFid(next.get("id"));
                    unknowTypeloancheckEntrys.add(loanCheckEntry);
                    continue;
                }
                loancheckEntrys.add(new LoanCheckEntry(srcbilltype, (Object)sourceentryid));
                if (loancheckEntrys.size() != max) continue;
                this.updateDB(loancheckEntrys, tableName, srcEntryName);
            }
            this.updateDB(loancheckEntrys, tableName, srcEntryName);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorInfo("entityName:" + e.getMessage());
            throw e;
        }
        int size = unknowTypeloancheckEntrys.size();
        int startIndex = 0;
        int endIndex = Math.min(size, max);
        while (endIndex < size) {
            subList = unknowTypeloancheckEntrys.subList(startIndex, endIndex);
            this.process(tableName, entityName, srcEntryName, subList);
            startIndex += subList.size();
            endIndex = Math.min(size, endIndex + subList.size());
        }
        subList = unknowTypeloancheckEntrys.subList(startIndex, size);
        this.process(tableName, entityName, srcEntryName, subList);
    }

    private void process(String tableName, String entityName, String srcEntryName, List<LoanCheckEntry> unknowTypeloancheckEntrys) {
        Set<Long> fids = unknowTypeloancheckEntrys.stream().map(v -> v.getFid()).collect(Collectors.toSet());
        Map findSourceBills = BFTrackerServiceHelper.findSourceBills((String)entityName, (Long[])fids.toArray(new Long[0]));
        Iterator<LoanCheckEntry> iterator = unknowTypeloancheckEntrys.iterator();
        while (iterator.hasNext()) {
            LoanCheckEntry loanCheckentry = iterator.next();
            for (Map.Entry entry : findSourceBills.entrySet()) {
                if (!((HashSet)entry.getValue()).contains(loanCheckentry.getSourcebillid())) continue;
                loanCheckentry.setSrcbilltype(entry.getKey());
                break;
            }
            if (loanCheckentry.getSrcbilltype() != null) continue;
            iterator.remove();
        }
        this.updateDB(unknowTypeloancheckEntrys, tableName, srcEntryName);
    }

    private void updateDB(List<LoanCheckEntry> sourceentryids, String tableName, String srcentryName) {
        String sql = String.format("update %s set fcostdeptid = ? , fcostcompanyid = ? where %s = ?", tableName, srcentryName);
        List<Object[]> params = this.getParams(sourceentryids);
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)sql, params);
            sourceentryids.clear();
        }
    }

    private List<Object[]> getParams(List<LoanCheckEntry> sourceentryids) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)sourceentryids.size());
        Map map = sourceentryids.stream().collect(Collectors.groupingBy(k -> k.getSrcbilltype(), Collectors.mapping(v -> v, Collectors.toSet())));
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() == null || MetadataServiceHelper.getDataEntityType((String)entry.getKey().toString()) == null) continue;
            String billType = entry.getKey().toString();
            String entryName = this.getEntryName(billType);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)billType, (String)String.format("%s.entrycostdept as costdept ,%s.entrycostcompany as costcompany,%s.id as id", entryName, entryName, entryName), (QFilter[])new QFilter[]{new QFilter(entryName + ".id", "in", entry.getValue().stream().map(LoanCheckEntry::getSourceentryid).collect(Collectors.toList()))});
            for (DynamicObject dobj : collection) {
                list.add(new Object[]{dobj.get("costdept"), dobj.get("costcompany"), dobj.get("id")});
            }
        }
        return list;
    }

    private String getEntryName(String billType) {
        if (ErEntityTypeUtils.isTripReqBill((String)billType)) {
            return "tripentry";
        }
        return "expenseentryentity";
    }

    private static class LoanCheckEntry {
        private Object srcbilltype;
        private Object sourceentryid;
        private Object sourcebillid;
        private Object fid;

        public LoanCheckEntry(Object srcbilltype, Object sourceentryid) {
            this.srcbilltype = srcbilltype;
            this.sourceentryid = sourceentryid;
        }

        public LoanCheckEntry(Long sourcebillid, Long sourceentryid) {
            this.sourcebillid = sourcebillid;
            this.sourceentryid = sourceentryid;
        }

        public Object getSrcbilltype() {
            return this.srcbilltype;
        }

        public Object getSourceentryid() {
            return this.sourceentryid;
        }

        public Object getSourcebillid() {
            return this.sourcebillid;
        }

        public void setSrcbilltype(Object srcbilltype) {
            this.srcbilltype = srcbilltype;
        }

        public Object getFid() {
            return this.fid;
        }

        public void setFid(Object fid) {
            this.fid = fid;
        }
    }
}

