/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.util.LinkedList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;

public class UpgradeDailyReimExpenseEntryReimDeptField
implements IUpgradeService {
    private static final int BATCH_UPDATE_COUNT = 1000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setLog("upgrade UpgradeDailyReimExpenseEntryReimDeptField");
        DynamicObjectCollection dailyReimBillIdDOs = QueryServiceHelper.query((String)"er_dailyreimbursebill", (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"1=?", (Object[])new Object[]{1})});
        if (dailyReimBillIdDOs == null || dailyReimBillIdDOs.size() <= 0) {
            result.setLog(ResManager.loadKDString((String)"\u65e0\u8d39\u7528\u62a5\u9500\u5355", (String)"UpgradeDailyReimExpenseEntryReimDeptField_0", (String)"fi-er-mservice", (Object[])new Object[0]));
            return result;
        }
        for (int i = 0; i < dailyReimBillIdDOs.size(); i += 1000) {
            Object[] ids = dailyReimBillIdDOs.stream().skip(i).limit(1000L).map(entity -> entity.get("id")).toArray();
            DynamicObject[] dailyReimBillDOs = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"er_dailyreimbursebill"));
            this.updateExpenseItemEntry(dailyReimBillDOs);
        }
        result.setLog(String.format("%1$s%2$s%3$s", ResManager.loadKDString((String)"\u5171\u5347\u7ea7", (String)"UpgradeDailyReimExpenseEntryReimDeptField_1", (String)"fi-er-mservice", (Object[])new Object[0]), dailyReimBillIdDOs.size(), ResManager.loadKDString((String)"\u6761\u8d39\u7528\u62a5\u9500\u5355", (String)"UpgradeDailyReimExpenseEntryReimDeptField_2", (String)"fi-er-mservice", (Object[])new Object[0])));
        return result;
    }

    private void updateExpenseItemEntry(DynamicObject[] dailyReimBillDOs) {
        LinkedList<Object[]> args = new LinkedList<Object[]>();
        for (DynamicObject dailyReimBillDO : dailyReimBillDOs) {
            DynamicObjectCollection expenseEntryDOs = dailyReimBillDO.getDynamicObjectCollection("expenseentryentity");
            DynamicObject companyDO = dailyReimBillDO.getDynamicObject("company");
            Long companyId = ErCommonUtils.getPk((Object)companyDO);
            if (companyId == null) continue;
            for (int i = 0; i < expenseEntryDOs.size(); ++i) {
                DynamicObject deptDO = ReimburseControlUtils.getDeptReimbureControlOrg((Long)companyId, (DynamicObject)dailyReimBillDO, (DynamicObject)((DynamicObject)expenseEntryDOs.get(i)));
                if (deptDO == null) continue;
                args.add(new Object[]{ErCommonUtils.getPk((Object)deptDO), ((DynamicObject)expenseEntryDOs.get(i)).getPkValue()});
            }
        }
        if (!args.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"UPDATE T_ER_EXPENSEDETAIL SET FREIMCTLDEPTID = ? WHERE FDETAILID = ? AND (FREIMCTLDEPTID IS NULL OR FREIMCTLDEPTID = 0);", args);
        }
    }
}

