/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;

public class UpgradeInvoiceAttachmentV2
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(UpgradeInvoiceAttachmentV2.class);
    private static final int BATCH_SIZE = 2000;
    private static final String ATTACH_INFO_TABLE_NAME = "t_er_invoiceattachinfo";
    private static final String INSERT_ATTACH_ENTRY_SQL = "insert into t_er_invoiceattachinfo(fid, fentryid, fattachno, fattachname, foriginalname, fattachtype, fattachurl, fgathertime, fattachremark) values (?, ?, ?, ?, ?, ?, ?, ?, ?);";
    private static final String INSERT_HISTORY_BILL_SQL = "insert into T_ER_INVATTACHHB(fid,fcostcompany, fbillno, fentityname) values(?, ?, ?, ?);";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        boolean success;
        UpgradeResult result = new UpgradeResult();
        logger.info("start upgrade UpgradeInvoiceAttachmentV2");
        long startTime = System.nanoTime();
        HashMap<String, String[]> tableIds = new HashMap<String, String[]>(){
            {
                this.put("t_er_dailyreimbursebill", new String[]{"er_dailyreimbursebill", "t_er_dailyreimbursebill", "fcostcompanyid"});
                this.put("t_er_reimbursebill", new String[]{"er_tripreimbursebill", "t_er_reimbursebill", "fcostcompanyid"});
                this.put("t_er_pubreimbill", new String[]{"er_publicreimbursebill", "t_er_pubreimbill", "fcostcompanyid"});
                this.put("t_er_contractbill", new String[]{"er_contractbill", "t_er_contractbill_S", "fcostcompanyid"});
                this.put("t_er_dailyloanbill", new String[]{"er_dailyloanbill", "t_er_dailyloanbill", "fcostcompanyid"});
                this.put("t_er_dailyapplybill", new String[]{"er_dailyapplybill", "t_er_dailyapplybill", "fcostcompanyid"});
                this.put("t_er_prepaybill", new String[]{"er_prepaybill", "t_er_prepaybill", "fcostcompanyid"});
                this.put("t_er_applyprojectbill", new String[]{"er_applyprojectbill", "t_er_applyprojectbill_s", "fcostcompanyid"});
                this.put("t_er_costestimatebill", new String[]{"er_costestimatebill", "t_er_costestimatebill", "fcostcompanyid"});
                this.put("t_er_withholdingbill", new String[]{"er_withholdingbill", "t_er_withholdingbill", "fcostcompanyid"});
                this.put("t_er_checkingpay", new String[]{"er_checkingpaybill", "t_er_checkingpay", "fcompany"});
                this.put("T_ER_ReqBill", new String[]{"er_tripreqbill", "T_ER_ReqBill_a", "FCostCompanyID"});
            }
        };
        boolean enableXh = KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud();
        logger.info("UpgradeInvoiceAttachmentV2 current use :" + (enableXh ? "xh" : "aws"));
        result.setLog("UpgradeInvoiceAttachmentV2 current use :" + (enableXh ? "xh" : "aws"));
        String fmt = "select a.fid,a.%s,a.fbillno from %s as a inner join %s as b on a.fid = b.fid where a.fbillstatus not in ('H', 'I') and b.finvokeinvoicecloud = '1' and a.fid not in (select c.fid from t_er_invoiceattachinfo as c)";
        for (Map.Entry entry : tableIds.entrySet()) {
            String a = (String)entry.getKey();
            String[] entryValue = (String[])entry.getValue();
            String entityName = entryValue[0];
            String costCompany = entryValue[2];
            String b = entryValue[1];
            String select = String.format(fmt, costCompany, a, b);
            HashMap billIds = new HashMap(2000);
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)select, resultSet -> {
                while (resultSet.next()) {
                    Long fid = resultSet.getLong("fid");
                    Long costCompanyId = resultSet.getLong(costCompany);
                    String billNo = resultSet.getString("fbillno");
                    billIds.put(fid, new Object[]{costCompanyId, billNo});
                    if (billIds.size() < 2000) continue;
                    this.handleBills(billIds, entityName, enableXh);
                }
                if (billIds.size() > 0) {
                    this.handleBills(billIds, entityName, enableXh);
                }
                return null;
            });
        }
        boolean existConfig = KingdeeInvoiceCloudConfig.existConfig();
        if (!enableXh && existConfig && !(success = this.insertSchedulePlan())) {
            logger.info("UpgradeInvoiceAttachmentV2 insert schedule plan failed.");
        }
        long endTime = System.nanoTime();
        logger.info(String.format("end upgrade UpgradeInvoiceAttachmentV2 cost time : %d", endTime - startTime));
        return result;
    }

    private void handleBills(Map<Long, Object[]> billIds, String entityName, boolean enableXh) {
        if (!enableXh) {
            List bills = billIds.entrySet().stream().map(e -> new Object[]{e.getKey(), ((Object[])e.getValue())[0], ((Object[])e.getValue())[1], entityName}).collect(Collectors.toList());
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)INSERT_HISTORY_BILL_SQL, bills);
        } else {
            String params = billIds.keySet().stream().map(e -> String.valueOf(e)).collect(Collectors.joining("','"));
            String fmt = "select fexpense_id,fattach_no,fattach_url,fattach_name,foriginal_name,fremark,fattach_type,fcreate_time from t_rim_attach a inner join t_rim_attach_relation b on ''||a.fid = b.fattach_id where fexpense_id in ('%s');";
            String selectAttach = String.format(fmt, params);
            logger.info("UpgradeInvoiceAttachmentV2 -> handleBills ids: " + params);
            ArrayList newRecords = new ArrayList(2000);
            DB.query((DBRoute)DBRoute.of((String)"taxc"), (String)selectAttach, resultSet1 -> {
                while (resultSet1.next()) {
                    Long fid = resultSet1.getLong("fexpense_id");
                    String attachNo = resultSet1.getString("fattach_no");
                    String attachName = resultSet1.getString("fattach_name");
                    String foriginal_name = resultSet1.getString("foriginal_name");
                    String fattach_type = resultSet1.getString("fattach_type");
                    String fattach_url = resultSet1.getString("fattach_url");
                    Date fcreate_time = resultSet1.getDate("fcreate_time");
                    String fremark = resultSet1.getString("fremark");
                    logger.info("UpgradeInvoiceAttachmentV2 -> handleBills billid\uff1a" + entityName + "-" + fid + ", attachNo\uff1a" + attachNo);
                    newRecords.add(new Object[]{fid, 0, attachNo, attachName, foriginal_name, fattach_type, fattach_url, fcreate_time, fremark});
                    if (newRecords.size() < 2000) continue;
                    this.insertNewRecords(newRecords);
                }
                if (newRecords.size() > 0) {
                    this.insertNewRecords(newRecords);
                }
                return null;
            });
        }
        billIds.clear();
    }

    private void insertNewRecords(List<Object[]> newRecords) {
        long[] ids = DB.genLongIds((String)ATTACH_INFO_TABLE_NAME, (int)newRecords.size());
        for (int j = 0; j < ids.length; ++j) {
            newRecords.get((int)j)[1] = ids[j];
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)INSERT_ATTACH_ENTRY_SQL, newRecords);
        newRecords.clear();
    }

    private boolean insertSchedulePlan() {
        return DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)"DELETE FROM T_SCH_JOB WHERE FID = '3BID07AP4L=6';\nINSERT INTO T_SCH_JOB(FID,FTASKCLASSNAME,FTASKDEFINEID,FRUNMODE,FRUNBYUSERID,FJOBTYPE,FSTATUS,FNUMBER,FCONCURRENT,FSTRATEGY,FTIMEOUT,FRETRYTIME,FRUNBYLANG,FCANSTOP,FPARAMS,FRUNBYORGID) VALUES ('3BID07AP4L=6','kd.fi.er.business.invoicecloud.task.TInvoiceAttachUpgradeTask','3BICF0FBXTZ9','0',1236081998485809152,'BIZ','1','em_invoiceattach_sync_SKDJ_S','1','1',0,0,' ','0','{}',0);\nDELETE FROM T_SCH_JOB_L WHERE FPKID = '3BID07AP6GO4';\nINSERT INTO T_SCH_JOB_L(FID,FPKID,FLOCALEID,FNAME) VALUES ('3BID07AP4L=6','3BID07AP6GO4','zh_CN','\u8d39\u7528-\u53d1\u7968\u96c6\u6210-\u9644\u4ef6\u540c\u6b65');\nDELETE FROM T_SCH_JOB_N WHERE FID = '3BID07AP4L=6';\nINSERT INTO T_SCH_JOB_N(FID,FJOBPRINCIPAL,FOVERTIME,FSUCCESSNOTIFY,FJOBMSGRECEIVER,FMSGCONTENT,FFAILNOTIFY,FNOTIFYTYPE,FCAPTION) VALUES ('3BID07AP4L=6',1236081998485809152,'0','0',0,' ','1',' ','\u8c03\u5ea6\u4f5c\u4e1a\u901a\u77e5');\n\nDELETE FROM T_SCH_SCHEDULE WHERE FID = '3BIE3=A/UN90';\nINSERT INTO T_SCH_SCHEDULE(FTWENTY,FFIVE,FELEVEN,FNINE,FNO,FSUN,FTWO,FEIGHT,FNOV,FPLAN,FWED,FHOST,FTWENTYTWO,FFOUR,FMAR,FSEP,FENDTIME,FSIX,FMAY,FREPEATMODE,FTHIRTYONE,FBYDAYORWEEK,FTWENTYSEVEN,FTWENTYSIX,FTHIRTEEN,FAUG,FDESC,FFIFTEEN,FTWENTYONE,FBYWEEK,FTUES,FSEVENTEEN,FSEVEN,FTWENTYFOUR,FMON,FTHIRTY,FTHREE,FFOURTEEN,FJAN,FNINETEEN,FTHUR,FTEN,FFRI,FJOBID,FSTARTTIME,FOCT,FAPR,FSIXTEEN,FID,FSAT,FONE,FTWENTYEIGHT,FTWENTYTHREE,FTWELVE,FNOWEEK,FSTATUS,FNUMBER,FTWENTYFIVE,FEIGHTEEN,FCYCLENUM,FTWENTYNINE,FJUL,FDEC,FJUN,FFEB) VALUES ('0','0','0','0',' ','0','0','0','0','0 0 0 12 6 ? 2023','0','172.19.81.72','0','0','0','0',{ts'2099-12-31  00:00:00'},'0','0','n','0','d','0','0','0','0','\u4e8b\u4ef6\u4e0d\u91cd\u590d','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','3BID07AP4L=6',{ts'2023-06-12  00:00:00'},'0','0','0','3BIE3=A/UN90','0','0','0','0','0',' ','1','em_SyncInvoiceAttachment_SKDP_S','0','0',1,'0','0','0','0','0');\nDELETE FROM T_SCH_SCHEDULE_L WHERE FPKID = '3BIE3=A/WIN+';\nINSERT INTO T_SCH_SCHEDULE_L(FID,FPKID,FLOCALEID,FNAME) VALUES ('3BIE3=A/UN90','3BIE3=A/WIN+','zh_CN','\u8d39\u7528-\u53d1\u7968\u96c6\u6210-\u53d1\u7968\u4e91\u9644\u4ef6\u5386\u53f2\u6570\u636e\u5347\u7ea7');\nDELETE FROM T_SCH_SCHEDULE_L WHERE FPKID = '3BIE3=A/WIN/';\nINSERT INTO T_SCH_SCHEDULE_L(FID,FPKID,FLOCALEID,FNAME) VALUES ('3BIE3=A/UN90','3BIE3=A/WIN/','zh_TW','\u8cbb\u7528-\u767c\u7968\u96c6\u6210-\u767c\u7968\u96f2\u9644\u4ef6\u66c6\u53f2\u6578\u64da\u5347\u7d1a');\nDELETE FROM T_SCH_SCHEDULE_N WHERE FID = '3BIE3=A/UN90';\nINSERT INTO T_SCH_SCHEDULE_N(FID,FSNOTIFYTYPE,FMSGRECEIVER,FSMSGCONTENT,FSTIMEOUT,FSCHPRINCIPAL,FSSUCCESSNOTIFY,FSFAILNOTIFY) VALUES ('3BIE3=A/UN90',' ',0,' ','0',0,'0','1');\nDELETE FROM T_SCH_SCHEDULE_ENTRY WHERE FENTRYID = '3BIE3=A/UN91';\nINSERT INTO T_SCH_SCHEDULE_ENTRY(FID,FJOBNUMBER,FENTRYID,FSEQ) VALUES ('3BIE3=A/UN90','3BID07AP4L=6','3BIE3=A/UN91',1);\n\nDELETE FROM T_SCH_TASKDEFINE WHERE FID = '3BICF0FBXTZ9';\nINSERT INTO T_SCH_TASKDEFINE(FID,FCLASSNAME,FAPPID,FNUMBER) VALUES ('3BICF0FBXTZ9','kd.fi.er.business.invoicecloud.task.TInvoiceAttachUpgradeTask','em','er_syncInvoiceAttachment');\nDELETE FROM T_SCH_TASKDEFINE_L WHERE FPKID = '3BICF0FBVYKA';\nINSERT INTO T_SCH_TASKDEFINE_L(FID,FPKID,FLOCALEID,FNAME) VALUES ('3BICF0FBXTZ9','3BICF0FBVYKA','zh_CN','\u8d39\u7528-\u53d1\u7968\u96c6\u6210-\u540c\u6b65\u9644\u4ef6');\nDELETE FROM T_SCH_TASKDEFINE_L WHERE FPKID = '3BICF0FBVYKB';\nINSERT INTO T_SCH_TASKDEFINE_L(FID,FPKID,FLOCALEID,FNAME) VALUES ('3BICF0FBXTZ9','3BICF0FBVYKB','zh_TW','\u8cbb\u7528-\u767c\u7968\u96c6\u6210-\u540c\u6b65\u9644\u4ef6');");
    }
}

