/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class UpgradeMappingExpenseItemServiceImpl
implements IUpgradeService {
    private static final int BATCH_SIZE = 2000;
    private static final String insertExpRangeSql = "insert into t_er_expenseitemrange(fid, fentryid, fseq, fentryexpenseitem, fisdefault) values (?, ?, ?, ?, ?);";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setLog("start upgrade UpgradeMappingExpenseItemServiceImpl");
        ArrayList insertList = new ArrayList(1000);
        String selectSql = "select fid, fexpenseitemid from t_er_rel_exp_ratetype";
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)selectSql, resultSet -> {
            while (resultSet.next()) {
                Long fid = resultSet.getLong("fid");
                Long fexpenseitemid = resultSet.getLong("fexpenseitemid");
                insertList.add(new Object[]{fid, 0, 1, fexpenseitemid, Character.valueOf('1')});
                if (insertList.size() != 2000) continue;
                this.insertNewRecords(result, insertList);
            }
            if (insertList.size() > 0) {
                result.setLog(String.format("UpgradeMappingExpenseItemServiceImpl: %d items left need to process", insertList.size()));
                this.insertNewRecords(result, insertList);
            }
            return null;
        });
        result.setLog("finish UpgradeMappingExpenseItemServiceImpl");
        return result;
    }

    private void insertNewRecords(UpgradeResult result, List<Object[]> insertList) {
        List<Object[]> newRecords = this.getNewRecords(result, insertList);
        if (newRecords.isEmpty()) {
            return;
        }
        long[] ids = ORM.create().genLongIds("er_rel_expense_ratetype", newRecords.size());
        for (int i = 0; i < ids.length; ++i) {
            newRecords.get((int)i)[1] = ids[i];
        }
        result.setLog(String.format("insertNewRecords: %s", Arrays.toString(newRecords.toArray())));
        DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)insertExpRangeSql, newRecords);
        insertList.clear();
    }

    private List<Object[]> getNewRecords(UpgradeResult result, List<Object[]> insertList) {
        Set ids = insertList.stream().map(e -> (Long)e[0]).collect(Collectors.toSet());
        String params = Stream.generate(() -> "?").limit(ids.size()).collect(Collectors.joining(","));
        String sql = String.format("select t.fid from t_er_expenseitemrange t where t.fid in (%s);", params);
        HashSet idsExist = new HashSet(params.length());
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])ids.toArray(), resultSet -> {
            while (resultSet.next()) {
                Long fid = resultSet.getLong("fid");
                if (fid == null) continue;
                idsExist.add(fid);
            }
            return null;
        });
        result.setLog(String.format(ResManager.loadKDString((String)"\u6620\u5c04\u8d39\u7528\u9879\u76ee\u8bb0\u5f55 ids: %1$s, \u6570\u636e\u5e93\u4e2d\u5df2\u7ecf\u5b58\u5728\u7684\u8bb0\u5f55 idsExist \uff1a%2$s", (String)"UpgradeMappingExpenseItemServiceImpl_1", (String)"fi-er-business", (Object[])new Object[0]), ids, idsExist));
        List<Object[]> newRecords = insertList.stream().filter(e -> !idsExist.contains(e[0])).collect(Collectors.toList());
        return newRecords;
    }
}

