/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.util.Date;
import java.util.LinkedList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class UpgradeTripReimExpenseFieldImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(UpgradeTripReimExpenseFieldImpl.class);
    private static final int BATCH_UPDATE_COUNT = 1000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setLog("upgrade UpgradeTripReimExpenseFieldImpl");
        DynamicObjectCollection dailyReimBillIdDOs = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"1=?", (Object[])new Object[]{1})});
        if (dailyReimBillIdDOs == null || dailyReimBillIdDOs.size() <= 0) {
            result.setLog(ResManager.loadKDString((String)"\u65e0\u5dee\u65c5\u62a5\u9500\u5355", (String)"UpgradeTripReimExpenseFieldImpl_0", (String)"fi-er-mservice", (Object[])new Object[0]));
            return result;
        }
        DynamicObjectCollection tripReimBillIds = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"1=?", (Object[])new Object[]{1})});
        if (tripReimBillIds == null || tripReimBillIds.size() < 1) {
            result.setLog(ResManager.loadKDString((String)"\u65e0\u5dee\u65c5\u62a5\u9500\u5355", (String)"UpgradeTripReimExpenseFieldImpl_0", (String)"fi-er-mservice", (Object[])new Object[0]));
            return result;
        }
        for (int i = 0; i < tripReimBillIds.size(); i += 1000) {
            Object[] ids = tripReimBillIds.stream().skip(i).limit(1000L).map(entity -> entity.get("id")).toArray();
            DynamicObject[] tripReimBillDOs = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"er_tripreimbursebill"));
            this.updateExpenseEntry(tripReimBillDOs);
        }
        result.setLog(String.format("%1$s%2$s%3$s", ResManager.loadKDString((String)"\u5171\u5347\u7ea7", (String)"UpgradeTripReimExpenseFieldImpl_1", (String)"fi-er-mservice", (Object[])new Object[0]), tripReimBillIds.size(), ResManager.loadKDString((String)"\u6761\u5dee\u65c5\u62a5\u9500\u5355", (String)"UpgradeTripReimExpenseFieldImpl_2", (String)"fi-er-mservice", (Object[])new Object[0])));
        return result;
    }

    private void updateExpenseEntry(DynamicObject[] tripReimBillDOs) {
        LinkedList<Object[]> headArgs = new LinkedList<Object[]>();
        LinkedList<Object[]> tripEntryArgs = new LinkedList<Object[]>();
        LinkedList<Object[]> entryArgs = new LinkedList<Object[]>();
        for (DynamicObject tripReimBillDO : tripReimBillDOs) {
            Date bizdate = tripReimBillDO.getDate("bizdate");
            if (bizdate == null) {
                log.info("UpgradeTripReimExpenseFieldImpl,\u591a\u8d39\u7528-\u5386\u53f2\u6570\u636e\u5347\u7ea7,\u5f53\u524d\u5355\u636e\u7533\u8bf7\u65e5\u671f\u4e3a\u7a7a," + tripReimBillDO.getString("billno"));
                continue;
            }
            headArgs.add(new Object[]{bizdate, tripReimBillDO.getPkValue()});
            DynamicObjectCollection tripEntrys = tripReimBillDO.getDynamicObjectCollection("tripentry");
            if (tripEntrys == null || tripEntrys.size() < 1) continue;
            String billkind = tripReimBillDO.getString("billkind");
            DynamicObject costcompany = tripReimBillDO.getDynamicObject("costcompany");
            Long costcompanyId = costcompany == null ? Long.valueOf(0L) : (Long)costcompany.getPkValue();
            DynamicObject costdept = tripReimBillDO.getDynamicObject("costdept");
            Long costdeptId = costdept == null ? Long.valueOf(0L) : (Long)costdept.getPkValue();
            DynamicObject headexpenseitem = tripReimBillDO.getDynamicObject("headexpenseitem");
            Long headexpenseitemId = headexpenseitem == null ? Long.valueOf(0L) : (Long)headexpenseitem.getPkValue();
            for (int i = 0; i < tripEntrys.size(); ++i) {
                DynamicObject tripEntry = (DynamicObject)tripEntrys.get(i);
                tripEntryArgs.add(new Object[]{bizdate, tripEntry.getPkValue()});
                DynamicObject tripEntryCostcompany = tripEntry.getDynamicObject("entrycostcompany");
                Long tripEntryCostcompanyId = tripEntryCostcompany == null ? Long.valueOf(0L) : (Long)tripEntryCostcompany.getPkValue();
                DynamicObject tripEntryCostdept = tripEntry.getDynamicObject("entrycostdept");
                Long tripEntryCostdeptId = tripEntryCostdept == null ? Long.valueOf(0L) : (Long)tripEntryCostdept.getPkValue();
                DynamicObject tripEntryExpenseitem = tripEntry.getDynamicObject("tripexpenseitem");
                Long tripEntryExpenseitemId = tripEntryExpenseitem == null ? Long.valueOf(0L) : (Long)tripEntryExpenseitem.getPkValue();
                DynamicObjectCollection expenseEntryDOs = tripEntry.getDynamicObjectCollection("entryentity");
                if (expenseEntryDOs == null || expenseEntryDOs.size() < 1) continue;
                for (int j = 0; j < expenseEntryDOs.size(); ++j) {
                    DynamicObject entry = (DynamicObject)expenseEntryDOs.get(j);
                    if ("1".equals(billkind)) {
                        entryArgs.add(new Object[]{bizdate, headexpenseitemId, costcompanyId, costdeptId, costdeptId, entry.getPkValue()});
                        continue;
                    }
                    entryArgs.add(new Object[]{bizdate, tripEntryExpenseitemId, tripEntryCostcompanyId, tripEntryCostdeptId, costdeptId, entry.getPkValue()});
                }
            }
        }
        if (!headArgs.isEmpty()) {
            // empty if block
        }
        if (!tripEntryArgs.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"UPDATE T_ER_REIMBURSETRIPENTRY SET FTRIPHAPPENDATE = ? WHERE FENTRYID = ? ;", tripEntryArgs);
        }
        if (!entryArgs.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"UPDATE T_ER_REIMBURSEENTRY SET FTRAVELHAPPENDATE = ?, FTRAVELEXPENSEITEM = ?, FTRAVELCOSTCOMPANY = ?, FTRAVELCOSTDEPT = ?, FTRAVELQUOTACTLDEPT = ? WHERE FDETAILID = ? ;", entryArgs);
        }
    }
}

