/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.tripstd.model.TripStandardDetail;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripHighSeasonStandardUtil;
import kd.fi.er.common.ControlMethodEnum;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;
import kd.fi.er.formplugin.web.tripstandard.util.TripStandardUtils;
import org.apache.commons.lang3.StringUtils;

public class UpgradeTripReimburseTripSumImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(UpgradeTripReimburseTripSumImpl.class);
    private static final int BATCH_UPDATE_COUNT = 1000;
    private static HashSet<String> vehicleAttributes = Sets.newHashSet((Object[])new String[]{"2", "4", "7", "3"});
    private static HashSet<String> accommodationAttributes = Sets.newHashSet((Object[])new String[]{"5"});
    private static HashSet<String> allowanceAttributes = Sets.newHashSet((Object[])new String[]{"1"});
    private static HashSet<String> notOthers = Sets.newHashSet((Object[])new String[]{"2", "4", "7", "5", "1", "3"});
    private static volatile HashMap<String, Boolean> map = new HashMap(2048);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DynamicObjectCollection tripReimBillIds = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billstatus", "!=", (Object)"A")});
        if (tripReimBillIds == null || tripReimBillIds.size() < 1) {
            result.setLog(ResManager.loadKDString((String)"\u65e0\u5dee\u65c5\u62a5\u9500\u5355", (String)"UpgradeTripReimExpenseFieldImpl_0", (String)"fi-er-mservice", (Object[])new Object[0]));
            return result;
        }
        try {
            ORM orm = ORM.create();
            WithDistinctable withDistinctable = WithDistinctable.get();
            DataSet dataSet = orm.queryDataSet("UpgradeTripReimburseTripSumImpl", "er_tripreimbursebill", "company", new QFilter[]{new QFilter("billstatus", "!=", (Object)"A")}, "", -1, (Distinctable)withDistinctable);
            Iterator iterator = dataSet.iterator();
            ArrayList<Long> list = new ArrayList<Long>(10000);
            while (iterator.hasNext()) {
                list.add(((Row)iterator.next()).getLong("company"));
            }
            for (Long companyId : list) {
                companyId = companyId == null ? Long.valueOf(0L) : companyId;
                UpgradeTripReimburseTripSumImpl.getSysParamter(companyId, "sumcheck");
                UpgradeTripReimburseTripSumImpl.getSysParamter(companyId, "enabled");
                UpgradeTripReimburseTripSumImpl.getSysParamter(companyId, "accdallowance");
                UpgradeTripReimburseTripSumImpl.getSysParamter(companyId, "vehicle");
            }
            list = null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        AtomicLong count = new AtomicLong(0L);
        CountDownLatch countDownLatch = null;
        ThreadPool threadPool = null;
        try {
            threadPool = ThreadPools.newFixedThreadPool((String)("UpgradeTripReimburseTripSumImpl_" + System.currentTimeMillis()), (int)10);
            int times = tripReimBillIds.size() / 1000 + (tripReimBillIds.size() % 1000 == 0 ? 0 : 1);
            CountDownLatch finalCountDownLatch = countDownLatch = new CountDownLatch(times);
            int i = 0;
            int j = 0;
            while (j < times) {
                int m = i;
                ++j;
                threadPool.execute(() -> {
                    try {
                        Object[] ids = tripReimBillIds.stream().skip(m).limit(1000L).map(entity -> entity.get("id")).toArray();
                        QFilter qFilter = new QFilter("id", "in", (Object)ids);
                        DynamicObject[] tripReimBillDOs = BusinessDataServiceHelper.load((String)"er_tripreimbursebill", (String)"company,currency,billkind,tripentry.tripvehicleamount,tripentry.tripvehicleover,tripentry.tripaccommodationamt,tripentry.tripaccommodationover,tripentry.tripallowanceamount,tripentry.tripallowanceover,tripentry.tripotheramount,tripentry.istravelers,tripentry.enddate,tripentry.startdate,tripentry.travelers,tripentry.travelers.fbasedataid,entryentity.expenseitem,entryentity.expenseitem.attribute,entryentity.isover,entryentity.entryappamount,entryentity.entrycurrency,entryentity.iscancelorder,entryentity.useroutstdctrl,entryentity.tripstandardamount,entryentity.hightripstandardamount,entryentity.caldaycount,entryentity.highseasondaycount,entryentity.originhighseasondays,entryentity.triparea,tripentry.tripday, tripentry.entryentity, entryentity.daycount, istravelers, entryentity.exchangerate, entryentity.detailquotetype", (QFilter[])new QFilter[]{qFilter});
                        long c = this.updateExpenseEntry(tripReimBillDOs);
                        tripReimBillDOs = null;
                        count.addAndGet(c);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        finalCountDownLatch.countDown();
                    }
                });
                i += 1000;
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            result.setLog("error " + exception.getMessage());
        }
        boolean res = false;
        try {
            if (countDownLatch != null) {
                res = countDownLatch.await(1600L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setLog(result.getLog() + e.getMessage());
        }
        if (threadPool != null) {
            threadPool.close();
        }
        result.setLog("result : " + res + result.getLog() + "UpgradeTripReimburseTripSumImpl success : " + count.get());
        result.setSuccess(true);
        return result;
    }

    private long updateExpenseEntry(DynamicObject[] dailyReimBillDOs) {
        LinkedList<Object[]> args = new LinkedList<Object[]>();
        AtomicLong count = new AtomicLong(0L);
        for (DynamicObject dailyReimBillDO : dailyReimBillDOs) {
            try {
                Map<Long, List> map = UpgradeTripReimburseTripSumImpl.calculate(dailyReimBillDO);
                DynamicObjectCollection tripEntryCollction = dailyReimBillDO.getDynamicObjectCollection("tripentry");
                if (tripEntryCollction == null || tripEntryCollction.size() == 0 || map == null) continue;
                for (int i = 0; i < tripEntryCollction.size(); ++i) {
                    DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(i);
                    List list = map.get(tripEntry.getPkValue());
                    args.add(new Object[]{list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5), list.get(6), tripEntry.getPkValue()});
                }
                count.addAndGet(1L);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (!args.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"UPDATE T_ER_ReimburseTripEntry SET ftripvehicleamount = ?, ftripvehicleover = ?, ftripaccommodationamt = ?,ftripaccommodationover = ?, ftripallowanceamount = ?, ftripallowanceover = ?,ftripotheramount = ? WHERE FENTRYID = ? ;", args);
            args.clear();
        }
        return count.get();
    }

    private static boolean getSysParamter(Long companyId, String key) {
        Boolean result = null;
        result = map.get(companyId + "_" + key);
        if (result == null) {
            if ("sumcheck".equals(key)) {
                result = SystemParamterUtil.getTripStdNeedSumCheck((long)companyId);
            } else if ("enabled".equals(key)) {
                result = UpgradeTripReimburseTripSumImpl.isEnableStandard(companyId);
            } else if ("accdallowance".equals(key)) {
                result = UpgradeTripReimburseTripSumImpl.isEnableAccdAllowance(companyId);
            } else if ("vehicle".equals(key)) {
                result = UpgradeTripReimburseTripSumImpl.isEnableVehicle(companyId);
            }
            map.put(companyId + "_" + key, result);
        }
        return result == null ? false : result;
    }

    public static Map<Long, List> calculate(DynamicObject bill) {
        Long companyId = ErCommonUtils.getPk((Object)bill.get("company"));
        companyId = companyId == null ? Long.valueOf(0L) : companyId;
        boolean sumcheck = UpgradeTripReimburseTripSumImpl.getSysParamter(companyId, "sumcheck");
        boolean enabled = UpgradeTripReimburseTripSumImpl.getSysParamter(companyId, "enabled");
        boolean accdallowance = UpgradeTripReimburseTripSumImpl.getSysParamter(companyId, "accdallowance");
        boolean enableAccdAllowanceStd = enabled && accdallowance;
        boolean isEnableVehicle = UpgradeTripReimburseTripSumImpl.getSysParamter(companyId, "vehicle");
        boolean enableVehicleStd = enabled && isEnableVehicle;
        int precision = 2;
        try {
            CurrencyBO currency = new CurrencyBO(ErCommonUtils.getPk((Object)bill.get("currency")));
            precision = currency.getPrecision();
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage(), (Throwable)exception);
        }
        String billKind = bill.getString("billkind");
        DynamicObjectCollection tripEntryCollction = bill.getDynamicObjectCollection("tripentry");
        HashMap<Long, List> map = new HashMap<Long, List>(4);
        for (int tripEntryIndex = 0; tripEntryIndex < tripEntryCollction.size(); ++tripEntryIndex) {
            DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(tripEntryIndex);
            BigDecimal tripvehicleamount = BigDecimal.ZERO;
            BigDecimal tripaccommodationamount = BigDecimal.ZERO;
            BigDecimal tripallowanceamount = BigDecimal.ZERO;
            BigDecimal tripotheramount = BigDecimal.ZERO;
            BigDecimal tripaccommodationover = BigDecimal.ZERO;
            BigDecimal tripallowanceover = BigDecimal.ZERO;
            String tripvehicleover = "0";
            ArrayList<String> groupby = new ArrayList<String>(4);
            DynamicObjectCollection detailEntryCollction = tripEntry.getDynamicObjectCollection("entryentity");
            for (int detailEntryIndex = 0; detailEntryIndex < detailEntryCollction.size(); ++detailEntryIndex) {
                String attribute;
                DynamicObject detailEntry = (DynamicObject)detailEntryCollction.get(detailEntryIndex);
                DynamicObject expenseItem = (DynamicObject)detailEntry.get("expenseitem");
                String string = attribute = expenseItem == null ? "" : expenseItem.getString("attribute");
                if (expenseItem != null && vehicleAttributes.contains(attribute)) {
                    tripvehicleamount = tripvehicleamount.add(detailEntry.getBigDecimal("entryappamount"));
                    if (!Arrays.asList("2", "4", "7").contains(attribute) || !enableVehicleStd || !"1".equals(detailEntry.getString("isover"))) continue;
                    tripvehicleover = "1";
                    continue;
                }
                RefObject refObject = new RefObject((Object)BigDecimal.ZERO);
                boolean isover = false;
                boolean over = false;
                if (enableAccdAllowanceStd && (accommodationAttributes.contains(attribute) || allowanceAttributes.contains(attribute))) {
                    if (sumcheck && !"1".equals(billKind)) {
                        if (!groupby.contains(TripStandardUtils.fetchGroupKey((DynamicObject)detailEntry, (String[])new String[]{"expenseitem", "entrycurrency"}))) {
                            if (!detailEntry.getBoolean("useroutstdctrl")) {
                                over = UpgradeTripReimburseTripSumImpl.checkSumGroupStdIsOver(bill, detailEntry, detailEntryCollction, tripEntryIndex, detailEntryIndex, precision, (RefObject<BigDecimal>)refObject, "expenseitem", "entrycurrency");
                            }
                            if (over) {
                                groupby.add(TripStandardUtils.fetchGroupKey((DynamicObject)detailEntry, (String[])new String[]{"expenseitem", "entrycurrency"}));
                            }
                        } else {
                            refObject = new RefObject((Object)BigDecimal.ZERO);
                        }
                    } else {
                        isover = UpgradeTripReimburseTripSumImpl.checkAccdAllowanceEntryStdIsOver(companyId, detailEntry, tripEntryIndex, detailEntryIndex, precision, (RefObject<BigDecimal>)refObject);
                    }
                }
                if (expenseItem == null || !notOthers.contains(attribute)) {
                    tripotheramount = tripotheramount.add(detailEntry.getBigDecimal("entryappamount"));
                    continue;
                }
                if (accommodationAttributes.contains(attribute)) {
                    tripaccommodationamount = tripaccommodationamount.add(detailEntry.getBigDecimal("entryappamount"));
                    if (!isover && !over) continue;
                    tripaccommodationover = tripaccommodationover.add((BigDecimal)refObject.getValue());
                    continue;
                }
                if (!allowanceAttributes.contains(attribute)) continue;
                tripallowanceamount = tripallowanceamount.add(detailEntry.getBigDecimal("entryappamount"));
                if (!isover && !over) continue;
                tripallowanceover = tripallowanceover.add((BigDecimal)refObject.getValue());
            }
            map.put((Long)tripEntry.getPkValue(), Arrays.asList(tripvehicleamount, tripvehicleover, tripaccommodationamount, tripaccommodationover, tripallowanceamount, tripallowanceover, tripotheramount));
        }
        return map;
    }

    private static boolean checkAccdAllowanceEntryStdIsOver(Long companyId, DynamicObject entry, int parentEntryIndex, int curEntryIndex, int amtprecision, RefObject<BigDecimal> refObject) {
        boolean isOverStd = false;
        boolean isCancelOrder = entry.getBoolean("iscancelorder");
        BigDecimal oriEntryAmount = entry.getBigDecimal("entryappamount");
        boolean userOutStdCtrl = entry.getBoolean("useroutstdctrl");
        BigDecimal oriMaxStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal((UpgradeTripReimburseTripSumImpl.isEnableStandard(companyId) && UpgradeTripReimburseTripSumImpl.isEnableAccdAllowance(companyId) && UpgradeTripReimburseTripSumImpl.isOpenHighSeasonStd(companyId) ? 1 : 0) != 0, (DynamicObject)entry);
        oriMaxStdAmount = UpgradeTripReimburseTripSumImpl.getCurrencyAmount(entry, amtprecision, oriMaxStdAmount);
        if (!userOutStdCtrl && !isCancelOrder && oriEntryAmount.compareTo(oriMaxStdAmount) > 0) {
            isOverStd = true;
            refObject.setValue((Object)oriEntryAmount.subtract(oriMaxStdAmount));
        }
        return isOverStd;
    }

    private static BigDecimal getCurrencyAmount(DynamicObject entry, int precision, BigDecimal oriMaxStdAmount) {
        BigDecimal stdexchangerate = entry.getBigDecimal("exchangerate");
        if (stdexchangerate == null) {
            stdexchangerate = BigDecimal.ONE;
        }
        if (precision < 0 || precision > 10) {
            precision = 2;
        }
        if ("0".equals(entry.getString("detailquotetype"))) {
            oriMaxStdAmount = oriMaxStdAmount.multiply(stdexchangerate).setScale(precision, RoundingMode.HALF_UP);
        } else if (stdexchangerate.compareTo(BigDecimal.ZERO) != 0) {
            oriMaxStdAmount = oriMaxStdAmount.divide(stdexchangerate, precision, RoundingMode.HALF_UP);
        }
        return oriMaxStdAmount;
    }

    private static boolean checkSumGroupStdIsOver(DynamicObject tripObject, DynamicObject entryObject, DynamicObjectCollection entryColl, int cardIndex, int rowIndex, int amtprecision, RefObject<BigDecimal> refObject, String ... groupPrppertyName) {
        boolean isOver = false;
        if (entryObject == null || entryColl == null || entryColl.isEmpty() || ArrayUtils.isEmpty((Object[])groupPrppertyName)) {
            return isOver;
        }
        Map<String, List<DynamicObject>> sumGroupEntry = entryColl.stream().collect(Collectors.groupingBy(entry -> TripStandardUtils.fetchGroupKey((DynamicObject)entry, (String[])groupPrppertyName)));
        List entryOfGroup = sumGroupEntry.getOrDefault(TripStandardUtils.fetchGroupKey((DynamicObject)entryObject, (String[])groupPrppertyName), new ArrayList());
        BigDecimal sumStdAmount = BigDecimal.ZERO;
        BigDecimal sumReimAmount = BigDecimal.ZERO;
        DynamicObject tripExp = entryObject.getDynamicObject("expenseitem");
        if (tripExp != null) {
            BigDecimal daycount = BigDecimal.valueOf(entryObject.getInt("daycount"));
            String attributeType = tripExp.getString("attribute");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)attributeType)) {
                daycount = daycount.add(UpgradeTripReimburseTripSumImpl.getTripDelayDay(cardIndex, rowIndex, tripObject));
            }
            Long companyId = ErCommonUtils.getPk((Object)tripObject.get("company"));
            BigDecimal highSeasonDays = UpgradeTripReimburseTripSumImpl.getTripHighDays(entryObject, companyId);
            if (!entryOfGroup.isEmpty()) {
                String mulTraStdCtrType;
                DynamicObjectCollection travelers = ((DynamicObject)entryObject.getParent()).getDynamicObjectCollection("travelers");
                List<Long> userIds = travelers.stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toList());
                TripStandardDetail tripStdDetail = UpgradeTripReimburseTripSumImpl.getSumGroupStd(userIds, entryObject, mulTraStdCtrType = SystemParamterUtil.getMultiTravelerStdControlType((long)companyId));
                if (tripStdDetail != null) {
                    BigDecimal tripSTDAmount = tripStdDetail.getStandardamount();
                    BigDecimal highSeasonTripSTDAmount = tripStdDetail.getHighSeasonStandardamount();
                    String attribute = entryObject.getDynamicObject("expenseitem").getString("attribute");
                    if ("5".equals(attribute) && "max".equals(mulTraStdCtrType)) {
                        tripSTDAmount = tripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
                        highSeasonTripSTDAmount = highSeasonTripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
                    }
                    sumStdAmount = sumStdAmount.add(tripSTDAmount.multiply(daycount.subtract(highSeasonDays))).add(highSeasonTripSTDAmount.multiply(highSeasonDays));
                } else {
                    sumStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal((UpgradeTripReimburseTripSumImpl.isEnableStandard(companyId) && UpgradeTripReimburseTripSumImpl.isEnableAccdAllowance(companyId) && UpgradeTripReimburseTripSumImpl.isOpenHighSeasonStd(companyId) ? 1 : 0) != 0, (DynamicObject)entryObject);
                }
                for (DynamicObject entry2 : entryOfGroup) {
                    sumReimAmount = sumReimAmount.add(entry2.getBigDecimal("entryappamount"));
                }
            }
            if (sumReimAmount.compareTo(sumStdAmount = UpgradeTripReimburseTripSumImpl.getCurrencyAmount(entryObject, amtprecision, sumStdAmount)) > 0) {
                isOver = true;
                refObject.setValue((Object)sumReimAmount.subtract(sumStdAmount));
            }
        }
        return isOver;
    }

    private static BigDecimal getTripDelayDay(int cardIndex, int rowIndex, DynamicObject tripObject) {
        Long companyId = ErCommonUtils.getPk((Object)tripObject.get("company"));
        String billKind = tripObject.getString("billkind");
        DynamicObjectCollection mainPageTripEntry = tripObject.getDynamicObjectCollection("tripentry");
        DynamicObjectCollection tripEntry = tripObject.getDynamicObjectCollection("tripentry");
        DynamicObjectCollection detailEntry = ((DynamicObject)tripEntry.get(cardIndex)).getDynamicObjectCollection("entryentity");
        DynamicObject curRow = (DynamicObject)detailEntry.get(rowIndex);
        if (curRow.getDynamicObject("expenseitem") == null || !StringUtils.equals((CharSequence)ErTripExpenseItemConstant.Attribute.Subsidy.getValue(), (CharSequence)curRow.getDynamicObject("expenseitem").getString("attribute"))) {
            return BigDecimal.ZERO;
        }
        if (!SystemParamterUtil.isOpenTripDateControl((Long)ErCommonUtils.getPk((Object)tripObject.get("company"))) || tripObject.getBoolean("istravelers") || !SystemParamterUtil.isEnableTripStandard((Long)companyId)) {
            return TripHighSeasonStandardUtil.getDelayDay((Long)companyId);
        }
        switch (billKind) {
            case "0": {
                if (cardIndex == 0) {
                    return BigDecimal.ONE;
                }
                Date preTripEndDay = ((DynamicObject)mainPageTripEntry.get(cardIndex - 1)).getDate("enddate");
                Date curTripStartDay = ((DynamicObject)tripEntry.get(cardIndex)).getDate("startdate");
                if (preTripEndDay != null && curTripStartDay != null && preTripEndDay.getTime() != curTripStartDay.getTime()) {
                    return BigDecimal.ONE;
                }
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    private static BigDecimal getTripHighDays(DynamicObject entry, Long companyId) {
        if (!SystemParamterUtil.isEnableTripStandard((Long)companyId) || !SystemParamterUtil.isEnableHighSeasonTripStandard((Long)companyId) || SystemParamterUtil.getTripStandardControlLevel((long)companyId) == ControlMethodEnum.NO_CONTROL) {
            return BigDecimal.ZERO;
        }
        return entry.getBigDecimal("originhighseasondays");
    }

    private static TripStandardDetail getSumGroupStd(List<Long> userIds, DynamicObject entryObject, String mulTraStdCtrType) {
        if (userIds == null || userIds.size() == 0) {
            return null;
        }
        DynamicObject entryCurrency = entryObject.getDynamicObject("entrycurrency");
        DynamicObject tripArea = entryObject.getDynamicObject("triparea");
        DynamicObject expenseItem = entryObject.getDynamicObject("expenseitem");
        TripStandardDetail tripStdDetail = null;
        if (entryCurrency != null && tripArea != null) {
            List tripStdDetailList = TripStandardUtils.getAccmodationStdFromPageCache(userIds, null, (String)mulTraStdCtrType, (Object)entryCurrency.getPkValue(), (Object)tripArea.getPkValue(), (DynamicObject)expenseItem, null);
            tripStdDetail = tripStdDetailList == null || tripStdDetailList.isEmpty() ? null : (TripStandardDetail)tripStdDetailList.get(0);
        }
        return tripStdDetail;
    }

    private static boolean isEnableStandard(Long companyId) {
        return SystemParamterUtil.isEnableTripStandard((Long)companyId);
    }

    private static boolean isEnableAccdAllowance(Long companyId) {
        return SystemParamterUtil.getTripStandardControlLevel((long)companyId) != ControlMethodEnum.NO_CONTROL;
    }

    private static boolean isEnableVehicle(Long companyId) {
        return SystemParamterUtil.getVehicleStdControlLevel((long)companyId) != ControlMethodEnum.NO_CONTROL;
    }

    private static boolean isOpenHighSeasonStd(Long companyId) {
        return SystemParamterUtil.isEnableHighSeasonTripStandard((Long)companyId);
    }
}

