/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.ai;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.ais.model.ShowBillFormData;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.ai.response.ErAiResponseModel;
import kd.fi.er.business.ai.response.model.NumCardModel;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;

public class AIGetTripReqBillBySingleTripApiPlugin
extends AbstractBillWebApiPlugin {
    private Log logger = LogFactory.getLog(AIGetTripReqBillBySingleTripApiPlugin.class);

    public void doAICommand(AICommandEvent e) {
        super.doAICommand(e);
        long startTime = System.currentTimeMillis();
        List<DynamicObject> toBeReimbursedList = this.getToBeReimbursedList(this.getReqBillFilter());
        ApiResult result = new ApiResult();
        Map params = e.getCommand().getParameter();
        this.logger.info(String.format("\u5c0fK\u67e5\u8be2\u51fa\u7684\u5355\u636e\u6761\u6570\u4e3a%1$s,\u5c0fK\u5165\u53c2\u4e3a%2$s", toBeReimbursedList.size(), SerializationUtils.toJsonString((Object)params)));
        try {
            result.setData((Object)this.convertToResponseModel(toBeReimbursedList, params));
        }
        catch (InvoiceCloudException invoiceCloudException) {
            invoiceCloudException.printStackTrace();
        }
        result.setSuccess(true);
        e.setResult(result);
        long endTime = System.currentTimeMillis();
        this.logger.info("\u5c0fK\u7ed3\u675fAIGetTripReqBillBySingleTrip doAICommand\u65b9\u6cd5\uff0c\u603b\u5171\u6267\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) / 1000L);
    }

    private QFilter getReqBillFilter() {
        Long userId = RequestContext.get().getCurrUserId();
        this.logger.info("\u5c0fK\u7528\u6237id\u4e3a" + userId);
        QFilter specialDataFilter = new QFilter("creator", "=", (Object)userId).or(new QFilter("applier", "=", (Object)userId));
        return specialDataFilter.and(QFilter.of((String)"isloan='0' and billstatus='E'", (Object[])new Object[0]));
    }

    private List<DynamicObject> getToBeReimbursedList(QFilter qfilter) {
        String orderBys = "createtime desc";
        DynamicObject[] reqArray = BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)"id,bizdate,description,rfrom,rto,rstartdate,renddate,tripentry,billno,approveamount,costcompany,amount", (QFilter[])new QFilter[]{qfilter}, (String)orderBys);
        if (null == reqArray || reqArray.length == 0) {
            return new ArrayList<DynamicObject>();
        }
        return Arrays.stream(reqArray).filter(v -> v.getDynamicObjectCollection("tripentry").size() == 1).collect(Collectors.toList());
    }

    private ErAiResponseModel convertToResponseModel(List<DynamicObject> toBeReimbursedList, Map params) throws InvoiceCloudException {
        if (toBeReimbursedList == null || toBeReimbursedList.isEmpty()) {
            ErAiResponseModel model = ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u62a5\u9500\u6761\u4ef6\u7684\u51fa\u5dee\u7533\u8bf7\u5355\u3002", (String)"AIGetTripReqBillBySingleTripApiPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
            return model;
        }
        String YZJ_CHATBOT = params.get("AI_DEVICE").toString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<Map<String, Object>> cardBody = new ArrayList<Map<String, Object>>(toBeReimbursedList.size());
        for (DynamicObject reqBill : toBeReimbursedList) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("billno", reqBill.getString("billno"));
            row.put("id", reqBill.getPkValue());
            row.put("description", reqBill.getString("description"));
            row.put("approveamount", reqBill.getBigDecimal("amount").setScale(2, 4));
            row.put("bizdate", sdf.format(reqBill.getDate("bizdate")));
            row.put("from", reqBill.getString("rfrom"));
            row.put("to", reqBill.getString("rto"));
            row.put("startdate", sdf.format(reqBill.getDate("rstartdate")));
            row.put("enddate", sdf.format(reqBill.getDate("renddate")));
            switch (YZJ_CHATBOT) {
                case "APP_CHATBOT": {
                    StringBuilder url = new StringBuilder(RequestContext.get().getClientFullContextPath()).append((CharSequence)new StringBuilder("mobile.html#/form/")).append("er_tripreqbill").append("_mob").append("?");
                    url.append("billStatusValue=1&").append("pkId=").append(reqBill.getPkValue());
                    url.append("&returnDefaultHome=true&isAI=true&app=tra");
                    row.put("billUrl", url);
                    break;
                }
                case "CQ_CHATBOT": {
                    String data = SerializationUtils.toJsonString((Object)new ShowBillFormData("tra", "er_tripreqbill", reqBill.getPkValue()));
                    row.put("billUrl", String.format("bizAction://%s?%s", "ShowBillForm", data));
                }
            }
            cardBody.add(row);
        }
        NumCardModel numCardModel = new NumCardModel();
        numCardModel.setTitle(ResManager.loadKDString((String)"\u627e\u5230\u5982\u4e0b\u5355\u884c\u7a0b\u7684\u5f85\u62a5\u9500\u7533\u8bf7\uff0c\u8bf7\u9009\u62e9\u5176\u4e2d\u4e00\u4e2a\u3002", (String)"AIGetTripReqBillBySingleTripApiPlugin_2", (String)"fi-er-business", (Object[])new Object[0]));
        this.logger.info(String.format("\u5c0fK\u4f20\u5165\u7684\u6807\u8bc6\u4e3a%1$s,\u5c0fK\u67e5\u8be2\u5dee\u65c5\u62a5\u9500\u5355\u8fd4\u56de\u5c0fK\u7684\u6570\u636e\u4e3a%2$s", YZJ_CHATBOT, SerializationUtils.toJsonString(cardBody)));
        numCardModel.setCardBody(cardBody);
        ErAiResponseModel model = ErAiResponseModel.createCardJsonResponse(numCardModel, null, null);
        return model;
    }
}

