/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.ai;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.ai.response.ErAiResponseModel;
import kd.fi.er.business.ai.response.model.NumCardModel;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.tripstd.service.IErTripStdService;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;
import org.apache.commons.lang3.StringUtils;

public class GetTripStdByTypeApiPlugin
extends AbstractBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(GetTripStdByTypeApiPlugin.class);
    private static final String TRIPARE_ANAME = "tripareaname";
    private static final String TRIPSTD_TYPENAME = "tripstdtypename";
    private static final String TRIPSTD_AMOUNTSTR = "tripstdamountstr";
    private IErTripStdService tripStdService = new ErTripStdServiceImp();
    private Long userID = Long.valueOf(RequestContext.get().getUserId());
    private Long companyId = GetTripStdByTypeApiPlugin.getCurrentUserCompanyId();

    public void doAICommand(AICommandEvent e) {
        long startTime = System.currentTimeMillis();
        Map param = e.getCommand().getParameter();
        String stdType = (String)param.get("tripStdType");
        ApiResult ret = new ApiResult();
        ErAiResponseModel responseModel = null;
        if (stdType != null) {
            responseModel = this.getResponseModel(stdType, param);
            if (responseModel == null) {
                String content = ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u76ee\u524d\u8fd8\u6ca1\u6709\u5bf9\u5e94\u7684\u5dee\u65c5\u6807\u51c6\uff0c\u5177\u4f53\u8be6\u60c5\u8bf7\u767b\u5f55PC\u7aef\u67e5\u8be2\u3002", (String)"GetTripStdByTypeApiPlugin_0", (String)"fi-er-business", (Object[])new Object[0]);
                responseModel = ErAiResponseModel.createTextResponse(content);
                ret.setErrorCode(null);
                ret.setMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u5dee\u65c5\u6807\u51c6\u3002", (String)"GetTripStdByTypeApiPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
                ret.setSuccess(false);
            } else {
                ret.setSuccess(true);
            }
            ret.setData((Object)responseModel);
        } else {
            ret.setErrorCode(null);
            ret.setMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u6807\u51c6\u7c7b\u578b\u3002", (String)"GetTripStdByTypeApiPlugin_2", (String)"fi-er-business", (Object[])new Object[0]));
            ret.setSuccess(false);
        }
        e.setResult(ret);
    }

    private ErAiResponseModel getResponseModel(String stdType, Map<String, Object> param) {
        ErAiResponseModel responseModel = null;
        if (stdType.trim().equals(ErTripExpenseItemConstant.Attribute.Subsidy.getValue()) || stdType.trim().equals(ErTripExpenseItemConstant.Attribute.Accommodation.getValue())) {
            String title;
            String cityName = (String)param.get("city");
            List<Map<String, Object>> stdList = this.getCurUserAccodationStdByCityName(stdType, cityName);
            if (stdList == null || stdList.isEmpty()) {
                return null;
            }
            if (cityName == null) {
                title = ResManager.loadKDString((String)"\u4e2a\u4eba\u5dee\u65c5\u6807\u51c6", (String)"GetTripStdByTypeApiPlugin_3", (String)"fi-er-business", (Object[])new Object[0]);
            } else {
                String stdName = "";
                switch (stdType) {
                    case "1": {
                        stdName = ResManager.loadKDString((String)"\u8865\u52a9", (String)"GetTripStdByTypeApiPlugin_4", (String)"fi-er-business", (Object[])new Object[0]);
                        break;
                    }
                    case "5": {
                        stdName = ResManager.loadKDString((String)"\u4f4f\u5bbf", (String)"GetTripStdByTypeApiPlugin_5", (String)"fi-er-business", (Object[])new Object[0]);
                        break;
                    }
                }
                title = String.format(ResManager.loadKDString((String)"\u60a8\u5728%1$s\u7684%2$s\u6807\u51c6", (String)"GetTripStdByTypeApiPlugin_21", (String)"fi-er-business", (Object[])new Object[0]), cityName, stdName);
            }
            NumCardModel numCardModel = new NumCardModel();
            numCardModel.setTitle(title);
            numCardModel.setCardBody(stdList);
            responseModel = ErAiResponseModel.createnNumCardResponse(numCardModel);
        } else if (stdType.trim().equals(ErTripExpenseItemConstant.Attribute.AirPlane.getValue()) || stdType.trim().equals(ErTripExpenseItemConstant.Attribute.Train.getValue())) {
            String vehicleStd = "";
            String vehicleName = "";
            switch (stdType) {
                case "2": {
                    vehicleName = ResManager.loadKDString((String)"\u98de\u673a", (String)"GetTripStdByTypeApiPlugin_9", (String)"fi-er-business", (Object[])new Object[0]);
                    vehicleStd = this.getCurUserVehicleStdByType("air");
                    break;
                }
                case "4": {
                    vehicleName = ResManager.loadKDString((String)"\u706b\u8f66", (String)"GetTripStdByTypeApiPlugin_10", (String)"fi-er-business", (Object[])new Object[0]);
                    vehicleStd = this.getCurUserVehicleStdByType("train");
                    break;
                }
            }
            if (vehicleStd != null) {
                String content = String.format(ResManager.loadKDString((String)"%1$s\u60a8\u53ef\u4ee5\u8d2d\u4e70%2$s", (String)"GetTripStdByTypeApiPlugin_22", (String)"fi-er-business", (Object[])new Object[0]), vehicleName, vehicleStd);
                responseModel = ErAiResponseModel.createTextResponse(content);
            }
        }
        return responseModel;
    }

    private String getCurUserVehicleStdByType(String vehicleType) {
        DynamicObject vehicleStd = this.tripStdService.getVehicleStdByUserIdAndVehicleType(this.userID, vehicleType, this.companyId);
        if (vehicleStd == null) {
            return null;
        }
        return this.unionArrays(Arrays.asList(vehicleStd.getString("cabinstr").split(",")), "\u3001");
    }

    private String unionArrays(List<String> paramStr, String split) {
        if (paramStr == null || paramStr.isEmpty()) {
            return null;
        }
        if (paramStr.size() == 1) {
            return paramStr.get(0);
        }
        StringBuilder sb = new StringBuilder(paramStr.get(0));
        for (int i = 1; i < paramStr.size(); ++i) {
            sb.append(split);
            sb.append(paramStr.get(i));
        }
        return sb.toString();
    }

    private List<Map<String, Object>> getCurUserAccodationStdByCityName(String stdType, String cityName) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<DynamicObject> stdEntryList = this.tripStdService.getTripStdEntryByUserIdAndCompanyId(this.userID, this.companyId);
        Map<Long, List<DynamicObject>> stdGroupByTripAreaMap = stdEntryList.stream().filter(t -> t.get("tripstandardtype") != null && t.get("triparea") != null).collect(Collectors.groupingBy(v -> (Long)v.getDynamicObject("triparea").getPkValue()));
        Iterator<Map.Entry<Long, List<DynamicObject>>> iterator = stdGroupByTripAreaMap.entrySet().iterator();
        while (iterator.hasNext()) {
            List<DynamicObject> curAreaStdEntryList = iterator.next().getValue();
            DynamicObject tripArea = curAreaStdEntryList.get(0).getDynamicObject("triparea");
            String citysStr = tripArea.getString("citystr");
            if (StringUtils.isNotEmpty((CharSequence)cityName) && !citysStr.contains(cityName)) continue;
            String tripAreaName = tripArea.getLocaleString("name").getLocaleValue();
            for (DynamicObject stdEntry : curAreaStdEntryList) {
                DynamicObject stdTypeObj = stdEntry.getDynamicObject("tripstandardtype");
                if (stdType != null && !StringUtils.equalsIgnoreCase((CharSequence)stdType, (CharSequence)stdTypeObj.getString("attribute"))) continue;
                String tripStdTypeName = stdTypeObj.getLocaleString("name").getLocaleValue();
                BigDecimal tripStdAmount = stdEntry.getBigDecimal("standardamount");
                CurrencyBO currency = new CurrencyBO((Long)stdEntry.getDynamicObject("currency").getPkValue());
                String tripStdAmountStr = String.format(ResManager.loadKDString((String)"%s/\u5929", (String)"GetTripStdByTypeApiPlugin_12", (String)"fi-er-business", (Object[])new Object[0]), AmountUtils.formatMoneyByUser(this.userID, currency.getSymbol(), currency.getPrecision(), tripStdAmount));
                HashMap<String, String> detail = new HashMap<String, String>();
                detail.put(TRIPARE_ANAME, tripAreaName);
                detail.put(TRIPSTD_TYPENAME, tripStdTypeName);
                detail.put(TRIPSTD_AMOUNTSTR, tripStdAmountStr);
                result.add(detail);
            }
        }
        return result;
    }

    public static Long getCurrentUserCompanyId() {
        String userId = RequestContext.getOrCreate().getUserId();
        return GetTripStdByTypeApiPlugin.getComanyIdByUserId(Long.valueOf(userId));
    }

    public static Long getComanyIdByUserId(Long userId) {
        Map<String, Object> userMap = CommonServiceHelper.getUserMap(userId);
        DynamicObject dept = (DynamicObject)userMap.get("org");
        Long companyId = 0L;
        if (dept != null) {
            Map companyfromOrg = OrgUnitServiceHelper.getCompanyfromOrg((Long)dept.getLong("id"));
            companyId = (Long)companyfromOrg.get("id");
        }
        return companyId;
    }
}

