/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.ai;

import java.util.List;
import java.util.Map;
import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.model.UrlModel;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.AICommand;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.FormService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.ai.ErAIService;
import kd.fi.er.business.servicehelper.ApiResultProcessor;

public class TripReqBillSaveApiPlugin
extends AbstractBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(TripReqBillSaveApiPlugin.class);
    private static final String CUSTPARAM = "custParam";
    private static final String BIZ_APPID = "appId";

    public void doAICommand(AICommandEvent e) {
        ResponseModel responseData;
        long startTime = System.currentTimeMillis();
        AICommand cmd = e.getCommand();
        Map params = cmd.getParameter();
        String error = ErAIService.preHandleData(params);
        if (error != null) {
            ApiResult result = new ApiResult();
            result.setSuccess(false);
            result.setMessage(error);
            e.setResult(result);
            return;
        }
        Map bizData = this.parseAIObjectByKey(params);
        String bizAppId = "tra";
        String formId = this.getFormId();
        bizData.put("appid", bizAppId);
        String jsondata = SerializationUtils.toJsonString((Object)bizData);
        ApiResult ret = this.executeSaveOperation(formId, jsondata);
        if (!ret.getSuccess()) {
            String pkId = ret.getMessage();
            if (pkId == null || pkId.isEmpty()) {
                pkId = ResManager.loadKDString((String)"\u4e1a\u52a1\u5e73\u53f0\u521b\u5efa\u8868\u5355\u5931\u8d25\u3002", (String)"TripReqBillSaveApiPlugin_0", (String)"fi-er-business", (Object[])new Object[0]);
            }
            responseData = ResponseModel.createTextResponse((String)pkId);
            logger.info("\u521b\u5efa\u8868\u5355\u5931\u8d25\u3002Message:{}", (Object)ret.getMessage());
        } else {
            String pkId = this.parsePkId(ret);
            if (pkId == null) {
                responseData = ResponseModel.createTextResponse((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u5e73\u53f0\u521b\u5efa\u8868\u5355\u5931\u8d25,pkId\u4e3a\u7a7a\u3002", (String)"TripReqBillSaveApiPlugin_4", (String)"fi-er-business", (Object[])new Object[0]));
                ret.setSuccess(false);
                logger.info("\u521b\u5efa\u8868\u5355\u5931\u8d25\u3002Message:{}", (Object)ret.getMessage());
            } else {
                StringBuilder url = new StringBuilder("/mobile.html#/form/").append(formId).append("_mob").append("?");
                url.append("billStatusValue=1&").append("pkId=").append(pkId);
                url.append("&returnDefaultHome=true&isAI=true&app=").append(bizAppId);
                UrlModel urlModel = new UrlModel();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
                urlModel.setTitle(dataEntityType.getDisplayName().getLocaleValue());
                urlModel.setUrl(url.toString());
                urlModel.setContent(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u751f\u6210\uff0c\u60a8\u53ef\u4ee5\u767b\u5f55PC\u7aef\u4fee\u6539\u6216\u63d0\u4ea4\u3002", (String)"TripReqBillSaveApiPlugin_2", (String)"fi-er-business", (Object[])new Object[0]));
                responseData = ResponseModel.createUrlResponse((UrlModel)urlModel);
            }
        }
        if (ret.getSuccess()) {
            ret.setData((Object)responseData);
        } else {
            ret.setMessage(responseData.getContent() + ret.getErrorCode() + ret.getMessage());
        }
        e.setResult(ret);
        ApiResultProcessor.processUrl(e);
        long endTime = System.currentTimeMillis();
        logger.info("\u7d50\u675fdoAICommand\u65b9\u6cd5\uff0c\u603b\u5171\u6267\u884c\u65f6\u95f4\uff1a{}", (Object)(endTime - startTime));
    }

    private ApiResult executeSaveOperation(String formId, String data) {
        String invokeAppid = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
        String result = (String)DispatchServiceHelper.invokeBOSService((String)invokeAppid, (String)"OperationWebApi", (String)"save", (Object[])new Object[]{formId, data});
        Map ret = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        return ApiResult.fromMap((Map)ret);
    }

    private String parsePkId(ApiResult ret) {
        Object data = ret.getData();
        if (data instanceof Map) {
            List pkIds = (List)((Map)data).get("successPkIds");
            return pkIds != null && !pkIds.isEmpty() ? pkIds.get(0).toString() : null;
        }
        return null;
    }

    protected DynamicObjectCollection query(String entityName, String selectFields, QFilter[] filters, String orderBys, int top) {
        if ("bd_admindivision".equals(entityName)) {
            String property = filters[0].getProperty();
            String cityName = (String)filters[0].getValue();
            filters = new QFilter[]{new QFilter(property, " like ", (Object)(cityName + "%")), new QFilter("enable", "=", (Object)"1"), new QFilter("iscity", "=", (Object)"1")};
        }
        if ("bd_currency".equals(entityName)) {
            filters = new QFilter[]{new QFilter("id", "=", filters[0].getValue())};
        }
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys, (int)top);
    }
}

