/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.amount.control.feestandard;

import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.formula.OutValue;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.shaded.com.google.common.collect.Sets;

public class FeeStandardHelper {
    private static Log logger = LogFactory.getLog(FeeStandardHelper.class);

    public static boolean firedRefreshEvent(int rowIndex) {
        String key = FeeStandardHelper.class.getName().concat(String.valueOf(rowIndex));
        if (ThreadCache.exists((Object)key)) {
            return true;
        }
        ThreadCache.put((Object)key, (Object)1);
        return false;
    }

    @Deprecated
    public static Collection<DynamicObject> queryFeeStandard(DynamicObject company, DynamicObject reimburselevel, DynamicObject currency, DynamicObject expenseitem, DynamicObject bizItem) {
        return FeeStandardHelper.queryFeeStandard(company, currency, expenseitem, bizItem);
    }

    public static Collection<DynamicObject> queryFeeStandard(DynamicObject company, DynamicObject currency, DynamicObject expenseitem, DynamicObject bizItem) {
        if (currency == null || expenseitem == null || bizItem == null || company == null) {
            return Collections.emptyList();
        }
        QFilter baseDataIdInFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_standard", (Long)((Long)company.getPkValue()));
        QFilter[] qfilters = new QFilter[]{baseDataIdInFilter, new QFilter("expenseitem", "=", expenseitem.getPkValue()), new QFilter("currency", "=", currency.getPkValue()), new QFilter("stardardtype", "=", bizItem.getPkValue()), new QFilter("enable", "=", (Object)"1")};
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"er_standard", (QFilter[])qfilters, (String)"id", (int)5000);
        return BusinessDataServiceHelper.loadFromCache((Object[])pks.toArray(), (String)"er_standard").values();
    }

    public static Collection<DynamicObject> queryFeeStandard(DynamicObject company, DynamicObject bizItem) {
        if (bizItem == null || company == null) {
            return Collections.emptyList();
        }
        QFilter baseDataIdInFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_standard", (Long)((Long)company.getPkValue()));
        QFilter[] qfilters = new QFilter[]{baseDataIdInFilter, new QFilter("stardardtype", "=", bizItem.getPkValue()), new QFilter("enable", "=", (Object)"1")};
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"er_standard", (QFilter[])qfilters, (String)"id", (int)5000);
        return BusinessDataServiceHelper.loadFromCache((Object[])pks.toArray(), (String)"er_standard").values();
    }

    public static List<DynamicObject> queryMyFeeStandard() {
        long currUserId = RequestContext.get().getCurrUserId();
        Long companyId = CommonServiceHelper.getCompanyIdByUserId(currUserId);
        ArrayList lists = Lists.newArrayListWithCapacity((int)16);
        if (companyId != null) {
            HashSet pkSet = Sets.newHashSet((Object[])new Object[]{16});
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            Map queryBaseDataFromCache = BaseDataServiceHelper.queryBaseDataFromCache((String)"er_standard", (Long)companyId, (QFilter)enableFilter, (String)"id,stardardtype,standardamount,ctlnumber,ctlperiod,currency.sign,currency.amtprecision,dimension,expenseitem,otherstand,otherstandamount,actualreimexpense");
            queryBaseDataFromCache.forEach((k, v) -> {
                if (pkSet.add(v.getPkValue())) {
                    lists.add(v);
                }
            });
        }
        return lists;
    }

    public static List<String> queryDimensions(String standardNum) {
        DynamicObject standardType = FeeStandardHelper.queryBizItem(standardNum);
        return FeeStandardHelper.collectDimension(standardType);
    }

    public static List<String> collectDimension(DynamicObject standardType) {
        if (standardType == null) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        DynamicObjectCollection objectCollection = standardType.getDynamicObjectCollection("dimension");
        ArrayList dimensions = Lists.newArrayListWithExpectedSize((int)objectCollection.size());
        for (int i = 0; i < objectCollection.size(); ++i) {
            DynamicObject fbasedataid = ((DynamicObject)objectCollection.get(i)).getDynamicObject("fbasedataid");
            if (fbasedataid == null) continue;
            dimensions.add(fbasedataid.getString("number"));
        }
        return dimensions;
    }

    @Deprecated
    public static DynamicObject queryStandardType(String standardNum) {
        return FeeStandardHelper.queryBizItem(standardNum);
    }

    public static DynamicObject queryBizItem(String bizItemNum) {
        if (StringUtils.isEmpty((CharSequence)bizItemNum)) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"er_standard_type", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizItemNum)});
    }

    public static Set<String> getStandardTypeFilterInExpenseItem(DynamicObject standardType) {
        DynamicObjectCollection entryentity;
        if (standardType != null && !(entryentity = standardType.getDynamicObjectCollection("entryentity")).isEmpty()) {
            HashSet nums = Sets.newHashSetWithExpectedSize((int)entryentity.size());
            for (DynamicObject entry : entryentity) {
                DynamicObject expenseitem = entry.getDynamicObject("expenseitem");
                if (expenseitem == null) continue;
                nums.add(expenseitem.getString("number"));
            }
            return nums;
        }
        return Collections.emptySet();
    }

    public static DynamicObject matchFeeStandardInMemory(Collection<DynamicObject> feeStandList, Map<String, Object> dimensionMap, Long applierCompany) {
        Set result = null;
        for (DynamicObject feeStand : feeStandList) {
            if (!FeeStandardHelper.allSame(dimensionMap, feeStand)) continue;
            if (applierCompany.equals(feeStand.getDynamicObject("createorg").getPkValue())) {
                return feeStand;
            }
            if (result == null) {
                result = Sets.newTreeSet((o1, o2) -> o1.getDate("modifytime").getTime() - o2.getDate("modifytime").getTime() > 0L ? -1 : 1);
            }
            result.add(feeStand);
        }
        return result == null ? null : (DynamicObject)result.iterator().next();
    }

    private static boolean allSame(Map<String, Object> dimensionMap, DynamicObject feeStand) {
        for (Map.Entry<String, Object> entry : dimensionMap.entrySet()) {
            Object o2;
            String dimension = entry.getKey();
            Object o1 = feeStand.get(dimension);
            if (FeeStandardHelper.equals(o1, o2 = entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof DynamicObject) {
            o1 = ((DynamicObject)o1).getPkValue();
        }
        if (o2 instanceof DynamicObject) {
            o2 = ((DynamicObject)o2).getPkValue();
        }
        return o1.equals(o2);
    }

    public static Date[] getPeriodDate(String ctrlPeriod, Date bizdate) {
        LocalDate localDate = bizdate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate[] localDatePeriod = null;
        switch (ctrlPeriod) {
            case "week": {
                localDatePeriod = FeeStandardHelper.getWeek(localDate);
                break;
            }
            case "month": {
                localDatePeriod = FeeStandardHelper.getMonth(localDate);
                break;
            }
            case "season": {
                localDatePeriod = FeeStandardHelper.getSeason(localDate);
                break;
            }
            case "year": {
                localDatePeriod = FeeStandardHelper.getYear(localDate);
                break;
            }
            default: {
                localDatePeriod = new LocalDate[]{localDate, localDate};
            }
        }
        return new Date[]{ErCommonUtils.getDateFromLocalDate(localDatePeriod[0]), ErCommonUtils.getDateFromLocalDate(localDatePeriod[1])};
    }

    private static LocalDate[] getYear(LocalDate localDate) {
        LocalDate firstDay = localDate.withDayOfYear(1);
        LocalDate lastDay = localDate.withDayOfYear(localDate.lengthOfYear());
        return new LocalDate[]{firstDay, lastDay};
    }

    private static LocalDate[] getSeason(LocalDate localDate) {
        LocalDate firstDay = localDate.with(localDate.getMonth().firstMonthOfQuarter()).withDayOfMonth(1);
        LocalDate lastDay = firstDay.plusMonths(2L).withDayOfMonth(firstDay.plusMonths(2L).lengthOfMonth());
        return new LocalDate[]{firstDay, lastDay};
    }

    private static LocalDate[] getMonth(LocalDate localDate) {
        LocalDate firstDay = localDate.withDayOfMonth(1);
        LocalDate lastDay = localDate.withDayOfMonth(localDate.lengthOfMonth());
        return new LocalDate[]{firstDay, lastDay};
    }

    private static LocalDate[] getWeek(LocalDate localDate) {
        LocalDate firstDay = localDate.with(DayOfWeek.MONDAY);
        LocalDate lastDay = localDate.with(DayOfWeek.SUNDAY);
        return new LocalDate[]{firstDay, lastDay};
    }

    @Deprecated
    public static boolean isOpenFeeStand(String bizItemNum, Long companyId) {
        return !"asset".equals(bizItemNum) && FeeStandardHelper.queryBizItem(bizItemNum) != null && SystemParamterUtil.getBoolParamResult(companyId, "feestandardcontrol");
    }

    public static boolean isOpenFeeStand(DynamicObject bizItem, Long companyId) {
        return bizItem != null && !"expense".equals(bizItem.getString("number")) && !"asset".equals(bizItem.getString("number")) && SystemParamterUtil.getBoolParamResult(companyId, "feestandardcontrol");
    }

    public static void calcIsOverStd(int rowIndex, IDataModel dataModel) {
        DynamicObject expenseitem = (DynamicObject)dataModel.getValue("expenseitem", rowIndex);
        if (expenseitem != null && "3".equals(expenseitem.get("isreimburseamountctl"))) {
            DynamicObject feeStand = (DynamicObject)dataModel.getValue("feestandid", rowIndex);
            BigDecimal controlAmt = (BigDecimal)dataModel.getValue(FeeStandardHelper.getControlAmtKey(), rowIndex);
            BigDecimal reimburseAmt = (BigDecimal)dataModel.getValue(FeeStandardHelper.getReimburseAmtKey(), rowIndex);
            if (FeeStandardHelper.overFeeAmount(reimburseAmt, controlAmt) && (feeStand == null || !feeStand.getBoolean("summarycontrol") && !feeStand.getBoolean("actualreimexpense"))) {
                dataModel.setValue("isover", (Object)true, rowIndex);
                return;
            }
            if (feeStand != null && feeStand.getBoolean("otherstand") && !feeStand.getBoolean("actualreimexpense")) {
                BigDecimal totalAmt;
                BigDecimal otherControlAmt = (BigDecimal)dataModel.getValue(FeeStandardHelper.getOtherControlAmtKey(), rowIndex);
                BigDecimal otherFeeAmt = (BigDecimal)dataModel.getValue(FeeStandardHelper.getOtherFeeAmtKey(), rowIndex);
                if (FeeStandardHelper.overFeeAmount(otherFeeAmt, otherControlAmt)) {
                    dataModel.setValue("isover", (Object)true, rowIndex);
                    return;
                }
                if ("1".equals(dataModel.getValue("wineway", rowIndex)) && feeStand.getBoolean("otherstand") && !feeStand.getBoolean("actualreimexpense") && !feeStand.getBoolean("summarycontrol") && FeeStandardHelper.overFeeAmount(totalAmt = otherFeeAmt.add((BigDecimal)dataModel.getValue(FeeStandardHelper.getReimburseAmtKey(), rowIndex)), controlAmt)) {
                    dataModel.setValue("isover", (Object)true, rowIndex);
                    return;
                }
            }
        }
        dataModel.setValue("isover", (Object)false, rowIndex);
    }

    public static boolean overFeeAmount(BigDecimal amt, BigDecimal controlAmt) {
        boolean isOver;
        if (amt == null || controlAmt == null) {
            return false;
        }
        boolean bl = isOver = amt.compareTo(controlAmt) > 0;
        if (controlAmt.compareTo(BigDecimal.ZERO) > 0 && FeeStandardHelper.headCurrencyControl()) {
            return isOver && amt.subtract(controlAmt).compareTo(ErStdConfig.getAccentryDiffRange()) > 0;
        }
        return isOver;
    }

    public static String getOtherFeeAmtKey() {
        if (FeeStandardHelper.headCurrencyControl()) {
            return "curotherfeeamount";
        }
        return "otherfeeamount";
    }

    public static String getOtherControlAmtKey() {
        if (FeeStandardHelper.headCurrencyControl()) {
            return "curothercontrolamt";
        }
        return "othercontrolamt";
    }

    public static String getControlAmtKey() {
        if (FeeStandardHelper.headCurrencyControl()) {
            return "curcontrolamt";
        }
        return "controlamt";
    }

    public static String getReimburseAmtKey() {
        if (FeeStandardHelper.headCurrencyControl()) {
            return "expeapprovecurramount";
        }
        return "expeapproveamount";
    }

    public static boolean headCurrencyControl() {
        return "2".equals(ErStdConfig.get("BaseCurrencyControl"));
    }

    public static String getPeriodStr(String ctrlPeriod) {
        switch (ctrlPeriod) {
            case "year": {
                return ResManager.loadKDString((String)"\u5e74", (String)"FeeStandard_period_year", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
            case "season": {
                return ResManager.loadKDString((String)"\u5b63", (String)"FeeStandard_period_season", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
            case "month": {
                return ResManager.loadKDString((String)"\u6708", (String)"FeeStandard_period_month", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
            case "week": {
                return ResManager.loadKDString((String)"\u5468", (String)"FeeStandard_period_week", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
        }
        return ctrlPeriod;
    }

    public static boolean existHeadProp(IDataModel model) {
        DynamicObject bizitem = (DynamicObject)model.getValue("bizitem");
        List<String> collectDimension = FeeStandardHelper.collectDimension(bizitem);
        for (String dimensnion : collectDimension) {
            if (!FeeStandardHelper.headProp(model, dimensnion)) continue;
            return true;
        }
        return false;
    }

    public static boolean headProp(IDataModel model, String propName) {
        IDataEntityProperty property = model.getProperty(propName);
        return property != null && property.getParent() != null && property.getParent() instanceof MainEntityType;
    }

    public static List<String> getHeadPropDimensions(IFormView view) {
        List<String> collectDimension = null;
        if (view != null) {
            IDataModel model = view.getModel();
            DynamicObject bizItem = (DynamicObject)model.getValue("bizitem");
            collectDimension = FeeStandardHelper.collectDimension(bizItem);
            Iterator<String> iterator = collectDimension.iterator();
            while (iterator.hasNext()) {
                IDataEntityProperty property = model.getProperty(iterator.next());
                if (property.getParent() instanceof MainEntityType) continue;
                iterator.remove();
            }
            return collectDimension;
        }
        return Lists.newArrayListWithExpectedSize((int)1);
    }

    public static String getDesc(DynamicObject feeStand) {
        DynamicObject currency = feeStand.getDynamicObject("currency");
        BigDecimal standAmt = feeStand.getBigDecimal("standardamount");
        int ctrlNum = feeStand.getInt("ctlnumber");
        if (feeStand.getDynamicObjectType().getProperty("actualreimexpense") != null && feeStand.getBoolean("actualreimexpense")) {
            return String.format(ResManager.loadKDString((String)"\u5b9e\u62a5\u5b9e\u9500", (String)"FeeStandardControlFormPlugin_actualReimExpense", (String)"fi-er-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        if (ctrlNum > 0) {
            return String.format(ResManager.loadKDString((String)"%1s", (String)"FeeStandardControlFormPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), AmountUtils.formatMoneyByUser(RequestContext.get().getCurrUserId(), currency.getString("sign"), currency.getInt("amtprecision"), standAmt));
        }
        return String.format(ResManager.loadKDString((String)"%1s", (String)"FeeStandardControlFormPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), AmountUtils.formatMoneyByUser(RequestContext.get().getCurrUserId(), currency.getString("sign"), currency.getInt("amtprecision"), standAmt));
    }

    public static String getOtherDesc(DynamicObject feeStand) {
        BigDecimal otherstandAmt = feeStand.getBigDecimal("otherstandamount");
        DynamicObject currency = feeStand.getDynamicObject("currency");
        return String.format(ResManager.loadKDString((String)"%1s", (String)"FeeStandardControlFormPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), AmountUtils.formatMoneyByUser(RequestContext.get().getCurrUserId(), currency.getString("sign"), currency.getInt("amtprecision"), otherstandAmt));
    }

    public static DynamicObject queryStandardTypeById(Long id) {
        if (Objects.isNull(id) || id.equals(0L)) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"er_standard_type", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    public static Map<String, String> getSensetiveField(Long id) {
        return FeeStandardHelper.getKeyValue(id, "sensetiveentity", "verifyfield", "sensetivefield");
    }

    public static Map<String, String> getAttachmentCheckName(Long id) {
        return FeeStandardHelper.getKeyValue(id, "attachmententity", "attachno", "attachname");
    }

    private static Map<String, String> getKeyValue(Long id, String entry, String key, String valueKey) {
        DynamicObject standard = FeeStandardHelper.queryStandardTypeById(id);
        IdentityHashMap<String, String> map = new IdentityHashMap<String, String>(10);
        if (standard == null) {
            return map;
        }
        DynamicObjectCollection collection = standard.getDynamicObjectCollection(entry);
        for (DynamicObject dyn : collection) {
            map.put(dyn.getString(key), dyn.getString(valueKey));
        }
        return map;
    }

    public static boolean checkSensetive(DynamicObject bill, Map<String, String> sensetiveMap, OutValue outValue) {
        ArrayList<FieldValue> checkFail = new ArrayList<FieldValue>(10);
        String splitKey = ",";
        for (Map.Entry<String, String> entry : sensetiveMap.entrySet()) {
            String fieldKey = entry.getKey();
            String sense = entry.getValue();
            if (StringUtils.isEmpty((CharSequence)fieldKey) || StringUtils.isEmpty((CharSequence)sense)) continue;
            for (String k : fieldKey.split(splitKey)) {
                String[] sensetive;
                if (StringUtils.isBlank((CharSequence)k) || (sensetive = FeeStandardHelper.splitSensetive(sense)).length == 0) continue;
                for (String s : sensetive) {
                    if (StringUtils.isBlank((CharSequence)s)) continue;
                    List<FieldValue> list = FeeStandardHelper.getFieldValues(bill, k, s);
                    for (FieldValue f : list) {
                        if (FeeStandardHelper.check(s, f.getValue().toString())) continue;
                        checkFail.add(f);
                    }
                }
            }
        }
        bill.getDynamicObjectType().getProperties();
        MainEntityType mainEntityType = (MainEntityType)bill.getDataEntityType();
        outValue.set((Object)FeeStandardHelper.buildMsg(mainEntityType, checkFail));
        return checkFail.size() == 0;
    }

    private static List<FieldValue> getFieldValues(DynamicObject bill, String fieldKey, String sensitive) {
        ArrayList<FieldValue> list;
        block6: {
            String[] keys;
            block7: {
                Map allEntry;
                Map propertyMap;
                MainEntityType mainEntityType;
                block5: {
                    mainEntityType = (MainEntityType)bill.getDataEntityType();
                    propertyMap = mainEntityType.getAllFields();
                    allEntry = mainEntityType.getAllEntities();
                    list = new ArrayList<FieldValue>(10);
                    if (fieldKey.contains(".")) break block5;
                    if (!propertyMap.containsKey(fieldKey)) {
                        logger.error("\u5355\u636e\uff1a {} \u4e0d\u5b58\u5728\u7684\u5b57\u6bb5\uff1a {}", (Object)mainEntityType.getName(), (Object)fieldKey);
                        return new ArrayList<FieldValue>(0);
                    }
                    FeeStandardHelper.add(list, new FieldValue(fieldKey, bill.get(fieldKey), sensitive, -1, -1, null, null));
                    break block6;
                }
                keys = fieldKey.split("\\.");
                if (keys.length != 2) break block7;
                if (!allEntry.containsKey(keys[0]) || !propertyMap.containsKey(keys[1])) {
                    logger.error("\u5355\u636e\uff1a {} \u4e0d\u5b58\u5728\u7684\u5b57\u6bb5\uff1a {}", (Object)mainEntityType.getName(), (Object)fieldKey);
                    return new ArrayList<FieldValue>(0);
                }
                DynamicObjectCollection collection = bill.getDynamicObjectCollection(keys[0]);
                int i = 1;
                for (DynamicObject d : collection) {
                    FeeStandardHelper.add(list, new FieldValue(keys[1], d.get(keys[1]), sensitive, i++, -1, keys[0], null));
                }
                break block6;
            }
            if (keys.length != 3) break block6;
            DynamicObjectCollection collection = bill.getDynamicObjectCollection(keys[0]);
            int i = 1;
            for (DynamicObject s : collection) {
                DynamicObjectCollection subs = s.getDynamicObjectCollection(keys[1]);
                int j = 1;
                for (DynamicObject t : subs) {
                    FeeStandardHelper.add(list, new FieldValue(keys[2], t.get(keys[2]), sensitive, j++, i, keys[0], keys[1]));
                }
                ++i;
            }
        }
        return list;
    }

    public static boolean check(String sensetive, String val) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return true;
        }
        return !val.contains(sensetive.toUpperCase()) && !val.contains(sensetive.toLowerCase());
    }

    private static List buildMsg(MainEntityType mainEntityType, List<FieldValue> list) {
        ArrayList<String> errs = new ArrayList<String>(list.size());
        for (FieldValue f : list) {
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)f.getParentEntry())) {
                sb.append(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c", (String)"FeeStandardHelper_9", (String)"fi-er-business", (Object[])new Object[0]), FeeStandardHelper.getFieldName(f.getParentEntry(), mainEntityType), f.getParentEntry()));
            } else if (StringUtils.isNotEmpty((CharSequence)f.getEntry())) {
                sb.append(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c", (String)"FeeStandardHelper_9", (String)"fi-er-business", (Object[])new Object[0]), FeeStandardHelper.getFieldName(f.getEntry(), mainEntityType), f.getIndex()));
            }
            sb.append(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201d%1$s\u201d\u5305\u542b\u654f\u611f\u5b57\u201c%2$s\u201d\u3002", (String)"FeeStandardHelper_8", (String)"fi-er-business", (Object[])new Object[0]), FeeStandardHelper.getFieldName(f.getField(), mainEntityType), f.getSensitive()));
            errs.add(sb.toString());
        }
        return errs;
    }

    private static void add(List list, FieldValue fieldValue) {
        if (fieldValue.getValue() == null || StringUtils.isEmpty((CharSequence)fieldValue.getValue().toString())) {
            return;
        }
        fieldValue.setValue(fieldValue.getValue().toString());
        list.add(fieldValue);
    }

    private static String getFieldName(String fieldKey, MainEntityType mainEntityType) {
        Map propertyMap = mainEntityType.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)propertyMap.get(fieldKey);
        if (property == null) {
            EntityType entityType = (EntityType)mainEntityType.getAllEntities().get(fieldKey);
            return entityType == null ? fieldKey : (entityType.getDisplayName() == null ? fieldKey : entityType.getDisplayName().getLocaleValue());
        }
        return property.getDisplayName() == null ? fieldKey : property.getDisplayName().getLocaleValue();
    }

    public static String[] splitSensetive(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return new String[0];
        }
        String split = ";";
        return str.split(split);
    }

    public static class FieldValue {
        private int parentIndex;
        private int index;
        private String field;
        private Object value;
        private String parentEntry;
        private String entry;
        private String sensitive;

        FieldValue(String field, Object value, String sensitive, int index, int parentIndex, String entry, String parentEntry) {
            this.field = field;
            this.value = value;
            this.index = index;
            this.parentIndex = parentIndex;
            this.entry = entry;
            this.parentEntry = parentEntry;
            this.sensitive = sensitive;
        }

        public int getParentIndex() {
            return this.parentIndex;
        }

        public void setParentIndex(int parentIndex) {
            this.parentIndex = parentIndex;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getParentEntry() {
            return this.parentEntry;
        }

        public void setParentEntry(String parentEntry) {
            this.parentEntry = parentEntry;
        }

        public String getEntry() {
            return this.entry;
        }

        public void setEntry(String entry) {
            this.entry = entry;
        }

        public String getSensitive() {
            return this.sensitive;
        }
    }
}

