/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.amount.control.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.amount.control.AmountFreed;
import kd.fi.er.business.amount.control.AmountFreedService;
import kd.fi.er.business.cache.TraceCache;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.curator.shaded.com.google.common.base.Objects;

public class AmountFreedImpl
implements AmountFreedService {
    private static final Log logger = LogFactory.getLog(AmountFreedImpl.class);
    private static ThreadLocal<TraceCache<String, DynamicObject>> amountFeedDOMapTL = ThreadLocal.withInitial(() -> new TraceCache());

    @Override
    public BigDecimal getHaveFreededAmount(int day, Long orgId, Long expenseItemId) {
        DynamicObject amountFeed = this.getAmountFreed(orgId, expenseItemId);
        if (amountFeed == null) {
            return BigDecimal.ONE;
        }
        if (amountFeed.getBoolean("nextmonthfree")) {
            return BigDecimal.ZERO;
        }
        DynamicObjectCollection entryEntity = amountFeed.getDynamicObjectCollection("entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            logger.warn(String.format("found amountFeed,but entryEntity is null ,param is :day->%s,orgId->%s,expenseItemId->%s", day, orgId, expenseItemId));
            return BigDecimal.ONE;
        }
        AmountFreed amountFreed = AmountFreed.buildAmountFreed();
        entryEntity.forEach(v -> amountFreed.setAmountFreedEntry(v.getInt("freedday"), v.getInt("freedrate")));
        return new BigDecimal((float)amountFreed.getHaveFeededAmount(day) / 100.0f).setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getHaveFreededAmount(Long orgId, Long expenseItemId) {
        LocalDate localDate = LocalDate.now();
        BigDecimal haveFreededAmount = this.getHaveFreededAmount(localDate.getDayOfMonth() == localDate.lengthOfMonth() ? 31 : localDate.getDayOfMonth(), orgId, expenseItemId);
        if (haveFreededAmount.compareTo(BigDecimal.ZERO) == 0) {
            logger.warn(String.format("getHaveFreededAmount is :%s,param is: orgId->%s,expenseItemId->%s", haveFreededAmount, orgId, expenseItemId));
        }
        return haveFreededAmount;
    }

    @Override
    public DynamicObject getAmountFreed(Long orgId, Long expenseItemId) {
        String key = orgId + "$$" + expenseItemId;
        TraceCache<String, DynamicObject> traceCache = amountFeedDOMapTL.get();
        if (!traceCache.isCurrentTrace()) {
            traceCache.clearAndSetTraceId();
        } else if (traceCache.isCurrentTrace() && traceCache.containKey(key)) {
            return traceCache.get(key);
        }
        QFilter baseDataProFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_amountfreed", (Long)orgId);
        if (baseDataProFilter == null) {
            traceCache.put(key, null);
            return null;
        }
        QFilter notDefaultQFilter = baseDataProFilter.copy().and(new QFilter("expenseitem.fbasedataid_id", "=", (Object)expenseItemId)).and(new QFilter("enable", "=", (Object)"1"));
        Map freedDOFromCache = BusinessDataServiceHelper.loadFromCache((String)"er_amountfreed", (String)"id,number,name,nextmonthfree,entryentity.freedday,entryentity.freedrate,isdefault,createtime,createorg", (QFilter[])new QFilter[]{notDefaultQFilter});
        DynamicObject[] notDefaultAmoutFreeDOs = freedDOFromCache.values().toArray(new DynamicObject[freedDOFromCache.size()]);
        logger.info("getAmountFreed(" + orgId + "," + expenseItemId + "); qFilter=" + SerializationUtils.toJsonString((Object)notDefaultQFilter) + "; amoutFreedDOs=" + SerializationUtils.toJsonString((Object)notDefaultAmoutFreeDOs));
        DynamicObject amountFreeDO = this.getIWantAmountFreeDO(notDefaultAmoutFreeDOs, orgId);
        if (amountFreeDO != null) {
            traceCache.put(key, amountFreeDO);
            return amountFreeDO;
        }
        QFilter defaultQFilter = baseDataProFilter.copy().and(new QFilter("isdefault", "=", (Object)Boolean.TRUE)).and(new QFilter("enable", "=", (Object)"1"));
        Map defaultAmoutFreeDOsFromCache = BusinessDataServiceHelper.loadFromCache((String)"er_amountfreed", (String)"id,number,name,nextmonthfree,entryentity.freedday,entryentity.freedrate,isdefault,createtime,createorg", (QFilter[])new QFilter[]{defaultQFilter});
        DynamicObject[] defaultAmoutFreeDOs = defaultAmoutFreeDOsFromCache.values().toArray(new DynamicObject[defaultAmoutFreeDOsFromCache.size()]);
        amountFreeDO = this.getIWantAmountFreeDO(defaultAmoutFreeDOs, orgId);
        traceCache.put(key, amountFreeDO);
        return amountFreeDO;
    }

    private DynamicObject getIWantAmountFreeDO(DynamicObject[] amountFreeDOs, Long useOrgId) {
        if (amountFreeDOs == null || amountFreeDOs.length <= 0) {
            return null;
        }
        if (amountFreeDOs.length == 1) {
            return amountFreeDOs[0];
        }
        Optional<DynamicObject> findFirstOpt = Arrays.stream(amountFreeDOs).filter(d -> Objects.equal((Object)ErCommonUtils.getPk(d.getDynamicObject("createorg")), (Object)useOrgId)).findFirst();
        if (findFirstOpt.isPresent()) {
            return findFirstOpt.get();
        }
        Arrays.sort(amountFreeDOs, (d1, d2) -> d2.getDate("createtime").compareTo(d1.getDate("createtime")));
        return amountFreeDOs[0];
    }
}

