/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.billingpool.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.billingpool.model.BillingSaveRelationArgs;
import kd.fi.er.business.billingpool.service.SaveRelationInfo;
import kd.fi.er.business.billingpool.writeback.BillingSaveStatusWriteBack;
import kd.fi.er.business.dao.billing.IBillingPoolDao;
import kd.fi.er.business.dao.billing.imp.BillingPoolDaoImpl;
import org.apache.commons.lang3.StringUtils;

public class BillingSaveRelationService {
    private static final Log log = LogFactory.getLog(BillingSaveRelationService.class);
    private static final String ENTITYNAME = "er_billingpool";
    private IBillingPoolDao billingDao;
    private BillingSaveRelationArgs args;
    private SaveRelationInfo saveRelationInfo;

    public BillingSaveRelationService(BillingSaveRelationArgs args) {
        this.args = args;
        this.initService();
    }

    private void initService() {
        this.saveRelationInfo = new SaveRelationInfo(this.args);
        this.billingDao = new BillingPoolDaoImpl(ENTITYNAME);
    }

    public void validate() {
        this.fillWriteOffInfo();
    }

    private void fillWriteOffInfo() {
        if (this.saveRelationInfo.getDataEntity() == null) {
            QFilter filter = new QFilter("voucherentity.relbillid", "=", (Object)this.args.gettId());
            filter.or("id", "in", this.args.getBillingIds());
            DynamicObject[] billing = this.billingDao.query("id,invoiceno,billstatus,invoicecurrency,oribalanceamount,oriusedamount,totalamount,isexpensesync,ismutilreimburse,reasonfortransferout,inoutamount,offsetamount,offsetexpense,ismutilreimburse,relbill,relbilltype,voucherentity.relentryid,voucherentity.relbillid,voucherentity.entityid,voucherentity.entityid,relbills,issmallreim", filter);
            this.saveRelationInfo.setDataEntity(billing);
        }
    }

    public void doWriteBack() {
        this.validate();
        this.executeWriteBack();
        try (TXHandle h = TX.required();){
            try {
                Map<Boolean, Set<Long>> needDeleteMap = this.saveRelationInfo.getNeedDelete();
                DynamicObject[] dataEntities = (DynamicObject[])this.saveRelationInfo.getDataEntity();
                if (needDeleteMap.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])dataEntities);
                } else {
                    Set<Long> saveIdMap = needDeleteMap.get(false);
                    Set<Long> deleteIdsMap = needDeleteMap.get(true);
                    if (saveIdMap != null && !saveIdMap.isEmpty()) {
                        DynamicObject[] deleteObjs = Arrays.stream(dataEntities).filter(dataEntity -> saveIdMap.contains(dataEntity.getLong("id"))).collect(Collectors.toSet()).toArray(new DynamicObject[saveIdMap.size()]);
                        SaveServiceHelper.save((DynamicObject[])deleteObjs);
                    }
                    if (deleteIdsMap != null && !deleteIdsMap.isEmpty()) {
                        OperateOption operateOption = OperateOption.create();
                        operateOption.setVariableValue("skipCheckDataPermission", String.valueOf(true));
                        operateOption.setVariableValue("er_skipCheckStatus", String.valueOf(true));
                        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)ENTITYNAME, (Object[])deleteIdsMap.toArray(), (OperateOption)operateOption);
                        if (!operationResult.isSuccess()) {
                            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                            String errorMsg = allErrorOrValidateInfo.stream().map(info -> info.getMessage()).collect(Collectors.joining());
                            if (StringUtils.isEmpty((CharSequence)errorMsg)) {
                                errorMsg = operationResult.getMessage();
                            }
                            throw new KDBizException(errorMsg);
                        }
                    }
                }
            }
            catch (Exception e) {
                h.markRollback();
                log.error((Throwable)e);
                throw new KDBizException(e.getCause().toString());
            }
        }
    }

    private void executeWriteBack() {
        new BillingSaveStatusWriteBack(this.saveRelationInfo).doWriteBack();
    }
}

