/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.billingpool.util;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.billingpool.model.BillingPoolConfigModel;
import kd.fi.er.business.utils.ActionLocalCache;

public class BillingPoolConfigUtils {
    public static List<BillingPoolConfigModel> queryPoolConfigs(Long accountOrgId) {
        return (List)ActionLocalCache.get().get("billingPoolUtils", accountOrgId, () -> {
            Map queryBaseDataFromCache;
            String fields = "id,number,name,createorg,ctrlstrategy,canimport,canmanualadd,equalwl,equalcostcompany,rangofsync,uniquecon,enableoffset,ctltype,period,iscrossyear,uptomonth,dupexpense,modifytime";
            QFilter qFilter = QFilter.of((String)"enable = '1'", (Object[])new Object[0]);
            if (accountOrgId != null && accountOrgId != 0L && !(queryBaseDataFromCache = BusinessDataServiceHelper.loadFromCache((String)"er_bd_billingpoolcfg", (String)fields, (QFilter[])new QFilter[]{qFilter = qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"er_bd_billingpoolcfg", (Long)accountOrgId))}, (String)"modifytime desc")).isEmpty()) {
                return BillingPoolConfigUtils.genConfigModels(accountOrgId, queryBaseDataFromCache.values());
            }
            return Lists.newLinkedList();
        });
    }

    private static final List<BillingPoolConfigModel> genConfigModels(Long accountOrgId, Collection<DynamicObject> configDynamicObjs) {
        LinkedList list = Lists.newLinkedList();
        for (DynamicObject configDynamicObj : configDynamicObjs) {
            Long createorg = configDynamicObj.getLong("createorg.id");
            BillingPoolConfigModel model = new BillingPoolConfigModel();
            model.setCreateOrg(createorg);
            model.setId(configDynamicObj.getLong("id"));
            model.setNumber(configDynamicObj.getString("number"));
            model.setName(configDynamicObj.getString("name"));
            model.setCtrlStrategy(configDynamicObj.getInt("ctrlstrategy"));
            model.setCanImport(configDynamicObj.getString("canimport"));
            model.setCanManualAdd(configDynamicObj.getString("canmanualadd"));
            model.setEqualWl(configDynamicObj.getString("equalwl"));
            model.setEqualCostCompany(configDynamicObj.getString("equalcostcompany"));
            model.setRangOfSync(configDynamicObj.getString("rangofsync"));
            model.setUniqueCon(configDynamicObj.getString("uniquecon"));
            model.setEnableOffset(configDynamicObj.getString("enableoffset"));
            model.setCtlType(configDynamicObj.getString("ctltype"));
            model.setPeriod(configDynamicObj.getInt("period"));
            model.setIsCrossYear(configDynamicObj.getString("iscrossyear"));
            model.setUpToMonth(configDynamicObj.getInt("uptomonth"));
            model.setDupExpense(configDynamicObj.getString("dupexpense"));
            model.setModifytime(configDynamicObj.getDate("modifytime"));
            if (createorg.equals(accountOrgId)) {
                list.add(0, model);
                return list;
            }
            list.add(model);
        }
        Collections.sort(list, (o1, o2) -> {
            Date o1Modifytime = o1.getModifytime();
            Date o2Modifytime = o2.getModifytime();
            if (o1Modifytime != null && o2Modifytime != null) {
                if (o1Modifytime.after(o2Modifytime)) {
                    return -1;
                }
                return 1;
            }
            return 0;
        });
        return list;
    }

    public static DynamicObject[] queryBillingPoolByIds(List<Long> pkIds) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"er_billingpool");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)dataEntityType);
        return dynamicObjects;
    }
}

