/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.cache;

import java.util.Map;
import kd.bos.context.RequestContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class TraceCache<K, V> {
    private String traceId;
    private Map<K, V> cache = Maps.newHashMap();

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public Map<K, V> getCache() {
        return this.cache;
    }

    public void setCache(Map<K, V> cache) {
        this.cache = cache;
    }

    public void clearAndSetTraceId() {
        this.cache.clear();
        this.traceId = RequestContext.get().getTraceId();
    }

    public boolean containKey(K key) {
        return this.cache.containsKey(key);
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public V get(K key) {
        return this.cache.get(key);
    }

    public boolean isCurrentTrace() {
        return StringUtils.equals((CharSequence)this.traceId, (CharSequence)RequestContext.get().getTraceId());
    }
}

