/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.common;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import kd.fi.er.business.servicehelper.ListConstructorHelper;
import kd.fi.er.common.PayerTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class AccountChangeUtil {
    public static ListShowParameter selectAccountByChangePayer(IFormView view, IDataModel model) {
        String payerType = AccountChangeUtil.getPayerType(view, model);
        if (StringUtils.isBlank((CharSequence)payerType)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"AbstractPublicRBSReceivePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return null;
        }
        PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)payerType);
        if (payerTypeEnum != null) {
            ListShowParameter lsp;
            DynamicObject payer = null;
            switch (payerTypeEnum) {
                case SUPPLIER: {
                    payer = (DynamicObject)model.getValue("changesupplier");
                    break;
                }
                case CUSTOMER: {
                    payer = (DynamicObject)model.getValue("changecustomer");
                    break;
                }
                case CASORG: {
                    payer = (DynamicObject)model.getValue("changecasorg");
                    break;
                }
                case PAYER: {
                    payer = (DynamicObject)model.getValue("changepayeer");
                    break;
                }
                case OTHER: {
                    return null;
                }
            }
            if (payer == null && payerTypeEnum != PayerTypeEnum.PAYER) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"AbstractPublicRBSReceivePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return null;
            }
            if (payer != null && (lsp = AccountChangeUtil.showBankInfo(payerType, (Long)payer.getPkValue(), view, model)) != null) {
                return lsp;
            }
        }
        return null;
    }

    public static String getPayerType(IFormView view, IDataModel model) {
        EntryGrid entry = (EntryGrid)view.getControl("changeentry");
        int rowIndex = entry.getEntryState().getFocusRow();
        return (String)model.getValue("changepayertype", rowIndex);
    }

    private static ListShowParameter showBankInfo(String payerEntityType, Long payerId, IFormView view, IDataModel model) {
        PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)payerEntityType);
        ListShowParameter lsp = null;
        switch (payerTypeEnum) {
            case SUPPLIER: {
                lsp = ListConstructorHelper.getSupplierBankInfoShowParameter(payerId);
                break;
            }
            case CUSTOMER: {
                lsp = ListConstructorHelper.getCustomerBankInfoShowParameter(payerId);
                break;
            }
            case CASORG: {
                lsp = ListConstructorHelper.getCasOrgBankInfoShowParameter(payerId);
                break;
            }
            case PAYER: {
                lsp = ListConstructorHelper.getPayerBankInfoShowParameter(payerId);
            }
        }
        Object invokeExtService = ErExpandServiceFacade.get().invokeExtService("ext.service.er.receiveBankInfoF7", "receiveBankInfoF7", new Object[]{payerEntityType, payerId, model}, new Class[]{String.class, Long.class, BillModel.class});
        if (invokeExtService != null && !"-1".equals(invokeExtService)) {
            lsp = (ListShowParameter)invokeExtService;
        }
        return lsp;
    }

    public static void fillBankInfo(IDataModel model, AccountInfo accountInfo, Integer rowIndex) {
        if (accountInfo != null) {
            String payerAccount = accountInfo.getAccount();
            PublicReimbursePayerAcctUtils.setValueDIY(model, "changepayeraccount", payerAccount, rowIndex);
            PublicReimbursePayerAcctUtils.setValueDIY(model, "changepayerbank", accountInfo.getBeBank(), rowIndex);
            PublicReimbursePayerAcctUtils.setValueDIY(model, "changepayeraccountname", accountInfo.getAccountName(), rowIndex);
        }
    }
}

