/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.daily.amount.service.servicehelper;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import org.apache.commons.lang3.StringUtils;

public class AmountCtrlServiceHelper {
    public static ReimburseAmountControlService getAmountCtrlService4CtrlMethod(String controlMethod) {
        controlMethod = (String)StringUtils.defaultIfBlank((CharSequence)controlMethod, (CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue());
        ErExpenseItemConstant.ReimburseAmountCtlMethod ctrlMethodEnum = ErExpenseItemConstant.ReimburseAmountCtlMethod.getEnumByValue((String)controlMethod);
        return ReimburseAmountControlService.controlServiceMap.get(ctrlMethodEnum);
    }

    public static ReimburseAmountControlService getAmountCtrlService4ExpenseItem(Long expenseItemId) {
        DynamicObject expenseItem = BusinessDataServiceHelper.loadSingleFromCache((Object)expenseItemId, (String)"er_expenseitemedit", (String)"reimburseamountctlmethod");
        String controlMethod = expenseItem.getString("reimburseamountctlmethod");
        return AmountCtrlServiceHelper.getAmountCtrlService4CtrlMethod(controlMethod);
    }

    public static BigDecimal getUserReimbursedAmountBetween(Long companyId, Long userId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, List<Long> notInIds) {
        ReimburseAmountControlService amountControlService = AmountCtrlServiceHelper.getAmountCtrlService4ExpenseItem(expenseItemId);
        return amountControlService.getUserReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, beginDate, endDate, notInIds);
    }

    public static BigDecimal getUserCurrentInReimbursedAmountBetween(Long companyId, Long userId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate) {
        ReimburseAmountControlService amountControlService = AmountCtrlServiceHelper.getAmountCtrlService4ExpenseItem(expenseItemId);
        return amountControlService.getCurrentInReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, beginDate, endDate);
    }

    public static BigDecimal getDeptReimbursedAmountBetween(Long companyId, Long deptId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, List<Long> notInIds) {
        ReimburseAmountControlService amountControlService = AmountCtrlServiceHelper.getAmountCtrlService4ExpenseItem(expenseItemId);
        return amountControlService.getDeptReimbursedAmountBetween(companyId, deptId, expenseItemId, currencyId, beginDate, endDate, notInIds);
    }

    public static BigDecimal getDeptCurrentInReimbursedAmountBetween(Long companyId, Long deptId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate) {
        ReimburseAmountControlService amountControlService = AmountCtrlServiceHelper.getAmountCtrlService4ExpenseItem(expenseItemId);
        return amountControlService.getDeptCurrentInReimbursedAmountBetween(companyId, deptId, expenseItemId, currencyId, beginDate, endDate);
    }
}

