/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.daily.service;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.er.business.amount.control.impl.AmountFreedImpl;
import kd.fi.er.business.cache.TraceCache;
import kd.fi.er.business.daily.amount.service.util.DailyAmountUtils;
import kd.fi.er.business.daily.service.impl.AccumulateControlServiceImpl;
import kd.fi.er.business.daily.service.impl.MonthlyControlServiceImpl;
import kd.fi.er.business.daily.service.impl.QuarterlyControlServiceImpl;
import kd.fi.er.business.daily.service.impl.YearlyControlServiceImpl;
import kd.fi.er.business.daily.service.model.ReimburseAmountBO;
import kd.fi.er.business.daily.service.model.ReimburseAmountControlResultBO;
import kd.fi.er.business.daily.service.model.ReimburseAmountDetailBean;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import kd.fi.er.common.reimctl.ReimburseControlCurrency;
import kd.fi.er.model.WrappedObject;
import org.apache.commons.lang3.StringUtils;

public interface ReimburseAmountControlService {
    public static final Log log = LogFactory.getLog(ReimburseAmountControlService.class);
    public static final List<String> BILL_STATUS_WITH_REIMBURSE = Collections.unmodifiableList(Arrays.asList("B", "C", "E", "F", "G", "I"));
    public static final List<String> BILL_STATUS_WITH_REIMBURSE_AUDIT = Collections.unmodifiableList(Arrays.asList("E", "F", "G", "I"));
    public static final List<String> STATUS_IN_REIMBURSE = Collections.unmodifiableList(Arrays.asList("B", "C"));
    public static final List<String> MONTHS = Collections.unmodifiableList(Arrays.asList("month1", "month2", "month3", "month4", "month5", "month6", "month7", "month8", "month9", "month10", "month11", "month12"));
    public static final ThreadLocal<TraceCache<String, BigDecimal>> reimburseAmountInDailyReimburseBillTL = ThreadLocal.withInitial(() -> new TraceCache());
    public static final Map<ErExpenseItemConstant.ReimburseAmountCtlMethod, ReimburseAmountControlService> controlServiceMap = ReimburseAmountControlService.init();

    public static Map<ErExpenseItemConstant.ReimburseAmountCtlMethod, ReimburseAmountControlService> init() {
        HashMap<ErExpenseItemConstant.ReimburseAmountCtlMethod, ReimburseAmountControlService> controlMap = new HashMap<ErExpenseItemConstant.ReimburseAmountCtlMethod, ReimburseAmountControlService>(3);
        AmountFreedImpl amountFreedService = new AmountFreedImpl();
        AccumulateControlServiceImpl accumulateControlService = new AccumulateControlServiceImpl();
        accumulateControlService.setAmountFreedService(amountFreedService);
        controlMap.put(ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative, accumulateControlService);
        MonthlyControlServiceImpl monthlyControlService = new MonthlyControlServiceImpl();
        monthlyControlService.setAmountFreedService(amountFreedService);
        controlMap.put(ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly, monthlyControlService);
        controlMap.put(ErExpenseItemConstant.ReimburseAmountCtlMethod.Yearly, new YearlyControlServiceImpl());
        controlMap.put(ErExpenseItemConstant.ReimburseAmountCtlMethod.Quarterly, new QuarterlyControlServiceImpl());
        return Collections.unmodifiableMap(controlMap);
    }

    @Deprecated
    public ReimburseAmountControlResultBO validate(Long var1, Long var2, Long var3, Long var4, List<ReimburseAmountBO> var5, List<Long> var6);

    @Deprecated
    public ReimburseAmountControlResultBO validateDeptReim(Long var1, Long var2, Long var3, Long var4, List<ReimburseAmountBO> var5, List<Long> var6);

    public Map<String, LocalDate> getReimburseBillHappenDatePeriod(YearMonth var1);

    public BigDecimal getReimburseLimitAmountByMonth(Long var1, Long var2, Long var3, Long var4, YearMonth var5);

    public BigDecimal getDeptReimburseLimitAmountByMonth(Long var1, Long var2, Long var3, Long var4, YearMonth var5);

    public BigDecimal getReimbursedAmountByMonth(Long var1, Long var2, Long var3, Long var4, YearMonth var5, List<Long> var6);

    public BigDecimal getDeptReimbursedAmountByMonth(Long var1, Long var2, Long var3, Long var4, YearMonth var5, List<Long> var6);

    default public Map<Month, BigDecimal> getReimburseMonthlyAmountLimited(Long companyId, Long userId, Long expenseItemId, Long currencyId, Year year) {
        return ReimburseAmountControlService.getEmployeeReimburseControlAmountMonthly(companyId, userId, expenseItemId, currencyId, year);
    }

    public static Map<Month, BigDecimal> getEmployeeReimburseControlAmountMonthly(Long companyId, Long userId, Long expenseItemId, Long currencyId, Year year) {
        EnumMap<Month, BigDecimal> reimburseLimitAmounts = new EnumMap<Month, BigDecimal>(Month.class);
        Arrays.stream(Month.values()).forEach(month -> reimburseLimitAmounts.put((Month)month, new BigDecimal("0")));
        QFilter qFilter = QFilter.of((String)"company=? and employee=? and expenseitem=? and currency=? and dateyear=? and auditstatus='1'", (Object[])new Object[]{companyId, userId, expenseItemId, currencyId, String.valueOf(year.getValue())});
        DynamicObject reimburseAmountDO = BusinessDataServiceHelper.loadSingleFromCache((String)"er_reimburseamount", (String)StringUtils.join(MONTHS, (String)","), (QFilter[])new QFilter[]{qFilter});
        if (reimburseAmountDO != null) {
            for (int i = 0; i < 12; ++i) {
                BigDecimal amount = reimburseAmountDO.getBigDecimal(MONTHS.get(i));
                amount = amount == null ? BigDecimal.ZERO : amount;
                reimburseLimitAmounts.put(Month.of(i + 1), amount);
            }
        }
        return reimburseLimitAmounts;
    }

    default public Map<Month, BigDecimal> getDeptReimburseMonthlyAmountLimited(Long companyId, Long deptId, Long expenseItemId, Long currencyId, Year year) {
        return ReimburseAmountControlService.getDeptReimburseControlAmountMonthly(companyId, deptId, expenseItemId, currencyId, year);
    }

    public static Map<Month, BigDecimal> getDeptReimburseControlAmountMonthly(Long companyId, Long deptId, Long expenseItemId, Long currencyId, Year year) {
        EnumMap<Month, BigDecimal> reimburseLimitAmounts = new EnumMap<Month, BigDecimal>(Month.class);
        Arrays.stream(Month.values()).forEach(month -> reimburseLimitAmounts.put((Month)month, BigDecimal.ZERO));
        QFilter qFilter = QFilter.of((String)"dept=? and expenseitem=? and currency=? and dateyear=? and auditstatus='1'", (Object[])new Object[]{deptId, expenseItemId, currencyId, String.valueOf(year.getValue())});
        DynamicObject reimburseAmountDO = BusinessDataServiceHelper.loadSingleFromCache((String)"er_dept_reimctl", (String)StringUtils.join(MONTHS, (String)","), (QFilter[])new QFilter[]{qFilter});
        if (reimburseAmountDO != null) {
            for (int i = 0; i < 12; ++i) {
                BigDecimal amount = reimburseAmountDO.getBigDecimal(MONTHS.get(i));
                amount = amount == null ? BigDecimal.ZERO : amount;
                reimburseLimitAmounts.put(Month.of(i + 1), amount);
            }
        }
        return reimburseLimitAmounts;
    }

    default public BigDecimal getReimbuseAmountLimitByYear(Long companyId, Long userId, Long expenseItemId, Long currencyId, Year year) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        QFilter qFilter = QFilter.of((String)"company=? and employee=? and expenseitem=? and currency=? and dateyear=? and auditstatus='1'", (Object[])new Object[]{companyId, userId, expenseItemId, currencyId, String.valueOf(year.getValue())});
        DynamicObject reimburseAmountDO = BusinessDataServiceHelper.loadSingleFromCache((String)"er_reimburseamount", (String)"totalamount", (QFilter[])new QFilter[]{qFilter});
        if (reimburseAmountDO == null) {
            log.info(String.format("\u6309\u5e74\u63a7\u5236:\u516c\u53f8:%d,\u7528\u6237:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u5e74:%s, \u672a\u627e\u5230\u989d\u5ea6, \u5c06\u8fd4\u56de\u989d\u5ea6\u4e3a0", companyId, userId, expenseItemId, currencyId, year));
        } else {
            totalAmount = reimburseAmountDO.getBigDecimal("totalamount");
        }
        return totalAmount;
    }

    default public BigDecimal getDeptReimbuseAmountLimitByYear(Long companyId, Long deptId, Long expenseItemId, Long currencyId, Year year) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        QFilter qFilter = QFilter.of((String)"dept=? and expenseitem=? and currency=? and dateyear=? and auditstatus='1'", (Object[])new Object[]{deptId, expenseItemId, currencyId, String.valueOf(year.getValue())});
        DynamicObject reimburseAmountDO = BusinessDataServiceHelper.loadSingleFromCache((String)"er_dept_reimctl", (String)"totalamount", (QFilter[])new QFilter[]{qFilter});
        if (reimburseAmountDO == null) {
            log.info(String.format("\u6309\u5e74\u63a7\u5236:\u516c\u53f8:%d,\u7528\u6237:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u5e74:%s, \u672a\u627e\u5230\u989d\u5ea6, \u5c06\u8fd4\u56de\u989d\u5ea6\u4e3a0", companyId, deptId, expenseItemId, currencyId, year));
        } else {
            totalAmount = reimburseAmountDO.getBigDecimal("totalamount");
        }
        return totalAmount;
    }

    public static boolean hasReimburseAmountData(Long companyId, Long userId, Long expenseItemId, Long currencyId, Year year) {
        QFilter qFilter = QFilter.of((String)"company=? and employee=? and expenseitem=? and currency=? and dateyear=? and auditstatus='1'", (Object[])new Object[]{companyId, userId, expenseItemId, currencyId, String.valueOf(year.getValue())});
        DynamicObject reimburseAmountDO = BusinessDataServiceHelper.loadSingleFromCache((String)"er_reimburseamount", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return reimburseAmountDO != null;
    }

    public static boolean hasDeptReimburseAmountData(Long companyId, Long deptId, Long expenseItemId, Long currencyId, Year year) {
        QFilter qFilter = QFilter.of((String)"dept=? and expenseitem=? and currency=? and dateyear=? and auditstatus='1'", (Object[])new Object[]{deptId, expenseItemId, currencyId, String.valueOf(year.getValue())});
        DynamicObject reimburseAmountDO = BusinessDataServiceHelper.loadSingleFromCache((String)"er_dept_reimctl", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return reimburseAmountDO != null;
    }

    default public BigDecimal getReimburseBalanceAmount(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth, List<Long> notInIds) {
        BigDecimal totalAmount = this.getReimburseLimitAmountByMonth(companyId, userId, expenseItemId, currencyId, yearMonth);
        BigDecimal reimbursedAmount = this.getReimbursedAmountByMonth(companyId, userId, expenseItemId, currencyId, yearMonth, notInIds);
        BigDecimal balanceAmount = totalAmount.subtract(reimbursedAmount);
        return balanceAmount.max(BigDecimal.ZERO);
    }

    default public BigDecimal getDeptReimburseBalanceAmount(Long companyId, Long deptId, Long expenseItemId, Long currencyId, YearMonth yearMonth, List<Long> notInIds) {
        BigDecimal totalAmount = this.getDeptReimburseLimitAmountByMonth(companyId, deptId, expenseItemId, currencyId, yearMonth);
        BigDecimal reimbursedAmount = this.getDeptReimbursedAmountByMonth(companyId, deptId, expenseItemId, currencyId, yearMonth, notInIds);
        BigDecimal balanceAmount = totalAmount.subtract(reimbursedAmount);
        return balanceAmount.max(BigDecimal.ZERO);
    }

    public static List<ReimburseAmountDetailBean> getUserReimbursedAmountDetailBetween(Long companyId, Long userId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, List<Long> notInIds) {
        QFilter otherFilter = QFilter.of((String)"expenseentryentity.reimburser=?", (Object[])new Object[]{userId});
        otherFilter = otherFilter.and(ReimburseControlUtils.getPersonReimCtlCompanyQFilter(companyId));
        if (notInIds != null && !notInIds.isEmpty()) {
            otherFilter.and(new QFilter("id", "not in", notInIds));
        }
        List<ReimburseAmountDetailBean> stdAmountDetail = ReimburseAmountControlService.getReimbursedAmountDetail(expenseItemId, currencyId, beginDate, endDate, otherFilter, BILL_STATUS_WITH_REIMBURSE, ReimburseControlUtils.getPersonCtlCurrency(companyId));
        List<ReimburseAmountDetailBean> exAmountDetail = DailyAmountUtils.getEmployeeReimbursedAmountDetailBetween(companyId, userId, expenseItemId, currencyId, beginDate, endDate, notInIds, Maps.newHashMapWithExpectedSize((int)0));
        HashMap<String, Object> paramExt = new HashMap<String, Object>();
        paramExt.put("company", companyId);
        paramExt.put("userid", userId);
        paramExt.put("expenseitem", expenseItemId);
        paramExt.put("currency", currencyId);
        paramExt.put("begindate", beginDate);
        paramExt.put("enddate", endDate);
        paramExt.put("existids", notInIds);
        List<ReimburseAmountDetailBean> extBosDetail = ErExtHelper.invokeExpandAmountDetail(paramExt, ErExtcaseEnum.ER_EXTCASE_REIMBURSE_AMOUNT.getCode(), "getEmployeeReimbursedAmountDetailBetween");
        stdAmountDetail.addAll(exAmountDetail);
        stdAmountDetail.addAll(extBosDetail);
        if (!ErStdConfig.standardQuotaQuery()) {
            return exAmountDetail;
        }
        stdAmountDetail.addAll(exAmountDetail);
        return stdAmountDetail;
    }

    public static List<ReimburseAmountDetailBean> getDeptReimbursedAmountDetailBetween(Long companyId, Long deptId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, List<Long> notInIds) {
        QFilter otherFilter = ReimburseControlUtils.getReimCtlDeptQFilter(companyId, deptId);
        if (notInIds != null && !notInIds.isEmpty()) {
            otherFilter.and(new QFilter("id", "not in", notInIds));
        }
        List<ReimburseAmountDetailBean> stdAmountDetail = ReimburseAmountControlService.getReimbursedAmountDetail(expenseItemId, currencyId, beginDate, endDate, otherFilter, BILL_STATUS_WITH_REIMBURSE, ReimburseControlUtils.getDeptCtlCurrency(companyId));
        List<ReimburseAmountDetailBean> exAmountDetail = DailyAmountUtils.getDeptReimbursedAmountDetailBetween(companyId, deptId, expenseItemId, currencyId, beginDate, endDate, notInIds, Maps.newHashMapWithExpectedSize((int)0));
        HashMap<String, Object> paramExt = new HashMap<String, Object>();
        paramExt.put("company", companyId);
        paramExt.put("deptid", deptId);
        paramExt.put("expenseitem", expenseItemId);
        paramExt.put("currency", currencyId);
        paramExt.put("begindate", beginDate);
        paramExt.put("enddate", endDate);
        paramExt.put("existids", notInIds);
        List<ReimburseAmountDetailBean> extBosDetail = ErExtHelper.invokeExpandAmountDetail(paramExt, ErExtcaseEnum.ER_EXTCASE_REIMBURSE_AMOUNT.getCode(), "getDeptReimbursedAmountDetailBetween");
        exAmountDetail.addAll(extBosDetail);
        if (!ErStdConfig.standardQuotaQuery()) {
            return exAmountDetail;
        }
        stdAmountDetail.addAll(exAmountDetail);
        return stdAmountDetail;
    }

    default public BigDecimal getUserReimbursedAmountBetween(Long companyId, Long userId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, List<Long> notInIds) {
        QFilter otherFilter = QFilter.of((String)"expenseentryentity.reimburser=?", (Object[])new Object[]{userId});
        otherFilter = otherFilter.and(ReimburseControlUtils.getPersonReimCtlCompanyQFilter(companyId));
        if (notInIds != null && !notInIds.isEmpty()) {
            otherFilter.and(new QFilter("id", "not in", notInIds));
        }
        BigDecimal stdAmount = this.getReimbursedAmount(expenseItemId, currencyId, beginDate, endDate, otherFilter, BILL_STATUS_WITH_REIMBURSE, ReimburseControlUtils.getPersonCtlCurrency(companyId));
        BigDecimal exAmount = DailyAmountUtils.getEmployeeReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, beginDate, endDate, notInIds, Maps.newHashMapWithExpectedSize((int)0));
        HashMap<String, Object> paramExt = new HashMap<String, Object>();
        paramExt.put("company", companyId);
        paramExt.put("userid", userId);
        paramExt.put("expenseitem", expenseItemId);
        paramExt.put("currency", currencyId);
        paramExt.put("begindate", beginDate);
        paramExt.put("enddate", endDate);
        paramExt.put("existids", notInIds);
        BigDecimal extBosAmount = ErExtHelper.invokeExpandAmount(paramExt, ErExtcaseEnum.ER_EXTCASE_REIMBURSE_AMOUNT.getCode(), "getDeptReimbursedAmountBetween");
        if (!ErStdConfig.standardQuotaQuery()) {
            return exAmount.add(extBosAmount);
        }
        return stdAmount.add(exAmount).add(extBosAmount);
    }

    default public BigDecimal getDeptReimbursedAmountBetween(Long companyId, Long deptId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, List<Long> notInIds) {
        QFilter otherFilter = ReimburseControlUtils.getReimCtlDeptQFilter(companyId, deptId);
        if (notInIds != null && !notInIds.isEmpty()) {
            otherFilter.and(new QFilter("id", "not in", notInIds));
        }
        BigDecimal stdAmount = this.getReimbursedAmount(expenseItemId, currencyId, beginDate, endDate, otherFilter, BILL_STATUS_WITH_REIMBURSE, ReimburseControlUtils.getDeptCtlCurrency(companyId));
        BigDecimal exAmount = DailyAmountUtils.getDeptReimbursedAmountBetween(companyId, deptId, expenseItemId, currencyId, beginDate, endDate, notInIds, Maps.newHashMapWithExpectedSize((int)0));
        HashMap<String, Object> paramExt = new HashMap<String, Object>();
        paramExt.put("company", companyId);
        paramExt.put("dept", deptId);
        paramExt.put("expenseitem", expenseItemId);
        paramExt.put("currency", currencyId);
        paramExt.put("begindate", beginDate);
        paramExt.put("enddate", endDate);
        paramExt.put("existids", notInIds);
        BigDecimal extBosAmount = ErExtHelper.invokeExpandAmount(paramExt, ErExtcaseEnum.ER_EXTCASE_REIMBURSE_AMOUNT.getCode(), "getDeptReimbursedAmountBetween");
        if (!ErStdConfig.standardQuotaQuery()) {
            return exAmount.add(extBosAmount);
        }
        return stdAmount.add(exAmount).add(extBosAmount);
    }

    default public BigDecimal getReimbursedAmount(Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, QFilter otherFilter, List<String> billStatus, ReimburseControlCurrency ctlCurrency) {
        IErDao dailyReimburseDao = ErDaoFactory.getInstance("er_dailyreimbursebill");
        String quotaDateField = ErStdConfig.getQuotaDateField();
        String filterStr = "%s >= ? and %s <= ?";
        filterStr = String.format(filterStr, quotaDateField, quotaDateField);
        QFilter qFilter = QFilter.of((String)("expenseentryentity.expenseitem = ? and " + filterStr), (Object[])new Object[]{expenseItemId, ErCommonUtils.getDateFromLocalDate(beginDate), ErCommonUtils.getDateFromLocalDate(endDate)});
        QFilter billStatusFilter = new QFilter("billstatus", "in", billStatus);
        QFilter keyQFilter = qFilter.and(billStatusFilter).and(otherFilter).and(ctlCurrency.getCurrencyQFilter(currencyId));
        String keyFilterJson = ErCommonUtils.serializeQFilter(keyQFilter);
        TraceCache<String, BigDecimal> traceCache = reimburseAmountInDailyReimburseBillTL.get();
        if (!traceCache.isCurrentTrace()) {
            traceCache.clearAndSetTraceId();
        } else if (traceCache.isCurrentTrace() && traceCache.containKey(keyFilterJson)) {
            return traceCache.get(keyFilterJson);
        }
        DataSet dataSet = dailyReimburseDao.queryDataSet(ReimburseAmountControlService.class.getCanonicalName(), "id," + ctlCurrency.getAmountFieldKey(), new QFilter[]{keyQFilter});
        WrappedObject wo = new WrappedObject((Object)BigDecimal.ZERO);
        dataSet.forEach(data -> {
            BigDecimal amount = data.getBigDecimal(ctlCurrency.getAmountFieldKey());
            wo.setValue((Object)((BigDecimal)wo.getValue()).add(amount));
        });
        dataSet.close();
        reimburseAmountInDailyReimburseBillTL.get().put(keyFilterJson, (BigDecimal)wo.getValue());
        return (BigDecimal)wo.getValue();
    }

    public static List<ReimburseAmountDetailBean> getReimbursedAmountDetail(Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, QFilter otherFilter, List<String> billStatus, ReimburseControlCurrency ctlCurrency) {
        IErDao dailyReimburseDao = ErDaoFactory.getInstance("er_dailyreimbursebill");
        String quotaDateField = ErStdConfig.getQuotaDateField();
        String filterStr = "%s >= ? and %s <= ?";
        filterStr = String.format(filterStr, quotaDateField, quotaDateField);
        QFilter qFilter = QFilter.of((String)("expenseentryentity.expenseitem = ? and " + filterStr), (Object[])new Object[]{expenseItemId, ErCommonUtils.getDateFromLocalDate(beginDate), ErCommonUtils.getDateFromLocalDate(endDate)});
        QFilter billStatusFilter = new QFilter("billstatus", "in", billStatus);
        QFilter keyQFilter = qFilter.and(billStatusFilter).and(otherFilter).and(ctlCurrency.getCurrencyQFilter(currencyId));
        LinkedList<ReimburseAmountDetailBean> result = new LinkedList<ReimburseAmountDetailBean>();
        try (DataSet dataSet = dailyReimburseDao.queryDataSet(ReimburseAmountControlService.class.getCanonicalName(), "id,billno,bizdate,expenseentryentity.happendate," + ctlCurrency.getAmountFieldKey(), new QFilter[]{keyQFilter});){
            for (Row data : dataSet) {
                ReimburseAmountDetailBean reimburseAmountDetailBean = new ReimburseAmountDetailBean();
                reimburseAmountDetailBean.setMetaKey("er_dailyreimbursebill");
                reimburseAmountDetailBean.setMobFormKey("er_dailyreimbursebill_mob");
                reimburseAmountDetailBean.setBillName(MetadataServiceHelper.getDataEntityType((String)reimburseAmountDetailBean.getMetaKey()).getDisplayName().getLocaleValue());
                reimburseAmountDetailBean.setBillId(data.getLong("id"));
                reimburseAmountDetailBean.setBillno(data.getString("billno"));
                reimburseAmountDetailBean.setHappenedDate(ErCommonUtils.getLocalDateFromDate(data.getDate(quotaDateField)));
                reimburseAmountDetailBean.setReimburseAmount(data.getBigDecimal(ctlCurrency.getAmountFieldKey()));
                result.add(reimburseAmountDetailBean);
            }
        }
        return result;
    }

    default public BigDecimal getCurrentInReimbursedAmountBetween(Long companyId, Long userId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate) {
        QFilter otherFilter = QFilter.of((String)"expenseentryentity.reimburser=?", (Object[])new Object[]{userId});
        otherFilter = otherFilter.and(ReimburseControlUtils.getPersonReimCtlCompanyQFilter(companyId));
        BigDecimal stdAmount = this.getReimbursedAmount(expenseItemId, currencyId, beginDate, endDate, otherFilter, STATUS_IN_REIMBURSE, ReimburseControlUtils.getPersonCtlCurrency(companyId));
        BigDecimal exAmount = DailyAmountUtils.getEmployeeCurrentInReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, beginDate, endDate, Maps.newHashMapWithExpectedSize((int)0));
        HashMap<String, Object> paramExt = new HashMap<String, Object>();
        paramExt.put("company", companyId);
        paramExt.put("userid", userId);
        paramExt.put("expenseitem", expenseItemId);
        paramExt.put("currency", currencyId);
        paramExt.put("begindate", beginDate);
        paramExt.put("enddate", endDate);
        BigDecimal extBosAmount = ErExtHelper.invokeExpandAmount(paramExt, ErExtcaseEnum.ER_EXTCASE_REIMBURSE_AMOUNT.getCode(), "getEmployeeCurrentInReimbursedAmountBetween");
        if (!ErStdConfig.standardQuotaQuery()) {
            return exAmount.add(extBosAmount);
        }
        return stdAmount.add(exAmount.add(extBosAmount));
    }

    default public BigDecimal getDeptCurrentInReimbursedAmountBetween(Long companyId, Long deptId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate) {
        QFilter reimCtlDeptQFilter = ReimburseControlUtils.getReimCtlDeptQFilter(companyId, deptId);
        BigDecimal stdAmount = this.getReimbursedAmount(expenseItemId, currencyId, beginDate, endDate, reimCtlDeptQFilter, STATUS_IN_REIMBURSE, ReimburseControlUtils.getDeptCtlCurrency(companyId));
        BigDecimal exAmount = DailyAmountUtils.getDeptCurrentInReimbursedAmountBetween(companyId, deptId, expenseItemId, currencyId, beginDate, endDate, Maps.newHashMapWithExpectedSize((int)0));
        HashMap<String, Object> paramExt = new HashMap<String, Object>();
        paramExt.put("company", companyId);
        paramExt.put("dept", deptId);
        paramExt.put("expenseitem", expenseItemId);
        paramExt.put("currency", currencyId);
        paramExt.put("begindate", beginDate);
        paramExt.put("enddate", endDate);
        BigDecimal extBosAmount = ErExtHelper.invokeExpandAmount(paramExt, ErExtcaseEnum.ER_EXTCASE_REIMBURSE_AMOUNT.getCode(), "getDeptCurrentInReimbursedAmountBetween");
        if (!ErStdConfig.standardQuotaQuery()) {
            return exAmount.add(extBosAmount);
        }
        return stdAmount.add(exAmount).add(extBosAmount);
    }

    public static boolean isReimburseLimitControlByExpensenItem(Long companyId, Long expenseItemId) {
        return SystemParamterUtil.isEnableReimbureControlByCompanyAndExpenseItem(companyId, expenseItemId);
    }

    public static String getReimburseLimitControlType(Long companyId) {
        return SystemParamterUtil.getReimburseLimitControlType(companyId);
    }

    default public BigDecimal getReimburseAuditBalanceAmount(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        BigDecimal totalAmount = this.getReimburseLimitAmountByMonth(companyId, userId, expenseItemId, currencyId, yearMonth);
        BigDecimal reimbursedAmount = this.getAuditReimbursedAmountByMonth(companyId, userId, expenseItemId, currencyId, yearMonth);
        BigDecimal balanceAmount = totalAmount.subtract(reimbursedAmount);
        return balanceAmount.max(BigDecimal.ZERO);
    }

    public BigDecimal getAuditReimbursedAmountByMonth(Long var1, Long var2, Long var3, Long var4, YearMonth var5);

    default public BigDecimal getAuditReimbursedAmountBetween(Long companyId, Long userId, Long expenseItemId, Long currencyId, LocalDate startHappenDate, LocalDate endHappenDate) {
        IErDao dailyReimburseDao = ErDaoFactory.getInstance("er_dailyreimbursebill");
        String quotaDateField = ErStdConfig.getQuotaDateField();
        String filterStr = "%s >= ? and %s <= ?";
        filterStr = String.format(filterStr, quotaDateField, quotaDateField);
        QFilter qFilter = QFilter.of((String)("expenseentryentity.reimburser=? and expenseentryentity.expenseitem = ? and " + filterStr), (Object[])new Object[]{userId, expenseItemId, ErCommonUtils.getDateFromLocalDate(startHappenDate), ErCommonUtils.getDateFromLocalDate(endHappenDate)});
        qFilter = qFilter.and(ReimburseControlUtils.getPersonReimCtlCompanyQFilter(companyId));
        QFilter billStatusFilter = new QFilter("billstatus", "in", BILL_STATUS_WITH_REIMBURSE_AUDIT);
        ReimburseControlCurrency personCtlCurrency = ReimburseControlUtils.getPersonCtlCurrency(companyId);
        QFilter keyQFilter = qFilter.and(billStatusFilter).and(personCtlCurrency.getCurrencyQFilter(currencyId));
        String keyFilterJson = ErCommonUtils.serializeQFilter(keyQFilter);
        TraceCache<String, BigDecimal> traceCache = reimburseAmountInDailyReimburseBillTL.get();
        if (!traceCache.isCurrentTrace()) {
            traceCache.clearAndSetTraceId();
        } else if (traceCache.isCurrentTrace() && traceCache.containKey(keyFilterJson)) {
            return traceCache.get(keyFilterJson);
        }
        DataSet dataSet = dailyReimburseDao.queryDataSet(ReimburseAmountControlService.class.getCanonicalName(), "id," + personCtlCurrency.getAmountFieldKey(), new QFilter[]{keyQFilter});
        WrappedObject wo = new WrappedObject((Object)BigDecimal.ZERO);
        dataSet.forEach(data -> {
            BigDecimal amount = data.getBigDecimal(personCtlCurrency.getAmountFieldKey());
            wo.setValue((Object)((BigDecimal)wo.getValue()).add(amount));
        });
        reimburseAmountInDailyReimburseBillTL.get().put(keyFilterJson, (BigDecimal)wo.getValue());
        return (BigDecimal)wo.getValue();
    }

    default public BigDecimal getReimburseQuarterlyAmountLimited(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        BigDecimal quarterAmount = BigDecimal.ZERO;
        QFilter qFilter = QFilter.of((String)"company=? and employee=? and expenseitem=? and currency=? and dateyear=? and auditstatus='1'", (Object[])new Object[]{companyId, userId, expenseItemId, currencyId, String.valueOf(yearMonth.getYear())});
        DynamicObject reimburseAmountDO = BusinessDataServiceHelper.loadSingleFromCache((String)"er_reimburseamount", (String)"quarter1,quarter2,quarter3,quarter4", (QFilter[])new QFilter[]{qFilter});
        if (reimburseAmountDO == null) {
            log.info(String.format("\u6309\u5b63\u63a7\u5236:\u516c\u53f8:%d,\u7528\u6237:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u5e74:%s, \u672a\u627e\u5230\u989d\u5ea6, \u5c06\u8fd4\u56de\u989d\u5ea6\u4e3a0", companyId, userId, expenseItemId, currencyId, yearMonth.getYear()));
        } else {
            int quarter = (yearMonth.getMonth().firstMonthOfQuarter().getValue() + 2) / 3;
            quarterAmount = reimburseAmountDO.getBigDecimal("quarter" + quarter);
        }
        return quarterAmount;
    }

    default public BigDecimal getDeptReimburseQuarterlyAmountLimited(Long companyId, Long deptId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        BigDecimal quarterAmount = BigDecimal.ZERO;
        QFilter qFilter = QFilter.of((String)"dept=? and expenseitem=? and currency=? and dateyear=? and auditstatus='1'", (Object[])new Object[]{deptId, expenseItemId, currencyId, String.valueOf(yearMonth.getYear())});
        DynamicObject reimburseAmountDO = BusinessDataServiceHelper.loadSingleFromCache((String)"er_dept_reimctl", (String)"quarter1,quarter2,quarter3,quarter4", (QFilter[])new QFilter[]{qFilter});
        if (reimburseAmountDO == null) {
            log.info(String.format("\u6309\u5b63\u63a7\u5236:\u516c\u53f8:%d,\u90e8\u95e8:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u5e74:%s, \u672a\u627e\u5230\u989d\u5ea6, \u5c06\u8fd4\u56de\u989d\u5ea6\u4e3a0", companyId, deptId, expenseItemId, currencyId, yearMonth.getYear()));
        } else {
            int quarter = (yearMonth.getMonth().firstMonthOfQuarter().getValue() + 2) / 3;
            quarterAmount = reimburseAmountDO.getBigDecimal("quarter" + quarter);
        }
        return quarterAmount;
    }
}

