/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.daily.service.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.amount.control.AmountFreedService;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.business.daily.service.model.ReimburseAmountBO;
import kd.fi.er.business.daily.service.model.ReimburseAmountControlResultBO;
import kd.fi.er.business.utils.ReimburseControlUtils;

public class AccumulateControlServiceImpl
implements ReimburseAmountControlService {
    private AmountFreedService amountFreedService;
    private static final Log log = LogFactory.getLog(AccumulateControlServiceImpl.class);

    @Override
    public ReimburseAmountControlResultBO validate(Long companyId, Long userId, Long expenseItemId, Long currencyId, List<ReimburseAmountBO> rawReimburseAmountBOs, List<Long> notInIds) {
        log.info(String.format("\u7d2f\u79ef\u63a7\u5236: \u516c\u53f8:%d, \u7528\u6237:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u8fdb\u884c\u63a7\u5236\u7684\u8d39\u7528\u9879\u76ee\u4fe1\u606f:%s", companyId, userId, expenseItemId, currencyId, JSON.toJSONString(rawReimburseAmountBOs)));
        Map<Integer, List<ReimburseAmountBO>> reimburseAmountByYears = rawReimburseAmountBOs.stream().collect(Collectors.groupingBy(obj -> obj.getHappenDate().getYear()));
        ReimburseAmountControlResultBO result = null;
        for (Map.Entry<Integer, List<ReimburseAmountBO>> pair : reimburseAmountByYears.entrySet()) {
            List<ReimburseAmountBO> reimburseAmountBOs = pair.getValue();
            TreeMap reimbursePerMonth = reimburseAmountBOs.stream().collect(Collectors.groupingBy(reim -> YearMonth.from(reim.getHappenDate()), TreeMap::new, Collectors.mapping(ReimburseAmountBO::getAmount, Collectors.toList())));
            BigDecimal currentBillReimedAmount = BigDecimal.ZERO;
            for (Map.Entry reimMonth : reimbursePerMonth.entrySet()) {
                YearMonth happenYearMonth = (YearMonth)reimMonth.getKey();
                BigDecimal reimAmountPerMonth = ((List)reimMonth.getValue()).stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal reimburseLimitAmount = this.getReimburseLimitAmountByMonth(companyId, userId, expenseItemId, currencyId, happenYearMonth);
                BigDecimal reimbursedAmount = this.getReimbursedAmountByMonth(companyId, userId, expenseItemId, currencyId, happenYearMonth, notInIds);
                BigDecimal needReimburseAmount = reimAmountPerMonth.add(currentBillReimedAmount);
                BigDecimal balanceAmount = reimburseLimitAmount.subtract(reimbursedAmount);
                result = new ReimburseAmountControlResultBO(false, reimburseLimitAmount, balanceAmount, currencyId, expenseItemId, String.format("%1$s%2$s%3$s", "1-", happenYearMonth.getMonthValue(), ResManager.loadKDString((String)"\u6708", (String)"AccumulateControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0])), ReimburseControlUtils.getUserName(userId));
                if (balanceAmount.compareTo(needReimburseAmount) < 0) {
                    result.setOver(true);
                    result.setInTable(ReimburseAmountControlService.hasReimburseAmountData(companyId, userId, expenseItemId, currencyId, Year.of(happenYearMonth.getYear())));
                    return result;
                }
                result.setOver(false);
                currentBillReimedAmount = currentBillReimedAmount.add(reimAmountPerMonth);
            }
        }
        return result;
    }

    @Override
    public ReimburseAmountControlResultBO validateDeptReim(Long companyId, Long deptId, Long expenseItemId, Long currencyId, List<ReimburseAmountBO> rawReimburseAmountBOs, List<Long> notInIds) {
        log.info(String.format("\u90e8\u95e8\u989d\u5ea6\u7d2f\u79ef\u63a7\u5236: \u516c\u53f8:%d, \u90e8\u95e8:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u8fdb\u884c\u63a7\u5236\u7684\u8d39\u7528\u9879\u76ee\u4fe1\u606f:%s", companyId, deptId, expenseItemId, currencyId, JSON.toJSONString(rawReimburseAmountBOs)));
        Map<Integer, List<ReimburseAmountBO>> reimburseAmountByYears = rawReimburseAmountBOs.stream().collect(Collectors.groupingBy(obj -> obj.getHappenDate().getYear()));
        ReimburseAmountControlResultBO result = null;
        for (Map.Entry<Integer, List<ReimburseAmountBO>> pair : reimburseAmountByYears.entrySet()) {
            List<ReimburseAmountBO> reimburseAmountBOs = pair.getValue();
            TreeMap reimbursePerMonth = reimburseAmountBOs.stream().collect(Collectors.groupingBy(reim -> YearMonth.from(reim.getHappenDate()), TreeMap::new, Collectors.mapping(ReimburseAmountBO::getAmount, Collectors.toList())));
            BigDecimal currentBillReimedAmount = BigDecimal.ZERO;
            for (Map.Entry reimMonth : reimbursePerMonth.entrySet()) {
                YearMonth happenYearMonth = (YearMonth)reimMonth.getKey();
                BigDecimal reimAmountPerMonth = ((List)reimMonth.getValue()).stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal reimburseLimitAmount = this.getDeptReimburseLimitAmountByMonth(companyId, deptId, expenseItemId, currencyId, happenYearMonth);
                BigDecimal reimbursedAmount = this.getDeptReimbursedAmountByMonth(companyId, deptId, expenseItemId, currencyId, happenYearMonth, notInIds);
                BigDecimal needReimburseAmount = reimAmountPerMonth.add(currentBillReimedAmount);
                BigDecimal balanceAmount = reimburseLimitAmount.subtract(reimbursedAmount);
                result = new ReimburseAmountControlResultBO(false, reimburseLimitAmount, balanceAmount, currencyId, expenseItemId, String.format("%1$s%2$s%3$s", "1-", happenYearMonth.getMonthValue(), ResManager.loadKDString((String)"\u6708", (String)"AccumulateControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0])), ReimburseControlUtils.getOrgName(deptId));
                if (balanceAmount.compareTo(needReimburseAmount) < 0) {
                    result.setInTable(ReimburseAmountControlService.hasDeptReimburseAmountData(companyId, deptId, expenseItemId, currencyId, Year.of(happenYearMonth.getYear())));
                    result.setOver(true);
                    return result;
                }
                result.setOver(false);
                currentBillReimedAmount = currentBillReimedAmount.add(reimAmountPerMonth);
            }
        }
        return result;
    }

    @Override
    public BigDecimal getReimburseLimitAmountByMonth(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        Map<Month, BigDecimal> reimburseMonthlyAmountLimited = this.getReimburseMonthlyAmountLimited(companyId, userId, expenseItemId, currencyId, Year.of(yearMonth.getYear()));
        BigDecimal reimburseLimitAmountBeforeYearMonth = reimburseMonthlyAmountLimited.entrySet().stream().filter(entry -> ((Month)entry.getKey()).getValue() < yearMonth.getMonthValue()).map(entry -> (BigDecimal)entry.getValue()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
        BigDecimal yearMonthAmount = reimburseMonthlyAmountLimited.get(Month.from(yearMonth));
        YearMonth currentYearMonth = YearMonth.from(ReimburseControlUtils.currentLocalDate());
        BigDecimal releaseRatio = BigDecimal.ONE;
        if (yearMonth.equals(currentYearMonth) && this.amountFreedService != null) {
            releaseRatio = this.amountFreedService.getHaveFreededAmount(companyId, expenseItemId);
        }
        BigDecimal releaseAmount = reimburseLimitAmountBeforeYearMonth.add(yearMonthAmount.multiply(releaseRatio));
        log.info(String.format("\u6309\u6708\u63a7\u5236:\u516c\u53f8:%d,\u7528\u6237:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u622a\u6b62\u5e74\u6708:%s, 1-%d\u6708\u91ca\u653e\u989d\u5ea6:%s, \u5f53\u6708\u5df2\u91ca\u653e\u989d\u5ea6:%s, \u91ca\u653e\u6bd4\u7387:%s", companyId, userId, expenseItemId, currencyId, yearMonth.toString(), Math.max(1, yearMonth.getMonthValue() - 1), reimburseLimitAmountBeforeYearMonth, yearMonthAmount.multiply(releaseRatio), releaseRatio));
        return releaseAmount;
    }

    @Override
    public BigDecimal getDeptReimburseLimitAmountByMonth(Long companyId, Long deptId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        Map<Month, BigDecimal> reimburseMonthlyAmountLimited = this.getDeptReimburseMonthlyAmountLimited(companyId, deptId, expenseItemId, currencyId, Year.of(yearMonth.getYear()));
        BigDecimal reimburseLimitAmountBeforeYearMonth = reimburseMonthlyAmountLimited.entrySet().stream().filter(entry -> ((Month)entry.getKey()).getValue() < yearMonth.getMonthValue()).map(entry -> (BigDecimal)entry.getValue()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
        BigDecimal yearMonthAmount = reimburseMonthlyAmountLimited.get(Month.from(yearMonth));
        BigDecimal releaseAmount = reimburseLimitAmountBeforeYearMonth.add(yearMonthAmount);
        log.info(String.format("\u6309\u6708\u63a7\u5236:\u516c\u53f8:%d,\u90e8\u95e8:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u622a\u6b62\u5e74\u6708:%s, 1-%d\u6708\u91ca\u653e\u989d\u5ea6:%s, \u5f53\u6708\u5df2\u91ca\u653e\u989d\u5ea6:%s", companyId, deptId, expenseItemId, currencyId, yearMonth.toString(), Math.max(1, yearMonth.getMonthValue() - 1), reimburseLimitAmountBeforeYearMonth, yearMonthAmount));
        return releaseAmount;
    }

    @Override
    public BigDecimal getReimbursedAmountByMonth(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth, List<Long> notInIds) {
        LocalDate startHappenDate = LocalDate.of(yearMonth.getYear(), 1, 1);
        LocalDate lastDay = LocalDate.of(yearMonth.getYear(), 12, 31);
        BigDecimal reimbursedAmout = this.getUserReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, startHappenDate, lastDay, notInIds);
        return reimbursedAmout;
    }

    @Override
    public BigDecimal getDeptReimbursedAmountByMonth(Long companyId, Long deptId, Long expenseItemId, Long currencyId, YearMonth yearMonth, List<Long> notInIds) {
        LocalDate startHappenDate = LocalDate.of(yearMonth.getYear(), 1, 1);
        LocalDate lastDay = LocalDate.of(yearMonth.getYear(), 12, 31);
        BigDecimal reimbursedAmout = this.getDeptReimbursedAmountBetween(companyId, deptId, expenseItemId, currencyId, startHappenDate, lastDay, notInIds);
        return reimbursedAmout;
    }

    public AmountFreedService getAmountFreedService() {
        return this.amountFreedService;
    }

    public void setAmountFreedService(AmountFreedService amountFreedService) {
        this.amountFreedService = amountFreedService;
    }

    @Override
    public BigDecimal getAuditReimbursedAmountByMonth(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        LocalDate startHappenDate = LocalDate.of(yearMonth.getYear(), 1, 1);
        LocalDate lastDay = LocalDate.of(yearMonth.getYear(), 12, 31);
        return this.getAuditReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, startHappenDate, lastDay);
    }

    @Override
    public Map<String, LocalDate> getReimburseBillHappenDatePeriod(YearMonth yearMonth) {
        LocalDate beginDate = LocalDate.of(yearMonth.getYear(), 1, 1);
        LocalDate endDate = yearMonth.atEndOfMonth();
        HashMap<String, LocalDate> datePeriod = new HashMap<String, LocalDate>(2);
        datePeriod.put("start", beginDate);
        datePeriod.put("end", endDate);
        return datePeriod;
    }
}

