/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.daily.service.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.utils.ErCommonUtils;

public class ReimburseAmountControlResultBO
implements Serializable {
    private static final long serialVersionUID = -1877158728709230038L;
    private boolean isOver;
    private BigDecimal totalAmount;
    private BigDecimal balanceAmount;
    private Long currencyId;
    private Long expenseItemId;
    private String reimbursePeriod;
    private String reimUserOrDeptName;
    private boolean isInTable;
    private String selfMsg;
    private Integer overIndex;

    public ReimburseAmountControlResultBO() {
    }

    public ReimburseAmountControlResultBO(boolean isOver, BigDecimal totalAmount, BigDecimal balanceAmount, Long currencyId, Long expenseItemId, String reimbursePeriod, String reimUserOrDeptName) {
        this.isOver = isOver;
        this.totalAmount = totalAmount;
        this.balanceAmount = balanceAmount;
        this.currencyId = currencyId;
        this.expenseItemId = expenseItemId;
        this.reimbursePeriod = reimbursePeriod;
        this.reimUserOrDeptName = reimUserOrDeptName;
        this.isInTable = true;
    }

    public boolean isOver() {
        return this.isOver;
    }

    public void setOver(boolean isOver) {
        this.isOver = isOver;
    }

    public int getOverIndex() {
        return this.overIndex;
    }

    public void setOverIndex(int overIndex) {
        this.overIndex = overIndex;
    }

    public BigDecimal getBalanceAmount() {
        return this.balanceAmount;
    }

    public void setBalanceAmount(BigDecimal balanceAmount) {
        this.balanceAmount = balanceAmount;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public Long getExpenseItemId() {
        return this.expenseItemId;
    }

    public void setExpenseItemId(Long expenseItemId) {
        this.expenseItemId = expenseItemId;
    }

    public String getReimbursePeriod() {
        return this.reimbursePeriod;
    }

    public String getReimUserOrDeptName() {
        return this.reimUserOrDeptName;
    }

    public void setReimUserOrDeptName(String reimUserOrDeptName) {
        this.reimUserOrDeptName = reimUserOrDeptName;
    }

    public void setReimbursePeriod(String reimbursePeriod) {
        this.reimbursePeriod = reimbursePeriod;
    }

    public static String getNoQuotaMsg() {
        return ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u989d\u5ea6\u6570\u636e\uff0c\u8bf7\u5148\u7ef4\u62a4\u989d\u5ea6\u3002", (String)"ReimburseAmountControlResultBO_3", (String)"fi-er-business", (Object[])new Object[0]);
    }

    public String getOverDesc() {
        if (!this.isOver) {
            return "";
        }
        DynamicObject expenseitemedit = QueryServiceHelper.queryOne((String)"er_expenseitemedit", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.expenseItemId)});
        String expenseItemName = (String)expenseitemedit.get("name");
        CurrencyBO currencyBO = new CurrencyBO(this.currencyId);
        String currencyName = currencyBO.getName();
        BigDecimal newTotalAmount = this.totalAmount.setScale((int)currencyBO.getPrecision(), RoundingMode.HALF_EVEN);
        BigDecimal newBalanceAmount = this.balanceAmount.setScale((int)currencyBO.getPrecision(), RoundingMode.HALF_EVEN);
        BigDecimal reimbursedAmount = newTotalAmount.subtract(newBalanceAmount).max(BigDecimal.ZERO);
        String noCtrlTips = "";
        if (!this.isInTable) {
            noCtrlTips = "\uff0c" + ReimburseAmountControlResultBO.getNoQuotaMsg();
        }
        String template = ResManager.loadKDString((String)"%1$s\uff0c%2$s\uff08%3$s\uff09\uff1a\u53ef\u7528\u989d\u5ea6%4$s\uff0c\u5df2\u62a5%5$s\uff0c\u53ef\u62a5%6$s%7$s\uff0c\u5f53\u524d\u62a5\u9500\u8d85\u51fa\u989d\u5ea6\u3002", (String)"ReimburseAmountControlResultBO_4", (String)"fi-er-business", (Object[])new Object[0]);
        String overDesc = String.format(template, this.reimUserOrDeptName, expenseItemName, currencyName, ErCommonUtils.getFormattedMoneyString(newTotalAmount, currencyBO), ErCommonUtils.getFormattedMoneyString(reimbursedAmount, currencyBO), ErCommonUtils.getFormattedMoneyString(newBalanceAmount.max(BigDecimal.ZERO), currencyBO), noCtrlTips);
        if (this.overIndex != null && this.overIndex < 100000) {
            template = ResManager.loadKDString((String)"\u7b2c%1$s\u884c|%2$s|%3$s(%4$s):\u53ef\u7528\u989d\u5ea6%5$s|\u5df2\u62a5%6$s|\u53ef\u62a5%7$s%8$s\uff0c\u5f53\u524d\u62a5\u9500\u8d85\u51fa\u989d\u5ea6\u3002", (String)"ReimburseAmountControlResultBO_5", (String)"fi-er-business", (Object[])new Object[0]);
            overDesc = String.format(template, this.overIndex, this.reimUserOrDeptName, expenseItemName, currencyName, ErCommonUtils.getFormattedMoneyString(newTotalAmount, currencyBO), ErCommonUtils.getFormattedMoneyString(reimbursedAmount, currencyBO), ErCommonUtils.getFormattedMoneyString(newBalanceAmount.max(BigDecimal.ZERO), currencyBO), noCtrlTips);
        } else if (this.overIndex != null && this.overIndex > 100000) {
            template = ResManager.loadKDString((String)"\u7b2c%1$s\u6bb5\u884c\u7a0b\uff0c\u7b2c%2$s\u884c|%3$s|%4$s(%5$s):\u53ef\u7528\u989d\u5ea6%6$s|\u5df2\u62a5%7$s|\u53ef\u62a5%8$s%9$s\uff0c\u5f53\u524d\u62a5\u9500\u8d85\u51fa\u989d\u5ea6\u3002", (String)"ReimburseAmountControlResultBO_6", (String)"fi-er-business", (Object[])new Object[0]);
            overDesc = String.format(template, this.overIndex / 100000, this.overIndex % 100000, this.reimUserOrDeptName, expenseItemName, currencyName, ErCommonUtils.getFormattedMoneyString(newTotalAmount, currencyBO), ErCommonUtils.getFormattedMoneyString(reimbursedAmount, currencyBO), ErCommonUtils.getFormattedMoneyString(newBalanceAmount.max(BigDecimal.ZERO), currencyBO), noCtrlTips);
        }
        return overDesc;
    }

    public boolean isInTable() {
        return this.isInTable;
    }

    public void setInTable(boolean isInTable) {
        this.isInTable = isInTable;
    }

    public String getSelfMsg() {
        return this.selfMsg;
    }

    public void setSelfMsg(String selfMsg) {
        this.selfMsg = selfMsg;
    }
}

