/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.dao.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ErOrm {
    private String entityName;
    private static final DynamicObject[] emptyObjects = new DynamicObject[0];

    public ErOrm(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public DynamicObject generateEmptyDynamicObject() {
        return this.generateEmptyDynamicObject(this.getEntityName());
    }

    public DynamicObject generateEmptyDynamicObject(String entityName) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return (DynamicObject)type.createInstance();
    }

    public DynamicObject generateDynamicObject(Object pk, String selectProperties) {
        return this.generateDynamicObject(this.getEntityName(), pk, selectProperties);
    }

    public DynamicObject generateDynamicObject(DynamicObject dobj, String selectProperties) {
        return this.generateDynamicObject(this.getEntityName(), dobj, selectProperties);
    }

    public DynamicObject generateDynamicObject(String entityName, DynamicObject dobj, String selectProperties) {
        return this.generateDynamicObject(entityName, dobj.getPkValue(), selectProperties);
    }

    private DynamicObject generateDynamicObject(String entityName, Object pk, String selectProperties) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName, (String)selectProperties);
    }

    public DynamicObject queryOne(Object pk) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)this.getEntityName());
    }

    public DynamicObject queryOne(Object pk, String selectProperties) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)this.getEntityName(), (String)selectProperties);
    }

    public DynamicObject queryOne(QFilter[] filters) {
        DynamicObject[] dobjs = ErOrm.load(this.getEntityName(), filters);
        if (dobjs.length > 0) {
            return dobjs[0];
        }
        return null;
    }

    public DynamicObject queryOne(String selectProperties, QFilter[] filters) {
        DynamicObject dobjs = BusinessDataServiceHelper.loadSingle((String)this.getEntityName(), (String)selectProperties, (QFilter[])filters);
        return dobjs;
    }

    public DynamicObject[] query(QFilter[] filters) {
        return ErOrm.load(this.getEntityName(), filters);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)this.getEntityName(), (String)selectProperties, (QFilter[])filters);
    }

    public DynamicObject[] query(QFilter[] filters, String orderBys, int top) {
        return this.load(this.getEntityName(), filters, orderBys, top);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters, String orderBys, int top) {
        return this.load(this.getEntityName(), selectProperties, filters, orderBys, top);
    }

    public DataSet queryDataSet(String algoKey, String selectFields, QFilter[] filters, String orderBys, int top) {
        return ORM.create().queryDataSet(algoKey, this.getEntityName(), selectFields, filters, orderBys, top);
    }

    public DataSet queryDataSet(String algoKey, String oql, Object[] params) {
        return ORM.create().queryDataSet(algoKey, oql, params);
    }

    public DataSet queryDataSet(String algoKey, DBRoute dbRoute, String sql, Object[] params) {
        return DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)sql, (Object[])params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObject[] load(String entityName, QFilter[] filters) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        ArrayList listIds = new ArrayList();
        try (DataSet ds = null;){
            ds = ORM.create().queryDataSet("BusinessDataServiceHelper.LoadFromCache", entityName, "id", filters);
            ds.forEach(row -> listIds.add(row.get(0)));
        }
        return BusinessDataServiceHelper.load((Object[])listIds.toArray(new Object[listIds.size()]), (DynamicObjectType)type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DynamicObject[] load(String algo, String entityName, QFilter[] filters, String orderBy, int pageIndex, int pagesize) {
        if (pageIndex < 0) return emptyObjects;
        if (pagesize <= 0) return emptyObjects;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        if (!StringUtils.isBlank((CharSequence)orderBy)) {
            IDSet idSet;
            block35: {
                idSet = new IDSet();
                String selectFields = "id";
                selectFields = Pattern.compile("(^id$)|(^id[ ,]+)|([ ,]+id[ ,]+)|([ ,]+id$)").matcher(orderBy).find() ? orderBy.toLowerCase().replaceAll(" asc", "").replaceAll(" desc", "") : selectFields + "," + orderBy.toLowerCase().replaceAll(" asc", "").replaceAll(" desc", "");
                try (DataSet ds = ORM.create().queryDataSet(algo, entityName, selectFields, filters, orderBy, -1);){
                    int skipN = pageIndex * pagesize;
                    if (skipN <= 0) {
                        int i = 0;
                        while (ds.hasNext()) {
                            idSet.add(ds.next().get("id"));
                            if (++i < pagesize || idSet.idList.size() != pagesize) continue;
                            break block35;
                        }
                        break block35;
                    }
                    IDSet skipIdSet = new IDSet();
                    int i = 0;
                    while (ds.hasNext()) {
                        skipIdSet.add(ds.next().get("id"));
                        if (++i < skipN || skipIdSet.idList.size() != skipN) continue;
                    }
                    if (skipIdSet.idList.size() < skipN) {
                        DynamicObject[] id;
                        DynamicObject[] dynamicObjectArray = id = emptyObjects;
                        return dynamicObjectArray;
                    }
                    while (ds.hasNext()) {
                        Object id = ds.next().get("id");
                        if (skipIdSet.has(id)) continue;
                        idSet.add(id);
                        if (idSet.idList.size() != pagesize) continue;
                        break;
                    }
                }
            }
            DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])idSet.idList.toArray(), (DynamicObjectType)type);
            return ErOrm.orderBy(objs, idSet.idList, orderBy);
        }
        ArrayList idList = new ArrayList();
        try (DataSet ds = ORM.create().queryDataSet(algo, entityName, "id", filters, (String)null, pageIndex * pagesize, pagesize, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
            return BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)type);
        }
    }

    private static DynamicObject[] orderBy(DynamicObject[] objs, List<Object> idList, String orderBy) {
        if (!StringUtils.isBlank((CharSequence)orderBy) && idList.size() > 1) {
            DynamicObject o;
            HashMap<Object, DynamicObject> maps = new HashMap<Object, DynamicObject>(objs.length);
            DynamicObject[] var4 = objs;
            int var5 = objs.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                o = var4[var6];
                maps.put(o.getPkValue(), o);
            }
            ArrayList<DynamicObject> listDyn = new ArrayList<DynamicObject>(objs.length);
            for (Object id : idList) {
                o = (DynamicObject)maps.get(id);
                if (o == null) continue;
                listDyn.add(o);
            }
            return listDyn.toArray(new DynamicObject[listDyn.size()]);
        }
        return objs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject[] load(String entityName, QFilter[] filters, String orderBys, int top) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        ArrayList<Object> listIds = new ArrayList<Object>();
        try (DataSet ds = null;){
            ds = ORM.create().queryDataSet("BusinessDataServiceHelper.LoadFromCache", entityName, "id", filters, orderBys, top);
            ds.forEach(row -> listIds.add(row.get(0)));
        }
        DynamicObject[] dobjs = BusinessDataServiceHelper.load((Object[])listIds.toArray(new Object[listIds.size()]), (DynamicObjectType)type);
        return this.resortByIds(dobjs, listIds);
    }

    private DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters, String orderBys, int top) {
        DynamicObject[] dobjs = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])filters, (String)orderBys, (int)top);
        return dobjs;
    }

    private DynamicObject[] resortByIds(DynamicObject[] dobjs, List<Object> listIds) {
        HashMap dobjMap = Maps.newHashMapWithExpectedSize((int)dobjs.length);
        for (DynamicObject dobj : dobjs) {
            dobjMap.put((Long)dobj.getPkValue(), dobj);
        }
        DynamicObject[] newDobjs = new DynamicObject[listIds.size()];
        int idx = 0;
        for (Object obj : listIds) {
            newDobjs[idx++] = (DynamicObject)dobjMap.get((Long)obj);
        }
        return newDobjs;
    }

    private static DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop);
        }
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)entityName, select);
        return type;
    }

    public boolean isExist(QFilter[] filters) {
        return ORM.create().exists(this.entityName, filters);
    }

    public Object saveOne(DynamicObject obj) {
        return SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj})[0];
    }

    public Object[] save(DynamicObject[] obj) {
        return SaveServiceHelper.save((DynamicObject[])obj);
    }

    private static class IDSet {
        private final Set<Object> sameSet = new HashSet<Object>();
        private final List<Object> idList = new ArrayList<Object>();

        private IDSet() {
        }

        void add(Object obj) {
            if (this.sameSet.add(obj)) {
                this.idList.add(obj);
            }
        }

        boolean has(Object obj) {
            return this.sameSet.contains(obj);
        }
    }
}

