/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.domain.amount;

import kd.fi.er.business.domain.amount.IBillAmountService;
import kd.fi.er.business.domain.amount.imp.DailyLoanBillAmountServiceImp;
import kd.fi.er.business.domain.amount.imp.DailyReimBillAmountServiceImp;
import kd.fi.er.business.domain.amount.imp.TripReimBillAmountServiceImp;
import kd.fi.er.business.domain.amount.imp.TripReqBillAmountServiceImp;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class BillAmountServiceFacade {
    public static IBillAmountService getService(String entityId) {
        if (ErEntityTypeUtils.isDailyReimburseBill(entityId) || ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
            return BillAmountServiceFacade.getDailyReimService();
        }
        if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            return BillAmountServiceFacade.getTripReimService();
        }
        if (ErEntityTypeUtils.isTripReqBill(entityId)) {
            return BillAmountServiceFacade.getTripReqService();
        }
        if (ErEntityTypeUtils.isDailyLoanBill(entityId) || ErEntityTypeUtils.isPrePayBill(entityId)) {
            return BillAmountServiceFacade.getDailyLoanService();
        }
        return null;
    }

    private static IBillAmountService getDailyLoanService() {
        return new DailyLoanBillAmountServiceImp();
    }

    private static IBillAmountService getTripReqService() {
        return new TripReqBillAmountServiceImp();
    }

    private static IBillAmountService getTripReimService() {
        return new TripReimBillAmountServiceImp();
    }

    public static IBillAmountService getDailyReimService() {
        return new DailyReimBillAmountServiceImp();
    }
}

