/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.externalsystem;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import org.apache.commons.lang.StringUtils;

@KSObject
public class SyncReqBillToYzj {
    private static Log logger = LogFactory.getLog(SyncReqBillToYzj.class);

    @KSMethod
    public static HashMap<String, Object> getToken() {
        HashMap<String, Object> yzjMap = new HashMap<String, Object>();
        String accessToken = (String)yzjMap.get("accessToken");
        if (null == accessToken || StringUtils.isEmpty((String)accessToken)) {
            Map<String, Object> yzjaccessJson = SyncReqBillToYzj.getYzjAccessToken();
            if (yzjaccessJson != null) {
                Integer expireIn = (Integer)yzjaccessJson.get("expireIn");
                accessToken = (String)yzjaccessJson.get("accessToken");
                String refreshToken = (String)yzjaccessJson.get("refreshToken");
                yzjMap.put("refreshToken", refreshToken);
                yzjMap.put("accessToken", accessToken);
                yzjMap.put("expireIn", expireIn);
            }
        } else {
            Map<String, Object> refreshAccessToken;
            long currentTime = System.currentTimeMillis();
            Integer expireIn = (Integer)yzjMap.get("expireIn");
            String refreshToken = (String)yzjMap.get("refreshToken");
            Long deadlinetime = currentTime - (long)expireIn.intValue();
            logger.info("deadlinetime:" + deadlinetime);
            if (deadlinetime > 300000L && (refreshAccessToken = SyncReqBillToYzj.refreshAccessToken(refreshToken)) != null) {
                accessToken = (String)refreshAccessToken.get("accessToken");
                expireIn = (Integer)refreshAccessToken.get("expireIn");
                yzjMap.put("accessToken", accessToken);
                yzjMap.put("expireIn", expireIn);
            }
        }
        return yzjMap;
    }

    @KSMethod
    public static Map<String, Object> getYzjAccessToken() {
        boolean success = false;
        Map resultData = null;
        try {
            HashMap resultMap = new HashMap();
            JSONObject paramJson = new JSONObject();
            Map<String, Object> paramMap = SyncReqBillToYzj.getYZJParam();
            String getYzjAccessToken_URL = (String)paramMap.get("getYzjAccessToken_URL");
            String appId = (String)paramMap.get("yzj_appId");
            String secret = (String)paramMap.get("yzj_secret");
            String scope = (String)paramMap.get("yzj_scope");
            paramJson.put("appId", (Object)appId);
            paramJson.put("secret", (Object)secret);
            long currentTime = System.currentTimeMillis();
            paramJson.put("timestamp", (Object)currentTime);
            paramJson.put("scope", (Object)scope);
            Map<String, Object> resultMsg = HttpServiceHelper.doPost(getYzjAccessToken_URL, paramJson.toJSONString());
            logger.info("getYzjAccessToken resultMsg:" + resultMsg);
            int errorCode = (Integer)resultMsg.get("errorCode");
            success = (Boolean)resultMsg.get("success");
            resultData = (Map)resultMsg.get("data");
            logger.info("getYzjAccessToken failed!" + resultData);
            String accessToken = (String)resultData.get("accessToken");
            Integer expireIn = (Integer)resultData.get("expireIn");
            String refreshToken = (String)resultData.get("refreshToken");
            logger.info("getYzjAccessToken accessToken:" + accessToken + ",expireIn:" + expireIn + ",refreshToken:" + refreshToken);
        }
        catch (Exception e) {
            logger.error("SyncReqBillToYzj getYzjAccessToken failed!!:resultData:" + resultData + "success:" + success + " e:" + e);
        }
        return resultData;
    }

    @KSMethod
    public static Map<String, Object> getYZJParam() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add("yzj_appId");
        keyList.add("yzj_secret");
        keyList.add("yzj_scope");
        keyList.add("getYzjAccessToken_URL");
        keyList.add("refreshYzjAccessToken_URL");
        keyList.add("SyncYZJ_URL");
        QFilter qFilter = new QFilter("key", "in", keyList);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObjectCollection getAccessInfo = QueryServiceHelper.query((String)"er_stdconfig", (String)"key,value", (QFilter[])qFilters);
        for (DynamicObject accessValue : getAccessInfo) {
            String key = accessValue.getString("key");
            String value = accessValue.getString("value");
            paramMap.put(key, value);
        }
        logger.info("getYzjAccessToken paramMap:" + paramMap);
        return paramMap;
    }

    @KSMethod
    public static Map<String, Object> refreshAccessToken(String refreshToken) {
        logger.info(" nextCloud SyncReqBillToYzj refreshAccessToken() login refreshToken:" + refreshToken);
        Map resultData = null;
        JSONObject jsonObject = new JSONObject();
        Map<String, Object> reslutMap = SyncReqBillToYzj.getYZJParam();
        String appId = (String)reslutMap.get("yzj_appId");
        String scope = (String)reslutMap.get("yzj_scope");
        String refreshYzjAccessToken_URL = (String)reslutMap.get("refreshYzjAccessToken_URL");
        long timestamp = System.currentTimeMillis();
        jsonObject.put("appId", (Object)appId);
        jsonObject.put("refreshToken", (Object)refreshToken);
        jsonObject.put("timestamp", (Object)timestamp);
        jsonObject.put("scope", (Object)scope);
        Map<String, Object> resultMsg = HttpServiceHelper.doPost(refreshYzjAccessToken_URL, jsonObject.toJSONString());
        logger.info("getYzjAccessToken resultMsg:" + resultMsg);
        int errorCode = (Integer)resultMsg.get("errorCode");
        boolean success = (Boolean)resultMsg.get("success");
        resultData = (Map)resultMsg.get("data");
        logger.info("getYzjAccessToken failed!" + resultData);
        if (resultData == null) {
            return resultData;
        }
        String accessToken = (String)resultData.get("accessToken");
        Integer expireIn = (Integer)resultData.get("expireIn");
        refreshToken = (String)resultData.get("refreshToken");
        logger.info("getYzjAccessToken accessToken:" + accessToken + ",expireIn:" + expireIn + ",refreshToken:" + refreshToken);
        return resultData;
    }

    @KSMethod
    public static void SyncReqBillToYzj(String billno) {
        String resultStr;
        Long applier_id;
        JSONObject jsonObject = new JSONObject();
        String form_inst_id = "";
        String trip_id = "";
        String business_destination = "";
        int business_days = 0;
        long business_time_startdate = 0L;
        long business_time_enddate = 0L;
        long submit_time = 0L;
        JSONArray tripreqJsonArray = new JSONArray();
        IErDao er_tripreqbill = ErDaoFactory.getInstance("er_tripreqbill");
        QFilter qFilter = new QFilter("billno", "=", (Object)billno);
        qFilter.and("billstatus", "=", (Object)"E");
        DynamicObject tripReqInfo = er_tripreqbill.queryOne(qFilter);
        if (tripReqInfo == null) {
            return;
        }
        DynamicObject applier = tripReqInfo.getDynamicObject("applier");
        applier_id = applier == null ? (applier_id = Long.valueOf(0L)) : (Long)applier.getPkValue();
        form_inst_id = String.valueOf((Long)tripReqInfo.getPkValue());
        trip_id = tripReqInfo == null ? trip_id : String.valueOf((Long)tripReqInfo.getPkValue());
        String reason = tripReqInfo.getString("description");
        Date auditdate = tripReqInfo.getDate("auditdate");
        if (auditdate != null) {
            submit_time = auditdate.getTime();
        }
        DynamicObjectCollection tripentrys = tripReqInfo.getDynamicObjectCollection("tripentry");
        for (DynamicObject tripentry : tripentrys) {
            Date enddate;
            DynamicObject to = tripentry.getDynamicObject("to");
            business_destination = to.getString("name");
            business_days = tripentry.getInt("tripday");
            Date startdate = tripentry.getDate("startdate");
            if (startdate != null) {
                business_time_startdate = startdate.getTime();
            }
            if ((enddate = tripentry.getDate("enddate")) != null) {
                business_time_enddate = enddate.getTime();
            }
            JSONObject postJson = new JSONObject();
            postJson.put("form_inst_id", (Object)form_inst_id);
            postJson.put("business_destination", (Object)business_destination);
            postJson.put("business_days", (Object)business_days);
            long[] business_time = new long[]{business_time_startdate, business_time_enddate};
            postJson.put("business_time", (Object)business_time);
            postJson.put("reason", (Object)reason);
            postJson.put("submit_time", (Object)submit_time);
            tripreqJsonArray.add((Object)postJson);
        }
        jsonObject = SyncReqBillToYzj.getUserParamMap(jsonObject, applier_id);
        jsonObject.put("details", (Object)tripreqJsonArray);
        Map<String, Object> paramMap = SyncReqBillToYzj.getYZJParam();
        String SyncYZJ_URL = (String)paramMap.get("SyncYZJ_URL");
        HashMap<String, Object> yzjMap = SyncReqBillToYzj.getToken();
        String accessToken = (String)yzjMap.get("accessToken");
        if (accessToken == null) {
            logger.info("SyncReqBillToYzjSingle accessToken is null");
        }
        String msg = !"success".equals(resultStr = HttpServiceHelper.PostData(SyncYZJ_URL = SyncYZJ_URL + accessToken, jsonObject.toString())) ? "SyncReqBillToYzjSingle failed billno:" : "SyncReqBillToYzjSingle success billno:";
        logger.info(msg + billno + "resultStr :" + resultStr);
    }

    @KSMethod
    private static JSONObject getUserParamMap(JSONObject jsonObject, Long userId) {
        IErDao user = ErDaoFactory.getInstance("bos_user");
        DynamicObject userInfo = user.queryOne("eid,useropenid,name", userId);
        long eid = 0L;
        String openid = null;
        String userName = null;
        if (userInfo != null) {
            eid = userInfo.getLong("eid");
            openid = userInfo.getString("useropenid");
            userName = userInfo.getString("name");
            logger.info("SyncReqBillToYzj nextCloud eid:" + eid + "and useropenid:" + openid);
        }
        jsonObject.put("name", userName);
        jsonObject.put("eid", (Object)eid);
        jsonObject.put("oid", (Object)openid);
        return jsonObject;
    }

    public static Date getStartDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2018);
        calendar.set(2, 10);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date firstDay = calendar.getTime();
        logger.info("firstDay:" + firstDay);
        return firstDay;
    }

    @KSMethod
    public static void SyncBatchReqBillToYzjOneTime(Date startDate, Date endDate) {
        logger.info("SyncBatchReqBillToYzjOneTime login");
        ArrayList<JSONObject> reqbillList = new ArrayList<JSONObject>();
        String form_inst_id = "";
        String trip_id = "";
        String business_destination = "";
        int business_days = 0;
        long business_time_startdate = 0L;
        long business_time_enddate = 0L;
        long submit_time = 0L;
        IErDao er_tripreqbill = ErDaoFactory.getInstance("er_tripreqbill");
        QFilter qFilter = new QFilter("billstatus", "in", Arrays.asList("E", "I"));
        qFilter.and("auditdate", ">=", (Object)startDate);
        qFilter.and("auditdate", "<=", (Object)endDate);
        DynamicObject[] tripReqInfos = er_tripreqbill.query(qFilter);
        if (tripReqInfos == null) {
            return;
        }
        logger.info(" SyncBatchReqBillToYzjOneTime tripReqInfos:" + tripReqInfos.length);
        for (DynamicObject tripReqInfo : tripReqInfos) {
            Long applier_id;
            JSONObject jsonObject = new JSONObject();
            JSONArray tripreqJsonArray = new JSONArray();
            if (tripReqInfo == null) continue;
            DynamicObject applier = tripReqInfo.getDynamicObject("applier");
            applier_id = applier == null ? (applier_id = Long.valueOf(0L)) : (Long)applier.getPkValue();
            form_inst_id = String.valueOf((Long)tripReqInfo.getPkValue());
            trip_id = tripReqInfo == null ? trip_id : String.valueOf((Long)tripReqInfo.getPkValue());
            String reason = tripReqInfo.getString("description");
            Date auditdate = tripReqInfo.getDate("auditdate");
            if (auditdate != null) {
                submit_time = auditdate.getTime();
            }
            DynamicObjectCollection tripentrys = tripReqInfo.getDynamicObjectCollection("tripentry");
            for (DynamicObject tripentry : tripentrys) {
                Date enddate;
                DynamicObject to = tripentry.getDynamicObject("to");
                business_destination = to.getString("name");
                business_days = tripentry.getInt("tripday");
                Date startdate = tripentry.getDate("startdate");
                if (startdate != null) {
                    business_time_startdate = startdate.getTime();
                }
                if ((enddate = tripentry.getDate("enddate")) != null) {
                    business_time_enddate = enddate.getTime();
                }
                JSONObject postJson = new JSONObject();
                postJson.put("form_inst_id", (Object)form_inst_id);
                postJson.put("business_destination", (Object)business_destination);
                postJson.put("business_days", (Object)business_days);
                long[] business_time = new long[]{business_time_startdate, business_time_enddate};
                postJson.put("business_time", (Object)business_time);
                postJson.put("reason", (Object)reason);
                postJson.put("submit_time", (Object)submit_time);
                tripreqJsonArray.add((Object)postJson);
            }
            jsonObject = SyncReqBillToYzj.getUserParamMap(jsonObject, applier_id);
            jsonObject.put("details", (Object)tripreqJsonArray);
            reqbillList.add(jsonObject);
        }
        if (reqbillList != null && reqbillList.size() > 0) {
            logger.info("SyncBatchReqBillToYzjOneTime reqbillList:" + JSON.toJSONString(reqbillList));
        }
        Map<String, Object> paramMap = SyncReqBillToYzj.getYZJParam();
        String SyncYZJ_URL = (String)paramMap.get("SyncYZJ_URL");
        String resultStr = "";
        int successCount = 0;
        int faildCount = 0;
        StringBuilder successSb = new StringBuilder();
        StringBuilder failedSb = new StringBuilder();
        for (int i = 0; i < reqbillList.size(); ++i) {
            String formInstId = "";
            try {
                JSONObject jsonObjectOne = (JSONObject)reqbillList.get(i);
                JSONArray details = jsonObjectOne.getJSONArray("details");
                JSONObject jsonObj = (JSONObject)details.get(0);
                formInstId = (String)jsonObj.get((Object)"form_inst_id");
                HashMap<String, Object> yzjMap = SyncReqBillToYzj.getToken();
                String accessToken = (String)yzjMap.get("accessToken");
                if (accessToken == null) {
                    logger.info("SyncBatchReqBillToYzjOneTime accessToken is null:" + formInstId);
                }
                if (!"success".equals(resultStr = HttpServiceHelper.PostData(SyncYZJ_URL = SyncYZJ_URL + accessToken, jsonObjectOne.toString()))) {
                    ++faildCount;
                    failedSb.append(formInstId);
                    failedSb.append(',');
                    continue;
                }
                ++successCount;
                successSb.append(formInstId);
                successSb.append(',');
                continue;
            }
            catch (Exception e) {
                logger.error("SyncBatchReqBillToYzjOneTime exceptionlog:" + resultStr + "formInstId:" + formInstId + "---" + e);
            }
        }
        logger.info("SyncBatchReqBillToYzjOneTime successCount:" + successCount + "\u2014\u2014failedCount:" + faildCount + ",syncFailed_id:" + failedSb + ",syncSuccessed_id:" + successSb);
    }
}

