/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.fatvs.skilldata;

import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class AutoContractPayWarningSkill
implements ISkillRunnable {
    private static final Log logger = LogFactory.getLog(AutoContractPayWarningSkill.class);
    private static final String skillNumber = "htfkznyj";

    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        String skillNum = skillRunContext.getSkillNum();
        SkillRunResult skillResult = skillRunContext.getSkillResult();
        if (StringUtils.equals((CharSequence)skillNum, (CharSequence)skillNumber)) {
            skillResult.setDate(skillRunContext.getStartTime());
            skillResult.setSkillNum(skillNum);
            skillResult.setTotalCount(Integer.valueOf(this.getRangeDateCount(skillRunContext.getStartTime(), skillRunContext.getEndTime())));
            skillResult.setFailCount(Integer.valueOf(0));
            skillResult.setData(this.genStatisticsData());
        }
        return skillResult;
    }

    private Map<String, Integer> getOverPayCount() {
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate nextMonth = now.plusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
        LocalDate curMonth = now.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastMonth = now.plusMonths(-1L).with(TemporalAdjusters.firstDayOfMonth());
        LocalDate monday = now.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDate sunday = now.with(TemporalAdjusters.next(DayOfWeek.MONDAY));
        LocalDateTime curMonthEnd = nextMonth.atStartOfDay();
        LocalDateTime curMonthDate = curMonth.atStartOfDay();
        LocalDateTime lastMonthStart = lastMonth.atStartOfDay();
        LocalDateTime curWeekStart = monday.atStartOfDay();
        LocalDateTime curWeekEnd = sunday.atStartOfDay();
        String nexMonthStr = curMonthEnd.format(formatter);
        String curMonthStr = curMonthDate.format(formatter);
        String lastMonthStr = lastMonthStart.format(formatter);
        String curWeekStartStr = curWeekStart.format(formatter);
        String curWeekEndStr = curWeekEnd.format(formatter);
        String curMonthTotalSql = String.format("select  count(1) as count from t_wf_message where fcontent_summary like '%%\u60a8\u6709\u5408\u540c\u5728\u4e00\u5468\u5185\u9700\u8981\u4ed8\u6b3e%%' and fcreatedate >= '%s' and fcreatedate < '%s'", curMonthStr, nexMonthStr);
        String lastMonthTotalSql = String.format("select  count(1) as count from t_wf_message where fcontent_summary like '%%\u60a8\u6709\u5408\u540c\u5728\u4e00\u5468\u5185\u9700\u8981\u4ed8\u6b3e%%' and fcreatedate >= '%s' and fcreatedate < '%s'", lastMonthStr, curMonthStr);
        String curWeekTotalSql = String.format("select  count(1) as count from t_wf_message where fcontent_summary like '%%\u60a8\u6709\u5408\u540c\u5728\u4e00\u5468\u5185\u9700\u8981\u4ed8\u6b3e%%' and fcreatedate >= '%s' and fcreatedate < '%s'", curWeekStartStr, curWeekEndStr);
        int curWeekTotal = 0;
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.workflow, (String)curWeekTotalSql);){
            for (Row row : ds) {
                curWeekTotal = row.getInteger("count");
            }
        }
        int curMonthTotal = 0;
        DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.workflow, (String)curMonthTotalSql);
        Object object = null;
        try {
            for (Row row : ds) {
                curMonthTotal = row.getInteger("count");
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        int lastMonthTotal = 0;
        DataSet ds2 = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.workflow, (String)lastMonthTotalSql);
        Object object2 = null;
        try {
            for (Row row : ds2) {
                lastMonthTotal = row.getInteger("count");
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (ds2 != null) {
                if (object2 != null) {
                    try {
                        ds2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ds2.close();
                }
            }
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("curWeekTotal", curWeekTotal);
        result.put("curMonthTotal", curMonthTotal);
        result.put("lastMonthTotal", lastMonthTotal);
        return result;
    }

    private List genStatisticsData() {
        ArrayList data = new ArrayList();
        Map<String, Integer> overPayCount = this.getOverPayCount();
        HashMap<String, String> bzzs = new HashMap<String, String>(4);
        bzzs.put("number", "bzzs");
        bzzs.put("name", ResManager.loadKDString((String)"\u672c\u5468\u603b\u6570", (String)"AutoContractPayWarningSkill_0", (String)"fi-er-business", (Object[])new Object[0]));
        bzzs.put("value", overPayCount.get("curWeekTotal").toString());
        bzzs.put("valueType", "0");
        HashMap<String, String> byzs = new HashMap<String, String>(4);
        byzs.put("number", "bzzs");
        byzs.put("name", ResManager.loadKDString((String)"\u672c\u6708\u603b\u6570", (String)"AutoContractPayWarningSkill_1", (String)"fi-er-business", (Object[])new Object[0]));
        byzs.put("value", overPayCount.get("curMonthTotal").toString());
        byzs.put("valueType", "0");
        HashMap<String, String> syzs = new HashMap<String, String>(4);
        syzs.put("number", "bzzs");
        syzs.put("name", ResManager.loadKDString((String)"\u4e0a\u6708\u603b\u6570", (String)"AutoContractPayWarningSkill_2", (String)"fi-er-business", (Object[])new Object[0]));
        syzs.put("value", overPayCount.get("lastMonthTotal").toString());
        syzs.put("valueType", "0");
        data.add(bzzs);
        data.add(byzs);
        data.add(syzs);
        return data;
    }

    private int getRangeDateCount(Date startDate, Date endDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startDateStr = format.format(startDate);
        String endDateStr = format.format(endDate);
        String countRangeSql = String.format("select  count(1) as count from t_wf_message where fcontent_summary like '%%\u60a8\u6709\u5408\u540c\u5728\u4e00\u5468\u5185\u9700\u8981\u4ed8\u6b3e%%' and fcreatedate >= '%s' and fcreatedate < '%s'", startDateStr, endDateStr);
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.workflow, (String)countRangeSql);){
            for (Row row : ds) {
                count = row.getInteger("count");
            }
        }
        return count;
    }
}

