/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.fileservice;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dlock.DLock;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.fi.er.business.servicehelper.HttpServiceHelper;

public class ErFileServiceHelper {
    private static final Log logger = LogFactory.getLog(ErFileServiceHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadFile(String url, String fileName, String path) {
        String attachmentPath = "";
        DLock lock = DLock.create((String)"fi.er.trip.uploadFile");
        lock.lock();
        try {
            Map<String, Object> data = HttpServiceHelper.doGetInputStream(url);
            InputStream in = (InputStream)data.get("in");
            if (in == null) {
                logger.info("ErFileServiceHelper_uploadFile>>> no stream");
                String string = attachmentPath;
                return string;
            }
            TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String filePath = "";
            filePath = tempFile.saveAsFullUrl(fileName, (InputStream)new ByteArrayInputStream(ByteStreams.toByteArray((InputStream)in)), 30000);
            logger.info(String.format("\u83b7\u53d6\u7684connection\u7684\u5927\u5c0f:%1$s,filePath:%2$s", data.get("size"), filePath));
            FileItem fileItems = new FileItem(fileName, path + fileName, tempFile.getInputStream(filePath));
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            attachmentPath = fileService.upload(fileItems);
            attachmentPath = UrlService.getAttachmentPreviewUrl((String)attachmentPath);
        }
        catch (Exception e) {
            logger.error("ErFileServiceHelper_uploadFile>>>", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return attachmentPath;
    }
}

