/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.handler;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.fi.er.business.handler.MultiAccountEntryHandler;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.common.SettlementTypeEnum;

public class TripMultiAccountEntryMobHandler
extends MultiAccountEntryHandler {
    @Override
    public void generateAccountEntry(IFormView view) {
        ACC_ENTRY_NAME = "accountentry";
        applier = (DynamicObject)view.getModel().getValue("applier");
        this.clearAccountEntry(view.getModel());
        this.createAccountEntry(view);
        this.resolveCostDept(view);
    }

    protected void resolveCostDept(IFormView view) {
        DynamicObjectCollection tripEntry = view.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        HashMap payerIdMapAccCostCompany = new HashMap();
        tripEntry.stream().forEach(card -> {
            DynamicObjectCollection detailEntry = card.getDynamicObjectCollection("entryentity");
            detailEntry.stream().forEach(row -> {
                DynamicObject accCostCompany = row.getDynamicObject("travelcostcompany");
                Map<Long, DynamicObject> map = row.getDynamicObjectCollection("trip2travelers").stream().filter(Objects::nonNull).collect(Collectors.toMap(traver -> traver.getLong("fbasedataid_id"), traver -> accCostCompany, (v1, v2) -> accCostCompany));
                map.entrySet().stream().filter(entry -> payerIdMapAccCostCompany.get(entry.getKey()) == null).forEach(entry -> {
                    DynamicObject cfr_ignored_0 = (DynamicObject)payerIdMapAccCostCompany.put(entry.getKey(), entry.getValue());
                });
            });
        });
        DynamicObjectCollection accEntry = view.getModel().getDataEntity(true).getDynamicObjectCollection("accountentry");
        IntStream.range(0, accEntry.size()).forEach(idx -> {
            Long payerId = ((DynamicObject)accEntry.get(idx)).getDynamicObject("payer").getDynamicObject("payer").getLong("id");
            if (payerIdMapAccCostCompany.get(payerId) != null) {
                ((DynamicObject)accEntry.get(idx)).set("acccostcompany", payerIdMapAccCostCompany.get(payerId));
                view.updateView("acccostcompany", idx);
            }
        });
    }

    protected void createAccountEntry(IFormView view) {
        Map<Long, BigDecimal> applierAmountMap = this.groupExpAmountByApplier(view);
        Set<Long> reimburseIds = this.buildAccountEntryView(applierAmountMap, view);
        this.showConfirm(reimburseIds, view);
    }

    private Map<Long, BigDecimal> groupExpAmountByApplier(IFormView view) {
        HashMap<Long, BigDecimal> singleTraver = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> multipleTravers = new HashMap<Long, BigDecimal>();
        if (DailyBillServiceHelper.isNewTripReim(view.getModel())) {
            DynamicObjectCollection tripEntryDOs = view.getModel().getEntryEntity("tripentry");
            for (DynamicObject tripEntry : tripEntryDOs) {
                DynamicObjectCollection entries = tripEntry.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entries) {
                    if (SettlementTypeEnum.MONTH_SETTLEMENT.getCode().equals(entry.getString("settlementtype"))) continue;
                    DynamicObjectCollection travelers = entry.getDynamicObjectCollection("trip2travelers");
                    BigDecimal tripApproveAmount = entry.getBigDecimal("entryappamount");
                    this.addValueToMap(travelers, tripApproveAmount, multipleTravers, singleTraver);
                }
            }
        } else {
            DynamicObjectCollection tripEntryDOs = view.getModel().getEntryEntity("tripentry");
            for (DynamicObject tripEntry : tripEntryDOs) {
                DynamicObjectCollection travelers = tripEntry.getDynamicObjectCollection("travelers");
                DynamicObjectCollection entries = tripEntry.getDynamicObjectCollection("entryentity");
                BigDecimal[] tripApproveAmount = new BigDecimal[]{BigDecimal.ZERO};
                entries.stream().filter(e -> !SettlementTypeEnum.MONTH_SETTLEMENT.getCode().equals(e.getString("settlementtype"))).forEach(e -> {
                    tripApproveAmount[0] = tripApproveAmount[0].add(e.getBigDecimal("entryappamount"));
                });
                this.addValueToMap(travelers, tripApproveAmount[0], multipleTravers, singleTraver);
            }
        }
        multipleTravers.putAll(singleTraver);
        return multipleTravers;
    }

    private void addValueToMap(DynamicObjectCollection travelers, BigDecimal tripApproveAmount, Map<Long, BigDecimal> multipleTravers, Map<Long, BigDecimal> singleTraver) {
        if (travelers.size() > 1) {
            Map<Long, BigDecimal> tripNoAmountMap = travelers.stream().filter(Objects::nonNull).map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toMap(e -> e, e -> BigDecimal.ZERO, (e1, e2) -> e1));
            multipleTravers.putAll(tripNoAmountMap);
        } else {
            Long traverId = travelers.isEmpty() ? (Long)applier.getPkValue() : Long.valueOf(((DynamicObject)travelers.get(0)).getLong("fbasedataid_id"));
            if (singleTraver.get(traverId) != null) {
                singleTraver.put(traverId, singleTraver.get(traverId).add(tripApproveAmount));
            } else {
                singleTraver.put(traverId, tripApproveAmount);
            }
        }
    }
}

