/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.handler;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.handler.MultiAccountEntryHandler;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;

public class TripReqMultiAccountEntryMobHandler
extends MultiAccountEntryHandler {
    @Override
    public void generateAccountEntry(IFormView view) {
        ACC_ENTRY_NAME = "accountentry";
        applier = (DynamicObject)view.getModel().getValue("applier");
        this.clearAccountEntry(view.getModel());
        this.createAccountEntry(view);
    }

    protected void createAccountEntry(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection tripEntry = dataEntity.getDynamicObjectCollection("tripentry");
        HashSet<Long> idSet = new HashSet<Long>();
        HashSet<Long> errIdSet = new HashSet<Long>();
        for (DynamicObject entry : tripEntry) {
            DynamicObjectCollection travelers = entry.getDynamicObjectCollection("travelers");
            for (DynamicObject traveler : travelers) {
                idSet.add(ErCommonUtils.getPk(traveler.getDynamicObject("fbasedataid")));
            }
        }
        idSet.remove(null);
        for (Long travelerId : idSet) {
            List<DynamicObject> defaultAccounts = PayeeServiceHelper.getOtherDefaultAccountByPayerID(travelerId, null, false);
            if (defaultAccounts == null || defaultAccounts.isEmpty()) {
                errIdSet.add(travelerId);
                continue;
            }
            DynamicObject defaultAccount = defaultAccounts.get(0);
            if (null == defaultAccount) {
                errIdSet.add(travelerId);
                continue;
            }
            int rowIndex = model.createNewEntryRow("accountentry");
            CoreBaseBillServiceHelper.fillAccountEntry(model, rowIndex, defaultAccount);
            Map<String, Object> currencyMap = AmountChangeUtil.getCurrencyPayerAndParam(model, rowIndex, travelerId);
            model.setValue("accountcurrency", currencyMap.get("currencyId"), rowIndex);
            model.setValue("accexchangerate", currencyMap.get("exchangeRate"), rowIndex);
            model.setValue("receiveamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("orireceiveamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("accnotpayamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("oriaccnotpayamount", (Object)BigDecimal.ZERO, rowIndex);
        }
        int entryRowCount = model.getEntryRowCount("accountentry");
        if (entryRowCount == 1) {
            Object value = model.getValue("amount");
            model.beginInit();
            model.setValue("amount", (Object)BigDecimal.ZERO);
            model.endInit();
            model.setValue("amount", value);
        }
        this.showErrorConfirm(errIdSet, view);
    }

    protected void showErrorConfirm(Set<Long> reimburseIds, IFormView view) {
        Map userArray;
        if (!reimburseIds.isEmpty() && (userArray = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", reimburseIds)})) != null && !userArray.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : userArray.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                builder.append(dynamicObject.getLocaleString("name").getLocaleValue()).append('\uff0c');
            }
            builder.deleteCharAt(builder.lastIndexOf("\uff0c"));
            view.showConfirm(String.format(ResManager.loadKDString((String)"%s\u672a\u81ea\u52a8\u4ea7\u751f\u6536\u6b3e\u4fe1\u606f\uff0c\u8bf7\u624b\u5de5\u6dfb\u52a0\u3002", (String)"MultiTripReimburserPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), builder), MessageBoxOptions.OK);
        }
    }
}

