/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.image;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleUtil;
import kd.fi.er.business.utils.AttachmentUtils;
import kd.fi.er.business.utils.ErAIUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ImageUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class ImageServiceHelper {
    private static final Log log = LogFactory.getLog(ImageServiceHelper.class);

    public static byte[] createSinglePdf(String pageId, String formId, String templateFormId, Object pkId) {
        String tplId = MetadataDao.getIdByNumber((String)templateFormId, (MetaCategory)MetaCategory.Form);
        log.info(String.format("\u521b\u5efa\u5355\u636e\u5c01\u9762pdf, pageId : %s, formId: %s, templateFormId: %s, tplId: %s", pageId, formId, templateFormId, tplId));
        byte[] result = null;
        if (!StringUtils.isBlank((CharSequence)tplId)) {
            result = PrintServiceHelper.createSinglePdf((String)pageId, (String)formId, (String)templateFormId, (Object)pkId);
        } else {
            PrintWork printWork = new PrintWork();
            printWork.setPrintLang(ResManager.getLanguage());
            printWork.setExpType("1");
            printWork.setPageId(pageId);
            PrintTask printTask = new PrintTask();
            tplId = BosPrintServiceHelper.getTplIdByNum((String)templateFormId);
            log.debug("\u521b\u5efa\u5355\u636e\u5c01\u9762\u7684pdf\uff0c\u65b0\u6a21\u677fid\uff1a" + tplId);
            printTask.setTplId(tplId);
            printTask.setPkIds(Collections.singletonList(pkId));
            printWork.setTaskList(Collections.singletonList(printTask));
            PrtAttach attach = BosPrintServiceHelper.execPrint((PrintWork)printWork);
            List attachDetails = attach.getAttachDetail();
            log.info("\u521b\u5efa\u5355\u636e\u5c01\u9762\u7684pdf\uff0cexecPrint \u8fd4\u56de\u9644\u4ef6\u8be6\u60c5\u6570\u636e\uff1a" + JSON.toJSONString((Object)attachDetails));
            if (!CollectionUtils.isEmpty((Collection)attachDetails)) {
                PrtAttach.AttachDetail attachDetail = (PrtAttach.AttachDetail)attachDetails.get(0);
                InputStream inputStream = BosPrintServiceHelper.getFileInputStream((String)attachDetail.getFilePath());
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[16384];
                try {
                    int nRead;
                    while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                        buffer.write(data, 0, nRead);
                    }
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
                result = buffer.toByteArray();
            }
        }
        log.info("\u521b\u5efa\u5355\u636e\u5c01\u9762\u7684pdf\u6570\u636e\uff1a" + (result == null ? 0 : result.length));
        return result == null ? new byte[]{} : result;
    }

    public static String getConfigedPrintTplFormNumber(String mainEntityId, Long userOrgId) {
        return ImageServiceHelper.getConfigedPrintTplFormNumber(null, mainEntityId, userOrgId);
    }

    public static String getConfigedPrintTplFormNumber(DynamicObject bill, String mainEntityId, Long userOrgId) {
        DynamicObject orgViewDO;
        Map imageTplMap;
        Long id = ErCommonUtils.getPk(bill);
        log.info("\u83b7\u53d6\u5f71\u50cf\u6a21\u7248, id: {}\uff0c mainEntityId: {}", (Object)id, (Object)mainEntityId);
        QFilter baseDataQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_image_tpl", (Long)userOrgId);
        QFilter mainQFilter = QFilter.of((String)"print_tpl_entry.entitymeta.id=? and enable = '1'", (Object[])new Object[]{mainEntityId});
        log.info("baseDataQFilter: " + baseDataQFilter + ", mainQFilter: " + mainQFilter + ", mainEntityId: " + mainEntityId + ", userOrgId:" + userOrgId);
        if (baseDataQFilter != null) {
            mainQFilter.and(baseDataQFilter);
        }
        if ((imageTplMap = BusinessDataServiceHelper.loadFromCache((String)"er_image_tpl", (QFilter[])new QFilter[]{mainQFilter})) == null || imageTplMap.isEmpty()) {
            return null;
        }
        log.info("imageTplMap: " + imageTplMap.keySet());
        HashMap createOrgIdMappingTplFormNumber = Maps.newHashMapWithExpectedSize((int)imageTplMap.size());
        HashMap imageMapWithCondtion = Maps.newHashMapWithExpectedSize((int)imageTplMap.size());
        imageTplMap.values().forEach(tpl -> {
            List imageListWithCondtion;
            Long createOrgId = (Long)tpl.getDynamicObject("createorg").getPkValue();
            List tplFormNumbers = (List)createOrgIdMappingTplFormNumber.get(createOrgId);
            if (tplFormNumbers == null) {
                tplFormNumbers = Lists.newArrayList();
            }
            if ((imageListWithCondtion = (List)imageMapWithCondtion.get(createOrgId)) == null) {
                imageListWithCondtion = Lists.newArrayList();
            }
            DynamicObjectCollection printTplEntryDOs = tpl.getDynamicObjectCollection("print_tpl_entry");
            List printTplEntryOpt = printTplEntryDOs.stream().filter(entry -> Objects.equals(entry.getDynamicObject("entitymeta").getPkValue(), mainEntityId)).collect(Collectors.toList());
            for (DynamicObject d : printTplEntryOpt) {
                DynamicObject printTpl = d.getDynamicObject("printtpl");
                String tplFormNumber = printTpl != null ? printTpl.getString("number") : "";
                String con = d.getString("conditionjs_tag");
                if (StringUtils.isNotEmpty((CharSequence)con) && id != null && id.compareTo(0L) > 0) {
                    if (!BillSettingRuleUtil.matchByCondition(bill, d)) continue;
                    imageListWithCondtion.add(tplFormNumber);
                    break;
                }
                tplFormNumbers.add(tplFormNumber);
            }
            if (tplFormNumbers.size() != 0) {
                createOrgIdMappingTplFormNumber.put(userOrgId, tplFormNumbers);
            }
            if (imageListWithCondtion.size() > 0) {
                imageMapWithCondtion.put(createOrgId, imageListWithCondtion);
            }
        });
        String orgViewType = "01";
        DynamicObject ctlStrategyDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bddefctrlstrtgy", (QFilter[])new QFilter[]{new QFilter("basedataid.id", "=", (Object)"er_image_tpl")});
        if (ctlStrategyDO != null && (orgViewDO = ctlStrategyDO.getDynamicObject("ctrlview")) != null) {
            orgViewType = orgViewDO.getString("treetype");
        }
        List superOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgViewType, (long)userOrgId);
        superOrgIds.add(userOrgId);
        String imageTplFormNumber = null;
        imageTplFormNumber = imageMapWithCondtion.size() > 0 ? ImageServiceHelper.getImageByOrg(imageMapWithCondtion, superOrgIds) : ImageServiceHelper.getImageByOrg(createOrgIdMappingTplFormNumber, superOrgIds);
        return imageTplFormNumber;
    }

    private static String getImageByOrg(Map<Long, List<String>> createOrgIdMappingTplFormNumber, List<Long> superOrgIds) {
        if (createOrgIdMappingTplFormNumber.size() == 0) {
            return null;
        }
        Long nearbyOrgId = createOrgIdMappingTplFormNumber.keySet().iterator().next();
        for (int i = superOrgIds.size() - 1; i >= 0; --i) {
            Long superOrgId = superOrgIds.get(i);
            if (!createOrgIdMappingTplFormNumber.containsKey(superOrgId)) continue;
            nearbyOrgId = superOrgId;
            break;
        }
        if (CollectionUtils.isEmpty((Collection)createOrgIdMappingTplFormNumber.get(nearbyOrgId))) {
            return null;
        }
        log.info("\u5339\u914d\u5230\u7684\u5f71\u50cf\u6a21\u7248\uff1a {}, {}", (Object)nearbyOrgId, (Object)SerializationUtils.toJsonString(createOrgIdMappingTplFormNumber.get(nearbyOrgId)));
        String imageTplFormNumber = createOrgIdMappingTplFormNumber.get(nearbyOrgId).get(0);
        return imageTplFormNumber;
    }

    public static String getImageNumber(String entityName, Long billId) {
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setBillId(String.valueOf(billId));
        imageInfo.setBilltype(entityName);
        ImageInfo result = kd.bos.servicehelper.image.ImageServiceHelper.getImageInfoInside((ImageInfo)imageInfo);
        String re = result == null ? "" : result.getImageNo();
        log.info(String.format("getImageNumber param:%1$s,%2$s;\u5f71\u50cf\u7f16\u7801:%3$s", entityName, billId, re));
        return re;
    }

    public static String convertBase64Str(byte[] bytes) {
        byte[] encode = Base64.getEncoder().encode(bytes);
        return new String(encode);
    }

    public static void writePdfToDisk(String path, byte[] bytes) {
        File file = new File(path);
        if (!file.exists()) {
            try {
                boolean createNewFile = file.createNewFile();
                if (!createNewFile) {
                    log.info(String.format("path:%s ,failed to create file", path));
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        try (FileOutputStream output = new FileOutputStream(file);){
            output.write(bytes);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    public static String upload(DynamicObject planebill, Boolean isweb) {
        String message;
        QFilter qFilter = new QFilter("tripentry.entryentity.ordernum", "=", (Object)planebill.getString("ordernum"));
        DynamicObject reimbursebill = QueryServiceHelper.queryOne((String)"er_tripreimbursebill", (String)"id,billno,creator", (QFilter[])new QFilter[]{qFilter});
        if (null == reimbursebill) {
            log.info("\u8ba2\u5355\uff1a{} \u5f71\u50cf\u4fe1\u606f\u4e0a\u4f20\u5dee\u65c5\u62a5\u9500\u5355\u9644\u4ef6\u8ba2\u5355\u4e0d\u5b58\u5728\u5173\u8054\u7684\u5dee\u65c5\u62a5\u9500\u5355\u3002", (Object)planebill.getString("ordernum"));
            String message2 = ResManager.loadKDString((String)"\u8ba2\u5355\u5f71\u50cf\u4fe1\u606f\u4e0a\u4f20\u5dee\u65c5\u62a5\u9500\u5355\u9644\u4ef6\u4e0d\u5b58\u5728\u5173\u8054\u7684\u5dee\u65c5\u62a5\u9500\u5355\u3002", (String)"ImageServiceHelper_5", (String)"fi-er-business", (Object[])new Object[0]);
            return message2;
        }
        IFormView view = ErAIUtils.getView("er_tripreimbursebill");
        IDataModel model = ErAIUtils.getModel(view, reimbursebill.getLong("id"));
        try {
            Map<String, String> result = AttachmentUtils.upload(view, model, planebill, isweb);
            message = result.get("message");
        }
        catch (Exception e) {
            log.info("\u8ba2\u5355\uff1a{}\u5f71\u50cf\u4fe1\u606f\u4e0a\u4f20\u5dee\u65c5\u62a5\u9500\u5355\u9644\u4ef6\u5f02\u5e38\uff1a{},{}", new Object[]{planebill.getString("ordernum"), reimbursebill.getString("billno"), e.getMessage()});
            String message3 = ResManager.loadKDString((String)"\u8ba2\u5355\u5f71\u50cf\u4fe1\u606f\u4e0a\u4f20\u5dee\u65c5\u62a5\u9500\u5355\u9644\u4ef6\u5f02\u5e38\u3002", (String)"ImageServiceHelper_6", (String)"fi-er-business", (Object[])new Object[0]);
            return message3;
        }
        if (null != message && !message.trim().isEmpty()) {
            return message;
        }
        if (null != (planebill = BusinessDataServiceHelper.loadSingle((Object)planebill.getLong("id"), (String)"er_planebill"))) {
            planebill.set("isattachment", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{planebill});
        }
        return message;
    }

    public static String syncImageToInvoiceCloud(DynamicObject planebill) {
        String message = "";
        QFilter qFilter = new QFilter("billno", "=", (Object)planebill.getString("reimbursenum"));
        DynamicObject reimbursebill = QueryServiceHelper.queryOne((String)"er_tripreimbursebill", (String)"id,billno,creator,costcompany", (QFilter[])new QFilter[]{qFilter});
        String ordernum = planebill.getString("ordernum");
        if (null == reimbursebill) {
            log.info("\u8ba2\u5355\uff1a{} \u5f71\u50cf\u4fe1\u606f\u63a8\u9001\u53d1\u7968\u4e91\u8ba2\u5355\u4e0d\u5b58\u5728\u5173\u8054\u7684\u5dee\u65c5\u62a5\u9500\u5355\u3002", (Object)ordernum);
            message = ResManager.loadKDString((String)"\u8ba2\u5355\u5f71\u50cf\u4fe1\u606f\u63a8\u9001\u53d1\u7968\u4e91\u8ba2\u5355\u4e0d\u5b58\u5728\u5173\u8054\u7684\u5dee\u65c5\u62a5\u9500\u5355\u3002", (String)"ImageServiceHelper_7", (String)"fi-er-business", (Object[])new Object[0]);
            return message;
        }
        String serialNo = "";
        try {
            serialNo = ImageUtils.pushInvoiceCloud(planebill, reimbursebill.getLong("costcompany"), reimbursebill.getLong("id"));
        }
        catch (Exception e) {
            log.info("\u8ba2\u5355\uff1a{}\u5f71\u50cf\u4fe1\u606f\u63a8\u9001\u53d1\u7968\u4e91\u5f02\u5e38\uff1a{},{}", new Object[]{ordernum, reimbursebill.getString("billno"), e.getMessage()});
            message = ResManager.loadKDString((String)"\u8ba2\u5355\u5f71\u50cf\u4fe1\u606f\u63a8\u9001\u53d1\u7968\u4e91\u5f02\u5e38\u3002", (String)"ImageServiceHelper_8", (String)"fi-er-business", (Object[])new Object[0]);
            return message;
        }
        IFormView view = ErAIUtils.getView("er_tripreimbursebill");
        IDataModel model = ErAIUtils.getModel(view, reimbursebill.getLong("id"));
        planebill = BusinessDataServiceHelper.loadSingle((Object)planebill.getLong("id"), (String)"er_planebill");
        if (reimbursebill != null && planebill != null) {
            DynamicObjectCollection invoiceentries = model.getEntryEntity("invoiceentry");
            log.info("\u8ba2\u5355\u5f71\u50cf\u4fe1\u606f\u63a8\u9001\u53d1\u7968\u4e91serialno\u4e3a\uff1a" + serialNo + "  --invoiceentrySize" + invoiceentries.size());
            if (StringUtils.isBlank((CharSequence)serialNo)) {
                message = ResManager.loadKDString((String)"\u8ba2\u5355\u5f71\u50cf\u4fe1\u606f\u63a8\u9001\u53d1\u7968\u4e91\u540e\u8fd4\u56de\u7684\u53d1\u7968\u5e8f\u5217\u53f7\u4e3a\u7a7a\u3002", (String)"ImageServiceHelper_9", (String)"fi-er-business", (Object[])new Object[0]);
                return message;
            }
            for (DynamicObject invoiceentry : invoiceentries) {
                if (!StringUtils.equals((CharSequence)invoiceentry.getString("invoiceno"), (CharSequence)planebill.getString("ticketnum")) && (!StringUtils.equals((CharSequence)invoiceentry.getString("invoiceordernum"), (CharSequence)ordernum) || !StringUtils.equals((CharSequence)invoiceentry.getString("ordertype"), (CharSequence)planebill.getString("ordertype")))) continue;
                invoiceentry.set("serialno", (Object)serialNo);
                boolean isallUpload = invoiceentries.stream().anyMatch(v -> StringUtils.isBlank((CharSequence)v.getString("serialno")));
                if (!isallUpload) {
                    model.setValue("receiveimagetime", (Object)new Date());
                }
                Long pkValue = ErCommonUtils.getPk(invoiceentry.getPkValue());
                boolean isCreate = model.getDataEntity(true).getDynamicObjectCollection("invoiceitementry").stream().allMatch(v -> StringUtils.equals((CharSequence)v.getString("invoiceheadentryid"), (CharSequence)pkValue.toString()));
                if (isCreate) continue;
                int index = model.createNewEntryRow("invoiceitementry");
                model.setValue("invoiceheadentryid", invoiceentry.getPkValue(), index);
            }
            OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)"er_tripreimbursebill", (DynamicObject[])new DynamicObject[]{model.getDataEntity(true)}, (OperateOption)OperateOption.create());
            if (save.isSuccess() && invoiceentries.size() > 0) {
                planebill.set("ispushinvoicecloud", (Object)"1");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{planebill});
                return null;
            }
            if (!save.isSuccess()) {
                log.error("\u8ba2\u5355\uff1a{}\u5f71\u50cf\u4fe1\u606f\u63a8\u9001\u53d1\u7968\u4e91\u5f02\u5e38\uff0c\u4fdd\u5b58\u5931\u8d25" + model.getValue("billno") + save.getMessage());
                message = ResManager.loadKDString((String)"\u8ba2\u5355\u5f71\u50cf\u4fe1\u606f\u5df2\u63a8\u9001\u81f3\u53d1\u7968\u4e91\uff0c\u4f46\u5dee\u65c5\u62a5\u9500\u5355\u4fdd\u5b58\u5931\u8d25\u3002", (String)"ImageServiceHelper_10", (String)"fi-er-business", (Object[])new Object[0]);
                return message;
            }
        }
        log.info("\u8ba2\u5355\uff1a{}\u5f71\u50cf\u4fe1\u606f\u63a8\u9001\u53d1\u7968\u4e91\u5f02\u5e38\uff0c\u8ba2\u5355\u6216\u62a5\u9500\u5355\u4e0d\u5b58\u5728{}", (Object)ordernum, (Object)reimbursebill.getString("billno"));
        message = ResManager.loadKDString((String)"\u8ba2\u5355\u5f71\u50cf\u4fe1\u606f\u63a8\u9001\u53d1\u7968\u4e91\u5f02\u5e38\u3002", (String)"ImageServiceHelper_8", (String)"fi-er-business", (Object[])new Object[0]);
        return message;
    }
}

