/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.dap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.invoicecloud.dap.SendVoucherMsgUtil;
import kd.fi.er.business.utils.ErStdConfig;

public class CasBillWriteBackInvoicePool {
    private static Log logger = LogFactory.getLog(CasBillWriteBackInvoicePool.class);

    public static void execute(Map<Object, Object> params) {
        new CasBillWriteBackInvoicePool()._execute(params);
    }

    private void _execute(Map<Object, Object> params) {
        if (!ErStdConfig.getBoolean("invoicecloud.saveDownstreamVoucher")) {
            logger.info("crossBillDapWriteBack \u4fdd\u5b58\u4e0b\u6e38\u51ed\u8bc1\u53c2\u6570\u672a\u5f00\u542f\u3002");
            return;
        }
        logger.info("crossBillDapWriteBack params: " + SerializationUtils.toJsonString(params));
        VoucherOperation operation = (VoucherOperation)params.get("operation");
        String billEntityNumber = (String)params.get("billEntityNumber");
        Map billToVch = (Map)params.get("billToVch");
        Set casBillIds = billToVch.keySet();
        List linkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)billEntityNumber, (Long[])casBillIds.toArray(new Long[0]), null);
        logger.info("\u4e0a\u6e38\u4e2a\u6570\uff1a" + linkUpNodes.size());
        HashMap<String, Map<Long, List<Voucher>>> entity_erBillToVch = new HashMap<String, Map<Long, List<Voucher>>>(linkUpNodes.size());
        this.handleUpReimBill(entity_erBillToVch, linkUpNodes, billToVch);
        this.handleUpCheckPayBill(entity_erBillToVch, linkUpNodes, billToVch);
        this.handleUpApplyPayBill(entity_erBillToVch, linkUpNodes, billToVch);
        for (Map.Entry mapEntry : entity_erBillToVch.entrySet()) {
            String _billEntityNumber = (String)mapEntry.getKey();
            Map _billToVch = (Map)mapEntry.getValue();
            SendVoucherMsgUtil.sendVoucherMsg(operation.getValue(), _billEntityNumber, _billToVch);
        }
    }

    private void handleUpApplyPayBill(Map<String, Map<Long, List<Voucher>>> entity_erBillToVch, List<BFRowLinkUpNode> linkUpNodes, Map<Long, Voucher> billToVch) {
        Long applyPayTableId = EntityMetadataCache.loadTableDefine((String)"er_applypaybill", (String)"er_applypaybill").getTableId();
        TableDefine pubTableDefine = EntityMetadataCache.loadTableDefine((String)"er_publicreimbursebill", (String)"er_publicreimbursebill");
        HashSet<Long> applyPayBillIds = new HashSet<Long>(linkUpNodes.size());
        for (BFRowLinkUpNode linkUpNode : linkUpNodes) {
            Map sNodes = linkUpNode.getSNodes();
            if (sNodes == null || sNodes.isEmpty()) continue;
            BFRowId next = (BFRowId)sNodes.keySet().iterator().next();
            Long srcBillId = next.getBillId();
            Long srcMainTableId = next.getMainTableId();
            if (Long.compare(applyPayTableId, srcMainTableId) != 0) continue;
            applyPayBillIds.add(srcBillId);
        }
        List applyPayLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)"er_applypaybill", (Long[])applyPayBillIds.toArray(new Long[0]), null);
        HashMap<Long, Long> payBillMap = new HashMap<Long, Long>();
        for (BFRowLinkUpNode linkUpNode : applyPayLinkUpNodes) {
            Long billId = linkUpNode.getRowId().getBillId();
            Map sNodes = linkUpNode.getSNodes();
            if (sNodes == null || sNodes.isEmpty()) continue;
            BFRowId next = (BFRowId)sNodes.keySet().iterator().next();
            Long srcBillId = next.getBillId();
            Long srcMainTableId = next.getMainTableId();
            if (Long.compare(pubTableDefine.getTableId(), srcMainTableId) != 0) continue;
            payBillMap.put(billId, srcBillId);
        }
        for (BFRowLinkUpNode linkUpNode : linkUpNodes) {
            Long publicReimBillId;
            Map sNodes = linkUpNode.getSNodes();
            if (sNodes == null || sNodes.isEmpty()) continue;
            BFRowId next = (BFRowId)sNodes.keySet().iterator().next();
            Long srcBillId = next.getBillId();
            Long srcMainTableId = next.getMainTableId();
            if (Long.compare(applyPayTableId, srcMainTableId) != 0 || (publicReimBillId = (Long)payBillMap.get(srcBillId)) == null) continue;
            List<Voucher> voucherLst = this.getVoucherLst(entity_erBillToVch, "er_publicreimbursebill", publicReimBillId);
            Long casBillId = linkUpNode.getRowId().getBillId();
            voucherLst.add(billToVch.get(casBillId));
        }
    }

    private void handleUpCheckPayBill(Map<String, Map<Long, List<Voucher>>> entity_erBillToVch, List<BFRowLinkUpNode> linkUpNodes, Map<Long, Voucher> billToVch) {
        Long erCheckTableId = EntityMetadataCache.loadTableDefine((String)"er_checkingpaybill", (String)"er_checkingpaybill").getTableId();
        for (BFRowLinkUpNode linkUpNode : linkUpNodes) {
            Map sNodes = linkUpNode.getSNodes();
            if (sNodes == null || sNodes.isEmpty()) continue;
            BFRowId next = (BFRowId)sNodes.keySet().iterator().next();
            Long srcBillId = next.getBillId();
            Long srcMainTableId = next.getMainTableId();
            if (Long.compare(erCheckTableId, srcMainTableId) != 0) continue;
            List<Voucher> voucherLst = this.getVoucherLst(entity_erBillToVch, "er_checkingpaybill", srcBillId);
            Long casBillId = linkUpNode.getRowId().getBillId();
            voucherLst.add(billToVch.get(casBillId));
        }
    }

    private void handlePayUpReimBill_step2(Map<String, Map<Long, List<Voucher>>> entity_erBillToVch, Map<Long, Object[]> payReqBillMap, Long erApplyPayTableId, List<BFRowLinkUpNode> linkUpNodes, Map<Long, Voucher> billToVch) {
        for (BFRowLinkUpNode linkUpNode : linkUpNodes) {
            Object[] checkPay;
            Map sNodes = linkUpNode.getSNodes();
            if (sNodes == null || sNodes.isEmpty()) continue;
            BFRowId next = (BFRowId)sNodes.keySet().iterator().next();
            String erBillEntityName = null;
            Long srcBillId = next.getBillId();
            Long srcMainTableId = next.getMainTableId();
            if (Long.compare(erApplyPayTableId, srcMainTableId) != 0 || (checkPay = payReqBillMap.get(srcBillId)) == null) continue;
            Voucher voucher = (Voucher)checkPay[0];
            erBillEntityName = (String)checkPay[1];
            srcBillId = (Long)checkPay[2];
            List<Voucher> voucherLst = this.getVoucherLst(entity_erBillToVch, erBillEntityName, srcBillId);
            Long casBillId = linkUpNode.getRowId().getBillId();
            voucherLst.add(billToVch.get(casBillId));
            if (voucher == null) continue;
            voucherLst.add(voucher);
        }
    }

    private Map<Long, Object[]> handlePayUpReimBill_step1(TableDefine pubTableDefine, Map<Object, Object> billIdVoucherId, List<BFRowLinkUpNode> applyPayLinkUpNodes) {
        HashMap<Long, Object[]> payBillMap = new HashMap<Long, Object[]>();
        for (BFRowLinkUpNode linkUpNode : applyPayLinkUpNodes) {
            Map sNodes;
            Long billId = linkUpNode.getRowId().getBillId();
            Object voucherId = billIdVoucherId.get(billId);
            if (voucherId == null || (sNodes = linkUpNode.getSNodes()) == null || sNodes.isEmpty()) continue;
            BFRowId next = (BFRowId)sNodes.keySet().iterator().next();
            Long srcBillId = next.getBillId();
            Long srcMainTableId = next.getMainTableId();
            if (Long.compare(pubTableDefine.getTableId(), srcMainTableId) != 0) continue;
            Voucher voucher = new Voucher();
            voucher.setId(((Long)voucherId).longValue());
            payBillMap.put(billId, new Object[]{voucher, pubTableDefine.getEntityNumber(), srcBillId});
        }
        return payBillMap;
    }

    private void handleUpReimBill(Map<String, Map<Long, List<Voucher>>> entity_erBillToVch, List<BFRowLinkUpNode> linkUpNodes, Map<Long, Voucher> billToVch) {
        List<String> erEntityNumbers = Arrays.asList("er_tripreimbursebill", "er_dailyreimbursebill", "er_publicreimbursebill");
        List erReimTableDefines = erEntityNumbers.stream().map(v -> EntityMetadataCache.loadTableDefine((String)v, (String)v)).collect(Collectors.toList());
        for (BFRowLinkUpNode linkUpNode : linkUpNodes) {
            Map sNodes = linkUpNode.getSNodes();
            if (sNodes == null || sNodes.isEmpty()) continue;
            BFRowId next = (BFRowId)sNodes.keySet().iterator().next();
            String erBillEntityName = null;
            Long srcBillId = next.getBillId();
            Long srcMainTableId = next.getMainTableId();
            for (TableDefine erTableDefine : erReimTableDefines) {
                if (Long.compare(erTableDefine.getTableId(), srcMainTableId) != 0) continue;
                erBillEntityName = erTableDefine.getEntityNumber();
                break;
            }
            if (erBillEntityName == null) continue;
            List<Voucher> voucherLst = this.getVoucherLst(entity_erBillToVch, erBillEntityName, srcBillId);
            Long casBillId = linkUpNode.getRowId().getBillId();
            voucherLst.add(billToVch.get(casBillId));
        }
    }

    private List<Voucher> getVoucherLst(Map<String, Map<Long, List<Voucher>>> entity_erBillToVch, String entityName, Long billId) {
        List<Voucher> voucherLst;
        Map<Long, List<Voucher>> erBillToVch = entity_erBillToVch.get(entityName);
        if (erBillToVch == null) {
            erBillToVch = new HashMap<Long, List<Voucher>>();
            entity_erBillToVch.put(entityName, erBillToVch);
        }
        if ((voucherLst = erBillToVch.get(billId)) == null) {
            voucherLst = new ArrayList<Voucher>();
            erBillToVch.put(billId, voucherLst);
        }
        return voucherLst;
    }
}

