/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.invoicepackage;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.invoicepackage.quickreimservice.AbstractQuickReimburseService;
import kd.fi.er.business.invoicecloud.invoicepackage.quickreimservice.DefaultQuickReimService;
import kd.fi.er.common.model.invoice.QuickConfigBo;
import kd.fi.er.common.utils.InvoiceCloudUtil;
import org.apache.commons.lang3.StringUtils;

public class QuickReimServiceFactory {
    private static final Log log = LogFactory.getLog(QuickReimServiceFactory.class);

    public AbstractQuickReimburseService getQuickReimburseService(QuickConfigBo quickConfig, IFormView view) {
        try {
            if ("0".equals(quickConfig.getOperation().getClientType())) {
                return this.getQuickReimburseServiceMob(quickConfig);
            }
            if ("1".equals(quickConfig.getOperation().getClientType())) {
                return this.getQuickReimburseServicePc(quickConfig);
            }
        }
        catch (Exception e) {
            String error = ResManager.loadKDString((String)"\u3010\u4e00\u952e\u62a5\u9500\u3011\u83b7\u53d6\u62a5\u9500\u6d41\u7a0b\u670d\u52a1\u5f02\u5e38:", (String)"QuickReimServiceFactory_0", (String)"fi-er-business", (Object[])new Object[0]);
            log.error(error, (Throwable)e);
            view.showErrorNotification(error + e.getMessage());
        }
        return null;
    }

    public AbstractQuickReimburseService getQuickReimburseService(DynamicObject quickConfig, IFormView view) {
        QuickConfigBo config = InvoiceCloudUtil.buildQuickConfigBo((DynamicObject)quickConfig);
        try {
            if ("0".equals(config.getOperation().getClientType())) {
                return this.getQuickReimburseServiceMob(config);
            }
            if ("1".equals(config.getOperation().getClientType())) {
                return this.getQuickReimburseServicePc(config);
            }
        }
        catch (Exception e) {
            String error = ResManager.loadKDString((String)"\u3010\u4e00\u952e\u62a5\u9500\u3011\u83b7\u53d6\u62a5\u9500\u6d41\u7a0b\u670d\u52a1\u5f02\u5e38:", (String)"QuickReimServiceFactory_0", (String)"fi-er-business", (Object[])new Object[0]);
            log.error(error, (Throwable)e);
            view.showErrorNotification(error + e.getMessage());
        }
        return null;
    }

    private AbstractQuickReimburseService getQuickReimburseServicePc(QuickConfigBo config) {
        return null;
    }

    private AbstractQuickReimburseService getQuickReimburseServiceMob(QuickConfigBo config) throws Exception {
        Class<?> quickReimService;
        AbstractQuickReimburseService service;
        String classname;
        QFilter enable;
        QFilter billType;
        QFilter clientType;
        QFilter formId = new QFilter("formid", "=", (Object)config.getSrcFormId());
        DynamicObject serviceConfig = BusinessDataServiceHelper.loadSingle((String)"er_reimservicepg", (String)"id,number,name,clienttype,classname", (QFilter[])new QFilter[]{formId, clientType = new QFilter("clienttype", "=", (Object)"0"), billType = new QFilter("billgroup", "=", (Object)config.getGroup()), enable = new QFilter("enable", "=", (Object)"1")});
        if (serviceConfig != null && StringUtils.isNotEmpty((CharSequence)(classname = serviceConfig.getString("classname"))) && (service = (AbstractQuickReimburseService)(quickReimService = Class.forName(classname)).newInstance()) != null) {
            service.setConfig(config);
            return service;
        }
        log.info("\u3010\u4e00\u952e\u62a5\u9500\u3011\u79fb\u52a8\u7aef\u672a\u52a0\u8f7d\u5230\u6d41\u7a0b\u670d\u52a1\u3002" + config.getNumber());
        service = new DefaultQuickReimService();
        service.setConfig(config);
        return service;
    }
}

