/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.kingdee;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.invoicecloud.cache.model.ErCacheUtils;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceTitleTax;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

enum InvoiceConfigPattern {
    orgPattern{

        @Override
        InvoiceCloudCfgBO getConfig(Long invoiceOrgId) {
            String key = String.format("kd.fi.er.business.invoicecloud.kingdee.InvoiceConfigPattern.orgPattern.{...}.getConfig(Long),%s", invoiceOrgId);
            Object value = null;
            if (ThreadCache.exists((Object)key)) {
                value = ThreadCache.get((Object)key);
                if (value == NULL_OBJECT) {
                    value = null;
                }
            } else {
                value = this._getConfig(invoiceOrgId);
                if (value == null) {
                    ThreadCache.put((Object)key, (Object)NULL_OBJECT);
                } else {
                    ThreadCache.put((Object)key, (Object)value);
                }
            }
            return (InvoiceCloudCfgBO)value;
        }

        private InvoiceCloudCfgBO _getConfig(Long invoiceOrgId) {
            QFilter[] filters = new QFilter[]{new QFilter("org.id", "=", (Object)invoiceOrgId), new QFilter("enable", "=", (Object)true)};
            DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)"er_bd_kdinvoicecloudcfg", (QFilter[])filters);
            if (config == null) {
                return null;
            }
            InvoiceCloudCfgBO invoiceCloudCfgBO = ErCacheUtils.transferInvoiceCfgDyoToInvoiceCloudCfgBO(config);
            long id = config.getLong("id");
            logger.info("\u83b7\u53d6\u7ec4\u7ec7\u6a21\u5f0f\u53d1\u7968\u4e91\u914d\u7f6eid: " + id);
            invoiceCloudCfgBO.setId(id);
            invoiceCloudCfgBO.setEntityName("er_bd_kdinvoicecloudcfg");
            invoiceCloudCfgBO.setInvoiceOrgId(invoiceOrgId);
            return invoiceCloudCfgBO;
        }

        @Override
        boolean existConfig() {
            Map configMap = BusinessDataServiceHelper.loadFromCache((String)"er_bd_kdinvoicecloudcfg", (QFilter[])new QFilter[0]);
            return configMap != null && configMap.size() > 0;
        }
    }
    ,
    groupPattern{

        @Override
        InvoiceCloudCfgBO getConfig(Long invoiceOrgId) {
            String key = String.format("kd.fi.er.business.invoicecloud.kingdee.InvoiceConfigPattern.groupPattern.{...}.getConfig(Long),%s", invoiceOrgId);
            Object value = null;
            if (ThreadCache.exists((Object)key)) {
                value = ThreadCache.get((Object)key);
                if (value == NULL_OBJECT) {
                    value = null;
                }
            } else {
                value = this._getConfig(invoiceOrgId);
                if (value == null) {
                    ThreadCache.put((Object)key, (Object)NULL_OBJECT);
                } else {
                    ThreadCache.put((Object)key, (Object)value);
                }
            }
            return (InvoiceCloudCfgBO)value;
        }

        private InvoiceCloudCfgBO _getConfig(Long invoiceOrgId) {
            QFilter enableQFilter;
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_bd_kdinvoicecloudcfgct", (Long)invoiceOrgId);
            Map configMap = BusinessDataServiceHelper.loadFromCache((String)"er_bd_kdinvoicecloudcfgct", (QFilter[])new QFilter[]{baseDataFilter, enableQFilter = new QFilter("enable", "=", (Object)true)});
            if (configMap == null || configMap.isEmpty()) {
                return null;
            }
            Collection configs = configMap.values();
            DynamicObject mainConfig = configs.stream().sorted((c1, c2) -> {
                Long createOrg1 = ErCommonUtils.getPk(c1.getDynamicObject("createorg"));
                Long createOrg2 = ErCommonUtils.getPk(c2.getDynamicObject("createorg"));
                if (Objects.equals(createOrg1, invoiceOrgId) && !Objects.equals(createOrg2, invoiceOrgId)) {
                    return -1;
                }
                if (Objects.equals(createOrg2, invoiceOrgId) && !Objects.equals(createOrg1, invoiceOrgId)) {
                    return 1;
                }
                String ctlStrategy1 = c1.getString("ctrlstrategy");
                String ctlStrategy2 = c2.getString("ctrlstrategy");
                if (StringUtils.equals((CharSequence)ctlStrategy1, (CharSequence)"7") && !StringUtils.equals((CharSequence)ctlStrategy2, (CharSequence)"7")) {
                    return -1;
                }
                if (StringUtils.equals((CharSequence)ctlStrategy2, (CharSequence)"7") && !StringUtils.equals((CharSequence)ctlStrategy1, (CharSequence)"7")) {
                    return 1;
                }
                Date modifyDate1 = c1.getDate("modifytime");
                Date modifyDate2 = c2.getDate("modifytime");
                return 2.dateCompare(modifyDate2, modifyDate1);
            }).findFirst().orElse(null);
            InvoiceCloudCfgBO invoiceCloudCfgBO = new InvoiceCloudCfgBO();
            long id = mainConfig.getLong("id");
            logger.info("\u83b7\u53d6\u96c6\u56e2\u6a21\u5f0f\u53d1\u7968\u4e91\u914d\u7f6eid: " + id);
            invoiceCloudCfgBO.setId(id);
            invoiceCloudCfgBO.setEntityName("er_bd_kdinvoicecloudcfgct");
            ErCacheUtils.initInvoiceCloudCfgBO(invoiceCloudCfgBO, mainConfig);
            invoiceCloudCfgBO.setInvoiceOrgId(invoiceOrgId);
            String taxRegNums = configs.stream().map(config -> (String)StringUtils.defaultIfBlank((CharSequence)config.getString("taxregnum"), (CharSequence)"")).collect(Collectors.joining("="));
            String firmnames = configs.stream().map(config -> (String)StringUtils.defaultIfBlank((CharSequence)config.getString("firmname").replaceAll("\\(", "\uff08").replaceAll("\\)", "\uff09"), (CharSequence)"")).collect(Collectors.joining("="));
            List<InvoiceTitleTax> titleTaxList = configs.stream().map(config -> new InvoiceTitleTax(config.getString("firmname").replaceAll("\\(", "\uff08").replaceAll("\\)", "\uff09"), config.getString("taxregnum"))).collect(Collectors.toList());
            invoiceCloudCfgBO.setTaxRegnum(taxRegNums);
            invoiceCloudCfgBO.setFirmname(firmnames);
            invoiceCloudCfgBO.setTitleTaxList(titleTaxList);
            return invoiceCloudCfgBO;
        }

        @Override
        boolean existConfig() {
            Map configMap = BusinessDataServiceHelper.loadFromCache((String)"er_bd_kdinvoicecloudcfgct", (QFilter[])new QFilter[0]);
            return configMap != null && configMap.size() > 0;
        }
    };

    private static final Log logger;
    private static final Object NULL_OBJECT;

    abstract InvoiceCloudCfgBO getConfig(Long var1);

    boolean existConfig() {
        return false;
    }

    static int dateCompare(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return 0;
        }
        if (d1 == null) {
            return -1;
        }
        if (d2 == null) {
            return 1;
        }
        return d1.compareTo(d2);
    }

    static {
        logger = LogFactory.getLog(InvoiceConfigPattern.class);
        NULL_OBJECT = new Object();
    }
}

