/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.kingdee;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.MapWrapper;
import kd.fi.er.business.invoicecloud.model.Invoice;
import kd.fi.er.business.invoicecloud.model.InvoiceItem;
import kd.fi.er.common.utils.Er;

public class InvoiceHelper {
    private static Log logger = LogFactory.getLog(InvoiceHelper.class);

    public static List<Invoice> convertToInvoiceLst(List<Map> rawInvoiceLst) {
        List rawWrapperLst = rawInvoiceLst.stream().map(v -> new MapWrapper((Map)v)).collect(Collectors.toList());
        List<Invoice> invoiceLst = rawWrapperLst.stream().map(InvoiceHelper::rawToInvoice).collect(Collectors.toList());
        invoiceLst.forEach(v -> v.clearFakeItem());
        return invoiceLst;
    }

    private static Invoice rawToInvoice(MapWrapper rawInvoice) {
        Invoice.Builder builder = new Invoice.Builder();
        builder.withInvoiceDate(rawInvoice.getString("invoiceDate")).withInvoiceCode(rawInvoice.getString("invoiceCode")).withInvoiceNo(rawInvoice.getString("invoiceNo")).withInvoiceType(rawInvoice.getString("invoiceType")).withSerialNo(rawInvoice.getString("serialNo")).withSalerName(rawInvoice.getString("salerName")).withRemark(rawInvoice.getString("remark"));
        if (rawInvoice.getBigDecimal("amount") == null) {
            builder.withAmount(rawInvoice.getBigDecimal("totalAmount"));
        } else {
            builder.withAmount(rawInvoice.getBigDecimal("amount"));
        }
        if (rawInvoice.getBigDecimal("taxAmount") == null) {
            builder.withTaxAmount(BigDecimal.ZERO);
        } else {
            builder.withTaxAmount(rawInvoice.getBigDecimal("taxAmount"));
        }
        builder.withTotalAmount(rawInvoice.getBigDecimal("totalAmount")).build();
        String trip = rawInvoice.getString("trip");
        if (trip != null) {
            builder.withTrip(trip.replaceAll(" - ", ","));
        }
        Invoice invoice = builder.build();
        List rawInvoiceItemLst = rawInvoice.getList("items");
        if (rawInvoiceItemLst != null) {
            rawInvoiceItemLst.stream().map(InvoiceHelper::rawToInvoiceItem).forEach(invoice::addItem);
        }
        return invoice;
    }

    private static InvoiceItem.Builder rawToInvoiceItem(Map rawInvoiceItem) {
        return new InvoiceItem.Builder().withDetailAmount(new BigDecimal(rawInvoiceItem.get("detailAmount").toString())).withTaxAmount(new BigDecimal(rawInvoiceItem.get("taxAmount").toString())).withTaxRate(new BigDecimal(rawInvoiceItem.get("taxRate").toString())).withGoodsCode(rawInvoiceItem.get("goodsCode").toString()).withGoodsName(rawInvoiceItem.get("goodsName").toString());
    }

    public static void handleNoItem(List<Invoice> invoiceLst) {
        for (Invoice invoice : invoiceLst) {
            if (invoice.getItems().size() != 0) continue;
            invoice.addItem(new InvoiceItem.Builder().withDetailAmount(invoice.getAmount()).withTaxAmount(invoice.getTaxAmount()).withTaxRate(invoice.getTaxRate()));
        }
    }

    public static Invoice merge(List<Invoice> invoices) {
        Map<Boolean, List<Invoice>> parti = invoices.stream().collect(Collectors.partitioningBy(v -> v.getInvoiceType().equals("8")));
        List<Invoice> taxiInvoices = parti.get(true);
        if (taxiInvoices.size() <= 1) {
            return null;
        }
        int count = taxiInvoices.size();
        Invoice firstTaxiInvoice = taxiInvoices.get(0);
        String invoiceNo = firstTaxiInvoice.getInvoiceNo() + (count == 1 ? "" : "...");
        Invoice.Builder builder = new Invoice.Builder();
        builder.withInvoiceDate(taxiInvoices.get(0).getInvoiceDate()).withInvoiceCode("-").withInvoiceNo(invoiceNo).withInvoiceType(firstTaxiInvoice.getInvoiceType()).withSerialNo(firstTaxiInvoice.getSerialNo()).withSalerName(firstTaxiInvoice.getSalerName()).withMergeSerialNos(Er.join(taxiInvoices, v -> v.getSerialNo(), (String)",")).withRemark(firstTaxiInvoice.getRemark());
        builder.withAmount(InvoiceHelper.sum(taxiInvoices, v -> v.getAmount()));
        builder.withTaxAmount(InvoiceHelper.sum(taxiInvoices, v -> v.getTaxAmount()));
        builder.withTotalAmount(InvoiceHelper.sum(taxiInvoices, v -> v.getTotalAmount()));
        return builder.build();
    }

    public static BigDecimal sum(List<Invoice> invoices, Function<Invoice, BigDecimal> propFn) {
        return invoices.stream().map(propFn).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
    }
}

