/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.kingdee;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.RecursiveTask;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceDetailBO;
import kd.fi.er.business.invoicecloud.model.BatchQueryInvoiceRespBO;
import kd.fi.er.business.invoicecloud.provider.service.factory.InvoiceServiceFactory;
import kd.fi.er.business.invoicecloud.provider.service.std.CommonInvoiceServiceImpl;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.sdk.fi.er.extpoint.invoicecloud.AfterSelectInvoice;
import org.apache.commons.lang3.StringUtils;

public class QueryInvoiceTask
extends RecursiveTask<List<BatchQueryInvoiceRespBO>> {
    private static final long serialVersionUID = 6335644086573603575L;
    private static final Log log = LogFactory.getLog(QueryInvoiceTask.class);
    private int threshold = Integer.MAX_VALUE;
    private int startSerialNoIndex;
    private int endSerialNoIndex;
    private String[] serialNos;
    private QueryInvoiceDetailBO baseQueryInvoiceDetailBO;
    private RequestContext requestContext;
    private PluginProxy<AfterSelectInvoice> afterSelectInvoicePluginProxy = null;

    @Deprecated
    private QueryInvoiceTask(QueryInvoiceDetailBO queryInvoiceDetailBO, String[] serialNos, int startSerialNoIndex, int endSerialNoIndex, RequestContext requestContext) {
        this(queryInvoiceDetailBO, serialNos, startSerialNoIndex, endSerialNoIndex, requestContext, null);
    }

    public QueryInvoiceTask(QueryInvoiceDetailBO queryInvoiceDetailBO, String[] serialNos, int startSerialNoIndex, int endSerialNoIndex, RequestContext requestContext, PluginProxy<AfterSelectInvoice> afterSelectInvoicePluginProxy) {
        this.startSerialNoIndex = startSerialNoIndex;
        this.endSerialNoIndex = endSerialNoIndex;
        this.serialNos = serialNos;
        this.baseQueryInvoiceDetailBO = queryInvoiceDetailBO;
        this.requestContext = requestContext;
        this.afterSelectInvoicePluginProxy = afterSelectInvoicePluginProxy;
    }

    @Override
    protected List<BatchQueryInvoiceRespBO> compute() {
        RequestContext.set((RequestContext)this.requestContext);
        List<BatchQueryInvoiceRespBO> result = Collections.synchronizedList(Lists.newArrayList());
        if (this.startSerialNoIndex >= this.endSerialNoIndex) {
            return result;
        }
        if (this.endSerialNoIndex - this.startSerialNoIndex < this.threshold) {
            QueryInvoiceDetailBO queryInvoiceVO = new QueryInvoiceDetailBO();
            queryInvoiceVO.setSerialNo(StringUtils.join((Object[])this.serialNos, (String)",", (int)this.startSerialNoIndex, (int)this.endSerialNoIndex));
            queryInvoiceVO.setBxdKey(this.baseQueryInvoiceDetailBO.getBxdKey());
            queryInvoiceVO.setCompanyName(this.baseQueryInvoiceDetailBO.getCompanyName());
            queryInvoiceVO.setTaxNo(this.baseQueryInvoiceDetailBO.getTaxNo());
            queryInvoiceVO.setCostCompany(this.baseQueryInvoiceDetailBO.getCostCompany());
            log.info("\u3010\u53d1\u7968\u4e91\u3011\u6821\u9a8c\u53d1\u7968\u65f6\u7684\u6570\u636e\uff1a" + queryInvoiceVO);
            BatchQueryInvoiceRespBO batchQueryInvoiceRespBO = new BatchQueryInvoiceRespBO();
            try {
                CommonInvoiceServiceImpl commonInvoiceService = InvoiceServiceFactory.getSingletonService(CommonInvoiceServiceImpl.class);
                if (commonInvoiceService != null) {
                    List<InvoiceVO> invoiceDetail = commonInvoiceService.queryInvoiceVos(queryInvoiceVO, this.afterSelectInvoicePluginProxy);
                    batchQueryInvoiceRespBO.setInvoiceVOs(invoiceDetail);
                    result.add(batchQueryInvoiceRespBO);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                batchQueryInvoiceRespBO.setException((Exception)((Object)new InvoiceCloudException(String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u5f02\u5e38%s", (String)"QueryInvoiceTask_0", (String)"fi-er-business", (Object[])new Object[0]), RequestContext.get().getTraceId()), (Throwable)e)));
                result.add(batchQueryInvoiceRespBO);
            }
        } else {
            int mid = (this.endSerialNoIndex + this.startSerialNoIndex) / 2;
            QueryInvoiceTask left = new QueryInvoiceTask(this.baseQueryInvoiceDetailBO, this.serialNos, this.startSerialNoIndex, mid, this.requestContext);
            left.fork();
            QueryInvoiceTask right = new QueryInvoiceTask(this.baseQueryInvoiceDetailBO, this.serialNos, mid + 1, this.endSerialNoIndex, this.requestContext);
            right.fork();
            result.addAll((Collection)left.join());
            result.addAll((Collection)right.join());
        }
        return result;
    }
}

