/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.kingdee;

import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.action.AbstractAction;
import kd.fi.er.business.invoicecloud.kingdee.model.ActionResult;
import kd.fi.er.business.invoicecloud.v2.util.AllInvoiceUrl;
import kd.fi.er.common.utils.MD5;
import org.apache.commons.lang3.StringUtils;

public class UserKeyAction
extends AbstractAction {
    private Log logger = LogFactory.getLog(UserKeyAction.class);
    private String taxRegNum;
    private String userId;
    private String timestamp;
    private String random;
    private String bxdKey;
    private Long orgId;

    @Deprecated
    public UserKeyAction(String taxRegNum, String userId, String bxdKey) {
        this.taxRegNum = taxRegNum;
        this.userId = userId;
        this.timestamp = UserKeyAction.genTimestamp();
        this.random = UserKeyAction.genRandom();
        this.bxdKey = bxdKey;
    }

    public UserKeyAction(Long orgId, String userId, String bxdKey) {
        this.orgId = orgId;
        this.userId = userId;
        this.timestamp = UserKeyAction.genTimestamp();
        this.random = UserKeyAction.genRandom();
        this.bxdKey = bxdKey;
    }

    @Override
    protected ActionResult doTokenAction(boolean refreshToken) {
        InvoiceCloudCfgBO config = this.orgId != null ? KingdeeInvoiceCloudConfig.getConfig(this.orgId) : KingdeeInvoiceCloudConfig.getConfig(this.taxRegNum);
        this.logger.info("InvoiceCloudCfgBO : " + config);
        String client_id = config.getClientId();
        String client_secret = config.getClientSecret();
        String ticketParam = config.genTicketParam();
        String firmName = config.getFirmname();
        if (StringUtils.isEmpty((CharSequence)this.taxRegNum)) {
            this.taxRegNum = config.getTaxRegnum();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("timestamp", this.timestamp);
        params.put("clientId", client_id);
        params.put("tin", this.taxRegNum);
        String rawSign = client_id + client_secret + this.taxRegNum + this.userId + this.timestamp;
        params.put("sign", MD5.md5crypt((String)rawSign));
        params.put("cid", this.userId);
        params.put("ticketParam", ticketParam);
        params.put("random", this.random);
        params.put("bxd_key", this.bxdKey);
        params.put("ghf_mc", firmName);
        String url = AllInvoiceUrl.userKeyAction(this.getToken(this.orgId == null ? 0L : this.orgId, refreshToken));
        return this.buildResult(this.doPost(url, params));
    }

    @Override
    public String desc() {
        return ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u83b7\u53d6\u5c0f\u7a0b\u5e8fuserKey", (String)"UserKeyAction_0", (String)"fi-er-business", (Object[])new Object[0]);
    }

    public static String genTimestamp() {
        return String.valueOf(new Date().getTime());
    }

    public static String genRandom() {
        SecureRandom random = new SecureRandom();
        return String.valueOf(random.nextDouble());
    }
}

