/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.kingdee.action;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.action.Action;
import kd.fi.er.business.invoicecloud.kingdee.model.ActionCode;
import kd.fi.er.business.invoicecloud.kingdee.model.ActionResult;

public abstract class AbstractAction
implements Action {
    private static final Log logger = LogFactory.getLog(AbstractAction.class);

    @Override
    public final String execute() {
        ActionResult actionResult = this.doTokenAction(false);
        if (actionResult != null) {
            if (ActionCode.compareActionCode(ActionCode.INVOICE_SUCCESS, actionResult.getErrorCode(), actionResult.getResponseCode())) {
                return actionResult.getResult();
            }
            if (!actionResult.isSuccess() && ActionCode.compareActionCode(ActionCode.INVOICE_ERROR_TOKEN_FAIL, actionResult.getErrorCode(), actionResult.getResponseCode())) {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011token\u5931\u6548\u6216\u8d85\u65f6\uff0c\u5c1d\u8bd5\u91cd\u65b0\u83b7\u53d6\u3002" + actionResult.getResult());
                actionResult = this.doTokenAction(true);
            }
        }
        logger.info(this.desc() + actionResult);
        if (actionResult == null) {
            return "";
        }
        return actionResult.getResult();
    }

    protected abstract ActionResult doTokenAction(boolean var1);

    public final ActionResult buildResult(String responseJson) {
        ActionResult result = new ActionResult();
        boolean isSuccess = true;
        String errCode = "";
        String errStr = "";
        int responseCode = 0;
        try {
            JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)responseJson, JSONObject.class);
            Integer code = jsonObject.getInteger("responseCode");
            responseCode = code == null ? 0 : code;
            errCode = jsonObject.getString("errcode");
        }
        catch (Exception e) {
            isSuccess = false;
            errStr = String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u54cd\u5e94\u4fe1\u606f\u89e3\u6790\u9519\u8bef:%s\u3002", (String)"AbstractAction_0", (String)"fi-er-business", (Object[])new Object[0]), e.getMessage());
            logger.error("\u3010\u53d1\u7968\u4e91\u3011\u54cd\u5e94\u4fe1\u606f\u89e3\u6790\u9519\u8bef:" + e, (Throwable)e);
        }
        result.setResult(responseJson);
        result.setSuccess(isSuccess);
        result.setResponseCode(responseCode);
        result.setErrorCode(errCode);
        result.setErrorStr(errStr);
        return result;
    }

    public final String getToken(long companyId, boolean refreshToken) {
        return APIHelper.getCacheToken(companyId, refreshToken);
    }
}

