/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.kingdee.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.action.AbstractAction;
import kd.fi.er.business.invoicecloud.kingdee.model.ActionResult;
import kd.fi.er.business.invoicecloud.v2.util.AllInvoiceUrl;
import kd.fi.er.business.utils.ErStdConfig;
import org.apache.commons.lang3.StringUtils;

public class QueryBySerialNoAction
extends AbstractAction {
    private static final Log log = LogFactory.getLog(QueryBySerialNoAction.class);
    private String serialNo;
    private String taxNo;
    private String companyName;
    private String bxdKey;
    private Long invoiceOrgId;

    public QueryBySerialNoAction(String serialNo) {
        this.serialNo = serialNo;
    }

    @Override
    protected ActionResult doTokenAction(boolean refreshToken) {
        if (ErStdConfig.getBoolean("intranet")) {
            String invoiceJson = "";
            invoiceJson = "{\"errcode\": \"0000\",\"description\": \"\u64cd\u4f5c\u6210\u529f\",\"data\": [{\"salerName\": \"\u6df1\u5733\u5e02\u6df1\u6295\u7269\u4e1a\u53d1\u5c55\u6709\u9650\u516c\u53f8\",\"invoiceMoney\": \"87143.96\",\"proxyMark\": \"\",\"downloadUrl\": \"https: //api.kingdee.com/kdrive/user/file/public?client_idu003d200242u0026file_idu003d65149340u0026scodeu003dRXRRMGloNmgwU3YzWkxjWWY3bnhCu0026signu003d3b766d2b98dbea973266cdee00509df13c05de88\",\"remark\": \"\u6295\u8d44\u5927\u53a614\u697cB4-5,F1-5\u533a\",\"authenticateFlag\": 1,\"payee\": \"\",\"checkStatus\": \"1\",\"salerTaxNo\": \"91440300279371676C\",\"invoiceType\": \"4\",\"invoiceNo\": \"24770357\",\"buyerAddressPhone\": \"\u6df1\u5733\u5e02\u798f\u7530\u533a\u6df1\u5357\u5927\u905340009\u53f7\u6295\u8d44\u5927\u53a616\u697c83883106\",\"salerAccount\": \"\u4e2d\u4fe1\u94f6\u884c\u798f\u5357\u652f\u884c7441310182600028010\",\"originalGraphUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_idu003d200242u0026file_idu003d73257535u0026qualityu003d100u0026scodeu003dQWNOb1Q5SE50R1phRjd3V2grSEs5u0026signu003dfae83719f656c923f6762d98d2e42ba3c9997aeau0026widthu003d800\",\"amount\": \"87143.96\",\"buyerTaxNo\": \"91440300664187170P\",\"validateMessage\": \"\u53d1\u7968\u5df2\u5728\u62a5\u9500\u4e2d,\u53d1\u7968\u62ac\u5934\u4e0e\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4,\u53d1\u7968\u62ac\u5934\u4e0e\u4f01\u4e1a\u7a0e\u53f7\u4e0d\u4e00\u81f4\",\"drawer\": \"\",\"reviewer\": \"\",\"invoiceDate\": \"2019-04-02\",\"buyerName\": \"\u73af\u5b87\u673a\u5668\u4eba\uff08\u7f8e\u56fd\uff09\u6709\u9650\u516c\u53f8\",\"invoiceCode\": \"4403182130\",\"serialNo\": \"836506eee8e04906acc8a15ea255ab7f0\",\"checkCode\": \"\",\"checkFlag\": 1,\"totalAmount\": \"92605.29\",\"salerAddressPhone\": \"\u6df1\u5733\u5e02\u798f\u7530\u533a\u6295\u8d44\u5927\u53a615\u697c 0755-83883283\",\"checkTime\": \"\",\"buyerAccount\": \"\u4e2d\u4fe1\u94f6\u884c\u798f\u5357\u652f\u884c7441310182600070147\",\"authenticateTime\": \"\",\"rotationAngle\": \"0\",\"snapshotUrl\": \"https://api.kingdee.com/kdrive/user/file/snapshot?client_idu003d200242u0026file_idu003d65149340u0026qualityu003d100u0026scodeu003dUkhIL0RMRmFLY2FYUUs3L2toTUpyu0026signu003d9456b2a4703dd07da0d293eff146c8eb600bdaf6u0026widthu003d800\",\"taxAmount\": \"5461.33\",\"totalAmountCn\": \"\",\"invoiceStatus\": \"0\",\"items\": [{\"unitPrice\": \"69464.3207547170\",\"taxRate\": \"0.060000\",\"unit\": \" \",\"num\": \"1.0000000000\",\"detailAmount\": \"69464.32\",\"specModel\": \" \",\"goodsCode\": \"3040801000000000000\",\"taxAmount\": \"4167.86\",\"goodsName\": \"*\u4f01\u4e1a\u7ba1\u7406\u670d\u52a1*2019\u5e744\u6708\u7ba1\u7406\u8d39\"},{\"unitPrice\": \"14273.4905660377\",\"taxRate\": \"0.060000\",\"unit\": \" \",\"num\": \"1.0000000000\",\"detailAmount\": \"14273.49\",\"specModel\": \" \",\"goodsCode\": \"3040000000000000000\",\"taxAmount\": \"856.41\",\"goodsName\": \"*\u73b0\u4ee3\u670d\u52a1*2019\u5e744\u6708\u7a7a\u8c03\u670d\u52a1\u8d39\"},{\"unitPrice\": \"24.5283018868\",\"taxRate\": \"0.060000\",\"unit\": \" \",\"num\": \"1.0000000000\",\"detailAmount\": \"24.53\",\"specModel\": \" \",\"goodsCode\": \"3040000000000000000\",\"taxAmount\": \"1.47\",\"goodsName\": \"*\u73b0\u4ee3\u670d\u52a1*2019\u5e743\u6708\u670d\u52a1\u8d39(\u7ef4\u4fee\u8d39)\"},{\"unitPrice\": \"1.0265486726\",\"taxRate\": \"0.130000\",\"unit\": \" \",\"num\": \"3255.0000000000\",\"detailAmount\": \"3341.42\",\"specModel\": \" \",\"goodsCode\": \"1100101020000000000\",\"taxAmount\": \"434.38\",\"goodsName\": \"*\u4f9b\u7535*2019\u5e743\u6708\u7535\u8d39\"},{\"unitPrice\": \"3.2524271845\",\"taxRate\": \"0.030000\",\"unit\": \" \",\"num\": \"12.3600000000\",\"detailAmount\": \"40.20\",\"specModel\": \" \",\"goodsCode\": \"1100300000000000000\",\"taxAmount\": \"1.21\",\"goodsName\": \"*\u6c34\u51b0\u96ea*2019\u5e743\u6708\u6c34\u8d39\"}],\"expenseStatus\": \"30\"},{\"salerName\": \"\u6df1\u5733\u5e02\u6df1\u6295\u7269\u4e1a\u53d1\u5c55\u6709\u9650\u516c\u53f8\",\"invoiceMoney\": \"64773.62\",\"proxyMark\": \"\",\"downloadUrl\": \"https://api.kingdee.com/kdrive/user/file/public?client_idu003d200242u0026file_idu003d67155291u0026scodeu003dYTZZekhfS1kwPXlpWnBGZzJySmJnu0026signu003dc639946c91cc28cd6e7ee5f458148ad380734440\",\"remark\": \"\u6295\u8d44\u5927\u53a614\u697cC\u533a\",\"authenticateFlag\": 1,\"payee\": \"\",\"checkStatus\": \"1\",\"salerTaxNo\": \"91440300279371676C\",\"invoiceType\": \"4\",\"invoiceNo\": \"21433383\",\"buyerAddressPhone\": \"\u6df1\u5733\u5e02\u798f\u7530\u533a\u6df1\u5357\u5927\u905340009\u53f7\u6295\u8d44\u5927\u53a616\u697c83883106\",\"salerAccount\": \"\u4e2d\u4fe1\u94f6\u884c\u798f\u5357\u652f\u884c7441310182600028010\",\"originalGraphUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_idu003d200242u0026file_idu003d73257252u0026qualityu003d100u0026scodeu003dR1V2X04tdXlYUnNmekZjSmlrdEZmu0026signu003dba60245a62746871cd45eb914cc5b09a5835354du0026widthu003d800\",\"amount\": \"64773.62\",\"buyerTaxNo\": \"91440300664187170P\",\"validateMessage\": \"\u53d1\u7968\u62ac\u5934\u4e0e\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4,\u53d1\u7968\u62ac\u5934\u4e0e\u4f01\u4e1a\u7a0e\u53f7\u4e0d\u4e00\u81f4\",\"drawer\": \"\",\"reviewer\": \"\",\"invoiceDate\": \"2020-01-01\",\"buyerName\": \"\u6df1\u5733\u5e02\u8fdc\u81f4\u6295\u8d44\u6709\u9650\u516c\u53f8\",\"invoiceCode\": \"4403181130\",\"serialNo\": \"e901bafdc2dc4a838f82e5f638f7992c0\",\"checkCode\": \"\",\"checkFlag\": 1,\"totalAmount\": \"68512.97\",\"salerAddressPhone\": \"\u6df1\u5733\u5e02\u798f\u7530\u533a\u6295\u8d44\u5927\u53a615\u697c 0755-83883283\",\"checkTime\": \"\",\"buyerAccount\": \"\u4e2d\u4fe1\u94f6\u884c\u798f\u5357\u652f\u884c7441310182600070147\",\"authenticateTime\": \"\",\"rotationAngle\": \"0\",\"snapshotUrl\": \"https://api.kingdee.com/kdrive/user/file/snapshot?client_idu003d200242u0026file_idu003d67155291u0026qualityu003d100u0026scodeu003dNnJrMSt2VUtKRktKK1pzMStNUnJTu0026signu003dfc02ef55ceb53a4b8b7de30493d50d7bf961ffb9u0026widthu003d800\",\"taxAmount\": \"3739.35\",\"totalAmountCn\": \"\",\"invoiceStatus\": \"0\",\"items\": [{\"unitPrice\": \"41996.2857142857\",\"taxRate\": \"0.050000\",\"unit\": \" \",\"num\": \"1.0000000000\",\"detailAmount\": \"41996.29\",\"specModel\": \" \",\"goodsCode\": \"3040502000000000000\",\"taxAmount\": \"2099.81\",\"goodsName\": \"*\u7ecf\u8425\u79df\u8d41*2019\u5e741\u6708\u623f\u5c4b\u79df\u91d1\"},{\"unitPrice\": \"16356.8207547170\",\"taxRate\": \"0.060000\",\"unit\": \" \",\"num\": \"1.0000000000\",\"detailAmount\": \"16356.82\",\"specModel\": \" \",\"goodsCode\": \"3040801000000000000\",\"taxAmount\": \"981.41\",\"goodsName\": \"*\u4f01\u4e1a\u7ba1\u7406\u670d\u52a1*2019\u5e741\u6708\u7ba1\u7406\u8d39\"},{\"unitPrice\": \"3644.0094339623\",\"taxRate\": \"0.060000\",\"unit\": \" \",\"num\": \"1.0000000000\",\"detailAmount\": \"3644.01\",\"specModel\": \" \",\"goodsCode\": \"3040000000000000000\",\"taxAmount\": \"218.64\",\"goodsName\": \"*\u73b0\u4ee3\u670d\u52a1*2019\u5e741\u6708\u7a7a\u8c03\u670d\u52a1\u8d39\"},{\"unitPrice\": \"1.0000000000\",\"taxRate\": \"0.160000\",\"unit\": \" \",\"num\": \"2740.0000000000\",\"detailAmount\": \"2740.00\",\"specModel\": \" \",\"goodsCode\": \"1100101020000000000\",\"taxAmount\": \"438.40\",\"goodsName\": \"*\u4f9b\u7535*2018\u5e7412\u6708\u7535\u8d39\"},{\"unitPrice\": \"3.2524271845\",\"taxRate\": \"0.030000\",\"unit\": \" \",\"num\": \"11.2200000000\",\"detailAmount\": \"36.50\",\"specModel\": \" \",\"goodsCode\": \"1100300000000000000\",\"taxAmount\": \"1.09\",\"goodsName\": \"*\u6c34\u51b0\u96ea*2018\u5e7412\u6708\u6c34\u8d39\"}],\"expenseStatus\": \"1\"},{\"passengerName\": \"\u674e\u5fd7\u4f1f\",\"salerName\": \"\",\"downloadUrl\": \"https://api.kingdee.com/kdrive/user/file/public?client_id=200242&file_id=77357885&scode=LVhNNz1xOGtmV2twdVpJLVFFOGE3&sign=5ac89634f4b56c06d618b9982ba0b491f9b61d44\",\"remark\": \"\",\"authenticateFlag\": 1,\"checkStatus\": \"1\",\"trip\": \"\u5317\u4eac - \u6df1\u5733\",\"salerTaxNo\": \"\",\"airportConstructionFee\": \"50.00\",\"invoiceType\": \"10\",\"invoiceNo\": \"9994532261726\",\"buyerAddressPhone\": \"\",\"salerAccount\": \"\",\"originalGraphUrl\": \"\",\"insurancePremium\": \"0\",\"amount\": \"730.00\",\"buyerTaxNo\": \"\",\"otherTotalTaxAmount\": \"0\",\"validateMessage\": \"\u53d1\u7968\u5df2\u5728\u62a5\u9500\u4e2d\",\"invoiceDate\": \"2019-05-25\",\"buyerName\": \"\",\"invoiceCode\": \"20190525\",\"serialNo\": \"b3a43e7f8a2346f1867a40c426615e0c0\",\"checkFlag\": 1,\"totalAmount\": \"780.00\",\"seatGrade\": \"K\",\"salerAddressPhone\": \"\",\"checkTime\": \"\",\"buyerAccount\": \"\",\"authenticateTime\": \"\",\"rotationAngle\": \"0\",\"snapshotUrl\": \"https://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=77357885&quality=100&scode=QWNOb1Q5SE50R1phRjd3V2grSEs5&sign=1066144b51f9b04bdb84d9f60dbd95c8a07ffac6&width=800\",\"taxAmount\": \"60.27\",\"totalAmountCn\": \"\",\"fuelSurcharge\": \"0\",\"expenseStatus\": \"60\"},{\"passengerName\": \"\u80e1\u5e86\u677e\",\"salerName\": \"\",\"downloadUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=75607008&quality=100&scode=RGNjVG5FcUc1WlVUcGJpRkFpWlJW&sign=f96b1097cd82c4b0640e3d054f98ece0132982a8&width=800\",\"remark\": \"\",\"authenticateFlag\": 1,\"checkStatus\": \"1\",\"trip\": \"\u5357\u4eac - \u5927\u4e30\",\"salerTaxNo\": \"\",\"invoiceType\": \"16\",\"invoiceNo\": \"12312900\",\"buyerAddressPhone\": \"\",\"salerAccount\": \"\",\"originalGraphUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=75607008&quality=100&scode=RGNjVG5FcUc1WlVUcGJpRkFpWlJW&sign=f96b1097cd82c4b0640e3d054f98ece0132982a8&width=800\",\"amount\": \"701.00\",\"buyerTaxNo\": \"\",\"validateMessage\": \"\",\"invoiceDate\": \"2019-05-20\",\"buyerName\": \"\",\"invoiceCode\": \"132011881313\",\"serialNo\": \"26e2c235e83e4a9d933bfdadc5c10a570\",\"checkFlag\": 1,\"totalAmount\": \"701.00\",\"salerAddressPhone\": \"\",\"checkTime\": \"\",\"buyerAccount\": \"\",\"authenticateTime\": \"\",\"rotationAngle\": \"180\",\"snapshotUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=75607008&quality=100&scode=RGNjVG5FcUc1WlVUcGJpRkFpWlJW&sign=f96b1097cd82c4b0640e3d054f98ece0132982a8&width=800\",\"taxAmount\": \"0\",\"totalAmountCn\": \"\",\"expenseStatus\": \"1\"},{\"passengerName\": \"\u674e\u5fd7\u4f1f\",\"salerName\": \"\",\"downloadUrl\": \"https://api.kingdee.com/kdrive/user/file/public?client_id=200242&file_id=77357943&scode=X3RrM19wai1KcS8zK01mL0JjRjl1&sign=1630331715830ae9f359b1136dbf4ecf5bc52d97\",\"remark\": \"\",\"authenticateFlag\": 1,\"checkStatus\": \"1\",\"trip\": \"\u6df1\u5733 - \u5317\u4eac\",\"salerTaxNo\": \"\",\"airportConstructionFee\": \"50.00\",\"invoiceType\": \"10\",\"invoiceNo\": \"8804532397082\",\"buyerAddressPhone\": \"\",\"salerAccount\": \"\",\"originalGraphUrl\": \"\",\"insurancePremium\": \"0\",\"amount\": \"1350.00\",\"buyerTaxNo\": \"\",\"otherTotalTaxAmount\": \"0\",\"validateMessage\": \"\u53d1\u7968\u5df2\u5728\u62a5\u9500\u4e2d\",\"invoiceDate\": \"2019-05-19\",\"buyerName\": \"\",\"invoiceCode\": \"20190519\",\"serialNo\": \"ff0283a0a41842feb1ed65777ee126550\",\"checkFlag\": 1,\"totalAmount\": \"1400.00\",\"seatGrade\": \"X\",\"salerAddressPhone\": \"\",\"checkTime\": \"\",\"buyerAccount\": \"\",\"authenticateTime\": \"\",\"rotationAngle\": \"0\",\"snapshotUrl\": \"https://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=77357943&quality=100&scode=WTI1PUtyYnhKbnBoaFlZYklZV0xu&sign=cb0b18489bbce350c784a8f342afdcd2c34fe033&width=800\",\"taxAmount\": \"111.47\",\"totalAmountCn\": \"\",\"fuelSurcharge\": \"0\",\"expenseStatus\": \"60\"},{\"passengerName\": \"\u5e84\u5609\u76db\",\"salerName\": \"\",\"downloadUrl\": \"https://api.kingdee.com/kdrive/user/file/public?client_id=200242&file_id=76695942&scode=dmtxPXRhb3F1eFdqbl9qYl95bUNV&sign=4b08f18b2965c3c120629872b46372ac9bc67259\",\"remark\": \"\",\"authenticateFlag\": 1,\"checkStatus\": \"1\",\"trip\": \"\u6606\u660e - \u6210\u90fd\",\"salerTaxNo\": \"\",\"invoiceType\": \"9\",\"invoiceNo\": \"A013415\",\"buyerAddressPhone\": \"\",\"salerAccount\": \"\",\"originalGraphUrl\": \"\",\"amount\": \"138.50\",\"buyerTaxNo\": \"\",\"validateMessage\": \"\",\"invoiceDate\": \"2019-05-02\",\"buyerName\": \"\",\"invoiceCode\": \"20190502\",\"serialNo\": \"aadf75cfec584963b2bd437f53bcf81b0\",\"checkFlag\": 1,\"totalAmount\": \"138.50\",\"seatGrade\": \"\u65b0\u7a7a\u8c03\u786c\u5ea7\",\"salerAddressPhone\": \"\",\"checkTime\": \"\",\"buyerAccount\": \"\",\"authenticateTime\": \"\",\"rotationAngle\": \"0\",\"snapshotUrl\": \"https://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=76695942&quality=100&scode=M2xLNWZqUW42RC1ubURINjBIN05q&sign=e8d62752dc703443f6912650244f502c07f417d7&width=800\",\"taxAmount\": \"0\",\"totalAmountCn\": \"\",\"expenseStatus\": \"1\"},{\"passengerName\": \"\u5f20\u6069\u7434\",\"salerName\": \"\",\"downloadUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=69103850&quality=100&scode=Y3ZmUDlValNIampnQm0yTzFBK25p&sign=d0c0129bf58c4aa0808dcfcd5096b95f852b0c44&width=800\",\"remark\": \"\",\"authenticateFlag\": 1,\"checkStatus\": \"1\",\"trip\": \"\u6df1\u5733 - \u5317\u4eac\",\"salerTaxNo\": \"\",\"airportConstructionFee\": \"50.00\",\"invoiceType\": \"10\",\"invoiceNo\": \"8802188971952\",\"buyerAddressPhone\": \"\",\"salerAccount\": \"\",\"originalGraphUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=69103850&quality=100&scode=Y3ZmUDlValNIampnQm0yTzFBK25p&sign=d0c0129bf58c4aa0808dcfcd5096b95f852b0c44&width=800\",\"insurancePremium\": \"0\",\"amount\": \"1695.00\",\"buyerTaxNo\": \"\",\"otherTotalTaxAmount\": \"0\",\"validateMessage\": \"\",\"invoiceDate\": \"2019-04-10\",\"buyerName\": \"\",\"invoiceCode\": \"20190410\",\"serialNo\": \"65e116d17a2643b0bf18ddc831764e220\",\"checkFlag\": 1,\"totalAmount\": \"1745.00\",\"seatGrade\": \"L\",\"salerAddressPhone\": \"\",\"checkTime\": \"\",\"buyerAccount\": \"\",\"authenticateTime\": \"\",\"rotationAngle\": \"90\",\"snapshotUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=69103850&quality=100&scode=Y3ZmUDlValNIampnQm0yTzFBK25p&sign=d0c0129bf58c4aa0808dcfcd5096b95f852b0c44&width=800\",\"taxAmount\": \"0\",\"totalAmountCn\": \"\",\"fuelSurcharge\": \"0\",\"expenseStatus\": \"1\"},{\"passengerName\": \"\u5f90\u838e\u838e\",\"salerName\": \"\",\"downloadUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=66601001&quality=100&scode=YTNzZ2FTRUlMaU56TDhMR3lySm95&sign=f6184303bda424427d884c3e1ae45cc1068a05ae&width=800\",\"remark\": \"\",\"authenticateFlag\": 1,\"checkStatus\": \"1\",\"trip\": \"\u664b\u6c5f - \u6df1\u5733\",\"salerTaxNo\": \"\",\"invoiceType\": \"9\",\"invoiceNo\": \"C078011\",\"buyerAddressPhone\": \"\",\"salerAccount\": \"\",\"originalGraphUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=66601001&quality=100&scode=YTNzZ2FTRUlMaU56TDhMR3lySm95&sign=f6184303bda424427d884c3e1ae45cc1068a05ae&width=800\",\"amount\": \"273.50\",\"buyerTaxNo\": \"\",\"validateMessage\": \"\u53d1\u7968\u5df2\u5728\u62a5\u9500\u4e2d\",\"invoiceDate\": \"2019-02-17\",\"buyerName\": \"\",\"invoiceCode\": \"20190217\",\"serialNo\": \"798b5942a08b4193a2a360db3d1ac7d30\",\"checkFlag\": 1,\"totalAmount\": \"273.50\",\"seatGrade\": \"\u65b0\u7a7a\u8c03\u786c\u5367\",\"salerAddressPhone\": \"\",\"checkTime\": \"\",\"buyerAccount\": \"\",\"authenticateTime\": \"\",\"rotationAngle\": \"0\",\"snapshotUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=66601001&quality=100&scode=YTNzZ2FTRUlMaU56TDhMR3lySm95&sign=f6184303bda424427d884c3e1ae45cc1068a05ae&width=800\",\"taxAmount\": \"0\",\"totalAmountCn\": \"\",\"expenseStatus\": \"60\"},{\"passengerName\": \"\u6bb5\u53cb\u7231\",\"salerName\": \"\",\"downloadUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=73908833&quality=100&scode=X3RrM19wai1KcS8zK01mL0JjRjl1&sign=d76e964331b4d2550ffedea0893e44c3c800dc5c&width=800\",\"remark\": \"\",\"authenticateFlag\": 1,\"checkStatus\": \"1\",\"trip\": \"\u4e5d\u6c5f - \u6df1\u5733\",\"salerTaxNo\": \"\",\"invoiceType\": \"9\",\"invoiceNo\": \"B026623\",\"buyerAddressPhone\": \"\",\"salerAccount\": \"\",\"originalGraphUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=73908833&quality=100&scode=X3RrM19wai1KcS8zK01mL0JjRjl1&sign=d76e964331b4d2550ffedea0893e44c3c800dc5c&width=800\",\"amount\": \"294.50\",\"buyerTaxNo\": \"\",\"validateMessage\": \"\u53d1\u7968\u5df2\u5728\u62a5\u9500\u4e2d\",\"invoiceDate\": \"2019-02-17\",\"buyerName\": \"\",\"invoiceCode\": \"20190217\",\"serialNo\": \"7820fab00aef4a6ab9bc43169ea9116d0\",\"checkFlag\": 1,\"totalAmount\": \"294.50\",\"seatGrade\": \"\u65b0\u7a7a\u8c03\u786c\u5367\",\"salerAddressPhone\": \"\",\"checkTime\": \"\",\"buyerAccount\": \"\",\"authenticateTime\": \"\",\"rotationAngle\": \"90\",\"snapshotUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=73908833&quality=100&scode=X3RrM19wai1KcS8zK01mL0JjRjl1&sign=d76e964331b4d2550ffedea0893e44c3c800dc5c&width=800\",\"taxAmount\": \"0\",\"totalAmountCn\": \"\",\"expenseStatus\": \"30\"},{\"passengerName\": \"\u6bb5\u53cb\u7231\",\"salerName\": \"\",\"downloadUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=76566814&quality=100&scode=SUMtRDVNRFZ2Rm5wL2NKdnVMVUxi&sign=a14e2c0cfa676bd165882c2c2031d83cccfa924d&width=800\",\"remark\": \"\",\"authenticateFlag\": 1,\"checkStatus\": \"1\",\"trip\": \"\u4e5d\u6c5f - \u6df1\u5733\",\"salerTaxNo\": \"\",\"invoiceType\": \"9\",\"invoiceNo\": \"B626623\",\"buyerAddressPhone\": \"\",\"salerAccount\": \"\",\"originalGraphUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=76566814&quality=100&scode=SUMtRDVNRFZ2Rm5wL2NKdnVMVUxi&sign=a14e2c0cfa676bd165882c2c2031d83cccfa924d&width=800\",\"amount\": \"294.50\",\"buyerTaxNo\": \"\",\"validateMessage\": \"\",\"invoiceDate\": \"2019-02-17\",\"buyerName\": \"\",\"invoiceCode\": \"20190217\",\"serialNo\": \"0057ec38b49e4315a03d0f995c90ae8f0\",\"checkFlag\": 1,\"totalAmount\": \"294.50\",\"seatGrade\": \"\u65b0\u7a7a\u8c03\u786c\u5367\",\"salerAddressPhone\": \"\",\"checkTime\": \"\",\"buyerAccount\": \"\",\"authenticateTime\": \"\",\"rotationAngle\": \"90\",\"snapshotUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=76566814&quality=100&scode=SUMtRDVNRFZ2Rm5wL2NKdnVMVUxi&sign=a14e2c0cfa676bd165882c2c2031d83cccfa924d&width=800\",\"taxAmount\": \"0\",\"totalAmountCn\": \"\",\"expenseStatus\": \"1\"},{\"passengerName\": \"\u8c22\u5c11\u4e91\",\"salerName\": \"\",\"downloadUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=75678558&quality=100&scode=clNST2U0UUh5YjYySD0yT08yRWR6&sign=7d80d71ac00af38bd14c535f5ce53f799e044fc9&width=800\",\"remark\": \"\",\"authenticateFlag\": 1,\"checkStatus\": \"1\",\"trip\": \"\u53f0\u5dde\u8def\u6865 - \u6b66\u6c49\",\"salerTaxNo\": \"\",\"airportConstructionFee\": \"50.00\",\"invoiceType\": \"10\",\"invoiceNo\": \"8112319255180\",\"buyerAddressPhone\": \"\",\"salerAccount\": \"\",\"originalGraphUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=75678558&quality=100&scode=clNST2U0UUh5YjYySD0yT08yRWR6&sign=7d80d71ac00af38bd14c535f5ce53f799e044fc9&width=800\",\"insurancePremium\": \"0\",\"amount\": \"510.00\",\"buyerTaxNo\": \"\",\"otherTotalTaxAmount\": \"0\",\"validateMessage\": \"\u53d1\u7968\u5df2\u5728\u62a5\u9500\u4e2d\",\"invoiceDate\": \"2019-03-23\",\"buyerName\": \"\",\"invoiceCode\": \"20180323\",\"serialNo\": \"18911fd08e0c4011b4789924028fb8b00\",\"checkFlag\": 1,\"totalAmount\": \"560.00\",\"seatGrade\": \"E\",\"salerAddressPhone\": \"\",\"checkTime\": \"\",\"buyerAccount\": \"\",\"authenticateTime\": \"\",\"rotationAngle\": \"0\",\"snapshotUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=75678558&quality=100&scode=clNST2U0UUh5YjYySD0yT08yRWR6&sign=7d80d71ac00af38bd14c535f5ce53f799e044fc9&width=800\",\"taxAmount\": \"0\",\"totalAmountCn\": \"\",\"fuelSurcharge\": \"0\",\"expenseStatus\": \"60\"},{\"passengerName\": \"\u5f90\u534e\u4e91\",\"salerName\": \"\",\"downloadUrl\": \"https://api.kingdee.com/kdrive/user/file/public?client_id=200242&file_id=77357819&scode=RWwtTmFqY2hBNkJ6ZjlQNE5yVXE2&sign=2758c5ac6fafaab411e853741383af3dcb5f9756\",\"remark\": \"\",\"authenticateFlag\": 1,\"checkStatus\": \"1\",\"trip\": \"\u6df1\u5733 - \u53f0\u5dde\u8def\u6865\",\"salerTaxNo\": \"\",\"airportConstructionFee\": \"50.00\",\"invoiceType\": \"10\",\"invoiceNo\": \"4792117406499\",\"buyerAddressPhone\": \"\",\"salerAccount\": \"\",\"originalGraphUrl\": \"\",\"insurancePremium\": \"0\",\"amount\": \"1130.00\",\"buyerTaxNo\": \"\",\"otherTotalTaxAmount\": \"0\",\"validateMessage\": \"\u53d1\u7968\u5df2\u5728\u62a5\u9500\u4e2d\",\"invoiceDate\": \"2019-03-18\",\"buyerName\": \"\",\"invoiceCode\": \"20180318\",\"serialNo\": \"a98d2a19c4254651a57d4b28a08eee696\",\"checkFlag\": 1,\"totalAmount\": \"1180.00\",\"seatGrade\": \"Y\",\"salerAddressPhone\": \"\",\"checkTime\": \"\",\"buyerAccount\": \"\",\"authenticateTime\": \"\",\"rotationAngle\": \"90\",\"snapshotUrl\": \"https://api.kingdee.com/kdrive/user/file/thumbnail?client_id=200242&file_id=77357819&quality=100&scode=OGEzZWRzWTNOaWV5R3dkYU5SMVJh&sign=e23ce4a26c34adcfe333a52ce75d773de8939ceb&width=800\",\"taxAmount\": \"0\",\"totalAmountCn\": \"\",\"fuelSurcharge\": \"0\",\"expenseStatus\": \"30\"},{\"currencyType\": \"RMB\",\"passengerName\": \"\u674e\u4f1f\u5eb7\",\"stationGetOn\": \"\u6dc4\u535a\",\"salerName\": \"\",\"downloadUrl\": \"https://api.kingdee.com/kdrive/user/file/public?client_idu003d200242u0026file_idu003d128390419u0026scodeu003dTlIzY1A1SFNlSUVnSDJ4RXNVaGxFu0026signu003d5df9289e1212984af596c482ac6a0ebe6fa961eb\",\"authenticateFlag\": 1,\"departurePosition\": {\"area\": \"\u5f20\u5e97\u533a\",\"province\": \"\u5c71\u4e1c\u7701\",\"city\": \"\u6dc4\u535a\u5e02\"},\"checkStatus\": 3,\"trip\": \"\u6dc4\u535a - \u6dc4\u535a\",\"stationGetOff\": \"\u6dc4\u535a\",\"salerTaxNo\": \"\",\"invoiceType\": \"16\",\"invoiceNo\": \"00421180\",\"pixel\": \"755,396\",\"buyerAddressPhone\": \"\",\"salerAccount\": \"\",\"originalGraphUrl\": \"https://api.kingdee.com/kdrive/user/file/public?client_idu003d200242u0026file_idu003d128390419u0026scodeu003dTlIzY1A1SFNlSUVnSDJ4RXNVaGxFu0026signu003d5df9289e1212984af596c482ac6a0ebe6fa961eb\",\"amount\": \"19.42\",\"buyerTaxNo\": \"\",\"validateMessage\": \"\u53d1\u7968\u5df2\u5728\u62a5\u9500\u4e2d\",\"buyerName\": \"\",\"invoiceDate\": \"2019-06-15\",\"invoiceCode\": \"137031992002\",\"serialNo\": \"aa451ea848c649ea93f2b25804b5c04d0\",\"checkFlag\": 1,\"totalAmount\": \"20.00\",\"taxRate\": \"0.030000\",\"salerAddressPhone\": \"\",\"checkTime\": \"\",\"buyerAccount\": \"\",\"authenticateTime\": \"\",\"rotationAngle\": \"0\",\"snapshotUrl\": \"https://api.kingdee.com/kdrive/user/file/thumbnail?client_idu003d200242u0026file_idu003d128390419u0026qualityu003d100u0026scodeu003dcldyRm5zTDhqT3hWRDRqVDVnODZru0026signu003d92c4acf511f39ba7c444fed5367ea84063f68de8u0026widthu003d800\",\"isRevise\": \"1\",\"destinationPosition\": {\"area\": \"\u5f20\u5e97\u533a\",\"province\": \"\u5c71\u4e1c\u7701\",\"city\": \"\u6dc4\u535a\u5e02\"},\"time\": \"\",\"taxAmount\": \"0.58\",\"totalAmountCn\": \"\",\"region\": \"[0,0,755,396]\",\"expenseStatus\": \"60\"},{\"currencyType\": \"RMB\",\"passengerName\": \"\u674e\u4f1f\u5eb7\",\"stationGetOn\": \"\u6dc4\u535a\",\"salerName\": \"\",\"downloadUrl\": \"https://api.kingdee.com/kdrive/user/file/public?client_idu003d200242u0026file_idu003d128390509u0026scodeu003ddmtxPXRhb3F1eFdqbl9qYl95bUNVu0026signu003daa372b6c6bd38580a89a889750d3997751b02317\",\"authenticateFlag\": 1,\"departurePosition\": {\"area\": \"\u5f20\u5e97\u533a\",\"province\": \"\u5c71\u4e1c\u7701\",\"city\": \"\u6dc4\u535a\u5e02\"},\"checkStatus\": 3,\"trip\": \"\u6dc4\u535a - \u6dc4\u535a\",\"stationGetOff\": \"\u6dc4\u535a\",\"salerTaxNo\": \"\",\"invoiceType\": \"16\",\"invoiceNo\": \"04216007\",\"pixel\": \"722,401\",\"buyerAddressPhone\": \"\",\"salerAccount\": \"\",\"originalGraphUrl\": \"https://api.kingdee.com/kdrive/user/file/public?client_idu003d200242u0026file_idu003d128390509u0026scodeu003ddmtxPXRhb3F1eFdqbl9qYl95bUNVu0026signu003daa372b6c6bd38580a89a889750d3997751b02317\",\"amount\": \"19.42\",\"buyerTaxNo\": \"\",\"validateMessage\": \"\u53d1\u7968\u5df2\u5728\u62a5\u9500\u4e2d\",\"buyerName\": \"\",\"invoiceDate\": \"2019-06-06\",\"invoiceCode\": \"137031892002\",\"serialNo\": \"997798241cb342299daa60df226d148a0\",\"checkFlag\": 1,\"totalAmount\": \"20.00\",\"taxRate\": \"0.030000\",\"salerAddressPhone\": \"\",\"checkTime\": \"\",\"buyerAccount\": \"\",\"authenticateTime\": \"\",\"rotationAngle\": \"0\",\"snapshotUrl\": \"https://api.kingdee.com/kdrive/user/file/thumbnail?client_idu003d200242u0026file_idu003d128390509u0026qualityu003d100u0026scodeu003dSk9rRlVPTldiR3JkLUIxbz1CUFlEu0026signu003df6dbbd77e0dfcf101a1940119d7f7634f0513ff2u0026widthu003d800\",\"isRevise\": \"2\",\"destinationPosition\": {\"area\": \"\u5f20\u5e97\u533a\",\"province\": \"\u5c71\u4e1c\u7701\",\"city\": \"\u6dc4\u535a\u5e02\"},\"time\": \"\",\"taxAmount\": \"0.58\",\"totalAmountCn\": \"\",\"region\": \"[0,0,722,401]\",\"expenseStatus\": \"60\"}]}";
            return this.buildResult(invoiceJson);
        }
        String url = AllInvoiceUrl.queryInvoice(this.getToken(this.invoiceOrgId, refreshToken));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("serialNo", this.serialNo);
        if (this.invoiceOrgId == null) {
            if (StringUtils.isNotBlank((CharSequence)this.taxNo)) {
                param.put("taxNo", this.taxNo);
            }
            if (StringUtils.isNotBlank((CharSequence)this.companyName)) {
                param.put("companyName", this.companyName);
            }
            param.put("ticketParam", KingdeeInvoiceCloudConfig.getTicketParam(this.taxNo));
        } else {
            InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(this.invoiceOrgId);
            param.put("taxNo", config.getTaxRegnum());
            param.put("companyName", config.getFirmname());
            param.put("ticketParam", config.genTicketParam());
        }
        param.put("bxd_key", this.bxdKey);
        String raw_response = this.doPost(url, param);
        log.info("\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u539f\u59cb\u6570\u636e:" + raw_response);
        return this.buildResult(raw_response);
    }

    @Override
    public String desc() {
        String fmt = ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u6839\u636e\u53d1\u7968\u5e8f\u5217\u53f7\u67e5\u8be2\u53d1\u7968\u8be6\u7ec6\u4fe1\u606f\uff1a{serialNo:%s}", (String)"QueryBySerialNoAction_0", (String)"fi-er-business", (Object[])new Object[0]);
        return String.format(fmt, this.serialNo);
    }

    @Deprecated
    public String processWhenDetailAmountisZero(String rawResp) {
        log.info("\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u521d\u59cb\u6570\u636e:" + rawResp);
        JSONObject resp = JSON.parseObject((String)rawResp);
        JSONArray jsonArray = resp.getJSONArray("data");
        boolean isProcessed = false;
        for (Object invoiceObj : jsonArray) {
            JSONObject invoice = (JSONObject)invoiceObj;
            if (!invoice.containsKey((Object)"items")) continue;
            HashMap<String, String> afterProcessItem = new HashMap<String, String>(9);
            long detailAmouitIsZeroItemCount = invoice.getJSONArray("items").stream().filter(item -> {
                String detailAmount = ((JSONObject)item).getString("detailAmount");
                return StringUtils.isBlank((CharSequence)detailAmount) || StringUtils.equals((CharSequence)detailAmount, (CharSequence)"0");
            }).count();
            if (detailAmouitIsZeroItemCount <= 0L) continue;
            String amount = invoice.getString("amount");
            String taxAmount = invoice.getString("taxAmount");
            BigDecimal taxRate = new BigDecimal(taxAmount).divide(new BigDecimal(amount), 6, RoundingMode.HALF_EVEN);
            afterProcessItem.put("unitPrice", amount);
            afterProcessItem.put("taxRate", taxRate.toString());
            afterProcessItem.put("unit", "");
            afterProcessItem.put("num", "1");
            afterProcessItem.put("detailAmount", amount);
            afterProcessItem.put("specModel", "");
            afterProcessItem.put("goodsCode", "");
            afterProcessItem.put("taxAmount", taxAmount);
            afterProcessItem.put("goodsName", ResManager.loadKDString((String)"\u6ce8\u610f:\u8fd9\u5f20\u53d1\u7968\u660e\u7ec6\u7531\u4e8e\u6709\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a0\u7684\u60c5\u51b5, \u56e0\u6b64\u8fd9\u4e2a\u539f\u6709\u53d1\u7968\u660e\u7ec6\u88ab\u4e00\u4e2a\u660e\u7ec6\u66ff\u6362\u4e86", (String)"QueryBySerialNoAction_1", (String)"fi-er-business", (Object[])new Object[0]));
            invoice.put("items", Collections.singletonList(afterProcessItem));
            invoice.put("validateMessage", (Object)String.format(ResManager.loadKDString((String)"%s&\u8fd9\u5f20\u53d1\u7968\u660e\u7ec6\u7531\u4e8e\u6709\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a0\u7684\u60c5\u51b5, \u56e0\u6b64\u8fd9\u4e2a\u539f\u6709\u53d1\u7968\u660e\u7ec6\u88ab\u4e00\u4e2a\u660e\u7ec6\u66ff\u6362\u4e86", (String)"QueryBySerialNoAction_3", (String)"fi-er-business", (Object[])new Object[0]), invoice.getString("validateMessage")));
            isProcessed = true;
        }
        if (isProcessed) {
            log.warn("\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u4fe1\u606f\u660e\u7ec6\u5df2\u88ab\u5904\u7406:" + resp.toJSONString());
        }
        return resp.toJSONString();
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public String getTaxNo() {
        return this.taxNo;
    }

    public void setTaxNo(String taxNo) {
        this.taxNo = taxNo;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getBxdKey() {
        return this.bxdKey;
    }

    public void setBxdKey(String bxdKey) {
        this.bxdKey = bxdKey;
    }

    public Long getInvoiceOrgId() {
        return this.invoiceOrgId;
    }

    public void setInvoiceOrgId(Long invoiceOrgId) {
        this.invoiceOrgId = invoiceOrgId;
    }
}

