/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.model;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.fi.er.business.invoicecloud.model.InvoiceItem;
import kd.fi.er.business.utils.InvoiceUtils;
import org.apache.commons.lang3.StringUtils;

public class Invoice {
    public static final String CR = System.lineSeparator();
    public static final String TAB = "\t";
    public static final BigDecimal HUNDRED = new BigDecimal("100");
    public static final String DEFAULT_INVOCE = "---";
    private final Date invoiceDate;
    private final String invoiceType;
    private final String invoiceNo;
    private final String invoiceCode;
    private final String serialNo;
    private final String salerName;
    private final String buyerName;
    private final String remark;
    private final String trip;
    private final BigDecimal amount;
    private final BigDecimal taxAmount;
    private final BigDecimal totalAmount;
    private final boolean fromInvoiceCloud;
    private final List<InvoiceItem> items = new ArrayList<InvoiceItem>();
    private final Set<String> mergedSerialNos = new HashSet<String>();
    private String keySerialNo;
    private final String validateMessage;
    private String passengerName;
    private BigDecimal airportConstructionFee;
    private String taxRatesTxt;

    public String toString() {
        SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd");
        return "invoiceDate: " + DF.format(this.invoiceDate) + TAB + "invoiceType: " + this.invoiceType + TAB + "invoiceNo: " + this.invoiceNo + TAB + "invoiceCode: " + this.invoiceCode + TAB + "serialNo: " + this.serialNo + TAB + "remark: " + this.remark + TAB + "trip: " + this.trip + TAB + "amount: " + this.amount.toString() + TAB + "taxAmount: " + this.taxAmount.toString() + TAB + "totalAmount: " + this.totalAmount.toString() + CR + this.items.toString();
    }

    public void clearFakeItem() {
        InvoiceItem item;
        if (this.items.size() > 1 && (item = this.items.get(0)).getDetailAmount().compareTo(this.amount) == 0 && item.getTaxAmount().compareTo(this.taxAmount) == 0) {
            this.items.remove(0);
        }
    }

    private Invoice(Builder builder) {
        this.invoiceDate = builder.invoiceDate;
        this.invoiceType = builder.invoiceType;
        this.invoiceNo = InvoiceUtils.getLimitedInvoiceNo(builder.invoiceNo);
        this.invoiceCode = InvoiceUtils.getLimitedInvoiceCode(builder.invoiceCode);
        this.serialNo = builder.serialNo;
        this.trip = builder.trip;
        this.amount = builder.amount;
        this.taxAmount = builder.taxAmount;
        this.totalAmount = builder.totalAmount;
        this.salerName = builder.salerName;
        this.buyerName = builder.buyerName;
        this.remark = builder.remark;
        this.validateMessage = builder.validateMessage;
        this.fromInvoiceCloud = builder.fromInvoiceCloud;
        this.mergedSerialNos.addAll(builder.mergedSerialNos);
        this.passengerName = builder.passengerName;
        this.airportConstructionFee = new BigDecimal(builder.airportConstructionFee);
        this.taxRatesTxt = builder.taxRatesTxt;
    }

    public void addItem(InvoiceItem.Builder itemBuilder) {
        this.items.add(itemBuilder.withParent(this).build());
    }

    public String getInvoiceType() {
        return this.invoiceType;
    }

    public String getInvoiceNo() {
        return InvoiceUtils.getLimitedInvoiceNo(this.invoiceNo);
    }

    public String getInvoiceCode() {
        return InvoiceUtils.getLimitedInvoiceCode(this.invoiceCode);
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public BigDecimal getTaxRate() {
        if (this.taxAmount == null || this.amount == null || this.taxAmount.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return this.taxAmount.multiply(HUNDRED).divide(this.amount, 2, 4);
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public Date getInvoiceDate() {
        return this.invoiceDate;
    }

    public List<InvoiceItem> getItems() {
        return new ArrayList<InvoiceItem>(this.items);
    }

    public String getRemark() {
        return this.remark;
    }

    public String getTrip() {
        return this.trip;
    }

    public String getSalerName() {
        return this.salerName;
    }

    public int getCount() {
        if (this.mergedSerialNos.size() == 0) {
            return 1;
        }
        return this.mergedSerialNos.size();
    }

    public Set<String> getMergedSerialNos() {
        return this.mergedSerialNos;
    }

    public boolean isFromInvoiceCloud() {
        return this.fromInvoiceCloud;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public String getValidateMessage() {
        if (this.validateMessage == null || this.validateMessage.trim().length() == 0) {
            return null;
        }
        return this.validateMessage;
    }

    public String getPassengerName() {
        return this.passengerName;
    }

    public void setPassengerName(String passengerName) {
        this.passengerName = passengerName;
    }

    public BigDecimal getAirportConstructionFee() {
        return this.airportConstructionFee;
    }

    public void setAirportConstructionFee(BigDecimal airportConstructionFee) {
        this.airportConstructionFee = airportConstructionFee;
    }

    public String getTaxRatesTxt() {
        return this.taxRatesTxt;
    }

    public void setTaxRatesTxt(String taxRatesTxt) {
        this.taxRatesTxt = taxRatesTxt;
    }

    public String getKeySerialNo() {
        return this.keySerialNo;
    }

    public void setKeySerialNo(String keySerialNo) {
        this.keySerialNo = keySerialNo;
    }

    public static class Builder {
        private DateFormat dFormat = new SimpleDateFormat("yyyy-MM-dd");
        private Date invoiceDate;
        private String invoiceType;
        private String invoiceNo;
        private String invoiceCode;
        private String serialNo;
        private String salerName;
        private String buyerName;
        private String remark;
        private String trip;
        private Set<String> mergedSerialNos = new HashSet<String>();
        private BigDecimal amount = BigDecimal.ZERO;
        private BigDecimal taxAmount = BigDecimal.ZERO;
        private BigDecimal totalAmount = BigDecimal.ZERO;
        private boolean fromInvoiceCloud;
        private String validateMessage;
        private String passengerName = "";
        private String airportConstructionFee = "0";
        private String taxRatesTxt = "";

        public Builder withInvoiceDate(String invoiceDate) {
            try {
                return this.withInvoiceDate(this.dFormat.parse(invoiceDate));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder withFromInvoiceCloud(boolean fromInvoiceCloud) {
            this.fromInvoiceCloud = fromInvoiceCloud;
            return this;
        }

        public Builder withInvoiceDate(Date date) {
            this.invoiceDate = date;
            return this;
        }

        public Builder withInvoiceType(String invoiceType) {
            this.invoiceType = invoiceType;
            return this;
        }

        public Builder withInvoiceNo(String invoiceNo) {
            this.invoiceNo = StringUtils.isBlank((CharSequence)invoiceNo) ? InvoiceUtils.getLimitedInvoiceNo(Invoice.DEFAULT_INVOCE) : InvoiceUtils.getLimitedInvoiceNo(invoiceNo);
            return this;
        }

        public Builder withInvoiceCode(String invoiceCode) {
            this.invoiceCode = StringUtils.isBlank((CharSequence)invoiceCode) ? InvoiceUtils.getLimitedInvoiceCode(Invoice.DEFAULT_INVOCE) : InvoiceUtils.getLimitedInvoiceCode(invoiceCode);
            return this;
        }

        public Builder withSerialNo(String serialNo) {
            this.serialNo = serialNo;
            return this;
        }

        public Builder withSalerName(String salerName) {
            this.salerName = salerName;
            return this;
        }

        public Builder withBuyerName(String buyerName) {
            this.buyerName = buyerName;
            return this;
        }

        public Builder withRemark(String remark) {
            this.remark = remark;
            return this;
        }

        public Builder withTrip(String trip) {
            this.trip = trip;
            return this;
        }

        public Builder withAmount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public Builder withTaxAmount(BigDecimal taxAmount) {
            this.taxAmount = taxAmount;
            return this;
        }

        public Builder withTotalAmount(BigDecimal totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder withMergeSerialNos(String mergeSerialNos) {
            this.mergedSerialNos = new HashSet<String>(Arrays.asList(mergeSerialNos.split(",")));
            return this;
        }

        public Builder withValidateMessage(String validateMessage) {
            this.validateMessage = validateMessage;
            return this;
        }

        public Builder withPassengerName(String passengerName) {
            this.passengerName = passengerName;
            return this;
        }

        public Builder withAirportConstructionFee(String airportConstructionFee) {
            this.airportConstructionFee = airportConstructionFee;
            return this;
        }

        public Builder withTaxs(String taxRatesTxt) {
            this.taxRatesTxt = taxRatesTxt;
            return this;
        }

        public Invoice build() {
            return new Invoice(this);
        }
    }
}

