/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.model;

import java.math.BigDecimal;
import kd.fi.er.business.invoicecloud.model.Invoice;

public class InvoiceItem {
    private final BigDecimal taxRate;
    private final BigDecimal detailAmount;
    private final BigDecimal taxAmount;
    private final String goodsCode;
    private final String goodsName;
    private final Invoice parent;
    private BigDecimal airportConstructionFee = BigDecimal.ZERO;

    public String toString() {
        return "taxRate: " + this.taxRate.toString() + "\t" + "detailAmount: " + this.detailAmount.toString() + "\t" + "taxAmount: " + this.taxAmount.toString() + "\t" + "goodsCode: " + this.goodsCode + "\t" + "goodsName: " + this.goodsName;
    }

    private InvoiceItem(Builder builder) {
        this.taxRate = builder.taxRate;
        this.detailAmount = builder.detailAmount;
        this.taxAmount = builder.taxAmount;
        this.goodsCode = builder.goodsCode;
        this.goodsName = builder.goodsName;
        this.parent = builder.parent;
        this.airportConstructionFee = builder.airportConstructionFee;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public BigDecimal getDetailAmount() {
        return this.detailAmount;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public BigDecimal getTotalAmount() {
        return this.detailAmount.add(this.taxAmount);
    }

    public String getGoodsCode() {
        return this.goodsCode;
    }

    public Invoice getParent() {
        return this.parent;
    }

    public String getGoodsName() {
        return this.goodsName;
    }

    public BigDecimal getAirportConstructionFee() {
        return this.airportConstructionFee;
    }

    public void setAirportConstructionFee(BigDecimal airportConstructionFee) {
        this.airportConstructionFee = airportConstructionFee;
    }

    public static class Builder {
        private BigDecimal taxRate;
        private BigDecimal detailAmount;
        private BigDecimal taxAmount;
        private String goodsCode;
        private String goodsName;
        private Invoice parent;
        private BigDecimal airportConstructionFee;

        public Builder withTaxRate(BigDecimal taxRate) {
            this.taxRate = taxRate;
            return this;
        }

        public Builder withDetailAmount(BigDecimal detailAmount) {
            this.detailAmount = detailAmount;
            return this;
        }

        public Builder withTaxAmount(BigDecimal taxAmount) {
            this.taxAmount = taxAmount;
            return this;
        }

        public Builder withGoodsCode(String goodsCode) {
            this.goodsCode = goodsCode;
            return this;
        }

        public Builder withGoodsName(String goodsName) {
            this.goodsName = goodsName;
            return this;
        }

        Builder withParent(Invoice parent) {
            this.parent = parent;
            return this;
        }

        public Builder withAriportConstructionFee(BigDecimal ariportConstructionFee) {
            this.airportConstructionFee = ariportConstructionFee;
            return this;
        }

        InvoiceItem build() {
            return new InvoiceItem(this);
        }
    }
}

