/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.provider.service.std;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceStatusEnum;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.model.AWSInvoiceData;
import kd.fi.er.business.invoicecloud.provider.param.req.EditInvoiceIframeReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.ImportInvoiceIframeUrlReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.InvoiceUnbindUrlReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.ShowInvoiceUrlReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.UpdateInvoiceStatusReqParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.IframeParam;
import kd.fi.er.business.invoicecloud.provider.service.InvoiceServiceForPC;
import kd.fi.er.business.invoicecloud.provider.service.factory.InvoiceServiceFactory;
import kd.fi.er.business.invoicecloud.provider.service.std.CommonInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.util.AllInvoiceUrl;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.utils.Er;
import kd.fi.er.common.utils.MD5;
import org.apache.commons.lang3.StringUtils;

public class InvoiceServiceForPCImpl
implements InvoiceServiceForPC {
    private static final Log log = LogFactory.getLog(InvoiceServiceForPCImpl.class);
    private static final Random rand = new SecureRandom();

    @Override
    public IframeParam getImportInvoiceIframeParam(ImportInvoiceIframeUrlReqParam request, IFormView formView) throws InvoiceCloudException {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String linkKey = UUID.randomUUID().toString().replace("-", "");
        InvoiceCloudCfgBO config = request.getInvoiceCompanyId() != null ? KingdeeInvoiceCloudConfig.getConfig(request.getInvoiceCompanyId()) : KingdeeInvoiceCloudConfig.getConfig(request.getTaxRegNum());
        Map<String, String> urlParams = this.getInvoicePCPageCommonParams(config, timestamp);
        urlParams.put("billNumber", "0");
        boolean showBindingInvoice = ErStdConfig.isShowBindingInvoice();
        if (!showBindingInvoice) {
            urlParams.put("invoiceSerialNos", request.getSerialNo());
        }
        urlParams.put("bxd_key", (String)StringUtils.defaultIfBlank((CharSequence)request.getBillId(), (CharSequence)"0"));
        urlParams.put("linkKey", linkKey);
        String optMode = StringUtils.isBlank((CharSequence)request.getOptMode()) ? "0" : request.getOptMode();
        urlParams.put("optMode", optMode);
        String gridParam = ErStdConfig.gridParam();
        urlParams.put("gridParam", gridParam);
        urlParams.put("resource", "4");
        String url = KingdeeInvoiceCloudConfig.getInvoiceSelectURL_PC();
        Map<String, String> params = this.getInvoicePCPageSocketParams(config, timestamp, linkKey, formView.getPageId());
        params.put("actionType", "selectInvoice");
        String socketUrl = this.getCtxPath() + "/ws.html?" + this.transferMapToUrlParam(params);
        log.info(String.format("\u9009\u62e9\u53d1\u7968\u7684url:%1$s socketurl:%2$s", url, socketUrl));
        IframeParam iframeParam = new IframeParam();
        iframeParam.setUrl(url);
        iframeParam.setSocketUrl(socketUrl);
        Map<String, Object> temp = urlParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue()));
        iframeParam.setContent(temp);
        return iframeParam;
    }

    @Override
    public IframeParam getShowInvoiceIframeParam(ShowInvoiceUrlReqParam request, IFormView formView) throws InvoiceCloudException {
        UpdateInvoiceStatusReqParam updateInvocieRequest = new UpdateInvoiceStatusReqParam();
        InvoiceCloudCfgBO config = request.getOrgId() != null ? KingdeeInvoiceCloudConfig.getConfig(request.getOrgId()) : KingdeeInvoiceCloudConfig.getConfig(request.getTaxRegNum());
        updateInvocieRequest.setBillId(request.getBillId());
        updateInvocieRequest.setBillNumber(request.getBillNumber());
        updateInvocieRequest.setInvoiceStatus(InvoiceStatusEnum.save);
        updateInvocieRequest.setSerialNos(request.getSerialNos());
        ArrayList awsInvoiceDatas = Lists.newArrayListWithExpectedSize((int)request.getSerialNos().size());
        for (String serialNo : request.getSerialNos()) {
            AWSInvoiceData awsInvoiceData = new AWSInvoiceData();
            awsInvoiceData.setSerialNo(serialNo);
            awsInvoiceDatas.add(awsInvoiceData);
        }
        updateInvocieRequest.setInvoiceData(awsInvoiceDatas);
        updateInvocieRequest.setTaxRegNum(request.getTaxRegNum());
        updateInvocieRequest.setTicketParam(config.genTicketParam());
        updateInvocieRequest.setOrgId(request.getOrgId());
        try {
            CommonInvoiceServiceImpl singletonService = InvoiceServiceFactory.getSingletonService(CommonInvoiceServiceImpl.class);
            if (singletonService == null) {
                log.info("\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230CommonInvoiceService\u670d\u52a1\u3002");
                throw new Exception(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230CommonInvoiceService\u670d\u52a1\u3002", (String)"InvoiceServiceForPCImpl_3", (String)"fi-er-business", (Object[])new Object[0]));
            }
            singletonService.updateInvoiceStatus(updateInvocieRequest);
        }
        catch (Exception e2) {
            log.info(e2.getMessage());
        }
        String timestamp = String.valueOf(System.currentTimeMillis());
        Map<String, String> urlParams = this.getInvoicePCPageCommonParams(config, timestamp);
        urlParams.put("billNumber", request.getBillId());
        urlParams.put("bxd_key", request.getBillId());
        String optMode = StringUtils.isBlank((CharSequence)request.getOptMode()) ? "0" : request.getOptMode();
        urlParams.put("optMode", optMode);
        String linkKey = UUID.randomUUID().toString().replace("-", "");
        urlParams.put("linkKey", linkKey);
        String gridParam = ErStdConfig.gridParam();
        urlParams.put("gridParam", gridParam);
        if (!StringUtils.isBlank((CharSequence)request.getRelevanceExpenseId())) {
            urlParams.put("relevanceExpenseId", request.getRelevanceExpenseId());
        }
        String url = KingdeeInvoiceCloudConfig.getInvoiceListURL_PC();
        log.info("\u67e5\u770b\u53d1\u7968\u5217\u8868url:" + url);
        IframeParam iframeParam = new IframeParam();
        iframeParam.setUrl(url);
        Map<String, Object> temp = urlParams.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
        iframeParam.setContent(temp);
        return iframeParam;
    }

    @Override
    public IframeParam getDeleteAttachIframeParam(ImportInvoiceIframeUrlReqParam request, IFormView formView) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        InvoiceCloudCfgBO config = request.getInvoiceCompanyId() != null ? KingdeeInvoiceCloudConfig.getConfig(request.getInvoiceCompanyId()) : KingdeeInvoiceCloudConfig.getConfig(request.getTaxRegNum());
        Map<String, String> urlParams = this.getInvoicePCPageCommonParams(config, timestamp);
        String billNumber = (String)StringUtils.defaultIfBlank((CharSequence)request.getBillId(), (CharSequence)"0");
        urlParams.put("billNumber", billNumber);
        urlParams.put("bxd_key", billNumber);
        String linkKey = UUID.randomUUID().toString().replace("-", "");
        urlParams.put("linkKey", linkKey);
        String url = AllInvoiceUrl.getDeleteAttachPCPageUrl();
        Map<String, String> params = this.getInvoicePCPageSocketParams(config, timestamp, linkKey, formView.getPageId());
        params.put("actionType", "deleteattach");
        String socketUrl = this.getCtxPath() + "/ws.html?" + this.transferMapToUrlParam(params);
        log.info(String.format("\u5220\u9664\u9644\u4ef6\u7684url:%1$s socketurl:%2$s", url, socketUrl));
        IframeParam iframeParam = new IframeParam();
        iframeParam.setUrl(url);
        iframeParam.setSocketUrl(socketUrl);
        Map<String, Object> temp = urlParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue()));
        iframeParam.setContent(temp);
        return iframeParam;
    }

    @Override
    public IframeParam getInvocieUnbindUrl(InvoiceUnbindUrlReqParam request, IFormView formView) throws InvoiceCloudException {
        IframeParam iframeParam = new IframeParam();
        String invoiceUnbindSrc = "";
        RequestContext reqCon = RequestContext.get();
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(reqCon.getOrgId());
        if (config == null) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u672a\u542f\u7528\u53d1\u7968\u4e91\u914d\u7f6e\uff0c\u8bf7\u542f\u7528\u6216\u8005\u5207\u6362\u81f3\u5df2\u542f\u7528\u53d1\u7968\u4e91\u914d\u7f6e\u7684\u7ec4\u7ec7\u3002", (String)"InvoiceServiceForPCImpl_0", (String)"fi-er-business", (Object[])new Object[0]));
            return iframeParam;
        }
        String clientId = config.getClientId();
        String clientSecret = config.getClientSecret();
        Long timestamp = System.currentTimeMillis();
        String sign = MD5.md5crypt((String)(clientId.trim() + clientSecret.trim() + timestamp));
        Long userID = Long.valueOf(reqCon.getUserId());
        DynamicObject user = QueryServiceHelper.queryOne((String)"bos_user", (String)"id, email, phone", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userID)});
        String userPhone = user.getString("phone");
        userPhone = userPhone == null ? "" : userPhone;
        String userEmail = user.getString("email");
        userEmail = userEmail == null ? "" : userEmail;
        HashMap params = Maps.newHashMap();
        params.put("client_id", clientId.trim());
        params.put("sign", sign);
        params.put("timestamp", timestamp);
        params.put("eid", userID);
        params.put("phone", userPhone);
        params.put("email", userEmail);
        log.info("client_id : " + clientId + ", sign : " + sign + ", timestamp : " + timestamp + ", eid: " + userID);
        Map returnMap = null;
        String gainCodeUrl = ErStdConfig.getInvoiceUnbindAuthCode();
        try {
            returnMap = (Map)Er.jsonToObj((String)HttpServiceHelper.doPost(gainCodeUrl, params), Map.class);
        }
        catch (Exception e) {
            log.info("invoiceCloud intel error , info : " + e.getMessage());
            return iframeParam;
        }
        String authCode = (String)returnMap.get("auth_code");
        if (authCode == null) {
            log.info(String.format("authCode is null , info : %s ", authCode));
            formView.showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u4e91\u8bf7\u6c42\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53d1\u7968\u4e91\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvoiceServiceForPCImpl_1", (String)"fi-er-business", (Object[])new Object[0]));
            return iframeParam;
        }
        String src = ErStdConfig.getInvoiceUnbind();
        invoiceUnbindSrc = src + authCode.trim();
        log.info("invoiceUnbindSrc : " + invoiceUnbindSrc);
        iframeParam.setUrl(invoiceUnbindSrc);
        return iframeParam;
    }

    @Override
    public IframeParam getEditInvoiceIframeParam(EditInvoiceIframeReqParam request, IFormView formView) throws InvoiceCloudException {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String linkKey = UUID.randomUUID().toString().replace("-", "");
        InvoiceCloudCfgBO config = request.getOrgId() != null ? KingdeeInvoiceCloudConfig.getConfig(request.getOrgId()) : KingdeeInvoiceCloudConfig.getConfig(request.getTaxRegNum());
        Map<String, String> urlParams = this.getInvoicePCPageCommonParams(config, timestamp);
        urlParams.put("billNumber", "0");
        urlParams.put("indexType", "kingdeecq000");
        urlParams.put("gridParam", ErStdConfig.gridParam());
        urlParams.put("serialNo", request.getSerialNo());
        urlParams.put("linkKey", linkKey);
        String editInvoiceUrlPc = AllInvoiceUrl.getEditInvoiceUrlPc();
        String url = editInvoiceUrlPc + "?" + this.transferMapToUrlParam(urlParams);
        Map<String, String> params = this.getInvoicePCPageSocketParams(config, timestamp, linkKey, formView.getPageId());
        params.put("actionType", "editInvoice");
        String socketUrl = this.getCtxPath() + "/ws.html?" + this.transferMapToUrlParam(params);
        log.info(String.format("\u4fee\u6539\u53d1\u7968\u7684url:%1$s socketurl:%2$s", url, socketUrl));
        IframeParam iframeParam = new IframeParam();
        iframeParam.setUrl(url);
        iframeParam.setSocketUrl(socketUrl);
        return iframeParam;
    }

    private Map<String, String> getInvoicePCPageSocketParams(InvoiceCloudCfgBO config, String timestamp, String linkKey, String pageId) {
        RequestContext requestContext = RequestContext.get();
        String userId = requestContext.getUserId();
        String taxRegNum = config.getTaxRegnum();
        String client_id = config.getClientId();
        String client_secret = config.getClientSecret();
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("timestamp", String.valueOf(timestamp));
        urlParams.put("client_id", client_id);
        urlParams.put("tin", taxRegNum);
        String rawSign = client_id + client_secret + timestamp;
        urlParams.put("sign", MD5.md5crypt((String)rawSign));
        urlParams.put("eid", userId);
        urlParams.put("pageid", pageId);
        urlParams.put("clientType", "pc");
        urlParams.put("linkKey", linkKey);
        urlParams.put("env", ErStdConfig.isProduct() ? "prod" : "test");
        return urlParams;
    }

    private Map<String, String> getInvoicePCPageCommonParams(InvoiceCloudCfgBO config, String timestamp) {
        RequestContext requestContext = RequestContext.get();
        String userId = requestContext.getUserId();
        String taxRegNum = config.getTaxRegnum();
        String client_id = config.getClientId();
        String client_secret = config.getClientSecret();
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("timestamp", timestamp);
        urlParams.put("client_id", client_id);
        urlParams.put("tin", taxRegNum);
        String companyName = config.getFirmname();
        if (StringUtils.isEmpty((CharSequence)companyName)) {
            companyName = "no company name";
        }
        urlParams.put("ghf_mc", companyName);
        String rawSign = client_id + client_secret + taxRegNum + userId + timestamp;
        urlParams.put("sign", MD5.md5crypt((String)rawSign));
        urlParams.put("eid", userId);
        urlParams.put("random", String.valueOf(rand.nextInt(Integer.MAX_VALUE)));
        urlParams.put("reqid", AllInvoiceUrl.getRequestId());
        urlParams.put("ticketParam", config.genTicketParam());
        return urlParams;
    }

    private String getCtxPath() {
        return RequestContext.get().getClientFullContextPath() + "invoicecloud";
    }

    private String transferMapToUrlParam(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        String urlParam = map.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        return urlParam;
    }

    @Override
    public String getShowMessageBeforeCloseImportInvoicePage() {
        return ResManager.loadKDString((String)"\u5173\u95ed\u7a97\u53e3\u540e\uff0c\u518d\u6b21\u6253\u5f00\u9700\u91cd\u65b0\u626b\u63cf\u3002\u662f\u5426\u786e\u8ba4\u5173\u95ed\uff1f", (String)"InvoiceServiceForPCImpl_2", (String)"fi-er-business", (Object[])new Object[0]);
    }
}

