/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.common.model.invoice.AttachVo;

public class TInvoiceAttachUpgradeTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(TInvoiceAttachUpgradeTask.class);
    private static final int BATCH_SIZE = 2000;
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)TInvoiceAttachUpgradeTask.class.getName(), (int)(Runtime.getRuntime().availableProcessors() * 2));
    private static final String ATTACH_INFO_TABLE_NAME = "t_er_invoiceattachinfo";
    private static final String INSERT_ATTACH_ENTRY_SQL = "insert into t_er_invoiceattachinfo(fid, fentryid, fattachno, fattachname, foriginalname, fattachtype, fattachurl, fgathertime, fattachremark) values (?, ?, ?, ?, ?, ?, ?, ?, ?);";
    private static final String UPDATE_SQL = "update T_ER_INVATTACHHB set fisupgrade = '1', fupgradetime = ? where fid = ?";
    private static final String UPDATE_NO_ATTACH_SQL = "update T_ER_INVATTACHHB set fisupgrade = '2', fupgradetime = ? where fid = ?";
    private static final String SELECT_SQL = "select fid, fbillno, fcostcompany, fentityname from T_ER_INVATTACHHB where fisupgrade = '0'";
    private static final String COUNT_SQL = "select count(1) as count from T_ER_INVATTACHHB where fisupgrade = '0';";
    private static final String BATCH_SELECT_SQL = "select top %s, %s fid, fbillno, fcostcompany, fentityname from T_ER_INVATTACHHB where fisupgrade = '0'";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean enableXh = KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud();
        if (enableXh) {
            return;
        }
        logger.info("TInvoiceAttachUpgradeTask -> start");
        long startTime = System.nanoTime();
        try {
            DB.query((DBRoute)DBRoute.of((String)"er"), (String)COUNT_SQL, resultSet -> {
                while (resultSet.next()) {
                    long count = resultSet.getLong("count");
                    logger.info(String.format("TInvoiceAttachUpgradeTask -> history bill total: %d", count));
                    if (count == 0L) {
                        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                        scheduleManager.disableSchedule("3BIE3=A/UN90");
                        continue;
                    }
                    if (count < 2000L) {
                        this.batchHandleBills(requestContext, SELECT_SQL);
                        continue;
                    }
                    int i = 0;
                    while ((long)i < count) {
                        String select = String.format(BATCH_SELECT_SQL, 2000, i);
                        this.batchHandleBills(requestContext, select);
                        i += 2000;
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Object)e);
        }
        finally {
            if (THREAD_POOL != null) {
                THREAD_POOL.close();
            }
        }
        long endTime = System.nanoTime();
        logger.info(String.format("TInvoiceAttachUpgradeTask -> end, total cost time : %d", endTime - startTime));
    }

    private void batchHandleBills(RequestContext requestContext, String sql) {
        ArrayList historyBills = new ArrayList(2000);
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, resultSet1 -> {
            while (resultSet1.next()) {
                Long fid = resultSet1.getLong("fid");
                Long costCompanyId = resultSet1.getLong("fcostcompany");
                String entityName = resultSet1.getString("fentityname");
                String billNo = resultSet1.getString("fbillno");
                historyBills.add(new Object[]{fid, billNo, entityName, costCompanyId});
            }
            return null;
        });
        logger.info("TInvoiceAttachUpgradeTask - > historyBill.size : " + historyBills.size());
        long startTime = System.nanoTime();
        int batchSize = 10;
        int batchCount = historyBills.size() / batchSize + (historyBills.size() % batchSize == 0 ? 0 : 1);
        CountDownLatch countDownLatch = new CountDownLatch(batchCount);
        for (int i = 0; i < historyBills.size(); i += batchSize) {
            List batch = historyBills.stream().skip(i).limit(batchSize).collect(Collectors.toList());
            BatchTask runnable = new BatchTask(batch, countDownLatch);
            THREAD_POOL.execute((Runnable)runnable, requestContext);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        long endTime = System.nanoTime();
        logger.info(String.format("TInvoiceAttachUpgradeTask -> batch cost time : %d", endTime - startTime));
    }

    private void insertNewRecords(List<Object[]> newRecords, List<Long> noAttachBillIds) {
        if (newRecords.size() > 0) {
            long[] ids = DB.genLongIds((String)ATTACH_INFO_TABLE_NAME, (int)newRecords.size());
            for (int j = 0; j < ids.length; ++j) {
                newRecords.get((int)j)[1] = ids[j];
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)INSERT_ATTACH_ENTRY_SQL, newRecords);
        }
        Set<Long> billIds = newRecords.stream().map(e -> (Long)e[0]).collect(Collectors.toSet());
        this.updateUpgradeDate(billIds, false);
        this.updateUpgradeDate(new HashSet<Long>(noAttachBillIds), true);
        newRecords.clear();
        noAttachBillIds.clear();
    }

    private void updateUpgradeDate(Set<Long> billIds, boolean noAttach) {
        if (billIds.size() <= 0) {
            return;
        }
        ArrayList<Object[]> data = new ArrayList<Object[]>(billIds.size());
        Date date = new Date();
        for (Long fid : billIds) {
            data.add(new Object[]{date, fid});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)(noAttach ? UPDATE_NO_ATTACH_SQL : UPDATE_SQL), data);
    }

    class BatchTask
    implements Runnable {
        private List<Object[]> batch;
        private CountDownLatch countDownLatch;

        public BatchTask(List batch, CountDownLatch countDownLatch) {
            this.batch = batch;
            this.countDownLatch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ArrayList<Object[]> newRecords = new ArrayList<Object[]>(this.batch.size());
                ArrayList<Long> noAttachBillIds = new ArrayList<Long>(1);
                for (Object[] bill : this.batch) {
                    Long costCompanyId;
                    String billNo;
                    Long fid;
                    String entityName = (String)bill[2];
                    List<AttachVo> attachVoList = APIHelper.queryInvoiceAttach(entityName, fid = (Long)bill[0], billNo = (String)bill[1], costCompanyId = (Long)bill[3]);
                    if (attachVoList == null || attachVoList.size() == 0) {
                        noAttachBillIds.add(fid);
                    } else {
                        for (AttachVo attachVo : attachVoList) {
                            String attachNo = attachVo.getAttachNo();
                            String attachName = attachVo.getAttachName();
                            String foriginal_name = attachVo.getOriginalName();
                            String fattach_type = attachVo.getAttachType();
                            String fattach_url = attachVo.getAttachUrl();
                            Date fcreate_time = attachVo.getGatherTime();
                            String fremark = attachVo.getRemark() == null ? "" : attachVo.getRemark();
                            logger.info("TInvoiceAttachUpgradeTask -> handleBills billid\uff1a" + fid + ", attachNo\uff1a" + attachNo);
                            newRecords.add(new Object[]{fid, 0, attachNo, attachName, foriginal_name, fattach_type, fattach_url, fcreate_time, fremark});
                        }
                    }
                    if (newRecords.size() < 2000 && noAttachBillIds.size() <= 2000) continue;
                    TInvoiceAttachUpgradeTask.this.insertNewRecords(newRecords, noAttachBillIds);
                }
                if (newRecords.size() > 0 || noAttachBillIds.size() > 0) {
                    TInvoiceAttachUpgradeTask.this.insertNewRecords(newRecords, noAttachBillIds);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

