/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.util;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.er.business.billingpool.util.BillingPoolConfigUtils;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.servicehelper.operation.ErOperationServiceHelper;
import kd.fi.er.common.model.invoice.pool.PoolAmountModel;
import kd.fi.er.common.model.invoice.pool.PoolExpenseModel;
import kd.fi.er.common.model.invoice.pool.PoolGenerateModel;
import kd.fi.er.common.model.invoice.pool.PoolHeadModel;
import kd.fi.er.common.model.invoice.pool.PoolOtherModel;
import kd.fi.er.common.model.invoice.pool.PoolRelation;
import kd.fi.er.common.model.invoice.pool.PoolRelationModel;
import kd.fi.er.common.model.invoice.pool.PoolResultModel;
import kd.fi.er.common.model.invoice.pool.PoolSellerPurchaserModel;
import kd.fi.er.common.model.invoice.pool.PoolTravelModel;
import kd.fi.er.common.model.invoice.pool.PoolVehicleModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BillingPoolUtils {
    private static final Log log = LogFactory.getLog(BillingPoolUtils.class);

    public static PoolResultModel createPoolDynamicOb(List<PoolGenerateModel> poolModels) {
        InvoiceLogUtils.insertLog(InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, "", InvoiceLogUtils.InvoiceOpType.WEB_REQUEST.getDesc(), JSONObject.toJSONString(poolModels));
        if (CollectionUtils.isEmpty(poolModels)) {
            PoolResultModel resultModel = new PoolResultModel();
            resultModel.setSuccess(Boolean.valueOf(false));
            resultModel.setErrorMsg("poolModels is null.");
            return resultModel;
        }
        List<DynamicObject> dynamicObjects = BillingPoolUtils.generatePoolDynamicOb(poolModels);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"er_billingpool");
        Object[] dynamicObjectArray = (DynamicObject[])dynamicObjects.stream().toArray(DynamicObject[]::new);
        BusinessDataReader.loadRefence((Object[])dynamicObjectArray, (IDataEntityType)entityType);
        BillingPoolUtils.executeBusiness(dynamicObjects);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("skipCheckDataPermission", String.valueOf(true));
        option.setVariableValue("hadCheckOverValidator", String.valueOf(true));
        OperationResult operationResult = ErOperationServiceHelper.localInvokeOperation("submit", (DynamicObject[])dynamicObjectArray, option);
        boolean success = operationResult.isSuccess();
        PoolResultModel resultModel = new PoolResultModel();
        resultModel.setSuccess(Boolean.valueOf(success));
        if (!success) {
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            String errorMsg = allErrorOrValidateInfo.stream().map(info -> info.getMessage()).collect(Collectors.joining());
            if (StringUtils.isEmpty((CharSequence)errorMsg)) {
                errorMsg = operationResult.getMessage();
            }
            resultModel.setErrorMsg(errorMsg);
        } else {
            List successPkIds = operationResult.getSuccessPkIds();
            DynamicObject[] loadPools = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)entityType);
            ArrayList<PoolRelation> poolRelations = new ArrayList<PoolRelation>(poolModels.size());
            for (DynamicObject poolDynamicObject : loadPools) {
                PoolRelation poolRelation = new PoolRelation();
                poolRelation.setPoolId((Long)poolDynamicObject.getPkValue());
                poolRelation.setPoolBillNo(poolDynamicObject.getString("billno"));
                DynamicObjectCollection voucherEntity = poolDynamicObject.getDynamicObjectCollection("voucherentity");
                if (!voucherEntity.isEmpty()) {
                    DynamicObject relationObject = (DynamicObject)voucherEntity.get(0);
                    poolRelation.setBillId(Long.valueOf(relationObject.getString("relbillid")));
                    poolRelation.setEntryId(Long.valueOf(relationObject.getLong("relentryid")));
                }
                poolRelations.add(poolRelation);
            }
            resultModel.setPoolRelation(poolRelations);
        }
        return resultModel;
    }

    private static void executeBusiness(List<DynamicObject> dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject invoiceType = dynamicObject.getDynamicObject("invoicetype");
            if (invoiceType == null) continue;
            if (1327558123443004416L == (Long)invoiceType.getPkValue() || 1327558257006475264L == (Long)invoiceType.getPkValue()) {
                dynamicObject.set("showvehicle", (Object)true);
            }
            if (!invoiceType.getBoolean("istransportinvoice")) continue;
            dynamicObject.set("showtrip", (Object)true);
        }
    }

    public static List<DynamicObject> generatePoolDynamicOb(List<PoolGenerateModel> poolModels) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(poolModels.size());
        long[] ids = ORM.create().genLongIds("er_billingpool", poolModels.size());
        for (int i = 0; i < poolModels.size(); ++i) {
            List poolRelationModels;
            PoolOtherModel otherModel;
            List poolExpenseModels;
            PoolAmountModel poolAmountModel;
            PoolVehicleModel poolVehicleModel;
            PoolTravelModel poolTravelModel;
            PoolSellerPurchaserModel sellerPurchaserModel;
            PoolGenerateModel poolModel = poolModels.get(i);
            long id = ids[i];
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"er_billingpool");
            QFilter poolTypeFilter = new QFilter("number", "=", (Object)"01");
            DynamicObject billPoolType = BusinessDataServiceHelper.loadSingleFromCache((String)"er_bd_billingpool_type", (QFilter[])new QFilter[]{poolTypeFilter});
            Long poolTypeId = 0L;
            if (billPoolType != null) {
                poolTypeId = (Long)billPoolType.getPkValue();
            }
            Long billTypeId = 0L;
            QFilter billTypeFilter = new QFilter("number", "=", (Object)"er_billingpool_BT_GENERIC");
            DynamicObject billType = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (QFilter[])new QFilter[]{billTypeFilter});
            if (billPoolType != null) {
                billTypeId = (Long)billType.getPkValue();
            }
            PoolHeadModel poolHeadModel = poolModel.getPoolHeadModel();
            QFilter taxRateFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_taxrate", (Long)poolHeadModel.getCostCompanyId());
            taxRateFilter.and("taxcategoryid", "=", (Object)1L);
            DynamicObjectCollection taxRateBaseData = QueryServiceHelper.query((String)"bd_taxrate", (String)"id,taxrate", (QFilter[])new QFilter[]{taxRateFilter});
            Map<BigDecimal, List<DynamicObject>> taxRateMap = taxRateBaseData.stream().collect(Collectors.groupingBy(taxRate -> taxRate.getBigDecimal("taxrate").stripTrailingZeros()));
            if (poolHeadModel != null) {
                Date date = new Date();
                poolHeadModel.setId(Long.valueOf(id));
                dynamicObject.set("id", (Object)id);
                String billNumber = CodeRuleServiceHelper.getNumber((String)"er_billingpool", (DynamicObject)dynamicObject, (String)String.valueOf(RequestContext.get().getOrgId()));
                dynamicObject.set("billno", (Object)billNumber);
                dynamicObject.set("isexpensesync", (Object)Boolean.TRUE);
                dynamicObject.set("name", (Object)poolHeadModel.getBillNo());
                dynamicObject.set("applier_id", (Object)poolHeadModel.getApplierId());
                dynamicObject.set("creator_id", (Object)poolHeadModel.getApplierId());
                dynamicObject.set("createtime", (Object)date);
                dynamicObject.set("modifier_id", (Object)poolHeadModel.getApplierId());
                dynamicObject.set("modifytime", (Object)date);
                dynamicObject.set("auditor_id", (Object)poolHeadModel.getApplierId());
                dynamicObject.set("auditdate", (Object)date);
                dynamicObject.set("gather_id", (Object)(poolHeadModel.getGatherId() == null ? poolHeadModel.getApplierId() : poolHeadModel.getGatherId()));
                dynamicObject.set("company_id", (Object)poolHeadModel.getCompanyId());
                dynamicObject.set("costdept_id", (Object)poolHeadModel.getCostDeptId());
                dynamicObject.set("costcompany_id", (Object)poolHeadModel.getCostCompanyId());
                dynamicObject.set("org_id", (Object)poolHeadModel.getOrgId());
                Long validateOrgId = poolHeadModel.getValidateOrgId();
                if (validateOrgId == null || validateOrgId == 0L) {
                    validateOrgId = poolHeadModel.getCostCompanyId();
                }
                dynamicObject.set("validateorg_id", (Object)validateOrgId);
                dynamicObject.set("invoicetype_id", (Object)poolHeadModel.getInvoiceTypeId());
                dynamicObject.set("billpooltype_id", (Object)(poolHeadModel.getBillPoolTypeId() == null ? poolTypeId : poolHeadModel.getBillPoolTypeId()));
                dynamicObject.set("billtype_id", (Object)(poolHeadModel.getBillTypeId() == null ? billTypeId : poolHeadModel.getBillTypeId()));
                dynamicObject.set("country_id", (Object)poolHeadModel.getCountryId());
                dynamicObject.set("countrystr", (Object)poolHeadModel.getCountryStr());
                List projectower = poolHeadModel.getProjectower();
                if (CollectionUtils.isNotEmpty((Collection)projectower)) {
                    DynamicObjectCollection projectowerCollection = dynamicObject.getDynamicObjectCollection("projectower");
                    for (Long projectowerId : projectower) {
                        DynamicObject projectowerDO = projectowerCollection.addNew();
                        projectowerDO.set("fbasedataid_id", (Object)projectowerId);
                    }
                }
                dynamicObject.set("invoiceDate", (Object)poolHeadModel.getInvoiceDate());
                dynamicObject.set("expiryPayDate", (Object)poolHeadModel.getExpiryPayDate());
                dynamicObject.set("invoiceNo", (Object)poolHeadModel.getInvoiceNo());
                dynamicObject.set("invoiceCode", (Object)poolHeadModel.getInvoiceCode());
                dynamicObject.set("projecttype_id", (Object)poolHeadModel.getProjectTypeId());
                dynamicObject.set("headexpenseitem_id", (Object)poolHeadModel.getExpenseItemId());
                dynamicObject.set("invoicecurrency_id", (Object)poolHeadModel.getInvoiceCurrencyId());
                dynamicObject.set("currency_id", (Object)poolHeadModel.getCurrencyId());
                dynamicObject.set("proxyMark", (Object)poolHeadModel.isProxyMark());
                dynamicObject.set("serialNo", (Object)poolHeadModel.getSerialNo());
                dynamicObject.set("invoiceStatus", (Object)poolHeadModel.getInvoiceStatus());
                dynamicObject.set("isRed", (Object)poolHeadModel.getIsRed());
                dynamicObject.set("billStatus", (Object)"A");
                dynamicObject.set("offset_invoice", (Object)poolHeadModel.isOffset_invoice());
                dynamicObject.set("offsetexpense", (Object)poolHeadModel.isOffsetExpense());
                dynamicObject.set("ismutilreimburse", (Object)poolHeadModel.isMutilReimburse());
                dynamicObject.set("oriBalanceAmount", (Object)poolHeadModel.getOriBalanceAmount());
                dynamicObject.set("relBillType", (Object)poolHeadModel.getRelBillType());
                dynamicObject.set("relBill", (Object)poolHeadModel.getRelBill());
                dynamicObject.set("hasVoucher", (Object)poolHeadModel.isHasVoucher());
                dynamicObject.set("voucherNo", (Object)poolHeadModel.getVoucherNo());
                dynamicObject.set("invoiceFrom", (Object)poolHeadModel.getInvoiceFrom());
                dynamicObject.set("billCreateTime", (Object)poolHeadModel.getBillCreateTime());
                dynamicObject.set("invoicestatus", (Object)poolHeadModel.getInvoiceStatus());
            }
            if ((sellerPurchaserModel = poolModel.getPoolSellerPurchaserModel()) != null) {
                dynamicObject.set("buyerorg_id", (Object)sellerPurchaserModel.getBuyerOrgId());
                dynamicObject.set("buyerOrgName", (Object)sellerPurchaserModel.getBuyerOrgName());
                dynamicObject.set("buyertaxno", (Object)sellerPurchaserModel.getBuyerTaxNo());
                dynamicObject.set("sellerOrg_id", (Object)sellerPurchaserModel.getSellerOrgId());
                dynamicObject.set("makeOutCompName", (Object)sellerPurchaserModel.getMakeOutCompName());
                dynamicObject.set("salertaxno_h", (Object)sellerPurchaserModel.getSalerTaxNo_h());
            }
            if ((poolTravelModel = poolModel.getPoolTravelModel()) != null) {
                dynamicObject.set("flighttrainnums", (Object)poolTravelModel.getFlightTrainNums());
                dynamicObject.set("seatgrade", (Object)poolTravelModel.getSeatGrade());
                dynamicObject.set("timegeton", (Object)poolTravelModel.getTimeGetOn());
                dynamicObject.set("timegetoff", (Object)poolTravelModel.getTimeGetOff());
                dynamicObject.set("invoicefromcity", (Object)poolTravelModel.getInvoiceFromCity());
                dynamicObject.set("invoicefromcity", (Object)poolTravelModel.getInvoiceToCity());
                dynamicObject.set("istartprovince", (Object)poolTravelModel.getiStartProvince());
                dynamicObject.set("istartcity", (Object)poolTravelModel.getiStartCity());
                dynamicObject.set("idestprovince", (Object)poolTravelModel.getiDestProvince());
                dynamicObject.set("idestcity", (Object)poolTravelModel.getiDestCity());
                dynamicObject.set("passengername", (Object)poolTravelModel.getPassengerName());
                dynamicObject.set("customeridnumber", (Object)poolTravelModel.getCustomerIdNumber());
            }
            if ((poolVehicleModel = poolModel.getPoolVehicleModel()) != null) {
                dynamicObject.set("vehplate", (Object)poolVehicleModel.getVehPlate());
                dynamicObject.set("vehicletype", (Object)poolVehicleModel.getVehicleType());
                dynamicObject.set("brand", (Object)poolVehicleModel.getBrand());
                dynamicObject.set("vincode", (Object)poolVehicleModel.getVinCode());
                dynamicObject.set("enginenum", (Object)poolVehicleModel.getEngineNum());
                dynamicObject.set("regnum", (Object)poolVehicleModel.getRegNum());
                dynamicObject.set("vehicleremark", (Object)poolVehicleModel.getVehicleRemark());
            }
            if ((poolAmountModel = poolModel.getPoolAmountModel()) != null) {
                dynamicObject.set("totalamount", (Object)poolAmountModel.getTotalAmount());
                String allTaxRate = poolAmountModel.getAllTaxRate();
                Long baseAllTaxRateId = null;
                if (StringUtils.isNotEmpty((CharSequence)allTaxRate)) {
                    try {
                        BigDecimal taxRateDecimal = new BigDecimal(allTaxRate).stripTrailingZeros();
                        if (taxRateMap.containsKey(taxRateDecimal)) {
                            baseAllTaxRateId = taxRateMap.get(taxRateDecimal).get(0).getLong("id");
                        }
                    }
                    catch (NumberFormatException e) {
                        log.warn("allTaxRate is not number : " + allTaxRate);
                    }
                }
                dynamicObject.set("alltaxrate", (Object)allTaxRate);
                dynamicObject.set("basealltaxrate_id", (Object)(poolAmountModel.getBaseAllTaxRateId() == null ? baseAllTaxRateId : poolAmountModel.getBaseAllTaxRateId()));
                dynamicObject.set("taxdetails", (Object)poolAmountModel.getTaxDetails());
                dynamicObject.set("taxamount_invoice", (Object)poolAmountModel.getTaxAmount_invoice());
                dynamicObject.set("invoicenotaxamount", (Object)poolAmountModel.getInvoiceNoTaxAmount());
                dynamicObject.set("gathertotalamount", (Object)poolAmountModel.getGatherTotalAmount());
                dynamicObject.set("gathertaxamount", (Object)poolAmountModel.getGatherTaxAmount());
                dynamicObject.set("insurancepremium", (Object)poolAmountModel.getInsurancePremium());
                dynamicObject.set("airconstfee", (Object)poolAmountModel.getAirConstFee());
                dynamicObject.set("othertotaltaxamount", (Object)poolAmountModel.getOtherTotalTaxAmount());
            }
            if (CollectionUtils.isNotEmpty((Collection)(poolExpenseModels = poolModel.getPoolExpenseModels()))) {
                DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
                for (PoolExpenseModel expenseModel : poolExpenseModels) {
                    DynamicObject expenseDynamicObject = entryEntity.addNew();
                    expenseDynamicObject.set("goodsname", (Object)expenseModel.getGoodsName());
                    expenseDynamicObject.set("goodscode", (Object)expenseModel.getGoodsCode());
                    expenseDynamicObject.set("specmodel", (Object)expenseModel.getSpecModel());
                    expenseDynamicObject.set("unit_id", (Object)expenseModel.getUnitId());
                    expenseDynamicObject.set("num", (Object)expenseModel.getNum());
                    expenseDynamicObject.set("unitprice", (Object)expenseModel.getUnitPrice());
                    expenseDynamicObject.set("entryamount", (Object)expenseModel.getEntryAmount());
                    String invoiceItemTaxRate = expenseModel.getInvoiceItemTaxRate();
                    Object baseAllTaxRateId = null;
                    if (StringUtils.isNotEmpty((CharSequence)invoiceItemTaxRate)) {
                        try {
                            BigDecimal itemTaxRateDecimal = new BigDecimal(invoiceItemTaxRate).stripTrailingZeros();
                            if (taxRateMap.containsKey(itemTaxRateDecimal)) {
                                baseAllTaxRateId = taxRateMap.get(itemTaxRateDecimal).get(0).getLong("id");
                            }
                        }
                        catch (NumberFormatException e) {
                            log.warn("allTaxRate is not number : " + invoiceItemTaxRate);
                        }
                    }
                    expenseDynamicObject.set("invoiceitemtaxrate", (Object)invoiceItemTaxRate);
                    expenseDynamicObject.set("invoiceitembasetaxrate", poolAmountModel.getBaseAllTaxRateId() == null ? baseAllTaxRateId : expenseModel.getInvoiceItemTaxRate());
                    expenseDynamicObject.set("invoiceitemtaxamount", (Object)expenseModel.getInvoiceItemTaxAmount());
                    expenseDynamicObject.set("excludeamount", (Object)expenseModel.getExcludeAmount());
                }
            }
            if ((otherModel = poolModel.getPoolOtherModel()) != null) {
                dynamicObject.set("sequencenum", (Object)otherModel.getSequenceNum());
                dynamicObject.set("invoiceIsChange", (Object)otherModel.getInvoiceIsChange());
                dynamicObject.set("ie_validatest", (Object)otherModel.getIe_validaTest());
                dynamicObject.set("validatemessage", (Object)otherModel.getValidateMessage());
            }
            if ((poolRelationModels = poolModel.getPoolRelationModels()) == null || poolRelationModels.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u751f\u6210\u8d26\u5355\u6c60\u8bb0\u8d26\u4fe1\u606f\u6a21\u578b\u3002", (String)"PoolUtils_0", (String)"fi-er-business", (Object[])new Object[0]));
            }
            PoolRelationModel relationModel = (PoolRelationModel)poolRelationModels.get(0);
            DynamicObjectCollection voucherEntity = dynamicObject.getDynamicObjectCollection("voucherentity");
            DynamicObject voucher = voucherEntity.addNew();
            voucher.set("relbillid", (Object)relationModel.getRelBillId());
            voucher.set("relentryid", (Object)relationModel.getRelEntryId());
            voucher.set("entityid", (Object)relationModel.getEntityId());
            voucher.set("relbills", (Object)relationModel.getRelbills());
            dynamicObjects.add(dynamicObject);
        }
        return dynamicObjects;
    }

    public static List<String> getMultReimBillIds(IDataModel dataModel) {
        MainEntityType dataEntityType = dataModel.getDataEntityType();
        if (dataEntityType.getProperty("invoiceentry") == null) {
            return new ArrayList<String>();
        }
        DynamicObjectCollection invoiceEntry = dataModel.getEntryEntity("invoiceentry");
        if (invoiceEntry == null || invoiceEntry.isEmpty()) {
            return new ArrayList<String>();
        }
        DynamicObjectType invoiceEntryType = invoiceEntry.getDynamicObjectType();
        if (invoiceEntryType.getProperty("ismutilreimburse") == null || invoiceEntryType.getProperty("ispool") == null || invoiceEntryType.getProperty("billingpoolid") == null) {
            return new ArrayList<String>();
        }
        List<Long> billingPoolIds = invoiceEntry.stream().filter(invoice -> invoice.getBoolean("ismutilreimburse") && invoice.getBoolean("ispool") && invoice.getLong("billingpoolid") != 0L).map(invoice -> invoice.getLong("billingpoolid")).collect(Collectors.toList());
        if (billingPoolIds.isEmpty()) {
            return new ArrayList<String>();
        }
        DynamicObject[] dynamicObjects = BillingPoolConfigUtils.queryBillingPoolByIds(billingPoolIds);
        if (dynamicObjects.length == 0) {
            return new ArrayList<String>();
        }
        ArrayList<Long> billIds = new ArrayList<Long>();
        billIds.addAll(billingPoolIds);
        for (DynamicObject billingPool : dynamicObjects) {
            DynamicObjectCollection voucherEntity = billingPool.getDynamicObjectCollection("voucherentity");
            if (voucherEntity.isEmpty()) continue;
            List relBillIds = voucherEntity.stream().map(entity -> entity.getLong("relbillid")).collect(Collectors.toList());
            billIds.addAll(relBillIds);
        }
        List<String> idStrList = billIds.stream().map(id -> id.toString()).collect(Collectors.toList());
        return idStrList;
    }

    public static boolean isMultReim(DynamicObject dataEntity) {
        if (dataEntity == null) {
            return true;
        }
        if (dataEntity.getDataEntityType().getName().equals("er_billingpool")) {
            return true;
        }
        if (!dataEntity.containsProperty("invoiceentry")) {
            return false;
        }
        DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
        if (invoiceEntry.isEmpty()) {
            return false;
        }
        DynamicObjectType invoiceEntryType = invoiceEntry.getDynamicObjectType();
        if (invoiceEntryType.getProperty("ismutilreimburse") != null && invoiceEntryType.getProperty("ispool") != null) {
            boolean multReim = invoiceEntry.stream().anyMatch(invoice -> invoice.getBoolean("ismutilreimburse") || invoice.getBoolean("ispool"));
            return multReim;
        }
        return false;
    }

    public static final void viewBillingPoolBill(IFormView view, Long poolId) {
        boolean exists = QueryServiceHelper.exists((String)"er_billingpool", (Object)poolId);
        if (exists) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setPkId((Object)poolId);
            parameter.setFormId("er_billingpool");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setHasRight(true);
            view.showForm((FormShowParameter)parameter);
        }
    }
}

