/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.mergerule;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import org.apache.commons.lang.time.DateFormatUtils;

public enum EqualFiledCalc {
    INVOICE_EQUAL("invoiceequal", item -> item.getInvoiceEntryBO().getSerialNo()),
    GOODCODE_EQUAL("goodcodeequal", item -> item.getGoodsCode()),
    GOODNAME_EQUAL("goodnameequal", item -> item.getGoodsName()),
    TAXRATE_EQUAL("taxrateequal", item -> item.getInvoiceItemTaxRate().multiply(BigDecimal.valueOf(100L)).setScale(0, RoundingMode.HALF_EVEN).toString()),
    TAXNUM_EQUAL("taxnumequal", item -> item.getInvoiceEntryBO().getBuyerTaxNo()),
    BUYER_NAME_EQUAL("buyernameequal", item -> item.getInvoiceEntryBO().getBuyerOrgName()),
    SALER_NAME_EQUAL("salernameequal", item -> item.getInvoiceEntryBO().getMakeOutCompanyName()),
    PASSENGER_EQUAL("passengerequal", item -> item.getInvoiceEntryBO().getPassengerName()),
    ITEM_EQUAL("itemequal", item -> item.getExpenseItemId() == null ? "0" : item.getExpenseItemId().toString()),
    INVOICEDATE_EQUAL("invoicedateequal", item -> {
        Date invoiceDate = item.getInvoiceEntryBO().getInvoiceDate();
        return invoiceDate != null ? DateFormatUtils.format((Date)invoiceDate, (String)"yyyy-MM") : "null";
    }),
    INVOICEDATEDETAIL_EQUAL("invoicedatedetailequal", item -> {
        Date invoiceDate = item.getInvoiceEntryBO().getInvoiceDate();
        return invoiceDate != null ? DateFormatUtils.format((Date)invoiceDate, (String)"yyyy-MM-dd") : "null";
    }),
    OFFSET_EQUAL("offsetequal", item -> ErStdConfig.getInvoicesCredits() ? String.valueOf(item.getInvoiceItemOffset()) : String.valueOf(item.getInvoiceCloudOffset())),
    FROM_EQUAL("fromequal", item -> item.getInvoiceEntryBO().getFrom()),
    TO_EQUAL("toequal", item -> item.getInvoiceEntryBO().getTo()),
    AMOUNT_EQUAL("amountequal", item -> item.getTotalAmount().toString()),
    SEATGRADE_EQUAL("seatgradequal", item -> item.getInvoiceEntryBO().getSeatGrade()),
    CURRENCY_EQUAL("currencyequal", item -> String.valueOf(item.getInvoiceEntryBO().getInvoiceCurrencyId()));

    private String key;
    private Function<InvoiceItemEntryBO, String> func;
    private static final Map<String, EqualFiledCalc> keyToValue;

    private EqualFiledCalc(String key, Function<InvoiceItemEntryBO, String> func) {
        this.key = key;
        this.func = func;
    }

    public String getFiledValue(InvoiceItemEntryBO invoiceItemEntryBO) {
        return this.func.apply(invoiceItemEntryBO);
    }

    public static EqualFiledCalc of(String key) {
        return keyToValue.get(key);
    }

    static {
        keyToValue = new HashMap<String, EqualFiledCalc>();
        for (EqualFiledCalc calc : EqualFiledCalc.values()) {
            keyToValue.put(calc.key, calc);
        }
    }
}

