/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.v2.service.IWebJsonParseService;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.model.invoice.pc.DataVO;
import kd.fi.er.common.model.invoice.pc.PCReturnVO;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCloudDeserializeServicePC
implements IWebJsonParseService {
    private static final Log log = LogFactory.getLog(InvoiceCloudDeserializeServicePC.class);

    private PCReturnVO getPCReturnVOFromStr(String rawStr) throws InvoiceCloudException {
        String errorMsg = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u53d1\u7968\u8fd4\u56de\u6570\u636e\u53cd\u5e8f\u5217\u5316\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvoiceCloudDeserializeServicePC_0", (String)"fi-er-business", (Object[])new Object[0]);
        try {
            PCReturnVO pcReturnVO = (PCReturnVO)JSON.parseObject((String)rawStr, PCReturnVO.class);
            if (pcReturnVO == null) {
                log.info("\u53cd\u5e8f\u5217\u5316\u524d\u7684\u6570\u636e:" + (String)StringUtils.defaultIfBlank((CharSequence)rawStr, (CharSequence)""));
                throw new InvoiceCloudException(errorMsg);
            }
            return pcReturnVO;
        }
        catch (Exception e) {
            log.info("\u53cd\u5e8f\u5217\u5316\u524d\u7684\u6570\u636e:" + (String)StringUtils.defaultIfBlank((CharSequence)rawStr, (CharSequence)""), (Object)e);
            throw new InvoiceCloudException(errorMsg);
        }
    }

    @Override
    public Set<String> getSerialNosFromWeb(String rawStr) throws InvoiceCloudException {
        PCReturnVO pcReturnVO = this.getPCReturnVOFromStr(rawStr);
        DataVO dataVO = pcReturnVO.getData();
        if (dataVO == null || dataVO.getInvoiceData() == null || dataVO.getInvoiceData().size() < 1) {
            throw new InvoiceCloudException(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u4efb\u4f55\u53d1\u7968\u3002", (String)"InvoiceCloudDeserializeServicePC_1", (String)"fi-er-business", (Object[])new Object[0]));
        }
        List invoiceDatas = pcReturnVO.getData().getInvoiceData();
        Set<String> serialNos = invoiceDatas.stream().map(invoice -> invoice.getSerialNo()).collect(Collectors.toSet());
        return serialNos;
    }
}

