/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.InvoiceVo2BoService;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.model.InvoiceTypeModel;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.invoicecloud.v2.TrainSeatGradeMap;
import kd.fi.er.business.invoicecloud.v2.service.impl.InvoiceVo2BoService.InvoiceVoToInvoiceBoServiceI;
import kd.fi.er.common.model.invoice.InvoiceItemVO;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import kd.fi.er.formplugin.daily.web.util.DateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CopyInvoiceVOToInvoiceEntryBOServiceImpl
extends InvoiceVoToInvoiceBoServiceI {
    private static final Log log = LogFactory.getLog(CopyInvoiceVOToInvoiceEntryBOServiceImpl.class);
    private final String INVOICE_HEAD_KEY;
    private final String INVOICE_ITEM_KEY;
    private Map<String, InvoiceTypeModel> invoiceTypeModels;

    public CopyInvoiceVOToInvoiceEntryBOServiceImpl(InvoiceContext invoiceContext) {
        this(invoiceContext, invoiceContext.getView().getEntityId());
    }

    public CopyInvoiceVOToInvoiceEntryBOServiceImpl(InvoiceContext invoiceContext, String entityName) {
        super(invoiceContext);
        this.INVOICE_HEAD_KEY = entityName;
        this.INVOICE_ITEM_KEY = entityName;
        this.invoiceTypeModels = InvoiceTypeUtils.loadInvoiceModels().stream().collect(Collectors.toMap(invoiceType -> invoiceType.getNumber(), invoiceType -> invoiceType, (type1, type2) -> type1));
    }

    @Override
    public void process() {
        InvoiceEntryBO invoiceEntryBO;
        List<InvoiceVO> invoiceVOs = this.invoiceContext.getInvoiceVOs();
        List<InvoiceEntryBO> invoiceEntryBOs = this.invoiceContext.getInvoiceEntryBOs();
        List<InvoiceItemEntryBO> allInvoiceItemEntryBOs = this.invoiceContext.getInvoiceItemEntryBOs();
        for (InvoiceVO invoiceVO : invoiceVOs) {
            invoiceEntryBO = this.generateInvoiceEntryBO(invoiceVO);
            invoiceEntryBOs.add(invoiceEntryBO);
            List invoiceItemEntryBOs = invoiceEntryBO.getInvoiceItemEntryBOs();
            for (InvoiceItemVO invoiceItemVO : invoiceVO.getItems()) {
                InvoiceItemEntryBO invoiceItemEntryBO = this.generateInvoiceItemEntryBO(invoiceVO, invoiceItemVO);
                invoiceItemEntryBO.setInvoiceEntryBO(invoiceEntryBO);
                invoiceItemEntryBOs.add(invoiceItemEntryBO);
                allInvoiceItemEntryBOs.add(invoiceItemEntryBO);
            }
        }
        long[] invoiceHeadIds = this.createEntryIds(this.INVOICE_HEAD_KEY, invoiceEntryBOs.size());
        for (int i = 0; i < invoiceHeadIds.length; ++i) {
            invoiceEntryBO = invoiceEntryBOs.get(i);
            if (invoiceEntryBO == null) continue;
            invoiceEntryBO.setEntryId(Long.valueOf(invoiceHeadIds[i]));
        }
        long[] invoiceItemIds = this.createEntryIds(this.INVOICE_ITEM_KEY, allInvoiceItemEntryBOs.size());
        for (int i = 0; i < invoiceItemIds.length; ++i) {
            InvoiceItemEntryBO invoiceItemEntryBO = allInvoiceItemEntryBOs.get(i);
            if (invoiceItemEntryBO == null || invoiceItemEntryBO.getEntryId() != null) continue;
            invoiceItemEntryBO.setEntryId(Long.valueOf(invoiceItemIds[i]));
        }
    }

    private InvoiceItemEntryBO generateInvoiceItemEntryBO(InvoiceVO invoiceVO, InvoiceItemVO invoiceItemVO) {
        QFilter qFilter;
        Map loadFromCache;
        log.info("\u3010\u53d1\u7968\u4e91\u3011\u539f\u59cb\u6570\u636eItemVO\uff1a" + invoiceItemVO);
        InvoiceItemEntryBO invoiceItemEntryBO = new InvoiceItemEntryBO();
        String invoiceType = invoiceVO.getInvoiceType();
        InvoiceTypeModel invoiceTypeModel = this.invoiceTypeModels.get(invoiceType);
        if (invoiceTypeModel == null) {
            invoiceTypeModel = this.invoiceTypeModels.get(InvoiceTypeEnum.key_11.getValue());
        }
        invoiceItemEntryBO.setInvoiceType_item(invoiceTypeModel.getId());
        invoiceItemEntryBO.setInvoiceNo_item(invoiceVO.getInvoiceNo());
        invoiceItemEntryBO.setInvoiceDate_item(invoiceVO.getInvoiceDate());
        if (!invoiceVO.getInvoiceType().equals("30")) {
            invoiceItemEntryBO.setInvoiceCurrency_item(this.invoiceContext.getInvoiceConfig().getInvoiceCurrencyId());
        } else {
            invoiceItemEntryBO.setInvoiceCurrency_item(invoiceVO.getCurrencyId());
        }
        invoiceItemEntryBO.setTotalAmount_item((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getTotalAmount(), (Object)BigDecimal.ZERO));
        invoiceItemEntryBO.setGootsName((String)StringUtils.defaultIfBlank((CharSequence)invoiceItemVO.getGoodsName(), (CharSequence)""));
        invoiceItemEntryBO.setGoodsName((String)StringUtils.defaultIfBlank((CharSequence)invoiceItemVO.getGoodsName(), (CharSequence)""));
        invoiceItemEntryBO.setUnitPrice((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItemVO.getUnitPrice(), (Object)BigDecimal.ZERO));
        invoiceItemEntryBO.setTaxRate((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItemVO.getTaxRate(), (Object)BigDecimal.ZERO));
        invoiceItemEntryBO.setInvoiceItemTaxRate((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItemVO.getTaxRate(), (Object)BigDecimal.ZERO));
        invoiceItemEntryBO.setUnit((String)StringUtils.defaultIfBlank((CharSequence)invoiceItemVO.getUnit(), (CharSequence)""));
        invoiceItemEntryBO.setExcludedTaxAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItemVO.getDetailAmount(), (Object)BigDecimal.ZERO));
        invoiceItemEntryBO.setExcludeAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItemVO.getDetailAmount(), (Object)BigDecimal.ZERO));
        invoiceItemEntryBO.setTaxAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItemVO.getTaxAmount(), (Object)BigDecimal.ZERO));
        invoiceItemEntryBO.setInvoiceItemTaxAmout((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItemVO.getTaxAmount(), (Object)BigDecimal.ZERO));
        invoiceItemEntryBO.setTotalAmount(invoiceItemEntryBO.getInvoiceItemTaxAmout().add(invoiceItemEntryBO.getExcludeAmount()));
        invoiceItemEntryBO.setSpecModel((String)StringUtils.defaultIfBlank((CharSequence)invoiceItemVO.getSpecModel(), (CharSequence)""));
        invoiceItemEntryBO.setGoodsCode((String)StringUtils.defaultIfBlank((CharSequence)invoiceItemVO.getGoodsCode(), (CharSequence)""));
        invoiceItemEntryBO.setNum((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceItemVO.getNum(), (Object)BigDecimal.ZERO));
        invoiceItemEntryBO.setInvoiceItemSerialNo(invoiceVO.getSerialNo());
        invoiceItemEntryBO.setVehPlate((String)StringUtils.defaultIfBlank((CharSequence)invoiceItemVO.getVehPlate(), (CharSequence)""));
        invoiceItemEntryBO.setGoodsCodeId(Long.valueOf(0L));
        if (StringUtils.isNotBlank((CharSequence)invoiceItemEntryBO.getGoodsCode()) && (loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"er_taxclasscode", (QFilter[])new QFilter[]{qFilter = QFilter.of((String)"mergecode=?", (Object[])new Object[]{invoiceItemEntryBO.getGoodsCode()})})) != null && !loadFromCache.isEmpty()) {
            DynamicObject taxClassCodeDO = (DynamicObject)loadFromCache.values().iterator().next();
            invoiceItemEntryBO.setGoodsCodeId((Long)taxClassCodeDO.getPkValue());
        }
        invoiceItemEntryBO.setZeroTaxRateFlag(invoiceItemVO.getZeroTaxRateFlag());
        invoiceItemEntryBO.setThirdPartFieldMap(invoiceItemVO.getThirdpartFieldMap());
        return invoiceItemEntryBO;
    }

    private InvoiceEntryBO generateInvoiceEntryBO(InvoiceVO invoiceVO) {
        boolean isBillingPool;
        log.info("\u3010\u53d1\u7968\u4e91\u3011\u539f\u59cb\u6570\u636eVO\uff1a" + invoiceVO);
        List items = invoiceVO.getItems();
        InvoiceEntryBO invoiceEntryBO = new InvoiceEntryBO();
        String invoiceType = invoiceVO.getInvoiceType();
        InvoiceTypeModel invoiceTypeModel = this.invoiceTypeModels.get(invoiceType);
        if (invoiceTypeModel == null) {
            invoiceTypeModel = this.invoiceTypeModels.get(InvoiceTypeEnum.key_11.getValue());
        }
        invoiceEntryBO.setInvoiceTypeId(invoiceTypeModel.getId());
        invoiceEntryBO.setInvoiceType(invoiceType);
        invoiceEntryBO.setInvoiceCode((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getInvoiceCode(), (CharSequence)"-"));
        invoiceEntryBO.setInvoiceNo((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getInvoiceNo(), (CharSequence)"-"));
        invoiceEntryBO.setInvoiceDate(invoiceVO.getInvoiceDate());
        if (invoiceVO.getCarrierDate() == null && invoiceTypeModel.isTransportInvoice()) {
            invoiceEntryBO.setCarrierDate(invoiceVO.getInvoiceDate());
        } else {
            invoiceEntryBO.setCarrierDate(invoiceVO.getCarrierDate());
        }
        invoiceEntryBO.setTotalAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getTotalAmount(), (Object)BigDecimal.ZERO));
        if (invoiceTypeModel != null && InvoiceTypeEnum.key_30.getValue().equals(invoiceTypeModel.getNumber())) {
            invoiceEntryBO.setTaxAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getTotalTaxAmount(), (Object)BigDecimal.ZERO));
        } else {
            invoiceEntryBO.setTaxAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getTaxAmount(), (Object)BigDecimal.ZERO));
        }
        StringBuilder taxDetails = new StringBuilder();
        IFormView view = this.invoiceContext.getView();
        if (view == null) {
            log.error("The invoiceContext's view is null,please check code!");
        } else {
            LocaleString totalAmountLs;
            LocaleString taxAmountLs;
            LocaleString taxRateLs;
            String taxRateName = "";
            String taxAmountName = "";
            String totalAmountName = "";
            TextEdit taxRateControl = (TextEdit)view.getControl("alltaxrate");
            AmountEdit taxAmountControl = (AmountEdit)view.getControl("taxamount_invoice");
            AmountEdit totalAmountControl = (AmountEdit)view.getControl("totalamount");
            if (taxRateControl != null && (taxRateLs = taxRateControl.getDisplayName()) != null) {
                taxRateName = taxRateLs.getLocaleValue();
            }
            if (taxAmountControl != null && (taxAmountLs = taxAmountControl.getDisplayName()) != null) {
                taxAmountName = taxAmountLs.getLocaleValue();
            }
            if (totalAmountControl != null && (totalAmountLs = totalAmountControl.getDisplayName()) != null) {
                totalAmountName = totalAmountLs.getLocaleValue();
            }
            try {
                if (StringUtils.isNotEmpty((CharSequence)invoiceVO.getTaxType1())) {
                    taxDetails.append(taxRateName).append(this.formatDecimalStr(invoiceVO.getTaxRate1())).append("|").append(taxAmountName).append(invoiceVO.getTaxAmount1()).append("|").append(totalAmountName).append(invoiceVO.getInvoiceAmount1()).append("\uff1b");
                    if (StringUtils.isNotEmpty((CharSequence)invoiceVO.getTaxType2())) {
                        taxDetails.append(taxRateName).append(this.formatDecimalStr(invoiceVO.getTaxRate2())).append("|").append(taxAmountName).append(invoiceVO.getTaxAmount2()).append("|").append(totalAmountName).append(invoiceVO.getInvoiceAmount2()).append("\uff1b");
                        if (StringUtils.isNotEmpty((CharSequence)invoiceVO.getTaxType3())) {
                            taxDetails.append(taxRateName).append(this.formatDecimalStr(invoiceVO.getTaxRate3())).append("|").append(taxAmountName).append(invoiceVO.getTaxAmount3()).append("|").append(totalAmountName).append(invoiceVO.getInvoiceAmount3()).append("\uff1b");
                            if (StringUtils.isNotEmpty((CharSequence)invoiceVO.getTaxType4())) {
                                taxDetails.append(taxRateName).append(this.formatDecimalStr(invoiceVO.getTaxRate4())).append("|").append(taxAmountName).append(invoiceVO.getTaxAmount4()).append("|").append(totalAmountName).append(invoiceVO.getInvoiceAmount4()).append("\uff1b");
                                if (StringUtils.isNotEmpty((CharSequence)invoiceVO.getTaxType5())) {
                                    taxDetails.append(taxRateName).append(this.formatDecimalStr(invoiceVO.getTaxRate5())).append("|").append(taxAmountName).append(invoiceVO.getTaxAmount5()).append("|").append(totalAmountName).append(invoiceVO.getInvoiceAmount5()).append("\uff1b");
                                }
                            }
                        }
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)invoiceVO.getTaxDetails())) {
                    taxDetails.append(invoiceVO.getTaxDetails());
                }
            }
            catch (Exception exception) {
                log.error("format taxrate error:" + exception);
            }
        }
        invoiceEntryBO.setTaxDetails(StringUtils.abbreviate((String)taxDetails.toString(), (int)500));
        invoiceEntryBO.setTaxRate(invoiceVO.getTaxRate());
        invoiceEntryBO.setValidateMessage((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getValidateMessage(), (CharSequence)""));
        invoiceEntryBO.setBuyerOrgName((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getBuyerName(), (CharSequence)""));
        String makeOutCompanyName = StringUtils.equals((CharSequence)InvoiceTypeEnum.key_25.getValue(), (CharSequence)invoiceType) ? invoiceVO.getInvoicingPartyName() : invoiceVO.getSalerName();
        invoiceEntryBO.setMakeOutCompanyName((String)StringUtils.defaultIfBlank((CharSequence)makeOutCompanyName, (CharSequence)""));
        invoiceEntryBO.setInvoiceCount(Integer.valueOf(1));
        StringBuilder remarkSb = new StringBuilder((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getRemark(), (CharSequence)""));
        if (invoiceVO.getTimeGetOn() != null) {
            remarkSb.append(String.format(ResManager.loadKDString((String)"; \u4e0a\u8f66\u65f6\u95f4: %s", (String)"CopyInvoiceVOToInvoiceEntrBOServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), invoiceVO.getTimeGetOn()));
        }
        if (invoiceVO.getTimeGetOff() != null) {
            remarkSb.append(String.format(ResManager.loadKDString((String)"; \u4e0b\u8f66\u65f6\u95f4: %s", (String)"CopyInvoiceVOToInvoiceEntrBOServiceImpl_1", (String)"fi-er-business", (Object[])new Object[0]), invoiceVO.getTimeGetOff()));
        }
        if (invoiceVO.getMileage() != null) {
            remarkSb.append(String.format(ResManager.loadKDString((String)"; \u91cc\u7a0b: %skm", (String)"CopyInvoiceVOToInvoiceEntrBOServiceImpl_2", (String)"fi-er-business", (Object[])new Object[0]), invoiceVO.getMileage()));
        }
        invoiceEntryBO.setRemarkInvoice(remarkSb.length() > 0 && remarkSb.charAt(0) == ';' ? remarkSb.substring(1, remarkSb.length()) : remarkSb.toString());
        invoiceEntryBO.setRemark_Invoice(remarkSb.length() > 0 && remarkSb.charAt(0) == ';' ? remarkSb.substring(1, remarkSb.length()) : remarkSb.toString());
        invoiceEntryBO.setBillingPoolId(invoiceVO.getBillingPoolId());
        invoiceEntryBO.setOriBalanceAmount(invoiceVO.getOriBalanceAmount());
        if (this.invoiceContext.getInvoiceConfig().isMustRelateExpenseItem() || !invoiceVO.getMutiReimburse()) {
            invoiceEntryBO.setPoolReimburseAmount(invoiceVO.getOriBalanceAmount());
        }
        invoiceEntryBO.setCountry(invoiceVO.getCountry());
        invoiceEntryBO.setCountryId(invoiceVO.getCountryId());
        invoiceEntryBO.setTimeGetOn(invoiceVO.getTimeGetOn());
        invoiceEntryBO.setTimeGetOff(invoiceVO.getTimeGetOff());
        invoiceEntryBO.setDueDate(invoiceVO.getDueDate());
        invoiceEntryBO.setMutiReimburse(invoiceVO.getMutiReimburse());
        invoiceEntryBO.setInvoiceFrom((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getInvoiceFrom(), (CharSequence)InvoiceFrom.InvoiceCloud.getValue()));
        invoiceEntryBO.setIsFromInvoiceCloud(Boolean.valueOf(true));
        invoiceEntryBO.setSerialNo((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getSerialNo(), (CharSequence)""));
        invoiceEntryBO.setCanCloseMultiReimburse(invoiceVO.getCanCloseMultiReimburse());
        BigDecimal newAirPortConstruFee = ((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getAirportConstructionFee(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getOtherTotalTaxAmount(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getInsurancePremium(), (Object)BigDecimal.ZERO));
        invoiceEntryBO.setAirportConstructionFee((BigDecimal)ObjectUtils.defaultIfNull((Object)newAirPortConstruFee, (Object)BigDecimal.ZERO));
        invoiceEntryBO.setAirConstFee((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getAirportConstructionFee(), (Object)BigDecimal.ZERO));
        invoiceEntryBO.setOtherTotalTaxAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getOtherTotalTaxAmount(), (Object)BigDecimal.ZERO));
        invoiceEntryBO.setInsurancePremium((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceVO.getInsurancePremium(), (Object)BigDecimal.ZERO));
        invoiceEntryBO.setBuyerTaxNo((String)StringUtils.defaultIfEmpty((CharSequence)invoiceVO.getBuyerTaxNo(), (CharSequence)""));
        invoiceEntryBO.setSalerTaxNo((String)StringUtils.defaultIfEmpty((CharSequence)invoiceVO.getSalerTaxNo(), (CharSequence)""));
        invoiceEntryBO.setCheckStatus((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getCheckStatus(), (CharSequence)InvoiceVO.CheckStatus.UNCHECK.getValue()));
        Set rawSet = invoiceVO.getItems().stream().map(invoiceItemEntry -> invoiceItemEntry.getTaxRate()).collect(Collectors.toSet());
        boolean bl = isBillingPool = invoiceVO.getBillingPoolId() != null && invoiceVO.getBillingPoolId() != 0L;
        if (!rawSet.isEmpty()) {
            ArrayList<BigDecimal> allTaxRateList = new ArrayList<BigDecimal>(rawSet);
            allTaxRateList.sort(BigDecimal::compareTo);
            ArrayList strTaxRateList = new ArrayList(rawSet.size());
            allTaxRateList.forEach(v -> {
                if (v != null) {
                    String str = isBillingPool ? v.stripTrailingZeros().toPlainString() : CopyInvoiceVOToInvoiceEntryBOServiceImpl.format(v);
                    strTaxRateList.add(str);
                }
            });
            invoiceEntryBO.setAllTaxRate(StringUtils.join(strTaxRateList, (String)","));
        } else {
            invoiceEntryBO.setAllTaxRate("");
        }
        String trip = invoiceVO.getTrip();
        if (StringUtils.isNotEmpty((CharSequence)trip)) {
            String[] tripArray = trip.split("-");
            if (tripArray.length == 2) {
                invoiceEntryBO.setFrom(tripArray[0].trim());
                invoiceEntryBO.setTo(tripArray[1].trim());
            } else if (tripArray.length == 4) {
                invoiceEntryBO.setFrom(tripArray[1].trim());
                invoiceEntryBO.setTo(tripArray[3].trim());
            }
        }
        String seatGrade = "";
        if (StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_10.getValue()) || StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_28.getValue())) {
            seatGrade = (String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getSeatGradeName(), (CharSequence)"");
            invoiceEntryBO.setFlightTrainNums((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getFlightNum(), (CharSequence)""));
        } else if (StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_9.getValue()) || StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_29.getValue())) {
            seatGrade = (String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getSeatGrade(), (CharSequence)"");
            seatGrade = TrainSeatGradeMap.getTargetSeatGrade(seatGrade);
            invoiceEntryBO.setFlightTrainNums((String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getTrainNum(), (CharSequence)""));
        } else if (StringUtils.equals((CharSequence)invoiceVO.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_15.getValue())) {
            String vehPlate = items.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getVehPlate())).map(v -> v.getVehPlate()).collect(Collectors.joining(","));
            invoiceEntryBO.setFlightTrainNums((String)StringUtils.defaultIfBlank((CharSequence)vehPlate, (CharSequence)""));
            Optional<String> startDate = items.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getStartDate())).map(v -> v.getStartDate()).findFirst();
            Optional<String> endDate = items.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getEndDate())).map(v -> v.getEndDate()).findFirst();
            if (startDate.isPresent()) {
                invoiceEntryBO.setStartDate(DateUtils.dateFomat(startDate.get(), "yyyy-MM-dd"));
            }
            if (endDate.isPresent()) {
                invoiceEntryBO.setEndDate(DateUtils.dateFomat(endDate.get(), "yyyy-MM-dd"));
            }
        } else {
            seatGrade = (String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getSeatGrade(), (CharSequence)"");
        }
        invoiceEntryBO.setSeatGrade(seatGrade);
        if (invoiceTypeModel.isTransportInvoice()) {
            String trainTime = StringUtils.equalsAny((CharSequence)invoiceType, (CharSequence[])new CharSequence[]{InvoiceTypeEnum.key_10.getValue(), InvoiceTypeEnum.key_28.getValue()}) ? invoiceVO.getAirTime() : (StringUtils.equals((CharSequence)invoiceType, (CharSequence)InvoiceTypeEnum.key_9.getValue()) ? invoiceVO.getTrainTime() : (StringUtils.equals((CharSequence)invoiceType, (CharSequence)InvoiceTypeEnum.key_29.getValue()) ? invoiceVO.getDepartureTime() : invoiceVO.getTime()));
            invoiceEntryBO.setAirTime(trainTime);
        }
        String startProvince = "";
        String startCity = "";
        InvoiceVO.StationPosition startStation = invoiceVO.getDeparturePosition();
        if (startStation != null) {
            startProvince = (String)StringUtils.defaultIfBlank((CharSequence)startStation.getProvince(), (CharSequence)"");
            startCity = (String)StringUtils.defaultIfBlank((CharSequence)startStation.getCity(), (CharSequence)"");
        }
        invoiceEntryBO.setStartProvince(startProvince);
        invoiceEntryBO.setStartCity(startCity);
        String destProvince = "";
        String destCity = "";
        InvoiceVO.StationPosition destStation = invoiceVO.getDestinationPosition();
        if (destStation != null) {
            destProvince = (String)StringUtils.defaultIfBlank((CharSequence)destStation.getProvince(), (CharSequence)"");
            destCity = (String)StringUtils.defaultIfBlank((CharSequence)destStation.getCity(), (CharSequence)"");
        } else if (items != null && items.stream().anyMatch(invoiceItem -> ((String)StringUtils.defaultIfBlank((CharSequence)invoiceItem.getGoodsName(), (CharSequence)"")).contains(ResManager.loadKDString((String)"\u4f4f\u5bbf", (String)"CopyInvoiceVOToInvoiceEntrBOServiceImpl_3", (String)"fi-er-business", (Object[])new Object[0])))) {
            destProvince = (String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getProvince(), (CharSequence)"");
            destCity = (String)StringUtils.defaultIfBlank((CharSequence)invoiceVO.getCity(), (CharSequence)"");
        }
        invoiceEntryBO.setDestProvince(destProvince);
        invoiceEntryBO.setDestCity(destCity);
        invoiceEntryBO.setThirdPartFieldMap(invoiceVO.getThirdpartFieldMap());
        if (InvoiceTypeEnum.key_30 == InvoiceTypeEnum.getByValue(invoiceVO.getInvoiceType())) {
            invoiceEntryBO.setInvoiceNoTaxAmount(invoiceVO.getInvoiceAmount());
        } else {
            invoiceEntryBO.setInvoiceNoTaxAmount(invoiceEntryBO.getTotalAmount().subtract(invoiceEntryBO.getTaxAmount()));
        }
        Set<String> vehicleInvoiceTypes = InvoiceTypeUtils.loadVehicleInvoiceTypes();
        boolean isTranNote = false;
        if (vehicleInvoiceTypes.contains(invoiceType)) {
            isTranNote = true;
        }
        if (StringUtils.equalsAny((CharSequence)invoiceType, (CharSequence[])new CharSequence[]{InvoiceTypeEnum.key_1.getValue(), InvoiceTypeEnum.key_26.getValue()})) {
            List invoiceItem2 = items;
            isTranNote = invoiceItem2.stream().anyMatch(item -> StringUtils.indexOf((CharSequence)item.getGoodsName(), (CharSequence)ResManager.loadKDString((String)"\u8fd0\u8f93\u670d\u52a1", (String)"CopyInvoiceVOToInvoiceEntrBOServiceImpl_4", (String)"fi-er-business", (Object[])new Object[0])) != -1);
        }
        invoiceEntryBO.setTransportNote(isTranNote ? "1" : "0");
        invoiceEntryBO.setInvoiceIsChange(invoiceVO.getIsRevise());
        String ticketChanges = invoiceVO.getTicketChanges();
        String businessType = invoiceVO.getBusinessType();
        invoiceEntryBO.setBusinessType(businessType);
        String typeOfBusiness = invoiceVO.getTypeOfBusiness();
        if (StringUtils.isNotEmpty((CharSequence)ticketChanges)) {
            invoiceEntryBO.setTicketChanges(ticketChanges);
        } else if (StringUtils.isNotEmpty((CharSequence)businessType)) {
            if (StringUtils.equals((CharSequence)"1", (CharSequence)businessType)) {
                invoiceEntryBO.setTicketChanges("3");
            } else if (StringUtils.equals((CharSequence)"2", (CharSequence)businessType)) {
                invoiceEntryBO.setTicketChanges("4");
            } else if (StringUtils.equals((CharSequence)"3", (CharSequence)businessType)) {
                invoiceEntryBO.setTicketChanges("2");
            }
        } else if (StringUtils.isNotEmpty((CharSequence)typeOfBusiness)) {
            String sale = ResManager.loadKDString((String)"\u552e", (String)"EM-D-870261", (String)"fi-er-business", (Object[])new Object[0]);
            String refund = ResManager.loadKDString((String)"\u9000", (String)"EM-D-508085", (String)"fi-er-business", (Object[])new Object[0]);
            if (StringUtils.equalsAny((CharSequence)typeOfBusiness, (CharSequence[])new CharSequence[]{"1", sale})) {
                invoiceEntryBO.setTicketChanges("3");
            } else if (StringUtils.equalsAny((CharSequence)typeOfBusiness, (CharSequence[])new CharSequence[]{"2", refund})) {
                invoiceEntryBO.setTicketChanges("4");
            }
        }
        if (StringUtils.equals((CharSequence)InvoiceTypeEnum.key_10.getValue(), (CharSequence)invoiceType)) {
            if (StringUtils.equals((CharSequence)"2", (CharSequence)ticketChanges)) {
                BigDecimal airportConstructionFee = invoiceVO.getOtherTotalTaxAmount();
                invoiceEntryBO.setAirportConstructionFee(airportConstructionFee);
            }
            invoiceEntryBO.setMakeOutCompanyName(invoiceVO.getFillingUnit());
        } else if (StringUtils.equals((CharSequence)InvoiceTypeEnum.key_28.getValue(), (CharSequence)invoiceType)) {
            invoiceEntryBO.setMakeOutCompanyName(invoiceVO.getFillingUnit());
        } else {
            String goodsName = items.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getGoodsName())).map(v -> v.getGoodsName()).collect(Collectors.joining("\uff0c"));
            invoiceEntryBO.setInvoiceGoodsName(goodsName);
        }
        Set goodsCodeSet = items.stream().map(v -> v.getGoodsCode()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("mergecode", "in", goodsCodeSet);
        qFilter.and("enable", "=", (Object)"1");
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"er_taxclasscode", (QFilter[])new QFilter[]{qFilter});
        if (loadFromCache != null && !loadFromCache.isEmpty()) {
            String goodsCode = loadFromCache.values().stream().map(v -> v.getLocaleString("name").toString()).collect(Collectors.joining("\uff0c"));
            invoiceEntryBO.setInvoiceAllTaxCode(goodsCode);
        }
        invoiceEntryBO.setBillCreateTime(invoiceVO.getBillCreateTime());
        this.copyVerifyResult(invoiceEntryBO, invoiceVO);
        if (!invoiceVO.getInvoiceType().equals("30")) {
            invoiceEntryBO.setInvoiceCurrencyId(this.invoiceContext.getInvoiceConfig().getInvoiceCurrencyId().longValue());
        } else {
            invoiceEntryBO.setInvoiceCurrencyId(invoiceVO.getCurrencyId().longValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceVO.getCanBeDeduction())) {
            if (StringUtils.equals((CharSequence)invoiceVO.getCanBeDeduction(), (CharSequence)"1")) {
                invoiceEntryBO.setCanBeDeduction(true);
            } else {
                invoiceEntryBO.setCanBeDeduction(false);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)invoiceVO.getDeductionFlag())) {
            if (StringUtils.equals((CharSequence)invoiceVO.getDeductionFlag(), (CharSequence)"1")) {
                invoiceEntryBO.setCanBeDeduction(true);
            } else {
                invoiceEntryBO.setCanBeDeduction(false);
            }
        } else {
            invoiceEntryBO.setCanBeDeduction(false);
        }
        invoiceEntryBO.setSupplement(this.isSupplement());
        invoiceEntryBO.setMapExpenseItem(this.isMapExpenseItem());
        invoiceEntryBO.setUploadSeq(invoiceVO.getUploadSeq());
        invoiceEntryBO.setPassengerName(invoiceVO.getPassengerName());
        String customerId = invoiceVO.getCustomerIdentityNum();
        if (StringUtils.isEmpty((CharSequence)customerId)) {
            customerId = invoiceVO.getCardNumber();
        }
        StringBuilder sbCustomerId = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)customerId)) {
            int startIndex = customerId.length() - 4;
            if (startIndex < 0) {
                startIndex = 0;
            }
            customerId = customerId.substring(startIndex);
            sbCustomerId.append("****");
            sbCustomerId.append(customerId);
        }
        invoiceEntryBO.setCustomerIDNumber(sbCustomerId.toString());
        String type = invoiceVO.getType();
        if (type != null) {
            invoiceEntryBO.setRed(type);
        }
        Integer flag = invoiceVO.getInternationalFlag();
        invoiceEntryBO.setRegion(invoiceEntryBO.getRegionByFlag(flag));
        String xbrlUrl = invoiceVO.getXbrlUrl();
        if (xbrlUrl != null && xbrlUrl.trim().length() > 0) {
            invoiceEntryBO.setXbrl(true);
        }
        invoiceEntryBO.setTravelDate(invoiceVO.getTravelDate());
        invoiceEntryBO.setCity(invoiceVO.getPlace());
        invoiceEntryBO.setFuelSurcharge(invoiceVO.getFuelSurcharge());
        invoiceEntryBO.setBuyerAddressPhone(invoiceVO.getBuyerAddressPhone());
        invoiceEntryBO.setEndorsement(invoiceVO.getEndorsement());
        invoiceEntryBO.setBlockChain("1".equals(invoiceVO.getBlockChain()) ? "1" : "0");
        if (!KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
            invoiceEntryBO.setBlockChain(invoiceVO.isBlockchain() ? "1" : "0");
        }
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            InvoiceItemVO invoiceItemVO = (InvoiceItemVO)items.get(0);
            invoiceEntryBO.setSpecModel_h(invoiceItemVO.getSpecModel());
            invoiceEntryBO.setUnit_h(invoiceItemVO.getUnit());
            invoiceEntryBO.setNum_h(invoiceItemVO.getNum());
            invoiceEntryBO.setUnitPrice_h(invoiceItemVO.getUnitPrice());
        }
        return invoiceEntryBO;
    }

    private static String format(BigDecimal decimal) {
        NumberFormat df = DecimalFormat.getPercentInstance();
        df.setMinimumFractionDigits(1);
        String format = df.format(decimal == null ? BigDecimal.ZERO : decimal);
        return format.replaceAll("\\.*0*%", "");
    }

    protected void copyVerifyResult(InvoiceEntryBO invoiceEntryBO, InvoiceVO invoiceVO) {
        String isSequenceNum = "2";
        String isPassVerifyBuyerName = "1";
        String isPassVerifyBuyerTaxNo = "1";
        Set<String> vatInvoice = InvoiceTypeUtils.loadVatInvoiceTypes();
        if (vatInvoice.contains(invoiceVO.getInvoiceType())) {
            invoiceEntryBO.setPersonalInvoice(invoiceVO.isPersonFlag() ? "1" : "0");
        } else {
            invoiceEntryBO.setPersonalInvoice(" ");
        }
        List verifyResults = invoiceVO.getVerifyResult();
        if (verifyResults != null && !verifyResults.isEmpty()) {
            Map<String, InvoiceVO.VerifyResultInfo> map = verifyResults.stream().collect(Collectors.toMap(v -> v.getKey(), v -> v, (oldStr, newStr) -> oldStr));
            InvoiceVO.VerifyResultInfo verifySequenceResultInfo = map.get("sequenceNum");
            if (verifySequenceResultInfo != null) {
                isSequenceNum = "1";
                invoiceEntryBO.setSequenceNumInfo((String)StringUtils.defaultIfBlank((CharSequence)verifySequenceResultInfo.getMsg(), (CharSequence)""));
            } else {
                isSequenceNum = "2";
            }
            InvoiceVO.VerifyResultInfo verifyBuyerNameResultInfo = map.get("verifyBuyerName");
            isPassVerifyBuyerName = verifyBuyerNameResultInfo != null ? "0" : "1";
            InvoiceVO.VerifyResultInfo verifyBuyerTaxNoResultInfo = map.get("verifyBuyerTaxNo");
            isPassVerifyBuyerTaxNo = verifyBuyerTaxNoResultInfo != null ? "0" : "1";
        }
        if (!vatInvoice.contains(invoiceVO.getInvoiceType())) {
            isPassVerifyBuyerName = "";
            isPassVerifyBuyerTaxNo = "";
        }
        if (!invoiceVO.isPersonFlag()) {
            invoiceEntryBO.setPassVerifyBuyerName(isPassVerifyBuyerName);
            invoiceEntryBO.setPassVerifyBuyerTaxNo(isPassVerifyBuyerTaxNo);
        }
        invoiceEntryBO.setSequenceNum(isSequenceNum);
    }

    private long[] createEntryIds(String entryName, int length) {
        long[] ids = ORM.create().genLongIds(entryName, length);
        return ids;
    }

    private String formatDecimalStr(String taxRateStr) {
        BigDecimal taxRate = new BigDecimal(taxRateStr);
        return taxRate.multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString();
    }
}

