/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.AbstractInvoiceService;
import kd.fi.er.business.js.ErContextFactory;
import kd.fi.er.common.model.invoice.InvoiceProcessMessage;
import kd.fi.er.common.model.invoice.InvoiceProcessResult;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class OffsetAmountInvoiceServiceImpl
extends AbstractInvoiceService {
    private static final Log logger = LogFactory.getLog(OffsetAmountInvoiceServiceImpl.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final ErContextFactory contextFactory = new ErContextFactory();
    private Map<String, String> fieldMapping = new HashMap<String, String>();
    private List<String> offsetFields = new ArrayList<String>();
    private Map<String, Method> getItemMethods;
    private Map<String, Method> getHeadMethods;
    private boolean isOrgOffset;

    public OffsetAmountInvoiceServiceImpl(InvoiceContext invoiceContext) {
        super(invoiceContext);
        this.isOrgOffset = invoiceContext.getInvoiceConfig().isOrgOffset();
        this.initFieldMapping();
    }

    @Deprecated
    public OffsetAmountInvoiceServiceImpl(InvoiceContext invoiceContext, boolean isOrgOffset) {
        this(invoiceContext);
    }

    private void initFieldMapping() {
        QFilter qFilter = QFilter.of((String)"entitykey = ?", (Object[])new Object[]{"default"});
        DynamicObject loadFromCache = BusinessDataServiceHelper.loadSingleFromCache((String)"er_invoicefieldmapping", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection mapping = loadFromCache.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : mapping) {
            String metaField = object.getString("metafield");
            String codeField = object.getString("codefield");
            this.fieldMapping.put(metaField, codeField);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"er_invoiceoffsetrulefield");
        this.offsetFields = new ArrayList(entityType.getAllFields().keySet());
        this.getItemMethods = Arrays.stream(InvoiceItemEntryBO.class.getDeclaredMethods()).filter(method -> method.getName().contains("get")).collect(Collectors.toMap(method -> method.getName().toLowerCase(), method -> method));
        this.getHeadMethods = Arrays.stream(InvoiceEntryBO.class.getDeclaredMethods()).filter(method -> method.getName().contains("get")).collect(Collectors.toMap(method -> method.getName().toLowerCase(), method -> method));
    }

    @Override
    public void process() {
        logger.info("\u53ef\u62b5\u6263\u670d\u52a1\u5904\u7406\u5f00\u59cb");
        List<InvoiceEntryBO> invoiceEntryBOs = this.invoiceContext.getInvoiceEntryBOs();
        boolean invoicesCredits = this.invoiceContext.getInvoiceConfig().isInvoicesCredits();
        InvoiceProcessResult ipr = new InvoiceProcessResult();
        this.invoiceContext.getInvoiceResult().put(this.getClass().getName(), ipr);
        ipr.setServiceName(this.getClass().getName());
        invoiceEntryBOs.forEach(invoiceEntryBO -> {
            boolean isOffset;
            boolean canBeDeduction = invoiceEntryBO.isCanBeDeduction();
            List invoiceItemEntryBOs = invoiceEntryBO.getInvoiceItemEntryBOs();
            String type = (String)StringUtils.defaultIfBlank((CharSequence)invoiceEntryBO.getInvoiceType(), (CharSequence)"");
            Map<Object, DynamicObject> loadFromCache = this.queryInvoiceType(type);
            String js = "";
            if (CollectionUtils.isEmpty(loadFromCache)) {
                String deleteInfo = String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5408\u9002\u7684\u53d1\u7968\u7c7b\u578b\uff0ctype%s\u3002", (String)"OffsetAmountInvoiceServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), type);
                logger.info(deleteInfo);
                ipr.getProcessResult().add(new InvoiceProcessMessage(deleteInfo, "level"));
                isOffset = false;
            } else {
                DynamicObject offsetRuleDO = loadFromCache.values().iterator().next();
                isOffset = offsetRuleDO.getBoolean("isoffset");
                if (isOffset) {
                    js = offsetRuleDO.getString("js");
                }
            }
            String finalJs = js;
            invoiceItemEntryBOs.forEach(invoiceItemEntryBO -> {
                boolean result = isOffset;
                if (StringUtils.isNotBlank((CharSequence)finalJs)) {
                    try {
                        result = this.executeJs(finalJs, (InvoiceItemEntryBO)invoiceItemEntryBO);
                    }
                    catch (Exception e) {
                        logger.error("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u53d1\u7968\u62b5\u6263\u81ea\u5b9a\u4e49\u6761\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a", (Throwable)e);
                        throw new RuntimeException(ResManager.loadKDString((String)"\u53d1\u7968\u62b5\u6263\u81ea\u5b9a\u4e49\u6761\u4ef6\u89e3\u6790\u5f02\u5e38\u3002", (String)"OffsetAmountInvoiceServiceImpl_1", (String)"fi-er-business", (Object[])new Object[0]), e);
                    }
                }
                invoiceItemEntryBO.setIsOffset(Boolean.valueOf(result));
                invoiceItemEntryBO.setInvoiceItemOffset(Boolean.valueOf(result));
                invoiceItemEntryBO.setInvoiceCloudOffset(Boolean.valueOf(canBeDeduction));
                BigDecimal offsetAmount = invoicesCredits ? (result ? invoiceItemEntryBO.getInvoiceItemTaxAmout() : BigDecimal.ZERO) : (canBeDeduction ? invoiceItemEntryBO.getInvoiceItemTaxAmout() : BigDecimal.ZERO);
                invoiceItemEntryBO.setOffsetAmount(offsetAmount);
            });
            Boolean isHeadOffset = invoicesCredits ? Boolean.valueOf(invoiceItemEntryBOs.stream().anyMatch(invoiceItemEntryBO -> invoiceItemEntryBO.getInvoiceItemOffset())) : Boolean.valueOf(invoiceItemEntryBOs.stream().anyMatch(invoiceItemEntryBO -> invoiceItemEntryBO.getInvoiceCloudOffset()));
            if (!this.isOrgOffset) {
                isHeadOffset = false;
            }
            invoiceEntryBO.setIsOffset(isHeadOffset);
            BigDecimal offsetAmount = BigDecimal.ZERO;
            if (isHeadOffset.booleanValue()) {
                Stream<InvoiceItemEntryBO> itemEntryBOStream = invoicesCredits ? invoiceItemEntryBOs.stream().filter(invoiceItemEntryBO -> invoiceItemEntryBO.getInvoiceItemOffset()) : invoiceItemEntryBOs.stream().filter(invoiceItemEntryBO -> invoiceItemEntryBO.getInvoiceCloudOffset());
                offsetAmount = itemEntryBOStream.map(invoiceItemEntryBO -> invoiceItemEntryBO.getOffsetAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            invoiceEntryBO.setOffsetAmount(offsetAmount);
            if (invoiceEntryBO.getTaxAmount() != null) {
                invoiceEntryBO.setInOutAmount(invoiceEntryBO.getTaxAmount().subtract(offsetAmount));
            }
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u5e8f\u5217\u53f7:" + invoiceEntryBO.getSerialNo() + ",\u53d1\u7968\u53f7\u7801:" + invoiceEntryBO.getInvoiceNo() + "  \u53ef\u62b5\u6263\u670d\u52a1\u53d1\u7968\u4fe1\u606f " + invoiceEntryBO);
        });
        logger.info("\u3010\u53d1\u7968\u4e91\u3011\u53ef\u62b5\u6263\u670d\u52a1\u5904\u7406\u7ed3\u675f");
    }

    private Boolean executeJs(String js, InvoiceItemEntryBO item) throws InvocationTargetException, IllegalAccessException {
        logger.info("\u53ef\u62b5\u6263\u6761\u4ef6\u5224\u65ad js\uff1a{}, \u53d1\u7968\u660e\u7ec6\uff1a{} ", (Object)js, (Object)item);
        Context context = contextFactory.makeContext();
        contextFactory.enterContext(context);
        ScriptableObject prototype = context.initStandardObjects();
        prototype.setParentScope(null);
        Scriptable scope = context.newObject((Scriptable)prototype);
        scope.setPrototype((Scriptable)prototype);
        for (String offsetField : this.offsetFields) {
            String codeField = this.fieldMapping.get(offsetField);
            if (StringUtils.isEmpty((CharSequence)codeField)) {
                codeField = offsetField;
            }
            codeField = codeField.toLowerCase();
            Method method = this.getItemMethods.get("get" + codeField);
            Object codeFieldValue = method != null ? method.invoke((Object)item, new Object[0]) : ((method = this.getHeadMethods.get("get" + codeField)) != null ? method.invoke((Object)item.getInvoiceEntryBO(), new Object[0]) : "");
            if (codeFieldValue instanceof Date) {
                codeFieldValue = dateFormat.format(codeFieldValue);
            } else if ("null".equals(codeFieldValue) || codeFieldValue == null) {
                codeFieldValue = "";
            }
            scope.put(offsetField, scope, codeFieldValue);
        }
        return (Boolean)context.evaluateString(scope, js, null, -1, null);
    }

    private Map<Object, DynamicObject> queryInvoiceType(String type) {
        QFilter filter = QFilter.of((String)"enable=? and number=?", (Object[])new Object[]{"1", type});
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"er_invoicetype", (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Map)loadFromCache)) {
            filter = QFilter.of((String)"enable=? and number=?", (Object[])new Object[]{"1", InvoiceTypeEnum.key_11.getValue()});
            loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"er_invoicetype", (QFilter[])new QFilter[]{filter});
        }
        return loadFromCache;
    }
}

