/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.AbstractInvoiceService;

public class TripReimburseBeforeImportInvoiceServiceImpl
extends AbstractInvoiceService {
    private static final String TRIP_ITEM_ENTRY = "entryentity";
    private static final String TRIP_ENTRY = "tripentry";
    private IDataModel dataModel;

    public TripReimburseBeforeImportInvoiceServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel) {
        super(invoiceContext);
        this.dataModel = dataModel;
    }

    @Override
    public void process() {
        DynamicObject dataEntity = this.dataModel.getDataEntity(true);
        int tripRowIndex = this.dataModel.getEntryCurrentRowIndex(TRIP_ENTRY);
        DynamicObject tripEntryDOs = (DynamicObject)dataEntity.getDynamicObjectCollection(TRIP_ENTRY).get(tripRowIndex);
        DynamicObjectCollection tripItemEntryDOs = tripEntryDOs.getDynamicObjectCollection(TRIP_ITEM_ENTRY);
        int expenseItemEntryCount = tripItemEntryDOs.size();
        for (int rowIndex = expenseItemEntryCount - 1; rowIndex >= 0; --rowIndex) {
            String itemfrom = "";
            if (this.dataModel.getProperty("itemfrom") != null) {
                itemfrom = (String)this.dataModel.getValue("itemfrom", rowIndex);
            }
            BigDecimal expenseAmount = (BigDecimal)this.dataModel.getValue("orientryamount", rowIndex);
            if (StringUtils.equals((CharSequence)itemfrom, (CharSequence)ItemFrom.InvoiceCloud.getValue()) || expenseAmount != null && expenseAmount.abs().compareTo(BigDecimal.valueOf(1.0E-8)) >= 0) continue;
            this.dataModel.deleteEntryRow(TRIP_ITEM_ENTRY, rowIndex);
        }
    }
}

