/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.BeforeImportInvoiceService;
import kd.fi.er.common.model.invoice.InvoiceProcessMessage;
import kd.fi.er.common.model.invoice.InvoiceProcessResult;

public class DailyReimburseBeforeImportInvoiceServiceImpl
extends BeforeImportInvoiceService {
    private static final Log log = LogFactory.getLog(DailyReimburseBeforeImportInvoiceServiceImpl.class);
    private String EXPENSE_ITEM_ENTRY = "expenseentryentity";
    private IDataModel dataModel;

    public DailyReimburseBeforeImportInvoiceServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel) {
        super(invoiceContext);
        this.dataModel = dataModel;
    }

    @Override
    public void process() {
        InvoiceProcessResult ipr = new InvoiceProcessResult();
        this.invoiceContext.getInvoiceResult().put(this.getClass().getName(), ipr);
        ipr.setServiceName(this.getClass().getName());
        int expenseItemEntryCount = this.dataModel.getEntryRowCount(this.EXPENSE_ITEM_ENTRY);
        for (int rowIndex = expenseItemEntryCount - 1; rowIndex >= 0; --rowIndex) {
            String itemfrom = "";
            if (this.dataModel.getProperty("itemfrom") != null) {
                itemfrom = (String)this.dataModel.getValue("itemfrom", rowIndex);
            }
            BigDecimal expenseAmount = (BigDecimal)this.dataModel.getValue("expenseamount", rowIndex);
            if (StringUtils.equals((CharSequence)itemfrom, (CharSequence)ItemFrom.InvoiceCloud.getValue()) || expenseAmount != null && expenseAmount.abs().compareTo(BigDecimal.valueOf(1.0E-8)) >= 0) continue;
            String deleteInfo = ResManager.loadKDString((String)"\u660e\u7ec6\u884c%s\u62a5\u9500\u91d1\u989d\u4e3a0\uff0c\u5220\u9664\u8be5\u660e\u7ec6\u884c\u3002", (String)"DailyReimburseBeforeImportInvoiceServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]);
            log.info(deleteInfo);
            ipr.getProcessResult().add(new InvoiceProcessMessage(deleteInfo, "info"));
            this.dataModel.deleteEntryRow(this.EXPENSE_ITEM_ENTRY, rowIndex);
        }
    }
}

